/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class StatusPanel
extends JPanel {
    private static Icon[] m_loadingImages = null;
    protected JButton m_cancelBtn = new JButton("Cancel");
    protected JLabel m_mainLbl;
    protected JLabel m_subLbl;
    protected JLabel m_iconLbl = new JLabel(m_loadingImages[0]);
    protected int m_imgIndex = 0;
    protected boolean m_bAnimate = true;

    public StatusPanel() {
        this.m_mainLbl = new JLabel("Working, Please Wait...", 0);
        this.m_mainLbl.setFont(new Font(UIManager.getFont("Label.font").getFamily(), 1, 15));
        this.m_mainLbl.setForeground(Color.black);
        this.setBackground(Color.white);
        this.m_subLbl = new JLabel("Working...", 0);
        this.m_subLbl.setBackground(Color.white);
        JPanel topPnl = new JPanel();
        topPnl.setLayout(new GridBagLayout());
        topPnl.setBorder(new MyBorder());
        GraphUtils.addComponent((Container)topPnl, (Component)this.m_iconLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)this.m_mainLbl, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setBorder(new BevelBorder(0));
        this.setPreferredSize(new Dimension(480, 105));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)topPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_subLbl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cancelBtn, (int)0, (int)2, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    public JButton getCancelBtn() {
        return this.m_cancelBtn;
    }

    public void animate(boolean bGo) {
        this.m_bAnimate = bGo;
        if (this.m_bAnimate) {
            new Animator();
        }
    }

    public void setStatusMessage(final String main, final String sub) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setMessages(main, sub);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.setMessages(main, sub);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void setMessages(String main, String sub) {
        this.m_mainLbl.setText(main);
        this.m_subLbl.setText(sub);
        this.m_subLbl.paintImmediately(this.m_subLbl.getBounds());
    }

    static {
        m_loadingImages = new ImageIcon[6];
        StatusPanel.m_loadingImages[0] = new ImageIcon(ImageCache.getImage("loading1.png"));
        StatusPanel.m_loadingImages[1] = new ImageIcon(ImageCache.getImage("loading2.png"));
        StatusPanel.m_loadingImages[2] = new ImageIcon(ImageCache.getImage("loading3.png"));
        StatusPanel.m_loadingImages[3] = new ImageIcon(ImageCache.getImage("loading4.png"));
        StatusPanel.m_loadingImages[4] = new ImageIcon(ImageCache.getImage("loading5.png"));
        StatusPanel.m_loadingImages[5] = new ImageIcon(ImageCache.getImage("loading6.png"));
    }

    public class MyBorder
    implements Border {
        int m_insetWidth = 4;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.black);
            g.drawLine(x, y + height - 1, width, y + height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    class Animator
    implements ActionListener {
        Timer m_timer = new Timer(90, this);

        public Animator() {
            this.m_timer.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Animator animator = this;
            synchronized (animator) {
                StatusPanel.this.repaint();
                if (!StatusPanel.this.m_bAnimate) {
                    this.m_timer.stop();
                }
                StatusPanel.this.m_imgIndex = StatusPanel.this.m_imgIndex == 5 ? 0 : ++StatusPanel.this.m_imgIndex;
                StatusPanel.this.m_iconLbl.setIcon(m_loadingImages[StatusPanel.this.m_imgIndex]);
            }
        }
    }
}

