/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SequenceView
extends BPELVerticalDropBranchView
implements ValidatableView,
Magnifiable,
StateSaveableView,
Tabable,
VoiceAccessible {
    private static Font m_font = UIManager.getFont("TextField.font");
    private static Color BORDER_COLOR = new Color(239, 239, 239);
    protected int m_borderWidth = 2;
    private int m_minWidth = 20;
    private int m_minHeight = 60;
    private int m_borderToSequence = 2;
    private int m_tabToBranch = 5;
    protected int m_insideBorderWidth = 1;
    private int m_imagePadding = 4;
    private ConfigBox m_configBox;
    private ConfigBox m_collapsedConfigBox;
    private ConfigBox m_minimizedConfigBox;
    protected CollapseExpandViewAction m_collapseAction;
    private Rectangle m_verticalNameBox = new Rectangle();
    protected List<GraphAction> m_actions;
    protected JTextField m_nameField = new JTextField();
    protected Rectangle m_nameBounds = new Rectangle();
    private ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bMagnified = false;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;
    protected int m_minimizedBorderWidth = 2;

    public SequenceView(GraphPane pane, View parent, SequenceNode n) {
        super(pane, parent, n);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 1);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.m_viewStatusBox.setBackground(null);
        this.m_viewStatusBox.setBorderColor(BPELGraphPane.TAB_BORDER_COLOR);
        this.setAcceptsArrow(false);
        this.setCollapsable(true);
        this.setCanSelect(true);
        this.m_configBox = new ConfigBox((View)this, this.getActions(), 1);
        this.m_configBox.setBorderColor(BORDER_COLOR);
        this.m_configBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox = new ConfigBox((View)this, this.getActions(), 0);
        this.m_collapsedConfigBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox.setBorderColor(null);
        this.m_minimizedConfigBox = new ConfigBox((View)this, this.getMinimizedActions(), 0);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setMinimizeMode(true);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setBorderColor(Color.cyan);
        Dimension configBoxSize = this.m_configBox.getSize();
        this.setInsets(this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth + configBoxSize.width + this.m_tabToBranch, this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth);
        this.computeVerticalNameBoxDimensions();
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(false);
        }
    }

    @Override
    public boolean canDelete() {
        Sequence s = (Sequence)this.getNode().getUserObject();
        return s.canDelete();
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane == null) {
            return false;
        }
        if (pane.isOptimized()) {
            return true;
        }
        BPELSettings settings = pane.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SEQUENCES");
        return b == null ? false : b;
    }

    @Override
    public View getView() {
        return this;
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<StatusBoxButton> buttons = plugin.addViewStatusButtons((View)this);
            if (buttons == null) continue;
            this.m_statusButtons.addAll(buttons);
        }
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void asyncGenerateValidationReport() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SequenceView.this.generateValidationReport();
            }
        };
        new Thread(r).start();
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            ValidationReport r = a.getValidationReport(this.createValidationContext(), false);
            if (r == null) {
                r = a.getValidationReport(this.createValidationContext(), true);
            }
            return r.getState() != 0;
        }
        return false;
    }

    public ToolTipable getToolTipable(int x, int y) {
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        return null;
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized() && this.isCollapsed()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_configBox.clearHighlights();
        this.m_collapsedConfigBox.clearHighlights();
        this.m_minimizedConfigBox.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public boolean hitNameEdit(int x, int y) {
        return this.m_nameBounds.contains(x, y);
    }

    @Override
    public boolean canEditName() {
        Sequence s = (Sequence)this.getNode().getUserObject();
        return s.isEditable() && this.isCollapsed() && !this.isMinimized();
    }

    public void setEditingName(boolean bEditing) {
        super.setEditingName(bEditing);
        GraphPane pane = this.getGraphPane();
        if (bEditing) {
            pane.add((Component)this.m_nameField);
            Dimension prefDim = this.m_nameField.getPreferredSize();
            String text = this.getName();
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)text);
            this.m_nameField.setText(text);
            this.m_nameField.setCaretPosition(0);
            this.m_nameField.requestFocus();
            int xOffset = 0;
            int w = strWidth + this.m_nameField.getInsets().left + this.m_nameField.getInsets().right;
            if (this.m_nameBounds.width < w) {
                xOffset = -(w - this.m_nameBounds.width) / 2;
            }
            this.m_nameField.setBounds(this.m_nameBounds.x + xOffset, this.m_nameBounds.y, w, prefDim.height);
            this.m_nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SequenceView.this.setEditingName(false);
                        SequenceView.this.saveNameChange();
                    }
                }
            });
            this.m_nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    SequenceView.this.setEditingName(false);
                    SequenceView.this.saveNameChange();
                }
            });
        } else {
            pane.remove((Component)this.m_nameField);
        }
        pane.repaint();
    }

    protected void saveNameChange() {
        Node n = this.getNode();
        n.setName(this.m_nameField.getText());
        this.computeVerticalNameBoxDimensions();
        this.getGraphPane().forceLayout();
    }

    private String getName() {
        String name = this.getNode().getName();
        if (name != null) {
            return name;
        }
        return " ";
    }

    protected void computeVerticalNameBoxDimensions() {
        Dimension d = this.m_configBox.getSize();
        this.m_verticalNameBox.width = d.width;
        this.m_verticalNameBox.height = 8 + GraphUtils.getStringWidth((Font)BPELGraphPane.VERTICAL_FONT, (String)this.getName());
    }

    public List<GraphAction> getActions() {
        if (this.m_actions != null) {
            return this.m_actions;
        }
        this.m_actions = new ArrayList<GraphAction>();
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        this.m_actions.add((GraphAction)this.m_collapseAction);
        return this.m_actions;
    }

    public List<GraphAction> getMinimizedActions() {
        return this.getActions();
    }

    public boolean getAcceptsArrow() {
        return this.isCollapsed();
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.isSelected() && this.isDraggable()) {
            return Cursor.getPredefinedCursor(13);
        }
        return null;
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isMinimized()) {
            return this.m_minimizedConfigBox.hitActionArea(x, y);
        }
        if (this.isCollapsed()) {
            if (this.isSelected()) {
                return this.m_collapsedConfigBox.hitActionArea(x, y);
            }
        } else if (this.isSelected()) {
            return this.m_configBox.hitActionArea(x, y);
        }
        return null;
    }

    protected Color getTextColor() {
        return Color.black;
    }

    public void paint(Graphics g, int layer) {
        Rectangle clip = g.getClipBounds();
        if (!this.m_bounds.intersects(clip)) {
            return;
        }
        if (this.isSelected()) {
            g.setColor(BPELGraphPane.VIEW_SELECTION_BACKGROUND);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.isEditing()) {
            this.paintEditingMode(g);
        } else if (this.isMinimized()) {
            this.paintMinimized(g, layer);
        } else if (this.isCollapsed()) {
            int xOffset = (this.m_bounds.width - this.getActivityImage().getWidth(null)) / 2;
            g.drawImage(this.getActivityImage(), this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, null);
            String name = this.getName();
            if (name != null) {
                g.setColor(this.getTextColor());
                g.setFont(UIManager.getFont("Label.font"));
                g.drawString(name, this.m_nameBounds.x, this.m_nameBounds.y + GraphUtils.getFontAscent((Font)g.getFont()));
            }
            if (this.isSelected()) {
                this.m_collapsedConfigBox.paint(g, null);
                this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
            }
            this.paintStatusIcons(g);
        } else {
            Color bg = this.getGraphPane().getBackground();
            GraphUtils.paintVerticalTabText((Graphics)g, (String)this.getName(), (int)this.m_verticalNameBox.x, (int)this.m_verticalNameBox.y, (int)this.m_verticalNameBox.width, (int)this.m_verticalNameBox.height, (Color)BORDER_COLOR, (Color)bg, (Color)BPELGraphPane.TAB_TEXT_COLOR, (float)1.0f);
            GraphUtils.drawDottedRect((Graphics)g, (int)(this.m_bounds.x + this.m_borderWidth + this.m_borderToSequence + this.m_configBox.getBounds().width), (int)(this.m_bounds.y + this.m_borderWidth + this.m_borderToSequence), (int)(this.m_bounds.width - this.m_borderWidth - this.m_borderToSequence - 2 * this.m_configBox.getBounds().width - this.m_borderWidth - this.m_borderToSequence), (int)(this.m_bounds.height - 2 * this.m_borderWidth - 2 * this.m_borderToSequence), (Color)BORDER_COLOR, (float)1.0f);
            this.paintSequenceChildren(g, layer);
            this.paintStatusIcons(g);
            this.m_configBox.paint(g, bg);
            if (this.isSelected()) {
                this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
            }
        }
    }

    protected void paintSequenceChildren(Graphics g, int layer) {
        List views = this.getViewsInClip(g.getClipBounds());
        if (views != null) {
            for (View v : views) {
                v.paint(g, layer);
            }
        }
    }

    protected Image getActivityImage() {
        Image i = ImageCache.getImage("graph/bpel/sequence_40x40.png");
        return this.isEditable() ? i : BasicImageCache.createDisabledImage((Image)i);
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = this.getActivityImage();
        String s = this.getName();
        int strWidth = GraphUtils.getStringWidth((Font)m_font, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)m_font);
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        GraphUtils.drawLine((Graphics)g, (int)this.midX(), (int)this.topY(), (int)r.x, (int)(r.y + 5), (float)1.0f, (Color)Color.cyan);
        GraphUtils.drawLine((Graphics)g, (int)this.midX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 5), (float)1.0f, (Color)Color.cyan);
        g.setColor(Color.cyan);
        GraphUtils.drawRoundRect((Graphics)g, (int)r.x, (int)r.y, (int)r.width, (int)r.height, (float)1.0f, (Color)Color.cyan);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)this.getTextColor(), (Font)m_font);
        }
        this.paintStatusIcons(g);
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        this.paintBorder(g, c, borderWidth);
    }

    protected void paintMinimized(Graphics g, int layer) {
        if (!this.isCollapsed()) {
            this.paintSequenceChildren(g, layer);
        }
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    protected void paintSelected(Graphics g) {
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_collapsedConfigBox.move(x, y);
        this.m_minimizedConfigBox.move(x, y);
        this.m_configBox.move(x, y);
        this.m_verticalNameBox.x += x;
        this.m_verticalNameBox.y += y;
        this.m_nameBounds.x += x;
        this.m_nameBounds.y += y;
        this.m_viewStatusBox.move(x, y);
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = this.getActivityImage();
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        String s = this.getName();
        int fontHeight = GraphUtils.getFontHeight((Font)m_font);
        int strWidth = GraphUtils.getStringWidth((Font)m_font, (String)s);
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x, this.m_bounds.y, w, h);
        r.x = this.m_bounds.x + this.m_bounds.width / 2 - r.width / 2;
        r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        r.x += this.m_bounds.width + 20;
        return r;
    }

    private Rectangle layoutMinimized(int x, int y, int w, int h, LayoutInfo info) {
        BaseView v;
        int i;
        if (this.isCollapsed()) {
            this.setCollapsed(false);
        }
        this.updateStatusButtons();
        Dimension configBoxSize = this.m_minimizedConfigBox.getSize();
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        this.m_minimizedConfigBox.setBounds(x, y, configBoxSize.width, configBoxSize.height);
        this.notifyLayoutWillOccur();
        this.setInsets(this.m_borderWidth, this.m_borderWidth + this.m_insideBorderWidth, this.m_borderWidth, this.m_borderWidth + this.m_insideBorderWidth);
        this.setBounds(x, y, 0, 0);
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        boolean bTextMode = nChildren == 1;
        for (int i2 = 0; i2 < nChildren; ++i2) {
            BaseView v2 = (BaseView)this.m_children.get(i2);
            if (!(v2 instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v2).setTextMode(bTextMode);
        }
        int childrenHeight = 0;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                childrenHeight += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            childrenHeight += r.height;
        }
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.height += childrenHeight;
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.stretchLastDropView();
        return this.m_bounds;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        if (this.isMinimized()) {
            return this.layoutMinimized(x, y, w, h, info);
        }
        this.computeVerticalNameBoxDimensions();
        this.updateStatusButtons();
        Dimension configBoxSize = this.m_configBox.getSize();
        this.setInsets(this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth + this.m_borderToSequence + configBoxSize.width + this.m_insideBorderWidth, this.m_borderWidth + this.m_borderToSequence + this.m_tabToBranch, this.m_borderWidth + this.m_borderToSequence + configBoxSize.width + this.m_insideBorderWidth);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        this.m_configBox.setBounds(x + this.m_borderWidth + this.m_borderToSequence, y + this.m_borderWidth + this.m_borderToSequence, configBoxSize.width, configBoxSize.height);
        if (this.isCollapsed()) {
            Dimension configSize = this.m_collapsedConfigBox.getSize();
            int iWidth = this.getActivityImage().getWidth(null);
            int iHeight = this.getActivityImage().getHeight(null);
            int imageViewWidth = 2 * (iWidth / 2 + this.m_imagePadding + configSize.width + this.m_imagePadding + this.m_borderWidth);
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)this.getName());
            int strViewWidth = this.m_borderWidth + this.m_imagePadding + strWidth + this.m_imagePadding + this.m_borderWidth;
            int viewWidth = Math.max(imageViewWidth, strViewWidth);
            int strHeight = GraphUtils.getFontHeight((Font)UIManager.getFont("Label.font"));
            int viewHeight = this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding + strHeight + this.m_borderWidth;
            this.setBounds(x, y, viewWidth, viewHeight);
            this.m_connectionX = this.midX();
            this.m_collapsedConfigBox.setBounds(this.m_connectionX - iWidth / 2 - this.m_imagePadding - configSize.width, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, configSize.width, configSize.height);
            int xOffset = (this.m_bounds.width - strWidth) / 2;
            this.m_nameBounds.setBounds(this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding, strWidth, strHeight);
            this.m_viewStatusBox.setBackground(null);
            this.m_viewStatusBox.setBorderColor(null);
            this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, this.m_bounds.y + this.m_borderWidth);
            return this.m_bounds;
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        boolean bTextMode = nChildren == 1;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        int childrenHeight = 0;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                childrenHeight += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            childrenHeight += r.height;
        }
        this.m_verticalNameBox.setLocation(this.m_configBox.getBounds().x, this.m_configBox.getBounds().y + this.m_configBox.getBounds().height);
        this.m_viewStatusBox.layout(this.m_verticalNameBox.getBounds().x, this.m_verticalNameBox.getBounds().y + this.m_verticalNameBox.getBounds().height);
        this.m_viewStatusBox.setBackground(Color.white);
        this.m_viewStatusBox.setBorderColor(BPELGraphPane.TAB_BORDER_COLOR);
        int verticalTabHeight = this.m_configBox.getBounds().height + this.m_verticalNameBox.getBounds().height + this.m_viewStatusBox.m_bounds.height;
        this.m_bounds.height += Math.max(verticalTabHeight, childrenHeight);
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        if (this.m_minWidth / 2 > maxLeft) {
            maxLeft = this.m_minWidth / 2;
        }
        if (this.m_minWidth / 2 > maxRight) {
            maxRight = this.m_minWidth / 2;
        }
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.stretchLastDropView();
        return this.m_bounds;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    public String getVoiceAccessibleText() {
        Sequence s = (Sequence)this.getNode().getUserObject();
        return "Sequence " + s.getName();
    }
}

