/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.EventHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.Handler;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.DropView;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.TabTreeNode;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddCatchAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddCatchAllAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddCompensationHandlerAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddOnAlarmAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddOnMessageAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.DocumentationAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.PartnerLinksAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.ShowHideFaultHandlersAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.VariablesAction;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.CatchAllNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CatchNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CompensationHandlerNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.EventHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.FaultHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.NoteNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnAlarmNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnMessageNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchAllView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CompensationHandlerView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnAlarmView;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnMessageView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ScopeView
extends BPELVerticalDropBranchView
implements ValidatableView,
Magnifiable,
StateSaveableView,
Tabable,
VoiceAccessible {
    protected static Font TEXT_FONT = new Font(UIManager.getFont("Label.font").getFontName(), 0, 11);
    protected int m_borderWidth = 2;
    protected int m_insetPadding = 15;
    protected int m_minWidth = 100;
    protected int m_minHeight = 100;
    protected int m_minimizedBorderWidth = 2;
    protected int m_borderToSequence = 2;
    protected int m_tabToBranch = 5;
    protected int m_imagePadding = 4;
    protected int m_handlerViewTopYOffset = 50;
    protected int m_faultsBottomPadding = 20;
    protected int m_handlerBranchPadding = 4;
    protected ConfigBox m_configBox;
    protected ConfigBox m_collapsedConfigBox;
    protected ConfigBox m_minimizedConfigBox;
    protected ConfigBox m_handlersConfigBox;
    protected CollapseExpandViewAction m_collapseAction;
    protected Rectangle m_verticalNameBox = new Rectangle();
    protected List<GraphAction> m_actions;
    protected JTextArea m_nameField = new JTextArea();
    protected Rectangle m_nameBounds = new Rectangle();
    protected List<NodeRenderer> m_faultHandlerViews = new ArrayList<NodeRenderer>();
    protected List<NodeRenderer> m_eventHandlerViews = new ArrayList<NodeRenderer>();
    protected NodeRenderer m_compensationHandlerView;
    protected NodeRenderer m_noteView;
    protected Rectangle m_scopeBounds = new Rectangle();
    protected boolean m_bShowHandlers;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected ShowHideFaultHandlersAction m_showHandlerAction;
    protected boolean m_bMagnified = false;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;
    protected FocusListener m_nameFieldFocusListener = null;
    protected KeyListener m_nameFieldKeyListener = null;
    protected VariablesAction m_variablesAction;
    protected PartnerLinksAction m_partnerLinksAction;
    protected AddCatchAction m_addCatchAction;
    protected AddCatchAllAction m_addCatchAllAction;
    protected AddOnMessageAction m_addOnMessageAction;
    protected AddOnAlarmAction m_addOnAlarmAction;
    protected AddCompensationHandlerAction m_addCompensationHandlerAction;
    protected DocumentationAction m_setImageAction;
    protected List<String> m_labelLines = new ArrayList<String>();

    public ScopeView(GraphPane pane, View parent, ScopeNode n) {
        super(pane, parent, n);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 1);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.m_viewStatusBox.setBackground(null);
        this.m_viewStatusBox.setBorderColor(null);
        this.m_configBox = new ConfigBox((View)this, this.getActions(), 1);
        this.m_configBox.setInsets(0, 0, 0, 0);
        this.m_configBox.setTransparentIcons(!this.isSelected());
        this.m_collapsedConfigBox = new ConfigBox((View)this, this.getCollapsedActions(), 0);
        this.m_collapsedConfigBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox.setBorderColor(null);
        this.m_minimizedConfigBox = new ConfigBox((View)this, this.getMinimizedActions(), 0);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setMinimizeMode(true);
        this.m_handlersConfigBox = new ConfigBox((View)this, this.getHandlerActions(), 0);
        this.m_handlersConfigBox.setInsets(0, 0, 0, 0);
        this.m_handlersConfigBox.setDecorated(false);
        Dimension tagSize = this.m_configBox.getSize();
        this.m_insetPadding = tagSize.width + this.m_tabToBranch;
        this.setBackground(null);
        this.setInsets(this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth + this.m_insetPadding, this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth + this.m_insetPadding);
        this.setCanSelect(true);
        this.setAcceptsArrow(false);
        this.computeVerticalNameBoxDimensions();
        this.setCollapsable(true);
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
        val = (Boolean)n.getData("showhandlers");
        this.m_bShowHandlers = val == null ? true : val;
    }

    @Override
    public List<TabTreeNode> getTabTreeNodes() {
        ArrayList<Object> nodes = new ArrayList<TabTreeNode>();
        if (this.isVisible()) {
            if (!this.isCollapsed()) {
                for (NodeRenderer nodeRenderer : this.m_children) {
                    List list = nodeRenderer.getTabTreeNodes();
                    if (list == null) continue;
                    nodes.addAll(list);
                }
                if (this.getShowHandlers()) {
                    List tabs2;
                    for (NodeRenderer r : this.m_faultHandlerViews) {
                        List list = r.getTabTreeNodes();
                        if (list == null) continue;
                        nodes.addAll(list);
                    }
                    for (NodeRenderer r : this.m_eventHandlerViews) {
                        List list = r.getTabTreeNodes();
                        if (list == null) continue;
                        nodes.addAll(list);
                    }
                    if (this.m_compensationHandlerView != null && (tabs2 = this.m_compensationHandlerView.getTabTreeNodes()) != null) {
                        nodes.addAll(tabs2);
                    }
                }
            }
            TabTreeNode treeNode = new TabTreeNode((Tabable)this);
            for (TabTreeNode tabTreeNode : nodes) {
                treeNode.addChild(tabTreeNode);
            }
            nodes = new ArrayList();
            nodes.add(treeNode);
        }
        return nodes;
    }

    public void setSelected(boolean bSelect) {
        super.setSelected(bSelect);
        this.m_configBox.setTransparentIcons(!bSelect);
        this.repaint();
    }

    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("scope_node");
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane == null) {
            return false;
        }
        if (pane.isOptimized()) {
            return true;
        }
        BPELSettings settings = pane.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SCOPES");
        return b != null && b != false;
    }

    public Point getCenteringPoint() {
        return new Point(this.m_configBox.getBounds().x, this.m_bounds.y);
    }

    @Override
    public View getView() {
        return this;
    }

    protected Font getTextFont() {
        return this.m_nameField.getFont();
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<StatusBoxButton> buttons = plugin.addViewStatusButtons((View)this);
            if (buttons == null) continue;
            this.m_statusButtons.addAll(buttons);
        }
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized() && this.isCollapsed()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_handlersConfigBox.clearHighlights();
        this.m_configBox.clearHighlights();
        this.m_collapsedConfigBox.clearHighlights();
        this.m_minimizedConfigBox.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public ToolTipable getToolTipable(int x, int y) {
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        if (Helper.hasValue((String)this.m_toolTipText)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean canDelete() {
        Scope s = (Scope)this.getNode().getUserObject();
        return s.canDelete();
    }

    public void setShowHandlers(boolean bShow) {
        this.m_bShowHandlers = bShow;
        this.m_showHandlerAction.updateIcon();
    }

    public boolean getShowHandlers() {
        return this.m_bShowHandlers;
    }

    public NodeRenderer getCompensationHandlerView() {
        return this.m_compensationHandlerView;
    }

    public void deleteCompensationHandlerView(CompensationHandlerView v) {
        if (v != this.m_compensationHandlerView) {
            return;
        }
        ScopeNode n = (ScopeNode)this.getNode();
        Scope s = (Scope)n.getUserObject();
        s.deleteCompensationHandler();
        n.setCompensationHandlerNode(null);
        this.m_compensationHandlerView = null;
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void deleteCatchView(CatchView cv) {
        ScopeNode n;
        FaultHandlersNode fn;
        if (this.m_faultHandlerViews.contains(cv) && (fn = (n = (ScopeNode)this.getNode()).getFaultHandlersNode()) != null) {
            CatchNode cn = (CatchNode)cv.getNode();
            fn.removeChildNode((Node)cn);
            Scope scopeModel = (Scope)n.getUserObject();
            scopeModel.deleteCatch((Catch)cn.getUserObject());
            this.m_faultHandlerViews.remove(cv);
            BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
            model.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void deleteCatchAllView(CatchAllView cv) {
        ScopeNode n;
        FaultHandlersNode fn;
        if (this.m_faultHandlerViews.contains(cv) && (fn = (n = (ScopeNode)this.getNode()).getFaultHandlersNode()) != null) {
            CatchAllNode cn = (CatchAllNode)cv.getNode();
            fn.removeChildNode((Node)cn);
            Scope scopeModel = (Scope)n.getUserObject();
            scopeModel.removeCatchAll();
            this.m_faultHandlerViews.remove(cv);
            BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
            model.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void deleteOnAlarmView(OnAlarmView v) {
        ScopeNode n;
        EventHandlersNode handlersNode;
        if (this.m_eventHandlerViews.contains(v) && (handlersNode = (n = (ScopeNode)this.getNode()).getEventHandlersNode()) != null) {
            OnAlarmNode cn = (OnAlarmNode)v.getNode();
            handlersNode.removeChildNode((Node)cn);
            Scope scopeModel = (Scope)n.getUserObject();
            scopeModel.deleteOnAlarm((OnAlarm)cn.getUserObject());
            this.m_eventHandlerViews.remove((Object)handlersNode);
            BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
            model.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceLayout();
        }
    }

    public void deleteOnMessageView(OnMessageView v) {
        ScopeNode n;
        EventHandlersNode handlersNode;
        if (this.m_eventHandlerViews.contains(v) && (handlersNode = (n = (ScopeNode)this.getNode()).getEventHandlersNode()) != null) {
            OnMessageNode cn = (OnMessageNode)v.getNode();
            handlersNode.removeChildNode((Node)cn);
            Scope scopeModel = (Scope)n.getUserObject();
            scopeModel.deleteOnMessage((OnMessage)cn.getUserObject());
            this.m_eventHandlerViews.remove((Object)handlersNode);
            BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
            model.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void addOnAlarm() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        Process p = model.getProcess();
        ScopeNode n = (ScopeNode)this.getNode();
        Scope scope = (Scope)n.getUserObject();
        EventHandlersNode evtHandlerNode = n.getEventHandlersNode();
        if (evtHandlerNode == null) {
            evtHandlerNode = (EventHandlersNode)ModelBuilder.createGraphNode(125, p, true);
            EventHandlers handler = scope.getEventHandlers();
            if (handler == null) {
                handler = scope.createEventHandlers();
            }
            evtHandlerNode.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)scope);
        }
        OnAlarmNode alarmNode = (OnAlarmNode)ModelBuilder.createGraphNode(116, p, true);
        OnAlarm alarm = (OnAlarm)alarmNode.getUserObject();
        alarm.setParentHandler((Handler)((EventHandlers)evtHandlerNode.getUserObject()));
        scope.addOnAlarm(alarm);
        evtHandlerNode.addChildNode((Node)alarmNode);
        n.setEventHandlersNode(evtHandlerNode);
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addOnMessage() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        Process p = model.getProcess();
        ScopeNode n = (ScopeNode)this.getNode();
        Scope scope = (Scope)n.getUserObject();
        EventHandlersNode evtHandlerNode = n.getEventHandlersNode();
        if (evtHandlerNode == null) {
            evtHandlerNode = (EventHandlersNode)ModelBuilder.createGraphNode(125, p, true);
            EventHandlers handler = scope.getEventHandlers();
            if (handler == null) {
                handler = scope.createEventHandlers();
            }
            evtHandlerNode.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)scope);
        }
        OnMessageNode msgNode = (OnMessageNode)ModelBuilder.createGraphNode(115, p, true);
        OnMessage msg = (OnMessage)msgNode.getUserObject();
        msg.setParentHandler((Handler)((EventHandlers)evtHandlerNode.getUserObject()));
        scope.addOnMessage(msg);
        evtHandlerNode.addChildNode((Node)msgNode);
        n.setEventHandlersNode(evtHandlerNode);
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addCompensationHandler() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        Process p = model.getProcess();
        ScopeNode scopeNode = (ScopeNode)this.getNode();
        CompensationHandlerNode compHandlerNode = scopeNode.getCompensationHandlerNode();
        if (compHandlerNode != null) {
            return;
        }
        Scope s = (Scope)scopeNode.getUserObject();
        compHandlerNode = (CompensationHandlerNode)ModelBuilder.createGraphNode(126, p, true);
        CompensationHandler handler = s.getCompensationHandler();
        if (handler == null) {
            handler = s.createCompensationHandler();
        }
        compHandlerNode.setUserObject(handler);
        handler.setHandlerParentActivity((Activity)s);
        scopeNode.setCompensationHandlerNode(compHandlerNode);
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addCatch() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        Process p = model.getProcess();
        ScopeNode n = (ScopeNode)this.getNode();
        Scope scopeActivity = (Scope)n.getUserObject();
        FaultHandlersNode fn = n.getFaultHandlersNode();
        if (fn == null) {
            fn = (FaultHandlersNode)ModelBuilder.createGraphNode(124, p, true);
            FaultHandlers handler = scopeActivity.getFaultHandlers();
            if (handler == null) {
                handler = scopeActivity.createFaultHandlers();
            }
            fn.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)scopeActivity);
        }
        CatchNode cNode = (CatchNode)ModelBuilder.createGraphNode(122, p, true);
        Catch ct = (Catch)cNode.getUserObject();
        ct.setParentHandler((Handler)((FaultHandlers)fn.getUserObject()));
        int childCount = fn.getChildCount();
        if (childCount > 0) {
            int idx = childCount - 1;
            fn.insertChildNode(idx, (Node)cNode);
        } else {
            fn.addChildNode((Node)cNode);
        }
        scopeActivity.addCatch(ct);
        n.setFaultHandlersNode(fn);
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addCatchAll() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        Process p = model.getProcess();
        ScopeNode n = (ScopeNode)this.getNode();
        Scope scopeActivity = (Scope)n.getUserObject();
        FaultHandlersNode fn = n.getFaultHandlersNode();
        if (fn == null) {
            fn = (FaultHandlersNode)ModelBuilder.createGraphNode(124, p, true);
            FaultHandlers handler = scopeActivity.getFaultHandlers();
            if (handler == null) {
                handler = scopeActivity.createFaultHandlers();
            }
            fn.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)scopeActivity);
        }
        CatchAllNode cNode = (CatchAllNode)ModelBuilder.createGraphNode(123, p, true);
        CatchAll ct = (CatchAll)cNode.getUserObject();
        ct.setParentHandler((Handler)((FaultHandlers)fn.getUserObject()));
        fn.addChildNode((Node)cNode);
        scopeActivity.setCatchAll(ct);
        n.setFaultHandlersNode(fn);
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceLayout();
    }

    public void rebuildNodeRenderersFromModel() {
        NoteNode noteNode;
        CompensationHandlerNode compHandlerNode;
        EventHandlersNode evtNode;
        super.rebuildNodeRenderersFromModel();
        ScopeNode scopeNode = (ScopeNode)this.getNode();
        GraphPane pane = this.getGraphPane();
        NodeRendererFactory f = pane.getNodeRendererFactory();
        FaultHandlersNode fn = scopeNode.getFaultHandlersNode();
        if (fn != null) {
            ArrayList<NodeRenderer> newHandlers = new ArrayList<NodeRenderer>();
            for (Node childNode : fn.getChildren()) {
                NodeRenderer v = this.getFaultViewForNode(childNode);
                if (v == null) {
                    v = f.createNodeRenderer(pane, childNode);
                    v.createChildNodeRenderers();
                    v.setParent((NodeRenderer)this);
                }
                newHandlers.add(v);
            }
            this.m_faultHandlerViews = newHandlers;
        }
        if ((evtNode = scopeNode.getEventHandlersNode()) != null) {
            ArrayList<NodeRenderer> newHandlers = new ArrayList<NodeRenderer>();
            for (Node childNode : evtNode.getChildren()) {
                NodeRenderer v = this.getEventHandlerViewForNode(childNode);
                if (v == null) {
                    v = f.createNodeRenderer(pane, childNode);
                    v.createChildNodeRenderers();
                    v.setParent((NodeRenderer)this);
                }
                newHandlers.add(v);
            }
            this.m_eventHandlerViews = newHandlers;
        }
        if ((compHandlerNode = scopeNode.getCompensationHandlerNode()) != null && this.m_compensationHandlerView == null) {
            this.m_compensationHandlerView = f.createNodeRenderer(pane, (Node)compHandlerNode);
            this.m_compensationHandlerView.createChildNodeRenderers();
            this.m_compensationHandlerView.setParent((NodeRenderer)this);
        }
        if ((noteNode = scopeNode.getNoteNode()) != null && this.m_noteView == null) {
            this.m_noteView = f.createNodeRenderer(pane, (Node)noteNode);
            this.m_noteView.createChildNodeRenderers();
            this.m_noteView.setParent((NodeRenderer)this);
        }
    }

    protected NodeRenderer getEventHandlerViewForNode(Node n) {
        Iterator it = this.getEventHandlerViews();
        while (it.hasNext()) {
            NodeRenderer r = (NodeRenderer)it.next();
            Node viewNode = r.getNode();
            if (viewNode != n) continue;
            return r;
        }
        return null;
    }

    protected NodeRenderer getFaultViewForNode(Node n) {
        Iterator it = this.getFaultHandlerViews();
        while (it.hasNext()) {
            NodeRenderer r = (NodeRenderer)it.next();
            Node viewNode = r.getNode();
            if (viewNode != n) continue;
            return r;
        }
        return null;
    }

    public void createChildNodeRenderers() {
        NoteNode noteNode;
        CompensationHandlerNode compHandlerNode;
        NodeRenderer r;
        NodeRenderer r2;
        super.createChildNodeRenderers();
        GraphPane pane = this.getGraphPane();
        NodeRendererFactory f = pane.getNodeRendererFactory();
        this.m_faultHandlerViews.clear();
        ScopeNode scopeNode = (ScopeNode)this.getNode();
        FaultHandlersNode fn = scopeNode.getFaultHandlersNode();
        if (fn != null) {
            for (Node childNode : fn.getChildren()) {
                r2 = f.createNodeRenderer(pane, childNode);
                if (r2 == null) continue;
                r2.createChildNodeRenderers();
                r2.setParent((NodeRenderer)this);
                this.m_faultHandlerViews.add(r2);
            }
        }
        this.m_eventHandlerViews.clear();
        EventHandlersNode evtHandlersNode = scopeNode.getEventHandlersNode();
        if (evtHandlersNode != null) {
            for (Node childNode : evtHandlersNode.getChildren()) {
                r = f.createNodeRenderer(pane, childNode);
                if (r == null) continue;
                r.createChildNodeRenderers();
                r.setParent((NodeRenderer)this);
                this.m_eventHandlerViews.add(r);
            }
        }
        if ((compHandlerNode = scopeNode.getCompensationHandlerNode()) != null && (r2 = f.createNodeRenderer(pane, (Node)compHandlerNode)) != null) {
            r2.createChildNodeRenderers();
            r2.setParent((NodeRenderer)this);
            this.m_compensationHandlerView = r2;
        }
        if ((noteNode = scopeNode.getNoteNode()) != null && (r = f.createNodeRenderer(pane, (Node)noteNode)) != null) {
            r.createChildNodeRenderers();
            r.setParent((NodeRenderer)this);
            this.m_noteView = r;
        }
    }

    public NodeRenderer getNodeRendererAtPosition(int x, int y) {
        if (this.m_bounds.contains(x, y)) {
            NodeRenderer result;
            NodeRenderer result2;
            if (this.m_faultHandlerViews.size() > 0) {
                for (NodeRenderer r : this.m_faultHandlerViews) {
                    result2 = r.getNodeRendererAtPosition(x, y);
                    if (result2 == null) continue;
                    return result2;
                }
            }
            if (this.m_eventHandlerViews.size() > 0) {
                for (NodeRenderer r : this.m_eventHandlerViews) {
                    result2 = r.getNodeRendererAtPosition(x, y);
                    if (result2 == null) continue;
                    return result2;
                }
            }
            if (this.m_compensationHandlerView != null && (result = this.m_compensationHandlerView.getNodeRendererAtPosition(x, y)) != null) {
                return result;
            }
            if (this.m_noteView != null && (result = this.m_noteView.getNodeRendererAtPosition(x, y)) != null) {
                return result;
            }
            return super.getNodeRendererAtPosition(x, y);
        }
        return null;
    }

    public NodeRenderer findNodeRendererForNode(Node n) {
        NodeRenderer result;
        NodeRenderer result2;
        if (this.m_faultHandlerViews.size() > 0) {
            for (NodeRenderer r : this.m_faultHandlerViews) {
                result2 = r.findNodeRendererForNode(n);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.m_eventHandlerViews.size() > 0) {
            for (NodeRenderer r : this.m_eventHandlerViews) {
                result2 = r.findNodeRendererForNode(n);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.m_compensationHandlerView != null && (result = this.m_compensationHandlerView.findNodeRendererForNode(n)) != null) {
            return result;
        }
        if (this.m_noteView != null && (result = this.m_noteView.findNodeRendererForNode(n)) != null) {
            return result;
        }
        return super.findNodeRendererForNode(n);
    }

    public boolean hitNameEdit(int x, int y) {
        return this.m_nameBounds.contains(x, y);
    }

    @Override
    public boolean canEditName() {
        Scope s = (Scope)this.getNode().getUserObject();
        return s.isEditable() && this.isCollapsed();
    }

    public void setEditingName(boolean bEditing) {
        super.setEditingName(bEditing);
        GraphPane pane = this.getGraphPane();
        if (bEditing) {
            this.m_nameField.setLineWrap(true);
            this.m_nameField.setWrapStyleWord(true);
            pane.add((Component)this.m_nameField);
            Dimension prefDim = new Dimension(this.m_nameBounds.width, this.m_nameBounds.height);
            String text = this.getLabel();
            this.m_nameField.setText(text);
            this.m_nameField.setCaretPosition(0);
            this.m_nameField.requestFocus();
            this.m_nameField.setBounds(this.m_nameBounds.x - 4, this.m_nameBounds.y - 4, prefDim.width + 8, prefDim.height + 8);
            this.addNameFieldKeyListener();
            this.addNameFieldFocusListener();
        } else {
            this.removeNameFieldKeyListener();
            this.removeNameFieldFocusListener();
            pane.remove((Component)this.m_nameField);
        }
        pane.repaint();
    }

    protected void addNameFieldKeyListener() {
        this.removeNameFieldKeyListener();
        this.m_nameFieldKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ScopeView.this.saveNameChange()) {
                    ScopeView.this.setEditingName(false);
                }
            }
        };
        this.m_nameField.addKeyListener(this.m_nameFieldKeyListener);
    }

    protected void removeNameFieldKeyListener() {
        if (this.m_nameFieldKeyListener != null) {
            this.m_nameField.removeKeyListener(this.m_nameFieldKeyListener);
            this.m_nameFieldKeyListener = null;
        }
    }

    protected void addNameFieldFocusListener() {
        this.removeNameFieldFocusListener();
        this.m_nameFieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getID() == 1005) {
                    ScopeView.this.saveNameChange();
                    ScopeView.this.setEditingName(false);
                }
            }
        };
        this.m_nameField.addFocusListener(this.m_nameFieldFocusListener);
    }

    protected void removeNameFieldFocusListener() {
        if (this.m_nameFieldFocusListener != null) {
            this.m_nameField.removeFocusListener(this.m_nameFieldFocusListener);
            this.m_nameFieldFocusListener = null;
        }
    }

    protected boolean saveNameChange() {
        Node n = this.getNode();
        String newName = this.m_nameField.getText();
        Scope s = (Scope)n.getUserObject();
        s.setUserLabel(newName);
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        model.nodesChanged(n.getParentNode(), new Node[]{n});
        this.computeVerticalNameBoxDimensions();
        this.getGraphPane().forceLayout();
        return true;
    }

    public boolean getAcceptsArrow() {
        return this.isCollapsed();
    }

    protected void computeVerticalNameBoxDimensions() {
        Dimension d = this.m_configBox.getSize();
        this.m_verticalNameBox.width = d.width;
        this.m_verticalNameBox.height = 8 + GraphUtils.getStringWidth((Font)BPELGraphPane.VERTICAL_FONT, (String)this.getName());
    }

    protected String getLabel() {
        Scope s = (Scope)this.getNode().getUserObject();
        String label = s.getUserLabel();
        if (label != null) {
            return label;
        }
        return this.getName();
    }

    protected String getName() {
        Scope s = (Scope)this.getNode().getUserObject();
        String name = s.getName();
        if (name != null) {
            return name;
        }
        return "";
    }

    public List<GraphAction> getCollapsedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public List<GraphAction> getHandlerActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_showHandlerAction = new ShowHideFaultHandlersAction((View)this);
        this.m_showHandlerAction.putValue("HOVER_ICON", ImageCache.getIcon("graph/bpel/collapse_over.png"));
        actions.add(this.m_showHandlerAction);
        return actions;
    }

    public List<GraphAction> getMinimizedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    private void updateActions() {
        if (this.m_actions == null) {
            return;
        }
        for (GraphAction a : this.m_actions) {
            if (!(a instanceof GraphAction)) continue;
            GraphAction ga = a;
            ga.updateState();
        }
    }

    public List<GraphAction> getActions() {
        if (this.m_actions != null) {
            if (this.getGraphPane().isEditable()) {
                Scope s = (Scope)this.getNode().getUserObject();
                boolean bEditable = s.isEditable();
                this.m_variablesAction.setEnabled(bEditable);
                this.m_partnerLinksAction.setEnabled(bEditable);
                this.m_addCatchAction.setEnabled(bEditable);
                this.m_addCatchAllAction.setEnabled(bEditable);
                this.m_addOnMessageAction.setEnabled(bEditable);
                this.m_addOnAlarmAction.setEnabled(bEditable);
                this.m_addCompensationHandlerAction.setEnabled(bEditable);
                this.m_setImageAction.setEnabled(bEditable);
            }
            return this.m_actions;
        }
        boolean bEditable = this.getGraphPane().isEditable();
        if (bEditable) {
            this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
            this.m_variablesAction = new VariablesAction((View)this);
            this.m_partnerLinksAction = new PartnerLinksAction((View)this);
            this.m_addCatchAction = new AddCatchAction((View)this);
            this.m_addCatchAllAction = new AddCatchAllAction((View)this);
            this.m_addOnMessageAction = new AddOnMessageAction((View)this);
            this.m_addOnAlarmAction = new AddOnAlarmAction((View)this);
            this.m_addCompensationHandlerAction = new AddCompensationHandlerAction((View)this);
            this.m_setImageAction = new DocumentationAction((View)this);
            this.m_actions = new ArrayList<GraphAction>();
            this.m_actions.add((GraphAction)this.m_collapseAction);
            this.m_actions.add(this.m_variablesAction);
            this.m_actions.add(this.m_partnerLinksAction);
            this.m_actions.add(this.m_addCatchAction);
            this.m_actions.add(this.m_addCatchAllAction);
            this.m_actions.add(this.m_addOnMessageAction);
            this.m_actions.add(this.m_addOnAlarmAction);
            this.m_actions.add(this.m_addCompensationHandlerAction);
            this.m_actions.add(this.m_setImageAction);
            ArrayList<GraphAction> extraActions = new ArrayList<GraphAction>();
            for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
                List<GraphAction> pluginActions = plugin.addViewAction((View)this);
                if (pluginActions == null) continue;
                extraActions.addAll(pluginActions);
            }
            if (extraActions.size() > 0) {
                this.m_actions.addAll(extraActions);
            }
        } else {
            this.m_actions = new ArrayList<GraphAction>();
            this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
            this.m_actions.add((GraphAction)this.m_collapseAction);
        }
        return this.m_actions;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
        if (this.m_bMagnified) {
            this.m_bMagnified = false;
            ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
        }
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.isSelected() && this.isDraggable()) {
            return Cursor.getPredefinedCursor(13);
        }
        return null;
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isMinimized()) {
            return this.m_minimizedConfigBox.hitActionArea(x, y);
        }
        if (this.isCollapsed()) {
            if (this.isSelected()) {
                return this.m_collapsedConfigBox.hitActionArea(x, y);
            }
            return null;
        }
        ActionInfo info = this.m_handlersConfigBox.hitActionArea(x, y);
        if (info != null) {
            return info;
        }
        return this.m_configBox.hitActionArea(x, y);
    }

    protected void paintSelected(Graphics g) {
        int width = this.isMinimized() ? this.m_minimizedBorderWidth : this.m_borderWidth;
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        this.paintBorder(g, settings.m_selectedBorderBackgroundColor, width);
    }

    protected Color getTextColor() {
        return this.isEditable() ? Color.black : Color.lightGray;
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = this.getActivityImage();
        String s = this.getName();
        int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)TEXT_FONT);
        GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)Color.cyan, (float)0.3f);
        Color lineClr = Color.cyan.darker();
        g.setColor(lineClr);
        g.drawRoundRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height, 10, 10);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)r.x, (int)(r.y + 10), (float)1.5f, (Color)Color.cyan.darker());
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 10), (float)1.5f, (Color)Color.cyan.darker());
        Graphics2D g2 = (Graphics2D)g;
        Color c1 = new Color(223, 242, 249);
        Color c2 = new Color(197, 214, 233);
        GradientPaint gp = new GradientPaint(r.x, r.y, c1, r.x, r.y + r.height, c2);
        g2.setPaint(gp);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        g.setColor(lineClr);
        g.drawRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)this.getTextColor(), (Font)TEXT_FONT);
        }
        this.paintStatusIcons(g);
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, float borderWidth) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        this.paintSelectionBox(g, r, borderWidth, settings.m_selectedBorderBackgroundColor);
    }

    protected void paintMinimized(Graphics g, int layer) {
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_minimizedBorderWidth);
        }
        if (this.isCollapsed()) {
            this.m_minimizedConfigBox.paint(g, Color.white);
            Icon icon = this.getMinimizedIcon();
            int iWidth = icon.getIconWidth();
            icon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + this.m_bounds.width / 2 - iWidth / 2, this.m_bounds.y + this.m_minimizedBorderWidth);
        } else {
            super.paint(g, layer);
            GraphUtils.drawDottedRect((Graphics)g, (int)this.m_scopeBounds.x, (int)this.m_scopeBounds.y, (int)this.m_scopeBounds.width, (int)this.m_scopeBounds.height, (Color)BPELGraphPane.DOTTED_BORDER_COLOR, (float)1.0f);
            this.m_minimizedConfigBox.paint(g, Color.white);
            if (this.getShowHandlers()) {
                this.paintHandlers(this.getAllHandlerViews(), g, layer);
            }
        }
    }

    public Color getSelectedBackgroundColor() {
        return BPELGraphPane.VIEW_SELECTION_BACKGROUND;
    }

    public void paint(Graphics g, int layer) {
        Rectangle clip = g.getClipBounds();
        if (!this.m_bounds.intersects(clip)) {
            return;
        }
        if (this.isSelected()) {
            GraphUtils.fillSelectionBox((Graphics)g, (int)this.m_bounds.x, (int)this.m_bounds.y, (int)this.m_bounds.width, (int)this.m_bounds.height, (Color)this.getSelectedBackgroundColor());
        }
        if (this.isEditing()) {
            this.paintEditingMode(g);
            return;
        }
        if (this.isMinimized()) {
            this.paintMinimized(g, layer);
            return;
        }
        if (this.isCollapsed()) {
            this.paintCollapsedScope(g);
        } else {
            this.paintScope(g, layer);
        }
    }

    protected void paintCollapsedScope(Graphics g) {
        int iWidth = this.getImage().getWidth(null);
        g.drawImage(this.getImage(), this.m_connectionX - iWidth / 2, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, null);
        int y = this.m_nameBounds.y;
        for (String line : this.m_labelLines) {
            g.setColor(this.getTextColor());
            g.setFont(this.getTextFont());
            int strWidth = GraphUtils.getStringWidth((Font)this.getTextFont(), (String)line);
            g.drawString(line, this.m_connectionX - strWidth / 2, y + GraphUtils.getFontAscent((Font)g.getFont()));
            y += GraphUtils.getFontHeight((Font)this.getTextFont());
        }
        if (this.m_noteView != null) {
            this.m_noteView.paint(g, 0);
        }
        this.m_collapsedConfigBox.paint(g, null);
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
        }
        this.paintStatusIcons(g);
    }

    protected void paintScopeChildren(Graphics g, int layer) {
        List views = this.getViewsInClip(g.getClipBounds());
        if (views != null) {
            for (View v : views) {
                v.paint(g, layer);
            }
        }
    }

    protected void paintScope(Graphics g, int layer) {
        this.paintScopeChildren(g, layer);
        if (this.getShowHandlers()) {
            this.paintHandlers(this.getAllHandlerViews(), g, layer);
        }
        GraphUtils.drawDottedRect((Graphics)g, (int)this.m_scopeBounds.x, (int)this.m_scopeBounds.y, (int)this.m_scopeBounds.width, (int)this.m_scopeBounds.height, (Color)BPELGraphPane.DOTTED_BORDER_COLOR, (float)1.0f);
        if (this.hasHandlers()) {
            this.m_handlersConfigBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
        }
        GraphUtils.paintVerticalTabText((Graphics)g, (String)this.getName(), (int)this.m_verticalNameBox.x, (int)this.m_verticalNameBox.y, (int)this.m_verticalNameBox.width, (int)this.m_verticalNameBox.height, (Color)BPELGraphPane.TAB_BORDER_COLOR, (Color)BPELGraphPane.TAB_BACKGROUND_COLOR, (Color)BPELGraphPane.TAB_TEXT_COLOR, (float)(this.isSelected() ? 1.0f : 0.6f));
        this.m_configBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
        this.paintStatusIcons(g);
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
        }
    }

    protected boolean hasHandlers() {
        return this.getAllHandlerViews().size() > 0;
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        this.m_showHandlerAction.updateIcon();
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    protected void paintHandlers(List<NodeRenderer> handlerViews, Graphics g, int layer) {
        if (handlerViews.size() > 0) {
            int bottomMostFaultBranchY = 0;
            int sz = handlerViews.size();
            for (int i = 0; i < sz; ++i) {
                NodeRenderer r = handlerViews.get(i);
                r.paint(g, layer);
                bottomMostFaultBranchY = Math.max(bottomMostFaultBranchY, r.getBounds().y + r.getBounds().height);
            }
            int thickness = this.getGraphPane().getLineThickness();
            Color lineClr = this.getGraphPane().getLineColor();
            BaseView r = (BaseView)handlerViews.get(sz - 1);
            int rightMostBranchX = r.getConnectionX();
            int topHorzY = this.m_bounds.y + this.m_insets.top + this.m_handlerViewTopYOffset / 2;
            GraphUtils.drawHorzLine((Graphics)g, (int)(this.m_scopeBounds.x + this.m_scopeBounds.width), (int)topHorzY, (int)rightMostBranchX, (float)thickness, (Color)lineClr);
            int leftX = this.m_scopeBounds.x + this.m_scopeBounds.width;
            if (bottomMostFaultBranchY > this.m_scopeBounds.y + this.m_scopeBounds.height) {
                leftX = this.m_connectionX;
            }
            int bottomHorzY = bottomMostFaultBranchY + this.m_faultsBottomPadding / 2;
            GraphUtils.drawHorzLine((Graphics)g, (int)leftX, (int)bottomHorzY, (int)rightMostBranchX, (float)thickness, (Color)lineClr);
            if (bottomHorzY > this.m_scopeBounds.y + this.m_scopeBounds.height) {
                GraphUtils.drawVertLine((Graphics)g, (int)leftX, (int)(this.m_bounds.y + this.m_bounds.height), (int)(this.m_scopeBounds.y + this.m_scopeBounds.height), (float)thickness, (Color)lineClr);
            }
            for (int i = 0; i < sz; ++i) {
                BaseView view = (BaseView)handlerViews.get(i);
                GraphUtils.drawVertLine((Graphics)g, (int)view.getConnectionX(), (int)topHorzY, (int)view.topY(), (float)thickness, (Color)lineClr);
                GraphUtils.drawVertLine((Graphics)g, (int)view.getConnectionX(), (int)bottomHorzY, (int)view.bottomY(), (float)thickness, (Color)lineClr);
            }
        }
    }

    public void move(int x, int y) {
        NodeRenderer r;
        super.move(x, y);
        this.m_minimizedConfigBox.move(x, y);
        this.m_collapsedConfigBox.move(x, y);
        this.m_viewStatusBox.move(x, y);
        this.m_configBox.move(x, y);
        this.m_verticalNameBox.x += x;
        this.m_verticalNameBox.y += y;
        this.m_nameBounds.x += x;
        this.m_nameBounds.y += y;
        this.m_scopeBounds.x += x;
        this.m_scopeBounds.y += y;
        this.m_handlersConfigBox.move(x, y);
        Iterator it = this.getFaultHandlerViews();
        while (it.hasNext()) {
            r = (NodeRenderer)it.next();
            r.move(x, y);
        }
        it = this.getEventHandlerViews();
        while (it.hasNext()) {
            r = (NodeRenderer)it.next();
            r.move(x, y);
        }
        if (this.m_compensationHandlerView != null) {
            this.m_compensationHandlerView.move(x, y);
        }
        if (this.m_noteView != null) {
            this.m_noteView.move(x, y);
        }
    }

    protected Iterator getFaultHandlerViews() {
        return this.m_faultHandlerViews.iterator();
    }

    protected Iterator getEventHandlerViews() {
        return this.m_eventHandlerViews.iterator();
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = this.getImage();
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        String s = this.getName();
        int fontHeight = GraphUtils.getFontHeight((Font)TEXT_FONT);
        int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x, this.m_bounds.y, w, h);
        r.x = this.m_bounds.x + this.m_bounds.width + 20;
        r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        if (this.m_bounds.height > r.height) {
            r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        }
        if (r.width < 80) {
            r.width = 80;
        }
        if (r.height < 80) {
            r.height = 80;
        }
        return r;
    }

    protected Rectangle layoutMinimized(int x, int y, int w, int h, LayoutInfo info) {
        BaseView v;
        int i;
        Dimension configBoxSize = this.m_minimizedConfigBox.getSize();
        if (this.isCollapsed()) {
            Icon icon = this.getMinimizedIcon();
            int left = this.m_minimizedBorderWidth + configBoxSize.width + icon.getIconWidth() / 2;
            int right = icon.getIconWidth() / 2 + this.m_minimizedBorderWidth;
            int width = 2 * Math.max(left, right);
            int height = 2 * this.m_minimizedBorderWidth + Math.max(icon.getIconHeight(), configBoxSize.height);
            this.setBounds(x, y, width, height);
            this.m_connectionX = this.midX();
            this.m_minimizedConfigBox.setBounds(x, y, configBoxSize.width, configBoxSize.height);
            return this.m_bounds;
        }
        this.updateStatusButtons();
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        this.m_minimizedConfigBox.setBounds(x, y, configBoxSize.width, configBoxSize.height);
        this.setInsets(this.m_minimizedBorderWidth, this.m_minimizedBorderWidth, this.m_minimizedBorderWidth, this.m_minimizedBorderWidth);
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        boolean bTextMode = nChildren == 1;
        for (int i2 = 0; i2 < nChildren; ++i2) {
            BaseView v2 = (BaseView)this.m_children.get(i2);
            if (!(v2 instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v2).setTextMode(bTextMode);
        }
        int childrenHeight = 0;
        int maxLeft = 10;
        int maxRight = 10;
        int xPos = x + this.m_insets.left;
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                childrenHeight += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            childrenHeight += r.height;
        }
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.height += childrenHeight;
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.m_scopeBounds.setBounds(this.m_bounds);
        if (this.getShowHandlers()) {
            List<NodeRenderer> handlerViews = this.getAllHandlerViews();
            int handlersWidth = 0;
            int handlersHeight = 0;
            int maxBranchHeight = 0;
            if (handlerViews.size() > 0) {
                yPos = this.m_bounds.y + this.m_insets.top + this.m_handlerViewTopYOffset;
                xPos = this.m_bounds.x + this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
                for (int i3 = 0; i3 < handlerViews.size(); ++i3) {
                    NodeRenderer r = handlerViews.get(i3);
                    Rectangle bounds = r.layout(xPos, yPos, 0, 0, info);
                    maxBranchHeight = Math.max(maxBranchHeight, bounds.height);
                    xPos += bounds.width + this.m_handlerBranchPadding;
                    handlersWidth += bounds.width;
                    if (i3 < handlerViews.size() - 1) {
                        handlersWidth += this.m_handlerBranchPadding;
                    }
                    handlersHeight = Math.max(handlersHeight, bounds.height);
                }
                handlersWidth += this.m_insets.right;
            }
            this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right + handlersWidth;
            int heightDueToFaultHandlers = this.m_insets.top + this.m_handlerViewTopYOffset + handlersHeight + this.m_faultsBottomPadding + this.m_insets.bottom;
            this.m_bounds.height = Math.max(this.m_bounds.height, heightDueToFaultHandlers);
            if (this.m_scopeBounds.height < this.m_bounds.height) {
                this.m_scopeBounds.height = this.m_bounds.height;
            }
        }
        this.stretchLastDropView();
        return this.m_bounds;
    }

    protected Dimension layoutLabel() {
        this.m_labelLines.clear();
        Scope s = (Scope)this.getNode().getUserObject();
        String text = s.getUserLabel();
        if (text == null || text.trim().length() == 0) {
            text = s.getName();
        }
        if (text == null || text.trim().length() == 0) {
            return new Dimension(0, 0);
        }
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int maxWidth = 100;
        int totalWidth = 0;
        int start = boundary.first();
        String currLine = "";
        int end = boundary.next();
        while (end != -1) {
            String word = text.substring(start, end);
            boolean bWhitespace = word.trim().length() == 0;
            int wordWidth = GraphUtils.getStringWidth((Font)this.getTextFont(), (String)word);
            if (currLine.length() == 0) {
                if (!bWhitespace) {
                    currLine = currLine + word;
                    totalWidth = wordWidth;
                }
            } else if (totalWidth + wordWidth > maxWidth) {
                this.m_labelLines.add(currLine.trim());
                currLine = word;
                totalWidth = wordWidth;
            } else {
                currLine = currLine + word;
                totalWidth += wordWidth;
            }
            start = end;
            end = boundary.next();
        }
        if (currLine.length() > 0 && currLine.trim().length() > 0) {
            this.m_labelLines.add(currLine.trim());
        }
        int maxLineWidth = 0;
        int height = 0;
        for (String line : this.m_labelLines) {
            int strWidth = GraphUtils.getStringWidth((Font)this.getTextFont(), (String)line);
            int strHeight = GraphUtils.getFontHeight((Font)this.getTextFont());
            maxLineWidth = Math.max(maxLineWidth, strWidth);
            height += strHeight;
        }
        return new Dimension(maxLineWidth, height);
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        Node childNode;
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        if (this.isMinimized()) {
            return this.layoutMinimized(x, y, w, h, info);
        }
        this.computeVerticalNameBoxDimensions();
        this.updateActions();
        this.updateStatusButtons();
        this.setInsets(this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth + this.m_insetPadding, this.m_borderWidth + this.m_borderToSequence, this.m_borderWidth + this.m_insetPadding);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        Dimension tagSize = this.m_configBox.getSize();
        this.m_configBox.setBounds(x + this.m_borderWidth + this.m_borderToSequence, y + this.m_borderWidth + this.m_borderToSequence, tagSize.width, tagSize.height);
        if (this.isCollapsed()) {
            Dimension labelDim = this.layoutLabel();
            Dimension noteDim = new Dimension(0, 0);
            if (this.m_noteView != null) {
                Rectangle r = this.m_noteView.layout(0, 0, 100, 100, info);
                noteDim.width = r.width;
                noteDim.height = r.height;
            }
            Dimension configSize = this.m_collapsedConfigBox.getSize();
            int iWidth = this.getImage().getWidth(null);
            int iHeight = this.getImage().getHeight(null);
            Dimension statusDim = this.m_viewStatusBox.computeSize();
            int imgLeft = this.m_borderWidth + configSize.width + this.m_imagePadding + iWidth / 2;
            int imgRight = iWidth / 2 + statusDim.width + this.m_borderWidth;
            int labelLeft = this.m_borderWidth + labelDim.width / 2;
            int labelRight = labelDim.width / 2 + this.m_borderWidth;
            int left = Math.max(imgLeft, labelLeft);
            int right = Math.max(imgRight, labelRight);
            if (noteDim.width == 0) {
                if (left > right) {
                    right = left;
                } else if (right > left) {
                    left = right;
                }
            }
            this.m_connectionX = this.m_bounds.x + left;
            if (this.m_noteView != null) {
                this.m_noteView.layout(this.m_bounds.x + left + right, this.m_bounds.y + this.m_borderWidth, 100, 100, info);
            }
            this.m_collapsedConfigBox.setBounds(this.m_connectionX - iWidth / 2 - configSize.width - this.m_imagePadding, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, configSize.width, configSize.height);
            this.m_nameBounds.setBounds(this.m_connectionX - labelDim.width / 2, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding, labelDim.width, labelDim.height);
            this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, this.m_bounds.y + this.m_borderWidth);
            this.m_bounds.width = this.m_borderWidth + left + right + noteDim.width + this.m_borderWidth;
            int labelAndImageHeight = this.m_imagePadding + iHeight + this.m_imagePadding + labelDim.height;
            this.m_bounds.height = this.m_borderWidth + Math.max(labelAndImageHeight, noteDim.height) + this.m_borderWidth;
            return this.m_bounds;
        }
        Node seqNode = this.getNode();
        int numChildren = seqNode.getChildCount();
        if (numChildren == 3 && (childNode = seqNode.getChildNode(1)).getNodeType() == 103) {
            View v = this.getChildViewForNode(seqNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(seqNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        this.m_verticalNameBox.setLocation(this.m_configBox.getBounds().x, this.m_configBox.getBounds().y + this.m_configBox.getBounds().height);
        this.m_viewStatusBox.layout(this.m_verticalNameBox.getBounds().x, this.m_verticalNameBox.getBounds().y + this.m_verticalNameBox.getBounds().height);
        this.m_viewStatusBox.setBackground(Color.white);
        this.m_viewStatusBox.setBorderColor(BPELGraphPane.TAB_BORDER_COLOR);
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        int childrenHeight = 0;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                childrenHeight += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            childrenHeight += r.height;
        }
        int verticalTabHeight = this.m_configBox.getBounds().height + this.m_verticalNameBox.getBounds().height + this.m_viewStatusBox.m_bounds.height;
        this.m_bounds.height += Math.max(verticalTabHeight, childrenHeight);
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        if (this.m_minWidth / 2 > maxLeft) {
            maxLeft = this.m_minWidth / 2;
        }
        if (this.m_minWidth / 2 > maxRight) {
            maxRight = this.m_minWidth / 2;
        }
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.m_scopeBounds.x = this.m_bounds.x + this.m_borderWidth + this.m_borderToSequence + this.m_insetPadding / 2;
        this.m_scopeBounds.y = this.m_bounds.y + this.m_borderWidth + this.m_borderToSequence;
        this.m_scopeBounds.width = this.m_bounds.width - this.m_insetPadding - 2 * this.m_borderWidth - 2 * this.m_borderToSequence;
        this.m_scopeBounds.height = this.m_bounds.height - 2 * this.m_borderWidth - 2 * this.m_borderToSequence;
        Dimension d = this.m_handlersConfigBox.getSize();
        this.m_handlersConfigBox.setBounds(this.m_scopeBounds.x + this.m_scopeBounds.width, this.m_scopeBounds.y, d.width, d.height);
        if (this.getShowHandlers()) {
            List<NodeRenderer> handlerViews = this.getAllHandlerViews();
            int handlersWidth = 0;
            int handlersHeight = 0;
            int maxBranchHeight = 0;
            if (handlerViews.size() > 0) {
                yPos = this.m_bounds.y + this.m_insets.top + this.m_handlerViewTopYOffset;
                xPos = this.m_bounds.x + this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
                for (int i = 0; i < handlerViews.size(); ++i) {
                    NodeRenderer r = handlerViews.get(i);
                    Rectangle bounds = r.layout(xPos, yPos, 0, 0, info);
                    maxBranchHeight = Math.max(maxBranchHeight, bounds.height);
                    xPos += bounds.width + this.m_handlerBranchPadding;
                    handlersWidth += bounds.width;
                    if (i < handlerViews.size() - 1) {
                        handlersWidth += this.m_handlerBranchPadding;
                    }
                    handlersHeight = Math.max(handlersHeight, bounds.height);
                }
                handlersWidth += this.m_insets.right;
            }
            this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right + handlersWidth;
            int heightDueToFaultHandlers = this.m_insets.top + this.m_handlerViewTopYOffset + handlersHeight + this.m_faultsBottomPadding + this.m_insets.bottom;
            this.m_bounds.height = Math.max(this.m_bounds.height, heightDueToFaultHandlers);
        }
        this.stretchLastDropView();
        return this.m_bounds;
    }

    protected List<NodeRenderer> getAllHandlerViews() {
        ArrayList<NodeRenderer> handlerViews = new ArrayList<NodeRenderer>(this.m_faultHandlerViews);
        handlerViews.addAll(this.m_eventHandlerViews);
        if (this.m_compensationHandlerView != null) {
            handlerViews.add(this.m_compensationHandlerView);
        }
        return handlerViews;
    }

    public void stretchLastDropView() {
        int nChildren = this.getChildCount();
        if (nChildren <= 0) {
            return;
        }
        BaseView v = this.getChild(nChildren - 1);
        if (v instanceof DropView) {
            Rectangle dropBounds = v.getBounds();
            int viewYEnd = this.m_scopeBounds.y + this.m_scopeBounds.height;
            int dropViewYEnd = dropBounds.y + dropBounds.height;
            int diff = viewYEnd - dropViewYEnd;
            if (diff > 0) {
                v.setBounds(dropBounds.x, dropBounds.y, dropBounds.width, dropBounds.height + diff);
            }
        }
    }

    @Override
    protected void notifyLayoutWillOccur() {
        int nChildren = this.m_children.size();
        boolean bTextMode = nChildren == 1;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            Node n = v.getNode();
            if (n == null || n.getNodeType() != 0) continue;
            boolean bShowArrow = false;
            BaseView nextView = this.getChild(i + 1);
            if (nextView != null) {
                bShowArrow = nextView.getAcceptsArrow();
            }
            ((DropView)v).setShowArrow(bShowArrow);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
            ((CollaxaDropView)v).setDropText(this.getDropText());
            ((CollaxaDropView)v).setDropAllowed(true);
        }
    }

    protected String getDropText() {
        return CollaxaDropView.DROP_TEXT_LINE1;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    protected Image getActivityImage() {
        Image image;
        Scope s = (Scope)this.getNode().getUserObject();
        String file = s.getUserImage();
        if (file != null && file.length() > 0 && (image = ImageCache.getUserDocumentationImage(file)) != null) {
            return image;
        }
        return ImageCache.getImage("graph/bpel/scope_40x40.png");
    }

    protected Image getImage() {
        if (!this.isEditable()) {
            return BasicImageCache.createDisabledImage((Image)this.getActivityImage());
        }
        return this.getActivityImage();
    }

    public String getVoiceAccessibleText() {
        Scope s = (Scope)this.getNode().getUserObject();
        return "Scope " + s.getName();
    }
}

