/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkConnection;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReplyNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELTaskView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkConnectable;
import oracle.tip.tools.ide.pm.bpelgraph.views.PortView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ReplyView
extends BPELTaskView
implements PartnerLinkConnectable {
    protected Icon m_interactionIcon;

    public ReplyView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.setAcceptsArrow(true);
        this.m_insideBorderWidth = 0;
        this.m_outsideBorderToInsideBorder = 0;
        this.m_borderToImage = this.m_outsideBorderToInsideBorder + 5;
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("reply_node");
    }

    @Override
    public boolean isMinimized() {
        return this.getMinimize("MINIMIZE_REPLY_ACTIVITIES");
    }

    @Override
    protected Image getActivityImage() {
        return ImageCache.getImage("graph/bpel/reply_40x40.png");
    }

    public String getToolTipText() {
        return ReplyView.getReplyToolTipText((Reply)this.getNode().getUserObject());
    }

    public static String getReplyToolTipText(Reply reply) {
        String ptype = "";
        QName portType = reply.getPortType();
        if (portType != null) {
            ptype = BPELModelUtil.getPrefixQualifiedName((QName)portType);
        }
        String settingsText = BPELStringTranslator.getString("COLLAXALAF_SETTINGS", "Settings");
        String text = "<html><body><table><tr><td colspan=2 align=center bgcolor=cyan><font color=black><b>Reply " + settingsText + "</b></font></td></tr>";
        text = text + ReplyView.getRowHTML("PortType", ptype);
        text = text + ReplyView.getRowHTML("Operation", reply.getOperation());
        text = text + ReplyView.getRowHTML("Variable", reply.getVariable());
        text = text + "</table></body></html>";
        return text;
    }

    protected static String getRowHTML(String name, String value) {
        if (value == null) {
            value = "";
        }
        return "<tr><td><b>" + name + ":</b></td><td>" + value + "</td></tr>";
    }

    @Override
    public void updatePartnerLinkGUIConnections() {
        String partnerLinkName;
        PortNode receivePortNode;
        ReplyNode n = (ReplyNode)this.getNode();
        Reply replyModel = (Reply)n.getUserObject();
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        for (View v : this.m_children) {
            Edge[] edges;
            if (!(v instanceof PortView) || (edges = model.getEdgesForPort(receivePortNode = (PortNode)v.getNode())) == null || edges.length <= 0) continue;
            Edge edge = edges[0];
            PortNode target = edge.getTarget();
            PortNode src = edge.getSource();
            model.deleteEdges(edges);
            if (target != receivePortNode) {
                model.deleteNode(target.getParentNode(), (Node)target);
                break;
            }
            if (src == receivePortNode) break;
            model.deleteNode(src.getParentNode(), (Node)src);
            break;
        }
        if ((partnerLinkName = replyModel.getPartnerLink()) == null) {
            return;
        }
        receivePortNode = (PortNode)n.getChildNode(0);
        List<PartnerLinkNode> plinksNodes = model.getPartnerLinkNodes();
        for (PartnerLinkNode linkNode : plinksNodes) {
            PartnerLink linkObj = (PartnerLink)linkNode.getUserObject();
            if (!partnerLinkName.equalsIgnoreCase(linkObj.getName())) continue;
            PortNode partnerLinkPort = new PortNode(0);
            model.addChildNode((Node)linkNode, (Node)partnerLinkPort);
            PartnerLinkConnection edge = new PartnerLinkConnection(receivePortNode, partnerLinkPort);
            model.insertEdge((Edge)edge);
            break;
        }
    }

    @Override
    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        super.layout(x, y, w, h, info);
        this.m_interactionIcon = this.getInteractionIcon();
        return this.m_bounds;
    }

    protected Icon getInteractionIcon() {
        Reply reply = (Reply)this.getNode().getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null || !ip.isEditorForActivity((Activity)reply)) continue;
            return ip.getIcon();
        }
        return null;
    }

    @Override
    public void paint(Graphics g, int layer) {
        super.paint(g, layer);
        if (this.m_interactionIcon != null) {
            int iWidth = this.m_interactionIcon.getIconWidth();
            int iHeight = this.m_interactionIcon.getIconHeight();
            int xOffset = Math.max(0, (this.m_bounds.width - iWidth) / 2);
            int yOffset = Math.max(0, (this.m_bounds.height - iHeight) / 2);
            this.m_interactionIcon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + xOffset, this.m_bounds.y + yOffset);
        }
    }
}

