/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkConnection;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReceiveNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELTaskView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkConnectable;
import oracle.tip.tools.ide.pm.bpelgraph.views.PortView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ReceiveView
extends BPELTaskView
implements PartnerLinkConnectable {
    protected Icon m_interactionIcon;

    public ReceiveView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.setAcceptsArrow(true);
        this.m_insideBorderWidth = 0;
        this.m_outsideBorderToInsideBorder = 3;
        this.m_borderToImage = this.m_outsideBorderToInsideBorder + 5;
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("receive_node");
    }

    @Override
    public boolean isMinimized() {
        return this.getMinimize("MINIMIZE_RECEIVE_ACTIVITIES");
    }

    @Override
    protected Image getActivityImage() {
        return ImageCache.getImage("graph/bpel/receive_42x42.png");
    }

    public String getToolTipText() {
        return ReceiveView.getReceiveToolTipText((Receive)this.getNode().getUserObject());
    }

    public static String getReceiveToolTipText(Receive rec) {
        String ptype = "";
        QName portType = rec.getPortType();
        if (portType != null) {
            ptype = BPELModelUtil.getPrefixQualifiedName((QName)portType);
        }
        String settingsText = BPELStringTranslator.getString("COLLAXALAF_SETTINGS", "Settings");
        String text = "<html><body><table><tr><td colspan=2 align=center bgcolor=cyan><font color=black><b>Receive " + settingsText + "</b></font></td></tr>";
        if (rec.getEventName() == null) {
            text = text + ReceiveView.getRowHTML(BPELStringTranslator.getString("PORTTYPE"), ptype);
            text = text + ReceiveView.getRowHTML(BPELStringTranslator.getString("OPERATION"), rec.getOperation());
        } else {
            String eName = BPELModelUtil.getPrefixQualifiedName((QName)rec.getEventName());
            text = text + ReceiveView.getRowHTML(BPELStringTranslator.getString("EVENT_NAME"), eName);
        }
        text = text + ReceiveView.getRowHTML(BPELStringTranslator.getString("VARIABLE"), rec.getVariable());
        text = text + "</table></body></html>";
        return text;
    }

    protected static String getRowHTML(String name, String value) {
        if (value == null) {
            value = "";
        }
        return "<tr><td><b>" + name + ":</b></td><td>" + value + "</td></tr>";
    }

    @Override
    public void updatePartnerLinkGUIConnections() {
        String partnerLinkName;
        PortNode receivePortNode;
        ReceiveNode n = (ReceiveNode)this.getNode();
        Receive receiveModel = (Receive)n.getUserObject();
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        for (View v : this.m_children) {
            Edge[] edges;
            if (!(v instanceof PortView) || (edges = model.getEdgesForPort(receivePortNode = (PortNode)v.getNode())) == null || edges.length <= 0) continue;
            Edge edge = edges[0];
            PortNode target = edge.getTarget();
            PortNode src = edge.getSource();
            model.deleteEdges(edges);
            if (target != receivePortNode) {
                model.deleteNode(target.getParentNode(), (Node)target);
                break;
            }
            if (src == receivePortNode) break;
            model.deleteNode(src.getParentNode(), (Node)src);
            break;
        }
        if ((partnerLinkName = receiveModel.getPartnerLink()) == null) {
            return;
        }
        receivePortNode = (PortNode)n.getChildNode(0);
        List<PartnerLinkNode> plinksNodes = model.getPartnerLinkNodes();
        for (PartnerLinkNode linkNode : plinksNodes) {
            PartnerLink linkObj = (PartnerLink)linkNode.getUserObject();
            if (!partnerLinkName.equalsIgnoreCase(linkObj.getName())) continue;
            PortNode partnerLinkPort = new PortNode(1);
            model.addChildNode((Node)linkNode, (Node)partnerLinkPort);
            PartnerLinkConnection edge = new PartnerLinkConnection(receivePortNode, partnerLinkPort);
            model.insertEdge((Edge)edge);
            break;
        }
    }

    @Override
    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        super.layout(x, y, w, h, info);
        this.m_interactionIcon = this.getInteractionIcon();
        return this.m_bounds;
    }

    protected Icon getInteractionIcon() {
        Receive receive = (Receive)this.getNode().getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null || !ip.isEditorForActivity((Activity)receive)) continue;
            return ip.getIcon();
        }
        return null;
    }

    @Override
    public void paint(Graphics g, int layer) {
        super.paint(g, layer);
        if (this.m_interactionIcon != null) {
            int iWidth = this.m_interactionIcon.getIconWidth();
            int iHeight = this.m_interactionIcon.getIconHeight();
            int xOffset = Math.max(0, (this.m_bounds.width - iWidth) / 2);
            int yOffset = Math.max(0, (this.m_bounds.height - iHeight) / 2);
            this.m_interactionIcon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + xOffset, this.m_bounds.y + yOffset);
        }
    }
}

