/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.EventHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.Handler;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.ConnectedColumnView;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.TabTreeNode;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.VerticalDropBranchView;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddCatchAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddCatchAllAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddCompensationHandlerAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddOnAlarmAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddOnMessageAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.PartnerLinksAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.ShowHideFaultHandlersAction;
import oracle.tip.tools.ide.pm.bpelgraph.actions.VariablesAction;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.CatchAllNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CatchNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CompensationHandlerNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.EventHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.FaultHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnAlarmNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnMessageNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ProcessNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchAllView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CompensationHandlerView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnAlarmView;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnMessageView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ProcessView
extends ConnectedColumnView
implements StateSaveableView,
Tabable {
    protected static Color m_gutterClr = new Color(240, 240, 240);
    protected ConfigBox m_configTab;
    protected ConfigBox m_collapsedConfigBox;
    protected ConfigBox m_handlersConfigBox;
    protected int m_tabWidth;
    protected int m_dottedRectPadding = 5;
    protected int m_dottedRectWidth = 1;
    protected Rectangle m_verticalNameBox = new Rectangle();
    protected JTextField m_nameField = new JTextField();
    protected Rectangle m_nameBounds = new Rectangle();
    protected int m_imagePadding = 2;
    protected int m_borderWidth = 2;
    protected int m_borderToInsideBorder = 5;
    protected CollapseExpandViewAction m_collapseAction;
    protected List<NodeRenderer> m_faultHandlerViews = new ArrayList<NodeRenderer>();
    protected List<NodeRenderer> m_eventHandlerViews = new ArrayList<NodeRenderer>();
    protected boolean m_bShowHandlers = true;
    protected int m_handlerViewTopYOffset = 50;
    protected int m_faultsBottomPadding = 20;
    protected int m_handlerBranchPadding = 4;
    protected CompensationHandlerView m_compensationHandlerView;
    protected Rectangle m_processBorderBounds = new Rectangle();
    protected ShowHideFaultHandlersAction m_showHandlerAction;
    protected List<GraphAction> m_actions = new ArrayList<GraphAction>();

    public ProcessView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.m_configTab = new ConfigBox((View)this, this.getActions(), 1);
        this.m_configTab.setInsets(0, 0, 0, 0);
        this.m_configTab.setTransparentIcons(true);
        this.m_collapsedConfigBox = new ConfigBox((View)this, this.getCollapsedActions(), 0);
        this.m_collapsedConfigBox.setInsets(0, 0, 0, 0);
        this.m_handlersConfigBox = new ConfigBox((View)this, this.getHandlerActions(), 0);
        this.m_handlersConfigBox.setInsets(0, 0, 0, 0);
        this.m_handlersConfigBox.setDecorated(false);
        this.m_tabWidth = this.m_configTab.getSize().width;
        this.setInsets(this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_tabWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding);
        this.m_verticalSpacing = 10;
        this.computeVerticalNameBoxDimensions();
        this.setCanSelect(true);
        this.setCollapsable(true);
        this.setCanDelete(false);
        Boolean val = (Boolean)n.getData((Object)"collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(false);
        }
        val = (Boolean)n.getData((Object)"showhandlers");
        this.m_bShowHandlers = val == null ? true : val;
        this.updateActions();
    }

    public List<TabTreeNode> getTabTreeNodes() {
        ArrayList<Object> nodes = new ArrayList<TabTreeNode>();
        if (this.isVisible()) {
            if (!this.isCollapsed()) {
                for (NodeRenderer nodeRenderer : this.m_children) {
                    List list = nodeRenderer.getTabTreeNodes();
                    if (list == null) continue;
                    nodes.addAll(list);
                }
                if (this.getShowHandlers()) {
                    List<TabTreeNode> tabs2;
                    for (NodeRenderer r : this.m_faultHandlerViews) {
                        List list = r.getTabTreeNodes();
                        if (list == null) continue;
                        nodes.addAll(list);
                    }
                    for (NodeRenderer r : this.m_eventHandlerViews) {
                        List list = r.getTabTreeNodes();
                        if (list == null) continue;
                        nodes.addAll(list);
                    }
                    if (this.m_compensationHandlerView != null && (tabs2 = this.m_compensationHandlerView.getTabTreeNodes()) != null) {
                        nodes.addAll(tabs2);
                    }
                }
            }
            TabTreeNode treeNode = new TabTreeNode((Tabable)this);
            for (TabTreeNode tabTreeNode : nodes) {
                treeNode.addChild(tabTreeNode);
            }
            nodes = new ArrayList();
            nodes.add(treeNode);
        }
        return nodes;
    }

    public void setSelected(boolean bSelect) {
        super.setSelected(bSelect);
        this.m_configTab.setTransparentIcons(!bSelect);
        this.repaint();
    }

    public NodeEditor getNodeEditor() {
        return NodeEditorFactory.getNodeEditor(this.getNode());
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        this.m_handlersConfigBox.clearHighlights();
        this.m_configTab.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public ToolTipable getToolTipable(int x, int y) {
        ActionInfo info;
        if (!this.isCollapsed() && (info = this.hitActionArea(x, y)) != null) {
            return info.getToolTipable();
        }
        return null;
    }

    public Activity getActivity() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        return null;
    }

    public boolean isEditable() {
        Activity a = this.getActivity();
        return a != null && a.isEditable();
    }

    public void setShowHandlers(boolean bShow) {
        this.m_bShowHandlers = bShow;
        this.m_showHandlerAction.updateIcon();
    }

    public boolean getShowHandlers() {
        return this.m_bShowHandlers;
    }

    public CompensationHandlerView getCompensationHandlerView() {
        return this.m_compensationHandlerView;
    }

    public void deleteCompensationHandlerView(CompensationHandlerView v) {
        if (v != this.m_compensationHandlerView) {
            return;
        }
        ProcessNode n = (ProcessNode)this.getNode();
        Process p = (Process)n.getUserObject();
        p.deleteCompensationHandler();
        n.setCompensationHandlerNode(null);
        this.m_compensationHandlerView = null;
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        model.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void deleteCatchView(CatchView cv) {
        ProcessNode n;
        FaultHandlersNode fn;
        if (this.m_faultHandlerViews.contains(cv) && (fn = (n = (ProcessNode)this.getNode()).getFaultHandlersNode()) != null) {
            CatchNode cn = (CatchNode)cv.getNode();
            fn.removeChildNode((Node)cn);
            Process model = (Process)n.getUserObject();
            model.deleteCatch((Catch)cn.getUserObject());
            this.m_faultHandlerViews.remove(cv);
            BPELGraphModel graphMmodel = (BPELGraphModel)this.getGraphPane().getModel();
            graphMmodel.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void deleteCatchAllView(CatchAllView cv) {
        ProcessNode n;
        FaultHandlersNode fn;
        if (this.m_faultHandlerViews.contains(cv) && (fn = (n = (ProcessNode)this.getNode()).getFaultHandlersNode()) != null) {
            CatchAllNode cn = (CatchAllNode)cv.getNode();
            fn.removeChildNode((Node)cn);
            Process model = (Process)n.getUserObject();
            model.removeCatchAll();
            this.m_faultHandlerViews.remove(cv);
            BPELGraphModel graphMmodel = (BPELGraphModel)this.getGraphPane().getModel();
            graphMmodel.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void deleteOnAlarmView(OnAlarmView v) {
        ProcessNode n;
        EventHandlersNode handlersNode;
        if (this.m_eventHandlerViews.contains(v) && (handlersNode = (n = (ProcessNode)this.getNode()).getEventHandlersNode()) != null) {
            OnAlarmNode cn = (OnAlarmNode)v.getNode();
            handlersNode.removeChildNode((Node)cn);
            Process model = (Process)n.getUserObject();
            model.deleteOnAlarm((OnAlarm)cn.getUserObject());
            this.m_eventHandlerViews.remove((Object)handlersNode);
            BPELGraphModel graphMmodel = (BPELGraphModel)this.getGraphPane().getModel();
            graphMmodel.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void deleteOnMessageView(OnMessageView v) {
        ProcessNode n;
        EventHandlersNode handlersNode;
        if (this.m_eventHandlerViews.contains(v) && (handlersNode = (n = (ProcessNode)this.getNode()).getEventHandlersNode()) != null) {
            OnMessageNode cn = (OnMessageNode)v.getNode();
            handlersNode.removeChildNode((Node)cn);
            Process model = (Process)n.getUserObject();
            model.deleteOnMessage((OnMessage)cn.getUserObject());
            this.m_eventHandlerViews.remove((Object)handlersNode);
            BPELGraphModel graphMmodel = (BPELGraphModel)this.getGraphPane().getModel();
            graphMmodel.fireGraphStructureChanged();
            this.rebuildNodeRenderersFromModel();
            this.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void addCompensationHandler() {
        BPELGraphModel graphModel = (BPELGraphModel)this.getGraphPane().getModel();
        ProcessNode processNode = (ProcessNode)this.getNode();
        CompensationHandlerNode compHandlerNode = processNode.getCompensationHandlerNode();
        if (compHandlerNode != null) {
            return;
        }
        Process processImpl = (Process)processNode.getUserObject();
        compHandlerNode = (CompensationHandlerNode)ModelBuilder.createGraphNode(126, processImpl, true);
        CompensationHandler handler = processImpl.getCompensationHandler();
        if (handler == null) {
            handler = processImpl.createCompensationHandler();
        }
        compHandlerNode.setUserObject(handler);
        handler.setHandlerParentActivity((Activity)processImpl);
        processNode.setCompensationHandlerNode(compHandlerNode);
        graphModel.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addCatch() {
        ProcessNode n = (ProcessNode)this.getNode();
        Process process = (Process)n.getUserObject();
        BPELGraphModel graphModel = (BPELGraphModel)this.getGraphPane().getModel();
        FaultHandlersNode fn = n.getFaultHandlersNode();
        if (fn == null) {
            fn = (FaultHandlersNode)ModelBuilder.createGraphNode(124, process, true);
            FaultHandlers handler = process.getFaultHandlers();
            if (handler == null) {
                handler = process.createFaultHandlers();
            }
            fn.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)process);
        }
        CatchNode cNode = (CatchNode)ModelBuilder.createGraphNode(122, process, true);
        Catch ct = (Catch)cNode.getUserObject();
        ct.setParentHandler((Handler)((FaultHandlers)fn.getUserObject()));
        int childCount = fn.getChildCount();
        if (childCount > 0) {
            int idx = childCount - 1;
            fn.insertChildNode(idx, (Node)cNode);
        } else {
            fn.addChildNode((Node)cNode);
        }
        process.addCatch(ct);
        n.setFaultHandlersNode(fn);
        graphModel.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addCatchAll() {
        ProcessNode n = (ProcessNode)this.getNode();
        Process process = (Process)n.getUserObject();
        BPELGraphModel graphModel = (BPELGraphModel)this.getGraphPane().getModel();
        FaultHandlersNode fn = n.getFaultHandlersNode();
        if (fn == null) {
            fn = (FaultHandlersNode)ModelBuilder.createGraphNode(124, process, true);
            FaultHandlers handler = process.getFaultHandlers();
            if (handler == null) {
                handler = process.createFaultHandlers();
            }
            fn.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)process);
        }
        CatchAllNode cNode = (CatchAllNode)ModelBuilder.createGraphNode(123, process, true);
        CatchAll ct = (CatchAll)cNode.getUserObject();
        fn.addChildNode((Node)cNode);
        process.setCatchAll(ct);
        n.setFaultHandlersNode(fn);
        graphModel.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addOnMessage() {
        ProcessNode n = (ProcessNode)this.getNode();
        Process process = (Process)n.getUserObject();
        BPELGraphModel graphModel = (BPELGraphModel)this.getGraphPane().getModel();
        EventHandlersNode evtHandlerNode = n.getEventHandlersNode();
        if (evtHandlerNode == null) {
            evtHandlerNode = (EventHandlersNode)ModelBuilder.createGraphNode(125, process, true);
            EventHandlers handler = process.getEventHandlers();
            if (handler == null) {
                handler = process.createEventHandlers();
            }
            evtHandlerNode.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)process);
        }
        OnMessageNode msgNode = (OnMessageNode)ModelBuilder.createGraphNode(115, process, true);
        OnMessage msg = (OnMessage)msgNode.getUserObject();
        msg.setParentHandler((Handler)((EventHandlers)evtHandlerNode.getUserObject()));
        process.addOnMessage(msg);
        evtHandlerNode.addChildNode((Node)msgNode);
        n.setEventHandlersNode(evtHandlerNode);
        graphModel.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void addOnAlarm() {
        ProcessNode n = (ProcessNode)this.getNode();
        Process process = (Process)n.getUserObject();
        BPELGraphModel graphModel = (BPELGraphModel)this.getGraphPane().getModel();
        EventHandlersNode evtHandlerNode = n.getEventHandlersNode();
        if (evtHandlerNode == null) {
            evtHandlerNode = (EventHandlersNode)ModelBuilder.createGraphNode(125, process, true);
            EventHandlers handler = process.getEventHandlers();
            if (handler == null) {
                handler = process.createEventHandlers();
            }
            evtHandlerNode.setUserObject(handler);
            handler.setHandlerParentActivity((Activity)process);
        }
        OnAlarmNode alarmNode = (OnAlarmNode)ModelBuilder.createGraphNode(116, process, true);
        OnAlarm alarm = (OnAlarm)alarmNode.getUserObject();
        alarm.setParentHandler((Handler)((EventHandlers)evtHandlerNode.getUserObject()));
        process.addOnAlarm(alarm);
        evtHandlerNode.addChildNode((Node)alarmNode);
        n.setEventHandlersNode(evtHandlerNode);
        graphModel.fireGraphStructureChanged();
        this.rebuildNodeRenderersFromModel();
        this.setShowHandlers(true);
        this.getGraphPane().forceImmediateLayout(true);
    }

    public void rebuildNodeRenderersFromModel() {
        CompensationHandlerNode compHandlerNode;
        EventHandlersNode evtNode;
        super.rebuildNodeRenderersFromModel();
        ProcessNode n = (ProcessNode)this.getNode();
        GraphPane pane = this.getGraphPane();
        NodeRendererFactory f = pane.getNodeRendererFactory();
        FaultHandlersNode fn = n.getFaultHandlersNode();
        if (fn != null) {
            ArrayList<NodeRenderer> newHandlers = new ArrayList<NodeRenderer>();
            for (Node childNode : fn.getChildren()) {
                NodeRenderer v = this.getFaultViewForNode(childNode);
                if (v == null) {
                    v = f.createNodeRenderer(pane, childNode);
                    v.createChildNodeRenderers();
                    v.setParent((NodeRenderer)this);
                }
                newHandlers.add(v);
            }
            this.m_faultHandlerViews = newHandlers;
        }
        if ((evtNode = n.getEventHandlersNode()) != null) {
            ArrayList<NodeRenderer> newHandlers = new ArrayList<NodeRenderer>();
            for (Node childNode : evtNode.getChildren()) {
                NodeRenderer v = this.getEventHandlerViewForNode(childNode);
                if (v == null) {
                    v = f.createNodeRenderer(pane, childNode);
                    v.createChildNodeRenderers();
                    v.setParent((NodeRenderer)this);
                }
                newHandlers.add(v);
            }
            this.m_eventHandlerViews = newHandlers;
        }
        if ((compHandlerNode = n.getCompensationHandlerNode()) != null && this.m_compensationHandlerView == null) {
            this.m_compensationHandlerView = (CompensationHandlerView)f.createNodeRenderer(pane, (Node)compHandlerNode);
            this.m_compensationHandlerView.createChildNodeRenderers();
            this.m_compensationHandlerView.setParent((NodeRenderer)this);
        }
    }

    protected NodeRenderer getEventHandlerViewForNode(Node n) {
        Iterator it = this.getEventHandlerViews();
        while (it.hasNext()) {
            NodeRenderer r = (NodeRenderer)it.next();
            Node viewNode = r.getNode();
            if (viewNode != n) continue;
            return r;
        }
        return null;
    }

    protected NodeRenderer getFaultViewForNode(Node n) {
        Iterator it = this.getFaultHandlerViews();
        while (it.hasNext()) {
            NodeRenderer r = (NodeRenderer)it.next();
            Node viewNode = r.getNode();
            if (viewNode != n) continue;
            return r;
        }
        return null;
    }

    public void createChildNodeRenderers() {
        CompensationHandlerNode compHandlerNode;
        NodeRenderer r;
        super.createChildNodeRenderers();
        GraphPane pane = this.getGraphPane();
        NodeRendererFactory f = pane.getNodeRendererFactory();
        this.m_faultHandlerViews.clear();
        ProcessNode processNode = (ProcessNode)this.getNode();
        FaultHandlersNode fn = processNode.getFaultHandlersNode();
        if (fn != null) {
            for (Node childNode : fn.getChildren()) {
                r = f.createNodeRenderer(pane, childNode);
                if (r == null) continue;
                r.createChildNodeRenderers();
                r.setParent((NodeRenderer)this);
                this.m_faultHandlerViews.add(r);
            }
        }
        this.m_eventHandlerViews.clear();
        EventHandlersNode evtHandlersNode = processNode.getEventHandlersNode();
        if (evtHandlersNode != null) {
            for (Node childNode : evtHandlersNode.getChildren()) {
                NodeRenderer r2 = f.createNodeRenderer(pane, childNode);
                if (r2 == null) continue;
                r2.createChildNodeRenderers();
                r2.setParent((NodeRenderer)this);
                this.m_eventHandlerViews.add(r2);
            }
        }
        if ((compHandlerNode = processNode.getCompensationHandlerNode()) != null && (r = f.createNodeRenderer(pane, (Node)compHandlerNode)) != null) {
            r.createChildNodeRenderers();
            r.setParent((NodeRenderer)this);
            this.m_compensationHandlerView = (CompensationHandlerView)r;
        }
    }

    public NodeRenderer getNodeRendererAtPosition(int x, int y) {
        if (this.m_bounds.contains(x, y)) {
            NodeRenderer result;
            NodeRenderer result2;
            if (this.m_faultHandlerViews.size() > 0) {
                for (NodeRenderer r : this.m_faultHandlerViews) {
                    result2 = r.getNodeRendererAtPosition(x, y);
                    if (result2 == null) continue;
                    return result2;
                }
            }
            if (this.m_eventHandlerViews.size() > 0) {
                for (NodeRenderer r : this.m_eventHandlerViews) {
                    result2 = r.getNodeRendererAtPosition(x, y);
                    if (result2 == null) continue;
                    return result2;
                }
            }
            if (this.m_compensationHandlerView != null && (result = this.m_compensationHandlerView.getNodeRendererAtPosition(x, y)) != null) {
                return result;
            }
            return super.getNodeRendererAtPosition(x, y);
        }
        return null;
    }

    public NodeRenderer findNodeRendererForNode(Node n) {
        NodeRenderer result;
        NodeRenderer result2;
        if (this.m_faultHandlerViews.size() > 0) {
            for (NodeRenderer r : this.m_faultHandlerViews) {
                result2 = r.findNodeRendererForNode(n);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.m_eventHandlerViews.size() > 0) {
            for (NodeRenderer r : this.m_eventHandlerViews) {
                result2 = r.findNodeRendererForNode(n);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.m_compensationHandlerView != null && (result = this.m_compensationHandlerView.findNodeRendererForNode(n)) != null) {
            return result;
        }
        return super.findNodeRendererForNode(n);
    }

    public List<GraphAction> getCollapsedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public List<GraphAction> getHandlerActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_showHandlerAction = new ShowHideFaultHandlersAction((View)this);
        actions.add(this.m_showHandlerAction);
        return actions;
    }

    public List<GraphAction> getActions() {
        if (this.m_actions.size() != 0) {
            this.updateActions();
            return this.m_actions;
        }
        this.m_actions = new ArrayList<GraphAction>();
        boolean bEditable = this.getGraphPane().isEditable();
        if (bEditable) {
            this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
            this.m_actions.add((GraphAction)this.m_collapseAction);
            this.m_actions.add(new VariablesAction((View)this));
            this.m_actions.add(new PartnerLinksAction((View)this));
            this.m_actions.add(new AddCatchAction((View)this));
            this.m_actions.add(new AddCatchAllAction((View)this));
            this.m_actions.add(new AddOnMessageAction((View)this));
            this.m_actions.add(new AddOnAlarmAction((View)this));
            this.m_actions.add(new AddCompensationHandlerAction((View)this));
        } else {
            this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
            this.m_actions.add((GraphAction)this.m_collapseAction);
        }
        return this.m_actions;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
    }

    public Cursor getCursor(int x, int y) {
        ActionInfo info = this.hitActionArea(x, y);
        return info == null ? null : Cursor.getPredefinedCursor(12);
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isCollapsed()) {
            return this.m_collapsedConfigBox.hitActionArea(x, y);
        }
        ActionInfo info = this.m_handlersConfigBox.hitActionArea(x, y);
        if (info != null) {
            return info;
        }
        return this.m_configTab.hitActionArea(x, y);
    }

    private String getName() {
        String name = this.getNode().getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    public boolean hitNameEdit(int x, int y) {
        return this.m_nameBounds.contains(x, y);
    }

    public boolean canEditName() {
        return this.isCollapsed() && this.isEditable();
    }

    public void setEditingName(boolean bEditing) {
        super.setEditingName(bEditing);
        GraphPane pane = this.getGraphPane();
        if (bEditing) {
            pane.add((Component)this.m_nameField);
            Dimension prefDim = this.m_nameField.getPreferredSize();
            String text = this.getName();
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)text);
            this.m_nameField.setText(text);
            this.m_nameField.setCaretPosition(0);
            this.m_nameField.requestFocus();
            int xOffset = 0;
            int w = strWidth + this.m_nameField.getInsets().left + this.m_nameField.getInsets().right;
            if (this.m_nameBounds.width < w) {
                xOffset = -(w - this.m_nameBounds.width) / 2;
            }
            this.m_nameField.setBounds(this.m_nameBounds.x + xOffset, this.m_nameBounds.y, w, prefDim.height);
            this.m_nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ProcessView.this.setEditingName(false);
                        ProcessView.this.saveNameChange();
                    }
                }
            });
            this.m_nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    ProcessView.this.setEditingName(false);
                    ProcessView.this.saveNameChange();
                }
            });
        } else {
            pane.remove((Component)this.m_nameField);
        }
        pane.repaint();
    }

    protected void saveNameChange() {
        Node n = this.getNode();
        n.setName(this.m_nameField.getText());
        this.computeVerticalNameBoxDimensions();
        this.getGraphPane().forceLayout();
    }

    protected void computeVerticalNameBoxDimensions() {
        Dimension d = this.m_configTab.getSize();
        this.m_verticalNameBox.width = d.width;
        this.m_verticalNameBox.height = 8 + GraphUtils.getStringWidth((Font)BPELGraphPane.VERTICAL_FONT, (String)this.getName());
    }

    protected void paintSelected(Graphics g) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        this.paintBorder(g, c, this.m_borderWidth);
    }

    protected Color getTextColor() {
        return this.isEditable() ? Color.black : Color.lightGray;
    }

    public void paint(Graphics g, int layer) {
        if (this.isSelected()) {
            g.setColor(BPELGraphPane.VIEW_SELECTION_BACKGROUND);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
            return;
        }
        if (this.isCollapsed()) {
            Image img = this.getImage();
            int xOffset = (this.m_bounds.width - img.getWidth(null)) / 2;
            g.drawImage(img, this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, null);
            String name = this.getName();
            if (name != null) {
                g.setColor(this.getTextColor());
                g.setFont(UIManager.getFont("Label.font"));
                g.drawString(name, this.m_nameBounds.x, this.m_nameBounds.y + GraphUtils.getFontAscent((Font)g.getFont()));
            }
            this.m_collapsedConfigBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
        } else {
            this.m_configTab.paint(g, m_gutterClr);
            if (this.hasHandlers()) {
                this.m_handlersConfigBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
            }
            if (this.getShowHandlers()) {
                this.paintHandlers(this.getAllHandlerViews(), g);
            }
            GraphUtils.paintVerticalTabText((Graphics)g, (String)this.getName(), (int)this.m_verticalNameBox.x, (int)this.m_verticalNameBox.y, (int)this.m_verticalNameBox.width, (int)this.m_verticalNameBox.height, (Color)BPELGraphPane.TAB_BORDER_COLOR, (Color)BPELGraphPane.TAB_BACKGROUND_COLOR, (Color)BPELGraphPane.TAB_TEXT_COLOR, (float)(this.isSelected() ? 1.0f : 0.6f));
            GraphUtils.drawDottedRect((Graphics)g, (int)this.m_processBorderBounds.x, (int)this.m_processBorderBounds.y, (int)this.m_processBorderBounds.width, (int)this.m_processBorderBounds.height, (Color)BPELGraphPane.DOTTED_BORDER_COLOR, (float)1.0f);
            super.paint(g, layer);
        }
    }

    protected boolean hasHandlers() {
        return this.getAllHandlerViews().size() > 0;
    }

    protected void paintHandlers(List<NodeRenderer> handlerViews, Graphics g) {
        if (handlerViews.size() > 0) {
            int bottomMostFaultBranchY = 0;
            int sz = handlerViews.size();
            for (int i = 0; i < sz; ++i) {
                NodeRenderer r = handlerViews.get(i);
                r.paint(g, 0);
                bottomMostFaultBranchY = Math.max(bottomMostFaultBranchY, r.getBounds().y + r.getBounds().height);
            }
            int thickness = this.getGraphPane().getLineThickness();
            Color lineClr = this.getGraphPane().getLineColor();
            BaseView r = (BaseView)handlerViews.get(sz - 1);
            int rightMostBranchX = r.getConnectionX();
            int topHorzY = this.m_bounds.y + this.m_insets.top + this.m_handlerViewTopYOffset / 2;
            GraphUtils.drawHorzLine((Graphics)g, (int)(this.m_processBorderBounds.x + this.m_processBorderBounds.width), (int)topHorzY, (int)rightMostBranchX, (float)thickness, (Color)lineClr);
            int leftX = this.m_processBorderBounds.x + this.m_processBorderBounds.width;
            if (bottomMostFaultBranchY > this.m_processBorderBounds.y + this.m_processBorderBounds.height) {
                leftX = this.m_connectionX;
            }
            int bottomHorzY = bottomMostFaultBranchY + this.m_faultsBottomPadding / 2;
            GraphUtils.drawHorzLine((Graphics)g, (int)leftX, (int)bottomHorzY, (int)rightMostBranchX, (float)thickness, (Color)lineClr);
            if (this.m_processBorderBounds.y + this.m_processBorderBounds.height < bottomHorzY) {
                GraphUtils.drawVertLine((Graphics)g, (int)this.m_connectionX, (int)bottomHorzY, (int)(this.m_processBorderBounds.y + this.m_processBorderBounds.height), (float)thickness, (Color)lineClr);
            }
            for (int i = 0; i < sz; ++i) {
                BaseView view = (BaseView)handlerViews.get(i);
                GraphUtils.drawVertLine((Graphics)g, (int)view.getConnectionX(), (int)topHorzY, (int)view.topY(), (float)thickness, (Color)lineClr);
                GraphUtils.drawVertLine((Graphics)g, (int)view.getConnectionX(), (int)bottomHorzY, (int)view.bottomY(), (float)thickness, (Color)lineClr);
            }
        }
    }

    public void move(int x, int y) {
        NodeRenderer r;
        super.move(x, y);
        this.m_processBorderBounds.x += x;
        this.m_processBorderBounds.y += y;
        this.m_collapsedConfigBox.move(x, y);
        this.m_configTab.move(x, y);
        this.m_handlersConfigBox.move(x, y);
        this.m_verticalNameBox.x += x;
        this.m_verticalNameBox.y += y;
        this.m_nameBounds.x += x;
        this.m_nameBounds.y += y;
        Iterator it = this.getFaultHandlerViews();
        while (it.hasNext()) {
            r = (NodeRenderer)it.next();
            r.move(x, y);
        }
        it = this.getEventHandlerViews();
        while (it.hasNext()) {
            r = (NodeRenderer)it.next();
            r.move(x, y);
        }
        if (this.m_compensationHandlerView != null) {
            this.m_compensationHandlerView.move(x, y);
        }
    }

    protected List<NodeRenderer> getAllHandlerViews() {
        ArrayList<NodeRenderer> handlerViews = new ArrayList<NodeRenderer>(this.m_faultHandlerViews);
        handlerViews.addAll(this.m_eventHandlerViews);
        if (this.m_compensationHandlerView != null) {
            handlerViews.add((NodeRenderer)this.m_compensationHandlerView);
        }
        return handlerViews;
    }

    protected Iterator getFaultHandlerViews() {
        return this.m_faultHandlerViews.iterator();
    }

    protected Iterator getEventHandlerViews() {
        return this.m_eventHandlerViews.iterator();
    }

    private void updateActions() {
        if (this.m_actions == null) {
            return;
        }
        for (GraphAction a : this.m_actions) {
            if (!(a instanceof GraphAction)) continue;
            GraphAction ga = a;
            ga.updateState();
        }
    }

    protected Image getActivityImage() {
        return ImageCache.getImage("graph/bpel/process.jpg");
    }

    protected Image getImage() {
        if (!this.isEditable()) {
            return BasicImageCache.createDisabledImage((Image)this.getActivityImage());
        }
        return this.getActivityImage();
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        BaseView v;
        int i;
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        this.updateActions();
        this.m_showHandlerAction.updateIcon();
        this.setInsets(this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_tabWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding);
        this.setBounds(x, y, 0, 0);
        if (this.isCollapsed()) {
            Dimension configSize = this.m_collapsedConfigBox.getSize();
            Image img = this.getImage();
            int iWidth = img.getWidth(null);
            int iHeight = img.getHeight(null);
            int imageViewWidth = 2 * (iWidth / 2 + this.m_imagePadding + configSize.width + this.m_imagePadding + this.m_borderWidth);
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)this.getName());
            int strViewWidth = this.m_borderWidth + this.m_imagePadding + strWidth + this.m_imagePadding + this.m_borderWidth;
            int viewWidth = Math.max(imageViewWidth, strViewWidth);
            int strHeight = GraphUtils.getFontHeight((Font)UIManager.getFont("Label.font"));
            int viewHeight = this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding + strHeight + this.m_borderWidth;
            this.setBounds(x, y, viewWidth, viewHeight);
            this.m_connectionX = this.midX();
            this.m_collapsedConfigBox.setBounds(this.m_connectionX - iWidth / 2 - configSize.width, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, configSize.width, configSize.height);
            int xOffset = (this.m_bounds.width - strWidth) / 2;
            this.m_nameBounds.setBounds(this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding, strWidth, strHeight);
            return this.m_bounds;
        }
        Dimension handlerConfigSize = this.m_handlersConfigBox.getSize();
        this.setInsets(this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_tabWidth + this.m_dottedRectPadding, this.m_borderWidth + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding, this.m_borderWidth + handlerConfigSize.width + this.m_borderToInsideBorder + this.m_dottedRectWidth + this.m_dottedRectPadding);
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int nChildren = this.m_children.size();
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        Dimension tabSize = this.m_configTab.getSize();
        this.m_bounds.height = Math.max(this.m_bounds.height, 2 * this.m_borderWidth + 2 * this.m_borderToInsideBorder + 2 * this.m_dottedRectWidth + tabSize.height + this.m_verticalNameBox.height);
        this.m_configTab.setBounds(this.m_bounds.x + this.m_borderWidth + this.m_borderToInsideBorder, this.m_bounds.y + this.m_insets.top - this.m_dottedRectPadding, tabSize.width, tabSize.height);
        this.m_verticalNameBox.setLocation(this.m_configTab.getBounds().x, this.m_configTab.getBounds().y + this.m_configTab.getBounds().height);
        this.m_processBorderBounds.setBounds(this.m_bounds.x + this.m_insets.left - this.m_dottedRectPadding, this.m_bounds.y + this.m_insets.top - this.m_dottedRectPadding, this.m_bounds.width - this.m_insets.left - this.m_insets.right + 2 * this.m_dottedRectPadding, this.m_bounds.height - this.m_insets.top - this.m_insets.bottom + 2 * this.m_dottedRectPadding);
        this.m_handlersConfigBox.setBounds(this.m_processBorderBounds.x + this.m_processBorderBounds.width, this.m_processBorderBounds.y, handlerConfigSize.width, handlerConfigSize.height);
        if (this.getShowHandlers()) {
            int maxBranchHeight = 0;
            List<NodeRenderer> handlerViews = this.getAllHandlerViews();
            int handlersWidth = 0;
            int handlersHeight = 0;
            if (handlerViews.size() > 0) {
                yPos = this.m_bounds.y + this.m_insets.top + this.m_handlerViewTopYOffset;
                xPos = this.m_bounds.x + this.m_bounds.width;
                for (int i2 = 0; i2 < handlerViews.size(); ++i2) {
                    NodeRenderer r = handlerViews.get(i2);
                    Rectangle bounds = r.layout(xPos, yPos, 0, 0, info);
                    maxBranchHeight = Math.max(maxBranchHeight, bounds.height);
                    xPos += bounds.width + this.m_handlerBranchPadding;
                    handlersWidth += bounds.width;
                    if (i2 < handlerViews.size() - 1) {
                        handlersWidth += this.m_handlerBranchPadding;
                    }
                    handlersHeight = Math.max(handlersHeight, bounds.height);
                }
                handlersWidth += this.m_insets.right;
            }
            this.m_bounds.width += handlersWidth;
            int heightDueToFaultHandlers = this.m_insets.top + this.m_handlerViewTopYOffset + handlersHeight + this.m_faultsBottomPadding + this.m_insets.bottom;
            this.m_bounds.height = Math.max(this.m_bounds.height, heightDueToFaultHandlers);
            for (NodeRenderer r : handlerViews) {
                if (!(r instanceof VerticalDropBranchView)) continue;
                VerticalDropBranchView v2 = (VerticalDropBranchView)r;
                this.stretchViewToHeight((View)v2, maxBranchHeight);
                v2.stretchLastDropView();
            }
        }
        return this.m_bounds;
    }

    public void centerLayout() {
        int viewWidth = this.m_bounds.width;
        int midX = this.m_bounds.x + this.m_bounds.width / 2;
        int nChildren = this.m_children.size();
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = this.getChild(i);
            Rectangle r = v.getBounds();
            if (viewWidth <= r.width) continue;
            int diff = Math.max(0, v.midX() - midX);
            v.move(diff, 0);
        }
    }

    protected void stretchViewToHeight(View v, int height) {
        if (v.isCollapsed()) {
            return;
        }
        Rectangle r = v.getBounds();
        if (r.height < height) {
            int diff = height - r.height;
            v.setBounds(r.x, r.y, r.width, r.height + diff);
        }
    }

    protected void paintTopConnection(Graphics g) {
    }

    protected void paintBottomConnection(Graphics g) {
    }
}

