/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.PortConnectionView;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.InvokeView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ReceiveView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ReplyView;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PortView
extends PortConnectionView {
    public PortView(GraphPane pane, View parent, PortNode n) {
        super(pane, parent, n);
        this.m_image = this.getImage();
    }

    public Cursor getCursor(int x, int y) {
        if (this.m_bounds.contains(x, y)) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    public void paint(Graphics g, int layer) {
        if (this.isVisible()) {
            Image i = this.getImage();
            g.drawImage(i, this.m_bounds.x, this.m_bounds.y, i.getWidth(null), i.getHeight(null), null);
        }
    }

    public int getPreferredSpan(int axis) {
        Image i = this.getImage();
        switch (axis) {
            case 0: {
                return i.getHeight(null);
            }
            case 1: {
                return i.getWidth(null);
            }
        }
        return 0;
    }

    public String getToolTipText() {
        Node parentNode = this.getNode().getParentNode();
        if (parentNode == null) {
            return null;
        }
        PortNode activityPortNode = null;
        if (parentNode instanceof PartnerLinkNode) {
            PortNode partnerLinkPortNode = (PortNode)this.getNode();
            BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
            BPELGraphModel model = (BPELGraphModel)pane.getModel();
            Edge[] edges = model.getEdgesForPort(partnerLinkPortNode);
            if (edges != null && edges.length > 0) {
                Edge e = edges[0];
                if (e.getSource() != partnerLinkPortNode) {
                    activityPortNode = e.getSource();
                } else if (e.getTarget() != partnerLinkPortNode) {
                    activityPortNode = e.getTarget();
                }
            }
        } else {
            activityPortNode = (PortNode)this.getNode();
        }
        String text = null;
        if (activityPortNode == null) {
            return null;
        }
        Object userObj = activityPortNode.getParentNode().getUserObject();
        if (userObj instanceof Invoke) {
            Invoke invoke = (Invoke)userObj;
            text = InvokeView.getInvokeToolTipText(invoke);
        } else if (userObj instanceof Receive) {
            Receive rec = (Receive)userObj;
            text = ReceiveView.getReceiveToolTipText(rec);
        } else if (userObj instanceof Reply) {
            Reply reply = (Reply)userObj;
            text = ReplyView.getReplyToolTipText(reply);
        }
        if (parentNode instanceof PartnerLinkNode) {
            return text;
        }
        return text != null ? text : "Drag onto a PartnerLink to make a web service connection.";
    }

    protected String getRowHTML(String name, String value) {
        if (value == null) {
            value = "";
        }
        return "<tr><td><b>" + name + ":</b></td><td>" + value + "</td></tr>";
    }

    public Point getConnectionPoint() {
        PortNode node = (PortNode)this.getNode();
        switch (this.m_orientation) {
            case 2: {
                if (node.getType() == 0) {
                    this.m_portConnectionPoint.setLocation(this.m_bounds.x - 2, this.m_bounds.y + this.m_bounds.height / 2);
                    break;
                }
                this.m_portConnectionPoint.setLocation(this.m_bounds.x - 2, this.m_bounds.y + this.m_bounds.height / 2);
                break;
            }
            case 4: {
                if (node.getType() == 0) {
                    this.m_portConnectionPoint.setLocation(this.m_bounds.x + this.m_bounds.width + 1, this.m_bounds.y + this.m_bounds.height / 2);
                    break;
                }
                this.m_portConnectionPoint.setLocation(this.m_bounds.x + this.m_bounds.width + 1, this.m_bounds.y + this.m_bounds.height / 2);
                break;
            }
            default: {
                this.m_portConnectionPoint.setLocation(this.m_bounds.x, this.m_bounds.y);
            }
        }
        return new Point(this.m_portConnectionPoint);
    }

    public Image getImage() {
        PortNode node = (PortNode)this.getNode();
        GraphModel model = this.getGraphPane().getModel();
        Edge[] edges = model.getEdgesForPort(node);
        boolean bConnected = edges.length > 0;
        switch (this.m_orientation) {
            case 2: {
                if (bConnected) {
                    if (node.getType() == 0) {
                        return ImageCache.getImage("graph/bpel/arrow_right_connected.png");
                    }
                    return ImageCache.getImage("graph/bpel/left_port_connected_blue.png");
                }
                if (node.getType() == 0) {
                    return ImageCache.getImage("graph/bpel/connector_left.png");
                }
                return ImageCache.getImage("graph/bpel/connector_left.png");
            }
            case 4: {
                if (bConnected) {
                    if (node.getType() == 0) {
                        return ImageCache.getImage("graph/bpel/arrow_left_connected.png");
                    }
                    return ImageCache.getImage("graph/bpel/right_port_connected_blue_5x10.png");
                }
                if (node.getType() == 0) {
                    return ImageCache.getImage("graph/bpel/connector_right.png");
                }
                return ImageCache.getImage("graph/bpel/connector_right.png");
            }
        }
        return GraphImageResource.PORT_SOURCE_CONNECTION_RIGHT;
    }

    public Image getDragImage(int x, int y) {
        Image img = null;
        boolean bDraggingLeft = x < this.m_bounds.x;
        img = bDraggingLeft ? ImageCache.getImage("graph/bpel/connector_left_drag_30x30.png") : ImageCache.getImage("graph/bpel/connector_right_drag_30x30.png");
        if (img == null) {
            img = this.getImage();
        }
        return img;
    }
}

