/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.PortView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.PartnerLinkNodeEditor2;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinkView
extends BaseView
implements ValidatableView,
Tabable,
VoiceAccessible {
    protected static Color BACKGROUND_SELECTED = new Color(213, 255, 213);
    protected int m_portSpacing = 0;
    protected int m_minHeight = 50;
    protected int m_portOrientation = 4;
    protected int m_imageToText = 5;
    protected int m_textToBorder = 5;
    protected int m_topToImage = 5;
    protected int m_borderWidth = 2;
    protected int m_maxPortWidth = 0;
    protected int m_topPadding = 2;
    protected int m_bottomPadding = 2;
    protected int m_minWidth = 100;
    protected int m_portPadding = 5;
    protected boolean m_bAbsolutePositioned = false;
    protected boolean m_bHighlight = false;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bGlobalPartnerLink = true;
    protected List<GraphAction> m_actions;
    protected String m_displayName;

    public PartnerLinkView(GraphPane pane, View parent, PartnerLinkNode n) {
        super(pane, parent, (Node)n);
        BPELGraphModel model;
        Scope s;
        int leftInset = 0;
        int rightInset = 0;
        this.setInsets(0, leftInset, 0, rightInset);
        this.setBackground(null);
        this.setCanSelect(true);
        this.setDraggable(false);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        PartnerLink l = (PartnerLink)n.getUserObject();
        if (l != null && !((s = BPELModelUtil.getScopeForPartnerLink((Process)(model = (BPELGraphModel)this.getGraphPane().getModel()).getProcess(), (PartnerLink)l)) instanceof Process)) {
            this.m_bGlobalPartnerLink = false;
        }
    }

    public boolean canDelete() {
        PartnerLink link = (PartnerLink)this.getNode().getUserObject();
        return link.isEditable();
    }

    public ToolTipable getToolTipable(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        return this;
    }

    public String getToolTipText() {
        String html = BPELStringTranslator.getString("COLLAXALAF_PARTNERLINK_TOOLTIP");
        if (html == null) {
            html = "<html><b>&nbsp;Partner Link</b><br>&nbsp;An external webservice that can call into<br>&nbsp;the process or be called by the process.</html>";
        }
        return html;
    }

    @Override
    public View getView() {
        return this;
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected ValidationContext createValidationContext() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        return new ValidationContext(model.getProcess());
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn;
        if (this.m_bounds.contains(x, y) && (btn = this.m_viewStatusBox.hitTest(x, y)) != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
    }

    public void setHighLighted(boolean bHightlight) {
        this.m_bHighlight = bHightlight;
    }

    public void setAbsolutePositioned(boolean bAbsolute) {
        this.m_bAbsolutePositioned = bAbsolute;
    }

    public boolean isAbsolutePositioned() {
        return this.m_bAbsolutePositioned;
    }

    public boolean isEditable() {
        PartnerLink link = (PartnerLink)this.getNode().getUserObject();
        return link.isEditable();
    }

    public NodeEditor getNodeEditor() {
        return new PartnerLinkNodeEditor2();
    }

    public void setPortOrientation(int orientation) {
        this.m_portOrientation = orientation;
    }

    private String getName() {
        PartnerLinkNode n = (PartnerLinkNode)this.getNode();
        PartnerLink lnk = (PartnerLink)n.getUserObject();
        if (lnk != null) {
            return lnk.getName();
        }
        return null;
    }

    public void paint(Graphics g, int layer) {
        int xOffset;
        if (this.isSelected()) {
            GraphUtils.fillSelectionBox((Graphics)g, (int)this.m_bounds.x, (int)this.m_bounds.y, (int)this.m_bounds.width, (int)this.m_bounds.height, (Color)BPELGraphPane.VIEW_SELECTION_BACKGROUND);
        }
        Color borderClr = this.isSelected() ? Color.black : new Color(156, 154, 156);
        Color c = Color.white;
        if (this.m_bHighlight) {
            c = Color.yellow;
        }
        int halfMaxPortWidth = this.m_maxPortWidth / 2;
        g.setColor(c);
        Rectangle insideBorder = this.m_portOrientation == 4 ? new Rectangle(this.m_bounds.x + this.m_borderWidth + this.m_insets.left + halfMaxPortWidth, this.m_bounds.y + this.m_borderWidth + this.m_topPadding, this.m_bounds.width - 2 * this.m_borderWidth - this.m_maxPortWidth - this.m_insets.left - this.m_insets.right, this.m_bounds.height - 2 * this.m_borderWidth - this.m_topPadding - this.m_bottomPadding) : new Rectangle(this.m_bounds.x + this.m_borderWidth + halfMaxPortWidth, this.m_bounds.y + this.m_borderWidth + this.m_topPadding, this.m_bounds.width - 2 * this.m_borderWidth - this.m_maxPortWidth - this.m_insets.left - this.m_insets.right, this.m_bounds.height - 2 * this.m_borderWidth - this.m_topPadding - this.m_bottomPadding);
        Color c1 = new Color(234, 235, 235);
        Color c2 = new Color(160, 160, 160);
        GradientPaint gp = new GradientPaint(insideBorder.x, insideBorder.y, c1, insideBorder.x, insideBorder.y + insideBorder.height, c2);
        int arc = 20;
        g.setColor(this.isPartnerLinkEditable() ? Color.white : Color.lightGray);
        g.fillRoundRect(insideBorder.x, insideBorder.y, insideBorder.width, insideBorder.height, arc, arc);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints oldHints = g2.getRenderingHints();
        g2.setRenderingHints(GraphUtils.SMOOTH_LINE_HINTS);
        Stroke oldStroke = g2.getStroke();
        BasicStroke newStroke = new BasicStroke(1.0f, 1, 0);
        g2.setStroke(newStroke);
        GraphUtils.drawRoundRect((Graphics)g, (int)insideBorder.x, (int)insideBorder.y, (int)insideBorder.width, (int)insideBorder.height, (float)2.0f, (Color)borderClr, (int)arc);
        g2.setRenderingHints(oldHints);
        g2.setStroke(oldStroke);
        if (this.isSelected()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            BPELSettings settings = graph.getSettings();
            this.paintSelectionBox(g, this.m_bounds, 2.0f, settings.m_selectedBorderBackgroundColor);
        }
        super.paint(g, layer);
        Icon icon = this.getPartnerLinkIcon();
        if (this.m_portOrientation == 4) {
            xOffset = insideBorder.x - this.m_bounds.x;
            xOffset += Math.max(0, (insideBorder.width - icon.getIconWidth()) / 2);
        } else {
            int xCentering = Math.max(0, (insideBorder.width - icon.getIconWidth()) / 2);
            xOffset = insideBorder.x - this.m_bounds.x + xCentering;
        }
        icon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_topPadding + this.m_topToImage);
        if (this.m_displayName != null) {
            g.setColor(this.getTextColor());
            g.setFont(this.getGraphPane().getFont());
            int textAscent = GraphUtils.getFontAscent((Font)g.getFont());
            int strWidth = GraphUtils.getStringWidth((Font)g.getFont(), (String)this.m_displayName);
            if (this.m_portOrientation == 4) {
                xOffset = insideBorder.x - this.m_bounds.x;
                xOffset += Math.max(0, (insideBorder.width - strWidth) / 2);
            } else {
                int xCentering = Math.max(0, (insideBorder.width - strWidth) / 2);
                xOffset = insideBorder.x - this.m_bounds.x + xCentering;
            }
            g.drawString(this.m_displayName, this.m_bounds.x + xOffset, this.topY() + this.m_borderWidth + this.m_topPadding + this.m_topToImage + icon.getIconHeight() + this.m_imageToText + textAscent);
        }
        this.paintStatusIcons(g);
    }

    protected boolean isPartnerLinkEditable() {
        PartnerLinkNode n = (PartnerLinkNode)this.getNode();
        if (n != null) {
            PartnerLink link = (PartnerLink)n.getUserObject();
            return link != null && link.isEditable();
        }
        return true;
    }

    protected Color getTextColor() {
        return this.isPartnerLinkEditable() ? Color.BLACK : Color.GRAY;
    }

    protected void paintSelected(Graphics g) {
    }

    public int getPreferredSpan(int axis) {
        return 80;
    }

    public void stretchToWidth(int width) {
        if (this.m_bounds.width < width) {
            if (this.m_portOrientation == 4) {
                int diff = width - this.m_bounds.width;
                Iterator iterator = this.getChildren();
                while (iterator.hasNext()) {
                    View v = (View)iterator.next();
                    v.move(diff, 0);
                }
            }
            this.m_bounds.width = width;
        }
        this.layoutStatusBox();
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        this.updateStatusButtons();
        if (this.isEditing()) {
            this.layoutEditingMode(x, y, w, h, info);
            return this.m_bounds;
        }
        this.setBounds(x, y, 0, 0);
        int textWidth = 0;
        int textHeight = 0;
        this.m_displayName = this.getName();
        if (Helper.hasValue((String)this.m_displayName)) {
            Font f = this.getGraphPane().getFont();
            textHeight = GraphUtils.getFontHeight((Font)f);
            textWidth = GraphUtils.getStringWidth((Font)f, (String)this.m_displayName);
            if (textWidth > 100) {
                this.m_displayName = Helper.stripString((String)this.m_displayName, (Font)f, (int)100);
                textWidth = GraphUtils.getStringWidth((Font)f, (String)this.m_displayName);
            }
        }
        int nChildren = this.m_children.size();
        Icon icon = this.getPartnerLinkIcon();
        int iWidth = icon.getIconWidth();
        int iHeight = icon.getIconHeight();
        this.m_maxPortWidth = 0;
        for (int i = 0; i < nChildren; ++i) {
            View v = (View)this.m_children.get(i);
            if (!(v instanceof PortView)) continue;
            this.m_maxPortWidth = Math.max(this.m_maxPortWidth, v.getPreferredSpan(1));
        }
        this.m_bounds.width = this.m_borderWidth + this.m_insets.left + this.m_maxPortWidth + this.m_portPadding + Math.max(iWidth, textWidth) + this.m_portPadding + this.m_maxPortWidth + this.m_insets.right + this.m_borderWidth;
        if (this.m_bounds.width < this.m_minWidth) {
            this.m_bounds.width = this.m_minWidth;
        }
        int heightDueToPorts = 0;
        int yPos = y + this.m_borderWidth + this.m_topPadding + this.m_topToImage;
        int portPadding = this.m_borderWidth + this.m_topPadding + this.m_topToImage;
        for (int i = 0; i < nChildren; ++i) {
            View v = (View)this.m_children.get(i);
            if (!(v instanceof PortView)) continue;
            PortView pv = (PortView)v;
            pv.setOrientation(this.m_portOrientation);
            if (i > 0) {
                yPos += this.m_portSpacing;
                heightDueToPorts += this.m_portSpacing;
            }
            int xPos = this.m_portOrientation == 4 ? this.m_bounds.x + this.m_bounds.width - this.m_borderWidth - this.m_maxPortWidth : this.m_bounds.x + this.m_borderWidth;
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            yPos += r.height;
            heightDueToPorts += r.height;
        }
        int noPortHeight = this.m_borderWidth + this.m_topPadding + this.m_topToImage + iHeight + this.m_imageToText + textHeight + this.m_textToBorder + this.m_bottomPadding + this.m_borderWidth;
        heightDueToPorts = portPadding + heightDueToPorts + portPadding;
        this.m_bounds.height = Math.max(noPortHeight, heightDueToPorts);
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        if (heightDueToPorts < this.m_bounds.height) {
            int diff = this.m_bounds.height - heightDueToPorts;
            for (int i = 0; i < nChildren; ++i) {
                View v = (View)this.m_children.get(i);
                if (!(v instanceof PortView)) continue;
                v.move(0, diff / 2);
            }
        }
        this.layoutStatusBox();
        return this.m_bounds;
    }

    protected Icon getPartnerLinkIcon() {
        Icon icon = null;
        PartnerLinkNode n = (PartnerLinkNode)this.getNode();
        if (n != null) {
            icon = n.getIcon();
        }
        if (icon == null) {
            icon = ImageCache.getIcon("graph/bpel/serviceicon_20x20.png");
        }
        return this.isPartnerLinkEditable() ? icon : ImageCache.createDisabledIcon(icon);
    }

    protected void layoutStatusBox() {
        if (this.m_portOrientation == 2) {
            this.m_viewStatusBox.layout(this.leftX() + this.m_borderWidth + this.m_maxPortWidth, this.m_bounds.y + this.m_borderWidth);
        } else {
            Dimension dim = this.m_viewStatusBox.computeSize();
            this.m_viewStatusBox.layout(this.rightX() - dim.width - this.m_borderWidth - this.m_maxPortWidth, this.m_bounds.y + this.m_borderWidth);
        }
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_viewStatusBox.move(x, y);
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj;
        Node node = this.getNode();
        if (node != null && (obj = node.getUserObject()) instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    public List<GraphAction> getActions() {
        if (this.m_actions != null) {
            return this.m_actions;
        }
        this.m_actions = new ArrayList<GraphAction>();
        ArrayList<GraphAction> extraActions = new ArrayList<GraphAction>();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<GraphAction> pluginActions = plugin.addViewAction((View)this);
            if (pluginActions == null) continue;
            extraActions.addAll(pluginActions);
        }
        if (extraActions.size() > 0) {
            this.m_actions.addAll(extraActions);
        }
        return this.m_actions;
    }

    public String getVoiceAccessibleText() {
        PartnerLink link = (PartnerLink)this.getNode().getUserObject();
        String s = "";
        if (link != null) {
            s = link.getName();
        }
        return "Partner Link " + s;
    }
}

