/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkNodeEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class PartnerLinkEditPanel
extends JPanel
implements ActionListener {
    JTextField m_nameField;
    JList m_portList;
    private JButton m_applyBtn;
    private JButton m_cancelBtn;
    private JButton m_addBtn;
    private PartnerLinkNodeEditor m_nodeEditor;
    GraphPane m_graph;

    public PartnerLinkEditPanel(PartnerLinkNodeEditor nodeEditor) {
        this.m_nodeEditor = nodeEditor;
        this.m_nameField = new JTextField();
        this.m_portList = new JList();
        this.m_applyBtn = new JButton(BPELStringTranslator.getString("APPLY_BUTTON_TEXT"));
        this.m_applyBtn.addActionListener(this);
        this.m_cancelBtn = new JButton("Cancel");
        this.m_cancelBtn.addActionListener(this);
        this.m_addBtn = new JButton("Add");
        this.m_addBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_applyBtn);
        btnPnl.add(this.m_cancelBtn);
        btnPnl.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)new JLabel("Name:"), (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.m_portList), (int)0, (int)2, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_addBtn, (int)0, (int)3, (int)2, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)btnPnl, (int)0, (int)4, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setPreferredSize(new Dimension(300, 300));
    }

    Object getValue() {
        NodeRenderer r = this.m_nodeEditor.getNodeRenderer();
        Node node = r.getNode();
        return node.getUserObject();
    }

    void loadControls() {
        NodeRenderer r = this.m_nodeEditor.getNodeRenderer();
        Node node = r.getNode();
        Object userObj = node.getUserObject();
        if (userObj == null) {
            userObj = BPELParser.createImplementation(PartnerLink.class);
            PartnerLink l = (PartnerLink)userObj;
            l.setName("Default Name");
            node.setUserObject((Object)l);
        }
        PartnerLink plink = (PartnerLink)node.getUserObject();
        this.m_nameField.setText(plink.getName());
        DefaultListModel<PortNode> model = new DefaultListModel<PortNode>();
        for (PortNode child : node.getChildren()) {
            model.addElement(child);
        }
        this.m_portList.setModel(model);
    }

    void handleAdd() {
        PortNode node = new PortNode(0);
        DefaultListModel model = (DefaultListModel)this.m_portList.getModel();
        model.addElement(node);
    }

    void saveChanges() {
        GraphModel graphModel = this.m_graph.getModel();
        NodeRenderer r = this.m_nodeEditor.getNodeRenderer();
        Node partnerLinkNode = r.getNode();
        String name = this.m_nameField.getText();
        PartnerLink pl = (PartnerLink)partnerLinkNode.getUserObject();
        pl.setName(name);
        DefaultListModel model = (DefaultListModel)this.m_portList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            PortNode pn = (PortNode)model.elementAt(i);
            int index = partnerLinkNode.indexOf((Node)pn);
            if (index != -1) continue;
            graphModel.addChildNode(partnerLinkNode, (Node)pn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_applyBtn) {
            this.saveChanges();
            this.m_nodeEditor.stopNodeEditing();
        } else if (src == this.m_cancelBtn) {
            this.m_nodeEditor.cancelNodeEditing();
        } else if (src == this.m_addBtn) {
            this.handleAdd();
        }
    }
}

