/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.DefaultEdgeRenderer;
import oracle.tip.tools.ide.common.graph.view.EdgeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneProperties;
import oracle.tip.tools.ide.pm.bpelgraph.views.BaseBPELTaskView;

public class PartnerLinkEdgeRenderer
extends DefaultEdgeRenderer
implements EdgeRenderer,
BPELGraphPaneProperties {
    protected BPELGraphPane m_pane;

    public PartnerLinkEdgeRenderer(BPELGraphPane pane) {
        this.m_pane = pane;
    }

    protected Color getEdgeColor() {
        BPELSettings settings = this.m_pane.getSettings();
        if (!this.canDelete()) {
            return this.isSelected() ? settings.m_selectedPartnerLinkColor : Color.lightGray;
        }
        return this.isSelected() ? settings.m_selectedPartnerLinkColor : settings.m_connectedPartnerLinkColor;
    }

    public boolean canDelete() {
        BPELGraphModel m = (BPELGraphModel)this.m_pane.getModel();
        Process process = m.getProcess();
        return process.isEditable();
    }

    public boolean isVisible() {
        BaseBPELTaskView v;
        boolean bVisible = super.isVisible();
        if (!bVisible) {
            return false;
        }
        if (this.m_edge.getSource() == null || this.m_edge.getTarget() == null) {
            return false;
        }
        Node n = this.m_edge.getSource().getParentNode();
        NodeRenderer r = this.m_pane.getNodeRendererForNode(n);
        if (r instanceof BaseBPELTaskView && (v = (BaseBPELTaskView)r).isMinimized()) {
            return false;
        }
        n = this.m_edge.getTarget().getParentNode();
        r = this.m_pane.getNodeRendererForNode(n);
        if (r instanceof BaseBPELTaskView && (v = (BaseBPELTaskView)r).isMinimized()) {
            return false;
        }
        this.m_bVisible = bVisible;
        return this.m_bVisible;
    }

    public Activity getActivityConnected() {
        PortNode srcPort = this.m_edge.getSource();
        Node srcNode = srcPort.getParentNode();
        if (srcNode.getUserObject() instanceof Activity) {
            return (Activity)srcNode.getUserObject();
        }
        PortNode targetPort = this.m_edge.getTarget();
        Node targetNode = targetPort.getParentNode();
        if (targetNode.getUserObject() instanceof Activity) {
            return (Activity)targetNode.getUserObject();
        }
        return null;
    }
}

