/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphModelEvent;
import oracle.tip.tools.ide.common.graph.event.GraphModelListener;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusEvent;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusListener;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;

public class OverViewPanel
extends JPanel
implements GraphModelListener,
GraphPaneStatusListener,
ChangeListener,
MouseListener,
MouseMotionListener {
    private static Font MESSAGE_FONT = null;
    private static Color TRANSPARENT_COLOR = Color.lightGray;
    protected BPELGraphPane m_pane;
    protected BPELGraphModel m_model;
    protected JViewport m_viewport;
    protected Rectangle m_scaledViewportRect = new Rectangle();
    protected JScrollPane m_scrollPane;
    protected boolean m_bPaintDiagramStructure = true;
    private static OverViewPanel m_instance;
    private Rectangle m_selectionRect = new Rectangle();

    private OverViewPanel(BPELGraphPane pane) {
        this.m_pane = pane;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void repaintSelectionBox() {
        if (this.m_pane == null) {
            return;
        }
        GraphElement graphElem = this.m_pane.getSelectedGraphElement();
        if (graphElem instanceof NodeRenderer) {
            Rectangle docRect = this.m_pane.getDocumentBounds();
            NodeRenderer r = (NodeRenderer)graphElem;
            for (NodeRenderer parent = r.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.isCollapsed()) continue;
                this.m_selectionRect.setBounds(0, 0, 0, 0);
                this.repaint();
                return;
            }
            Rectangle b = r.getBounds();
            double xPct = (double)b.x / (double)docRect.width;
            double yPct = (double)b.y / (double)docRect.height;
            double pctWidth = (double)b.width / (double)docRect.width;
            double pctHeight = (double)b.height / (double)docRect.height;
            Dimension scaledDim = this.computeScaledDimension();
            int xPos = (int)((double)scaledDim.width * xPct);
            int yPos = (int)((double)scaledDim.height * yPct);
            int w = (int)((double)scaledDim.width * pctWidth);
            int h = (int)((double)scaledDim.height * pctHeight);
            if (w < 10) {
                w = 10;
            }
            if (h < 10) {
                h = 10;
            }
            this.m_selectionRect.setBounds(xPos, yPos, w, h);
        }
        this.repaint();
    }

    public void updateThumbnail() {
        if (this.m_pane == null) {
            return;
        }
        this.m_pane.repaint();
    }

    public boolean getPaintDiagramStructure() {
        return this.m_bPaintDiagramStructure;
    }

    public void setPaintDiagramStructure(boolean bPaintDiagramStructure) {
        this.m_bPaintDiagramStructure = bPaintDiagramStructure;
        this.repaint();
    }

    public static synchronized OverViewPanel getInstance() {
        if (m_instance == null) {
            m_instance = new OverViewPanel(null);
        }
        return m_instance;
    }

    public BPELGraphPane getGraphPane() {
        return this.m_pane;
    }

    public synchronized void setGraphPane(BPELGraphPane graph) {
        this.m_viewport = null;
        this.m_scrollPane = null;
        if (this.m_pane != null) {
            this.m_pane.removeGraphPaneStatusListener(this);
        }
        this.m_pane = graph;
        if (graph != null) {
            graph.addGraphPaneStatusListener(this);
            this.setModel((BPELGraphModel)graph.getModel());
        }
        this.updateDisplay();
        this.repaint();
    }

    public void removeGraphPane(BPELGraphPane graph) {
        if (this.m_pane == graph) {
            this.setGraphPane(null);
        }
    }

    public void setModel(BPELGraphModel model) {
        if (this.m_model != null) {
            this.m_model.removeGraphModelListener(this);
        }
        this.m_scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)this.m_pane));
        if (this.m_scrollPane != null) {
            this.m_viewport = this.m_scrollPane.getViewport();
            this.m_viewport.addChangeListener(this);
        }
        if (model != null) {
            model.addGraphModelListener(this);
        }
        this.m_model = model;
        this.updateDisplay();
    }

    @Override
    public void doLayout() {
        this.computeViewportRect();
    }

    protected void computeViewportRect() {
        if (this.m_viewport == null || this.m_pane == null) {
            this.m_scaledViewportRect.setBounds(0, 0, 0, 0);
            return;
        }
        Rectangle viewPortRect = this.m_viewport.getViewRect();
        Component comp = this.m_viewport.getView();
        Dimension scaledDim = this.computeScaledDimension();
        double pctX = (double)viewPortRect.x / (double)comp.getWidth();
        double scaledViewportX = pctX * scaledDim.getWidth();
        double pctY = (double)viewPortRect.y / (double)comp.getHeight();
        double scaledViewportY = pctY * scaledDim.getHeight();
        double pctWidth = (double)viewPortRect.width / (double)comp.getWidth();
        double scaledViewportWidth = pctWidth * scaledDim.getWidth();
        double pctHeight = (double)viewPortRect.height / (double)comp.getHeight();
        double scaledViewportHeight = pctHeight * scaledDim.getHeight();
        this.m_scaledViewportRect.setBounds((int)scaledViewportX, (int)scaledViewportY, (int)scaledViewportWidth, (int)scaledViewportHeight);
        this.repaintSelectionBox();
    }

    protected void paintTransparentRectangle(Graphics g, Rectangle r) {
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = g2d.getComposite();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, 0.25f);
        g2d.setComposite(alphaComp);
        g2d.setColor(Color.gray);
        g.fillRect(r.x, r.y, r.width, r.height);
        g2d.setComposite(oldComp);
    }

    public synchronized Dimension computeScaledDimension() {
        double scaledGraphPaneWidth;
        double scaledGraphPaneHeight;
        Dimension overviewPanelDim = this.getSize();
        if (this.m_viewport == null || this.m_pane == null) {
            return null;
        }
        Rectangle2D.Double graphPaneRect = new Rectangle2D.Double(0.0, 0.0, this.m_pane.getDocumentBounds().width, this.m_pane.getDocumentBounds().height);
        if (((RectangularShape)graphPaneRect).getHeight() > ((RectangularShape)graphPaneRect).getWidth()) {
            scaledGraphPaneHeight = overviewPanelDim.height - 1;
            scaledGraphPaneWidth = ((RectangularShape)graphPaneRect).getWidth() / ((RectangularShape)graphPaneRect).getHeight() * scaledGraphPaneHeight;
            while (scaledGraphPaneWidth > (double)overviewPanelDim.width) {
                scaledGraphPaneWidth = ((RectangularShape)graphPaneRect).getWidth() / ((RectangularShape)graphPaneRect).getHeight() * (scaledGraphPaneHeight -= 1.0);
            }
        } else {
            scaledGraphPaneWidth = overviewPanelDim.width - 1;
            scaledGraphPaneHeight = ((RectangularShape)graphPaneRect).getHeight() * scaledGraphPaneWidth / ((RectangularShape)graphPaneRect).getWidth();
            while (scaledGraphPaneHeight > (double)overviewPanelDim.height) {
                scaledGraphPaneHeight = ((RectangularShape)graphPaneRect).getHeight() * (scaledGraphPaneWidth -= 1.0) / ((RectangularShape)graphPaneRect).getWidth();
            }
        }
        return new Dimension((int)scaledGraphPaneWidth, (int)scaledGraphPaneHeight);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, sz.width, sz.height);
        if (this.m_pane != null) {
            int xOffset;
            int iHeight;
            int iWidth;
            int yOffset = 0;
            if (this.m_pane.inDrillDownMode()) {
                return;
            }
            if (this.getPaintDiagramStructure()) {
                Image i = this.m_pane.getPaneImage();
                if (i == null) return;
                iWidth = i.getWidth(null);
                iHeight = i.getHeight(null);
                xOffset = Math.max(0, (sz.width - iWidth) / 2);
                g.drawImage(i, xOffset, yOffset, null);
                g.setColor(new Color(148, 150, 148));
                g.drawRect(xOffset, yOffset, iWidth, iHeight);
            } else {
                Dimension scaledDim = this.computeScaledDimension();
                xOffset = Math.max(0, (sz.width - scaledDim.width) / 2);
                iWidth = scaledDim.width;
                iHeight = scaledDim.height;
                g.setColor(Color.white);
                g.fillRect(xOffset, yOffset, iWidth, iHeight);
                g.setColor(Color.black);
                g.drawRect(xOffset, yOffset, iWidth, iHeight);
            }
            if (this.m_scaledViewportRect != null && this.m_scaledViewportRect.height > 0 && this.m_scaledViewportRect.width > 0) {
                Color bg = TRANSPARENT_COLOR;
                Rectangle rect = new Rectangle(xOffset, yOffset, iWidth, this.m_scaledViewportRect.y - yOffset);
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
                rect.setBounds(xOffset, this.m_scaledViewportRect.y, this.m_scaledViewportRect.x, yOffset + iHeight - this.m_scaledViewportRect.y);
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
                rect.setBounds(xOffset + this.m_scaledViewportRect.x + this.m_scaledViewportRect.width, this.m_scaledViewportRect.y, xOffset + iWidth - (xOffset + this.m_scaledViewportRect.x + this.m_scaledViewportRect.width), yOffset + iHeight - this.m_scaledViewportRect.y);
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
                rect.setBounds(xOffset + this.m_scaledViewportRect.x, this.m_scaledViewportRect.y + this.m_scaledViewportRect.height, this.m_scaledViewportRect.width, yOffset + iHeight - (this.m_scaledViewportRect.y + this.m_scaledViewportRect.height));
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)rect, (Color)bg, (float)0.25f);
                Color c = new Color(192, 192, 192);
                GraphUtils.drawRect((Graphics)g, (int)(this.m_scaledViewportRect.x + xOffset), (int)this.m_scaledViewportRect.y, (int)this.m_scaledViewportRect.width, (int)this.m_scaledViewportRect.height, (int)1, (Color)c);
            }
            if (this.m_selectionRect.width <= 0 || this.m_selectionRect.height <= 0) return;
            GraphUtils.drawRect((Graphics)g, (int)(this.m_selectionRect.x + xOffset), (int)this.m_selectionRect.y, (int)this.m_selectionRect.width, (int)this.m_selectionRect.height, (int)2, (Color)Color.blue);
            return;
        } else {
            g.setColor(Color.lightGray);
            String text = "BPEL Overview Inactive";
            g.setFont(MESSAGE_FONT);
            Font f = g.getFont();
            int strWidth = GraphUtils.getStringWidth((Font)f, (String)text);
            int h = GraphUtils.getFontHeight((Font)f);
            int x = Math.max(0, (this.getWidth() - strWidth) / 2);
            int y = Math.max(0, (this.getHeight() - h) / 2);
            g.drawString(text, x, y);
        }
    }

    protected void positionViewport(int x, int y) {
    }

    public void updateDisplay() {
        this.computeViewportRect();
        this.repaint();
    }

    protected void updateViewport() {
        this.computeViewportRect();
        this.repaint();
    }

    protected Point computeVisibleRectPosition(int x, int y, Rectangle scaledRect) {
        Dimension sz = this.getSize();
        int xOffset = Math.max(0, (sz.width - scaledRect.width) / 2);
        int xPos = x - xOffset;
        int viewportX = xPos - this.m_scaledViewportRect.width / 2;
        int viewportY = y - this.m_scaledViewportRect.height / 2;
        if (viewportX < scaledRect.x) {
            viewportX = scaledRect.x;
        }
        if (viewportY < scaledRect.y) {
            viewportY = scaledRect.y;
        }
        if (viewportX + this.m_scaledViewportRect.width > scaledRect.x + scaledRect.width) {
            viewportX = Math.max(scaledRect.x, scaledRect.x + scaledRect.width - this.m_scaledViewportRect.width);
        }
        if (viewportY + this.m_scaledViewportRect.height > scaledRect.y + scaledRect.height) {
            viewportY = Math.max(scaledRect.y, scaledRect.y + scaledRect.height - this.m_scaledViewportRect.height);
        }
        return new Point(viewportX, viewportY);
    }

    public void graphNodesChanged(GraphModelEvent e) {
        this.updateDisplay();
    }

    public void graphNodesInserted(GraphModelEvent e) {
        this.updateDisplay();
    }

    public void graphNodesRemoved(GraphModelEvent e) {
        this.updateDisplay();
    }

    public void graphStructureChanged(GraphModelEvent e) {
        this.updateDisplay();
    }

    public void edgesInserted(GraphModelEvent e) {
        this.updateDisplay();
    }

    public void edgesRemoved(GraphModelEvent e) {
        this.updateDisplay();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateViewport();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(13));
        int x = e.getX();
        int y = e.getY();
        Dimension scaledDim = this.computeScaledDimension();
        if (y > scaledDim.height || x > scaledDim.width) {
            return;
        }
        Rectangle scaledRect = new Rectangle(0, 0, scaledDim.width, scaledDim.height);
        Point grabPt = this.computeVisibleRectPosition(x, y, scaledRect);
        this.m_scaledViewportRect.x = grabPt.x;
        this.m_scaledViewportRect.y = grabPt.y;
        int xPos = this.m_scaledViewportRect.x - scaledRect.x;
        int yPos = this.m_scaledViewportRect.y - scaledRect.y;
        float pctX = (float)xPos / (float)scaledRect.width;
        float pctY = (float)yPos / (float)scaledRect.height;
        if (this.m_scrollPane != null) {
            JViewport vp = this.m_scrollPane.getViewport();
            Component graph = vp.getView();
            Dimension graphDim = graph.getSize();
            int graphX = Math.round(pctX * (float)graphDim.width);
            int graphY = Math.round(pctY * (float)graphDim.height);
            vp.setViewPosition(new Point(graphX, graphY));
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Dimension scaledDim = this.computeScaledDimension();
        if (y > scaledDim.height || x > scaledDim.width) {
            return;
        }
        Rectangle scaledRect = new Rectangle(0, 0, scaledDim.width, scaledDim.height);
        Point grabPt = this.computeVisibleRectPosition(x, y, scaledRect);
        this.m_scaledViewportRect.x = grabPt.x;
        this.m_scaledViewportRect.y = grabPt.y;
        int xPos = this.m_scaledViewportRect.x - scaledRect.x;
        int yPos = this.m_scaledViewportRect.y - scaledRect.y;
        float pctX = (float)xPos / (float)scaledRect.width;
        float pctY = (float)yPos / (float)scaledRect.height;
        if (this.m_scrollPane != null) {
            JViewport vp = this.m_scrollPane.getViewport();
            Component graph = vp.getView();
            Dimension graphDim = graph.getSize();
            int graphX = Math.round(pctX * (float)graphDim.width);
            int graphY = Math.round(pctY * (float)graphDim.height);
            vp.setViewPosition(new Point(graphX, graphY));
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void modelLoaded(GraphModel model) {
    }

    public void statusChanged(GraphPaneStatusEvent evt) {
        switch (evt.getId()) {
            case 1: {
                this.updateDisplay();
                break;
            }
        }
    }

    static {
        MESSAGE_FONT = UIManager.getFont("Label.font");
    }
}

