/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.editors.OptimizeData;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OptimizeDataCellRenderer
extends DefaultTableCellRenderer {
    public OptimizeDataCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof OptimizeData) {
            boolean bEnabled = table.isEnabled();
            OptimizeData data = (OptimizeData)value;
            String type = data.getType();
            if (type.equals("MINIMIZE_INVOKE_ACTIVITIES")) {
                this.setIcon(this.getIcon("invoke_node", bEnabled));
            } else if (type.equals("MINIMIZE_ASSIGN_ACTIVITIES")) {
                this.setIcon(this.getIcon("assign_node", bEnabled));
            } else if (type.equals("MINIMIZE_REPLY_ACTIVITIES")) {
                this.setIcon(this.getIcon("reply_node", bEnabled));
            } else if (type.equals("MINIMIZE_RECEIVE_ACTIVITIES")) {
                this.setIcon(this.getIcon("receive_node", bEnabled));
            } else if (type.equals("MINIMIZE_WAIT_ACTIVITIES")) {
                this.setIcon(this.getIcon("wait_node", bEnabled));
            } else if (type.equals("MINIMIZE_TRANSFORM_ACTIVITIES")) {
                this.setIcon(this.getIcon("transform_node", bEnabled));
            } else if (type.equals("MINIMIZE_EMPTY_ACTIVITIES")) {
                this.setIcon(this.getIcon("empty_node", bEnabled));
            } else if (type.equals("MINIMIZE_VALIDATE_ACTIVITIES")) {
                this.setIcon(this.getIcon("validate_node", bEnabled));
            } else if (type.equals("MINIMIZE_SWITCHES")) {
                this.setIcon(this.getIcon("switch_node", bEnabled));
            } else if (type.equals("MINIMIZE_PICKS")) {
                this.setIcon(this.getIcon("pick_node", bEnabled));
            } else if (type.equals("MINIMIZE_WHILES")) {
                this.setIcon(this.getIcon("while_node", bEnabled));
            } else if (type.equals("MINIMIZE_FLOWS")) {
                this.setIcon(this.getIcon("flow_node", bEnabled));
            } else if (type.equals("MINIMIZE_ONALARMS")) {
                this.setIcon(this.getIcon("on_alarm_node", bEnabled));
            } else if (type.equals("MINIMIZE_ONMESSAGES")) {
                this.setIcon(this.getIcon("on_message_node", bEnabled));
            } else if (type.equals("MINIMIZE_COMPENSATE_ACTIVITIES")) {
                this.setIcon(this.getIcon("compensate_node", bEnabled));
            } else if (type.equals("MINIMIZE_COMPENSATION_HANDLERS")) {
                this.setIcon(this.getIcon("compensationhandler_node", bEnabled));
            } else if (type.equals("MINIMIZE_DROP_ZONES")) {
                this.setIcon(this.getIcon("graph/bpel/dropzone_bpel_20.png", bEnabled));
            } else if (type.equals("MINIMIZE_SCOPES")) {
                this.setIcon(this.getIcon("scope_node", bEnabled));
            } else if (type.equals("MINIMIZE_SEQUENCES")) {
                this.setIcon(this.getIcon("sequence_node", bEnabled));
            } else if (type.equals("MINIMIZE_TERMINATE_ACTIVITIES")) {
                this.setIcon(this.getIcon("terminate_node", bEnabled));
            } else if (type.equals("MINIMIZE_THROW_ACTIVITIES")) {
                this.setIcon(this.getIcon("throw_node", bEnabled));
            } else if (type.equals("MINIMIZE_JAVA_EMBED_ACTIVITIES")) {
                this.setIcon(this.getIcon("java_embedding_node", bEnabled));
            } else if (type.equals("MINIMIZE_CATCHALLS")) {
                this.setIcon(this.getIcon("catch_all_node", bEnabled));
            } else if (type.equals("MINIMIZE_CATCHES")) {
                this.setIcon(this.getIcon("catch_node", bEnabled));
            } else {
                this.setIcon(null);
            }
        }
        this.setBackground(Color.white);
        this.setText(null);
        return this;
    }

    private Icon getIcon(String key, boolean bEnabled) {
        Icon icon = ImageCache.getIcon(key);
        if (!bEnabled && icon != null) {
            return ImageCache.createDisabledIcon(icon);
        }
        return icon;
    }
}

