/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnMessageNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.AssertStatusButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicVerticalBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OnMessageView
extends BasicVerticalBranchView
implements StateSaveableView,
VoiceAccessible {
    private static Image m_activityImage = ImageCache.getImage("graph/bpel/onmessage_47x47.png");
    private static Image m_disabledActivityImage = BasicImageCache.createDisabledImage((Image)m_activityImage);
    protected Icon m_interactionIcon;

    public OnMessageView(GraphPane pane, View parent, OnMessageNode n) {
        super(pane, parent, n);
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
        this.setDraggable(false);
    }

    @Override
    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        this.m_statusButtons.add(new AssertStatusButton((View)this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("on_message_node");
    }

    @Override
    protected String getText() {
        OnMessage onMsg = (OnMessage)this.getNode().getUserObject();
        String s = onMsg.getDescription();
        this.setToolTipText(s);
        if (s != null && s.length() > 40) {
            s = s.substring(0, 37) + "...";
        }
        return s;
    }

    @Override
    protected Image getImage() {
        return this.isEditable() ? m_activityImage : m_disabledActivityImage;
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    @Override
    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    @Override
    protected boolean requiresSequence() {
        return true;
    }

    @Override
    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        this.updateStatusButtons();
        this.m_interactionIcon = this.getInteractionIcon();
        return super.layout(x, y, w, h, info);
    }

    protected Icon getInteractionIcon() {
        OnMessage onMsg = (OnMessage)this.getNode().getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null || !ip.isEditorForActivity((Activity)onMsg)) continue;
            return ip.getIcon();
        }
        return null;
    }

    @Override
    protected void paintBranchImage(Graphics g) {
        Image img = this.getImage();
        if (img != null) {
            g.drawImage(img, this.m_connectionX - img.getWidth(null) / 2, this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder, null);
            if (this.m_interactionIcon != null) {
                this.m_interactionIcon.paintIcon((Component)this.getGraphPane(), g, this.m_connectionX - this.m_interactionIcon.getIconWidth() / 2, this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder);
            }
        }
    }

    public String getVoiceAccessibleText() {
        return "On Message Branch";
    }
}

