/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Annotation;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnAlarmNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicVerticalBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OnAlarmView
extends BasicVerticalBranchView
implements StateSaveableView,
VoiceAccessible {
    private static Image m_activityImage = ImageCache.getImage("graph/bpel/onalarm_47x47.png");
    private static Image m_disabledActivityImage = BasicImageCache.createDisabledImage((Image)m_activityImage);

    public OnAlarmView(GraphPane pane, View parent, OnAlarmNode n) {
        super(pane, parent, n);
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
        this.setDraggable(false);
    }

    @Override
    protected String getText() {
        String s = "";
        OnAlarm onAlarm = (OnAlarm)this.getNode().getUserObject();
        Annotation a = onAlarm.getAnnotation();
        if (a != null && a.getDocumentation() != null) {
            s = a.getDocumentation().getValue();
        }
        this.setToolTipText(s);
        if (s != null && s.length() > 40) {
            s = s.substring(0, 37) + "...";
        }
        return s;
    }

    @Override
    protected Image getImage() {
        return this.isEditable() ? m_activityImage : m_disabledActivityImage;
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("on_alarm_node");
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    @Override
    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    @Override
    protected boolean requiresSequence() {
        return true;
    }

    @Override
    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        this.updateStatusButtons();
        return super.layout(x, y, w, h, info);
    }

    public String getVoiceAccessibleText() {
        return "On Alarm Branch";
    }
}

