/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.documentation.NoteNodeEditor;

public class NoteView
extends View {
    private static Color BACKGROUND = Color.decode("#f5f5f5");
    private static Font TEXT_FONT = UIManager.getFont("Label.font");
    private static int MAX_WIDTH = 125;
    protected int m_borderWidth = 2;
    protected int m_vertPadding = 5;
    protected int m_horzPadding = 7;
    protected List<String> m_labelLines = new ArrayList<String>();

    public NoteView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.setCanSelect(true);
    }

    public int getEditorType() {
        return 1;
    }

    public boolean isEditable() {
        return true;
    }

    public String getText() {
        Object o = this.getNode().getUserObject();
        if (o instanceof Scope) {
            return ((Scope)o).getUserComment();
        }
        return null;
    }

    public NodeEditor getNodeEditor() {
        return new NoteNodeEditor();
    }

    public void paint(Graphics g, int layer) {
        if (this.m_labelLines.size() == 0) {
            return;
        }
        Color bg = BACKGROUND;
        Color fg = Color.gray;
        Rectangle r = new Rectangle(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_borderWidth, this.m_bounds.width - 2 * this.m_borderWidth, this.m_bounds.height - 2 * this.m_borderWidth);
        g.setColor(bg);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        GraphUtils.drawRoundRect((Graphics)g, (int)r.x, (int)r.y, (int)r.width, (int)r.height, (float)1.0f, (Color)fg, (int)15);
        g.setFont(TEXT_FONT);
        g.setColor(fg);
        int textHeight = GraphUtils.getFontHeight((Font)TEXT_FONT);
        int yPos = this.m_bounds.y + this.m_borderWidth + this.m_vertPadding + GraphUtils.getFontAscent((Font)TEXT_FONT);
        for (String s : this.m_labelLines) {
            g.drawString(s, this.m_bounds.x + this.m_borderWidth + this.m_horzPadding, yPos);
            yPos += textHeight;
        }
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
        }
        int[] xPoints = new int[]{this.m_bounds.x + this.m_borderWidth - 5, this.m_bounds.x + this.m_borderWidth, this.m_bounds.x + this.m_borderWidth};
        int[] yPoints = new int[]{this.m_bounds.y + this.m_bounds.height / 2, this.m_bounds.y + this.m_bounds.height / 2 - 5, this.m_bounds.y + this.m_bounds.height / 2 + 5};
        g.setColor(bg);
        g.fillPolygon(xPoints, yPoints, 3);
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        RenderingHints oldHints = g2.getRenderingHints();
        g2.setRenderingHints(GraphUtils.SMOOTH_LINE_HINTS);
        g.setColor(bg);
        g2.setStroke(new BasicStroke(2.0f, 1, 0));
        g.drawLine(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_bounds.height / 2 - 4, this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_bounds.height / 2 + 4);
        g2.setStroke(new BasicStroke(1.0f, 1, 0));
        g.setColor(fg);
        g.drawLine(this.m_bounds.x + this.m_borderWidth - 5, this.m_bounds.y + this.m_bounds.height / 2, this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_bounds.height / 2 - 5);
        g.drawLine(this.m_bounds.x + this.m_borderWidth - 5, this.m_bounds.y + this.m_bounds.height / 2, this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_bounds.height / 2 + 5);
        g2.setStroke(oldStroke);
        g2.setRenderingHints(oldHints);
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, float borderWidth) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        this.paintSelectionBox(g, r, borderWidth, settings.m_selectedBorderBackgroundColor);
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        this.m_labelLines.clear();
        String text = this.getText();
        if (text == null || text.trim().length() == 0) {
            this.m_bounds.setBounds(x, y, 0, 0);
            return this.m_bounds;
        }
        Dimension d = this.layoutLabel();
        this.m_bounds.setBounds(x, y, d.width + 2 * (this.m_borderWidth + this.m_horzPadding), d.height + 2 * (this.m_borderWidth + this.m_vertPadding));
        return this.m_bounds;
    }

    protected Dimension layoutLabel() {
        this.m_labelLines.clear();
        String text = this.getText();
        if (text == null || text.trim().length() == 0) {
            return new Dimension(0, 0);
        }
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int maxWidth = MAX_WIDTH;
        int totalWidth = 0;
        int start = boundary.first();
        String currLine = "";
        int end = boundary.next();
        while (end != -1) {
            String word = text.substring(start, end);
            boolean bWhitespace = word.trim().length() == 0;
            int wordWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)word);
            if (currLine.length() == 0) {
                if (!bWhitespace) {
                    currLine = currLine + word;
                    totalWidth = wordWidth;
                }
            } else if (totalWidth + wordWidth > maxWidth) {
                this.m_labelLines.add(currLine.trim());
                currLine = word;
                totalWidth = wordWidth;
            } else {
                currLine = currLine + word;
                totalWidth += wordWidth;
            }
            start = end;
            end = boundary.next();
        }
        if (currLine.length() > 0 && currLine.trim().length() > 0) {
            this.m_labelLines.add(currLine.trim());
        }
        int maxLineWidth = 0;
        int height = 0;
        for (String line : this.m_labelLines) {
            int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)line);
            int strHeight = GraphUtils.getFontHeight((Font)TEXT_FONT);
            maxLineWidth = Math.max(maxLineWidth, strWidth);
            height += strHeight;
        }
        return new Dimension(maxLineWidth, height);
    }
}

