/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELNodeTypes;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorSource;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AssignViewNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.CatchAllNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.CatchNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.CompensateNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.CompensationHandlerNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EmptyNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.FlowNNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.FlowNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.InvokeNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.OnAlarmNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.OnMessageNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.PickNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ProcessNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ReceiveViewNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ReplyViewNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ScopeNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.SequenceNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.SwitchCaseNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.SwitchNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.SwitchOtherwiseNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.TerminateNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ThrowNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.TransformationViewNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.WaitViewNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.WhileNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.documentation.NoteNodeEditor;

public class NodeEditorFactory
implements BPELNodeTypes {
    private static List m_nodeEditorSources = new ArrayList();

    public static void addNodeEditorSource(NodeEditorSource src) {
        m_nodeEditorSources.add(src);
    }

    public static NodeEditor getNodeEditor(Node node) {
        NodeEditor editor;
        block1: {
            NodeEditorSource src;
            editor = NodeEditorFactory.getNodeEditor(node.getNodeType());
            if (editor != null) break block1;
            Iterator it = m_nodeEditorSources.iterator();
            while (it.hasNext() && (editor = (src = (NodeEditorSource)it.next()).getNodeEditor(node)) == null) {
            }
        }
        return editor;
    }

    public static NodeEditor getNodeEditor(int nodeType) {
        switch (nodeType) {
            case 135: {
                return new NoteNodeEditor();
            }
            case 109: {
                return new AssignViewNodeEditor();
            }
            case 100: {
                return new InvokeNodeEditor();
            }
            case 101: {
                return new ReceiveViewNodeEditor();
            }
            case 102: {
                return new ScopeNodeEditor();
            }
            case 103: {
                return new SequenceNodeEditor();
            }
            case 104: {
                return new SwitchNodeEditor();
            }
            case 105: {
                return new ProcessNodeEditor();
            }
            case 106: {
                return new SwitchCaseNodeEditor();
            }
            case 107: {
                return new SwitchOtherwiseNodeEditor();
            }
            case 108: {
                return new FlowNodeEditor();
            }
            case 112: {
                return new WaitViewNodeEditor();
            }
            case 113: {
                return new ReplyViewNodeEditor();
            }
            case 114: {
                return new PickNodeEditor();
            }
            case 115: {
                return new OnMessageNodeEditor();
            }
            case 116: {
                return new OnAlarmNodeEditor();
            }
            case 117: {
                return new WhileNodeEditor();
            }
            case 118: {
                return new TerminateNodeEditor();
            }
            case 119: {
                return new EmptyNodeEditor();
            }
            case 121: {
                return new ThrowNodeEditor();
            }
            case 120: {
                return new CompensateNodeEditor();
            }
            case 133: {
                return new TransformationViewNodeEditor();
            }
            case 134: {
                return new FlowNNodeEditor();
            }
            case 122: {
                return new CatchNodeEditor();
            }
            case 123: {
                return new CatchAllNodeEditor();
            }
            case 126: {
                return new CompensationHandlerNodeEditor();
            }
        }
        return null;
    }
}

