/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.PortConnectionView;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkConnection;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELTaskView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkConnectable;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class InvokeView
extends BPELTaskView
implements PartnerLinkConnectable {
    protected Icon m_interactionIcon;

    public InvokeView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.setAcceptsArrow(true);
        this.m_insideBorderWidth = 0;
        this.m_outsideBorderToInsideBorder = 0;
        this.m_borderToImage = this.m_outsideBorderToInsideBorder + 5;
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("invoke_node");
    }

    @Override
    protected Image getActivityImage() {
        return ImageCache.getImage("graph/bpel/invoke_40x40.png");
    }

    @Override
    public boolean isMinimized() {
        return this.getMinimize("MINIMIZE_INVOKE_ACTIVITIES");
    }

    public String getToolTipText() {
        return InvokeView.getInvokeToolTipText((Invoke)this.getNode().getUserObject());
    }

    public static String getInvokeToolTipText(Invoke invoke) {
        String ptype = "";
        QName portType = invoke.getPortType();
        if (portType != null) {
            ptype = BPELModelUtil.getPrefixQualifiedName((QName)portType);
        }
        String settingsText = BPELStringTranslator.getString("COLLAXALAF_SETTINGS", "Settings");
        String text = "<html><body><table><tr><td colspan=2 align=center bgcolor=cyan><font color=black><b>Invoke " + settingsText + "</b></font></td></tr>";
        if (invoke.getEventName() == null) {
            text = text + InvokeView.getRowHTML(BPELStringTranslator.getString("PORTTYPE"), ptype);
            text = text + InvokeView.getRowHTML(BPELStringTranslator.getString("OPERATION"), invoke.getOperation());
            text = text + InvokeView.getRowHTML(BPELStringTranslator.getString("INPUT_VARIABLE"), invoke.getInputVariable());
            text = text + InvokeView.getRowHTML(BPELStringTranslator.getString("OUTPUT_VARIABLE"), invoke.getOutputVariable());
        } else {
            String eName = BPELModelUtil.getPrefixQualifiedName((QName)invoke.getEventName());
            text = text + InvokeView.getRowHTML(BPELStringTranslator.getString("EVENT_NAME"), eName);
            text = text + InvokeView.getRowHTML(BPELStringTranslator.getString("VARIABLE"), invoke.getInputVariable());
        }
        text = text + "</table></body></html>";
        return text;
    }

    protected static String getRowHTML(String name, String value) {
        if (value == null) {
            value = "";
        }
        return "<tr><td><b>" + name + ":</b></td><td>" + value + "</td></tr>";
    }

    @Override
    public void updatePartnerLinkGUIConnections() {
        String partnerLinkName;
        InvokeNode n = (InvokeNode)this.getNode();
        Invoke invokeModel = (Invoke)n.getUserObject();
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        for (NodeRenderer r : this.m_children) {
            PortNode invokePortNode;
            Edge[] edges;
            View v = (View)r;
            if (!(v instanceof PortConnectionView) || (edges = model.getEdgesForPort(invokePortNode = (PortNode)v.getNode())) == null || edges.length <= 0) continue;
            Edge edge = edges[0];
            PortNode target = edge.getTarget();
            PortNode src = edge.getSource();
            model.deleteEdges(edges);
            if (target != invokePortNode) {
                model.deleteNode(target.getParentNode(), (Node)target);
                break;
            }
            if (src == invokePortNode) break;
            model.deleteNode(src.getParentNode(), (Node)src);
            break;
        }
        if ((partnerLinkName = invokeModel.getPartnerLink()) == null) {
            return;
        }
        PortNode invokePortNode = (PortNode)n.getChildNode(0);
        for (PartnerLinkNode linkNode : model.getPartnerLinkNodes()) {
            PartnerLink linkObj = (PartnerLink)linkNode.getUserObject();
            if (!partnerLinkName.equalsIgnoreCase(linkObj.getName())) continue;
            PortNode partnerLinkPort = new PortNode(0);
            model.addChildNode((Node)linkNode, (Node)partnerLinkPort);
            PartnerLinkConnection edge = new PartnerLinkConnection(invokePortNode, partnerLinkPort);
            model.insertEdge((Edge)edge);
            break;
        }
    }

    @Override
    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        super.layout(x, y, w, h, info);
        this.m_interactionIcon = this.getInteractionIcon();
        return this.m_bounds;
    }

    protected Icon getInteractionIcon() {
        Invoke invoke = (Invoke)this.getNode().getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null || !ip.isEditorForActivity((Activity)invoke)) continue;
            return ip.getIcon();
        }
        return null;
    }

    @Override
    public void paint(Graphics g, int layer) {
        super.paint(g, layer);
        if (this.m_interactionIcon != null) {
            int iWidth = this.m_interactionIcon.getIconWidth();
            int iHeight = this.m_interactionIcon.getIconHeight();
            int xOffset = Math.max(0, (this.m_bounds.width - iWidth) / 2);
            int yOffset = Math.max(0, (this.m_bounds.height - iHeight) / 2);
            this.m_interactionIcon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + xOffset, this.m_bounds.y + yOffset);
        }
    }
}

