/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Flow;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.TabTreeNode;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.VerticalDropBranchView;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.actions.AddFlowSequenceAction;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowLink;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowLinker;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicVerticalBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class FlowView
extends BaseView
implements Magnifiable,
FlowLinker,
ValidatableView,
StateSaveableView,
Tabable,
VoiceAccessible {
    protected static Font TEXT_FONT = new Font(UIManager.getFont("Label.font").getFontName(), 0, 11);
    protected static Image m_diamond = ImageCache.getImage("graph/bpel/flow_small.png");
    protected static Image m_disabledDiamond = BasicImageCache.createDisabledImage((Image)m_diamond);
    protected static Image m_minimizedDiamond = ImageCache.getImage("flow_node");
    protected int m_diamondToTop = 2;
    protected int m_diamondToTopHorizontal = 2;
    protected int m_borderWidth = 2;
    protected int m_borderToImage = 0;
    protected int m_bottomHorizontalToBottom = 5;
    protected int m_bottomHorizontalPadding = 10;
    protected int m_diamondToHorizontal = 2;
    protected int m_horizontalToBranch = 5;
    protected int m_horizontalHeight = 1;
    protected int m_sidePadding = 5;
    protected int m_padding = 5;
    protected int m_horizontalSpacing = 0;
    protected int m_minimizedBorderWidth = 2;
    protected int m_minimizedSidePadding = 0;
    protected int m_minimizedBottomHorizontalPadding = 2;
    protected int m_minimizedHorizontalToBranch = 1;
    protected int m_imagePadding = 4;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;
    protected int m_configToImage = 3;
    protected boolean m_bMagnified;
    protected JTextField m_nameField = new JTextField();
    protected Rectangle m_nameBounds = new Rectangle();
    protected Color m_lineColor = new Color(152, 152, 152);
    protected Color m_barColor = new Color(152, 152, 152);
    protected List<FlowLink> m_flowLinks = new ArrayList<FlowLink>();
    protected ConfigBox m_configBox;
    protected ConfigBox m_collapsedConfigBox;
    protected ConfigBox m_minimizedConfigBox;
    protected CollapseExpandViewAction m_collapseAction;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();

    public FlowView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.m_configBox = new ConfigBox((View)this, this.getActions(), 0);
        this.m_configBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox = new ConfigBox((View)this, this.getCollapsedActions(), 0);
        this.m_collapsedConfigBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox.setBorderColor(null);
        this.m_minimizedConfigBox = new ConfigBox((View)this, this.getMinimizedActions(), 0);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setMinimizeMode(true);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        int diamondHeight = m_diamond.getHeight(null);
        this.setInsets(this.m_borderWidth + this.m_borderToImage + diamondHeight + this.m_diamondToHorizontal + this.m_horizontalHeight + this.m_horizontalToBranch, this.m_borderWidth + this.m_sidePadding, this.m_borderWidth + 2 * this.m_bottomHorizontalPadding + this.m_horizontalHeight, this.m_borderWidth + this.m_sidePadding);
        this.setBackground(null);
        this.setCanSelect(true);
        this.setCollapsable(true);
        Boolean val = (Boolean)n.getData((Object)"collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
        this.updateActions();
    }

    public List<TabTreeNode> getTabTreeNodes() {
        ArrayList<Object> nodes = new ArrayList<TabTreeNode>();
        if (!this.isCollapsed()) {
            for (NodeRenderer nodeRenderer : this.m_children) {
                List list = nodeRenderer.getTabTreeNodes();
                if (list == null) continue;
                nodes.addAll(list);
            }
        }
        if (this instanceof Tabable && this.isVisible()) {
            TabTreeNode treeNode = new TabTreeNode((Tabable)this);
            for (TabTreeNode tabTreeNode : nodes) {
                treeNode.addChild(tabTreeNode);
            }
            nodes = new ArrayList();
            nodes.add(treeNode);
        }
        return nodes;
    }

    public boolean canDelete() {
        Activity a = (Activity)this.getNode().getUserObject();
        return a.canDelete();
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane.isOptimized()) {
            return true;
        }
        BPELSettings settings = pane.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("MINIMIZE_FLOWS");
        return b == null ? false : b;
    }

    @Override
    public View getView() {
        return this;
    }

    public NodeEditor getNodeEditor() {
        return NodeEditorFactory.getNodeEditor(this.getNode());
    }

    protected ValidationContext createValidationContext() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        return new ValidationContext(model.getProcess());
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<StatusBoxButton> buttons = plugin.addViewStatusButtons((View)this);
            if (buttons == null) continue;
            this.m_statusButtons.addAll(buttons);
        }
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            ValidationReport r = a.getValidationReport(this.createValidationContext(), false);
            if (r == null) {
                r = a.getValidationReport(this.createValidationContext(), true);
            }
            return r.getState() != 0;
        }
        return false;
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized() && this.isCollapsed()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_configBox.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
        this.m_collapsedConfigBox.clearHighlights();
        info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public void addSequence() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        Sequence s = (Sequence)BPELParser.createImplementation(Sequence.class);
        String sequence1_name = BPELModelUtil.generateUniqueName((Process)model.getProcess(), (String)"Sequence", Sequence.class);
        s.setName(sequence1_name);
        Flow f = (Flow)this.getNode().getUserObject();
        try {
            f.addSequence(s);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)this.getGraphPane(), (Throwable)e);
            return;
        }
        FlowNode flowNode = (FlowNode)this.getNode();
        SequenceNode seqNode = new SequenceNode();
        seqNode.setUserObject(s);
        seqNode.setName(sequence1_name);
        flowNode.addSequence(seqNode);
        f.generateValidationReport(new ValidationContext(model.getProcess()));
        this.rebuildNodeRenderersFromModel();
        this.getGraphPane().forceLayout();
        model.fireGraphStructureChanged();
    }

    public ToolTipable getToolTipable(int x, int y) {
        ActionInfo info;
        if (!this.isCollapsed() && (info = this.hitActionArea(x, y)) != null) {
            return info.getToolTipable();
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        if (this.m_bounds.contains(x, y)) {
            return new ToolTipable(){

                public String getToolTipText() {
                    return "Flow";
                }
            };
        }
        return null;
    }

    public boolean isEditable() {
        Object o = this.getNode().getUserObject();
        if (o instanceof Activity) {
            Activity a = (Activity)o;
            return a.isEditable();
        }
        return true;
    }

    public List<GraphAction> getCollapsedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public List<GraphAction> getMinimizedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public boolean hitNameEdit(int x, int y) {
        return this.m_nameBounds.contains(x, y);
    }

    public boolean canEditName() {
        Activity a = this.getActivity();
        return a != null && a.canDelete() && this.isCollapsed();
    }

    public void setEditingName(boolean bEditing) {
        super.setEditingName(bEditing);
        GraphPane pane = this.getGraphPane();
        if (bEditing) {
            pane.add((Component)this.m_nameField);
            Dimension prefDim = this.m_nameField.getPreferredSize();
            String text = this.getName();
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)text);
            this.m_nameField.setText(text);
            this.m_nameField.setCaretPosition(0);
            this.m_nameField.requestFocus();
            int xOffset = 0;
            int w = strWidth + this.m_nameField.getInsets().left + this.m_nameField.getInsets().right;
            if (this.m_nameBounds.width < w) {
                xOffset = -(w - this.m_nameBounds.width) / 2;
            }
            this.m_nameField.setBounds(this.m_nameBounds.x + xOffset, this.m_nameBounds.y, w, prefDim.height);
            this.m_nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        FlowView.this.setEditingName(false);
                        FlowView.this.saveNameChange();
                    }
                }
            });
            this.m_nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    FlowView.this.setEditingName(false);
                    FlowView.this.saveNameChange();
                }
            });
        } else {
            pane.remove((Component)this.m_nameField);
        }
        pane.repaint();
    }

    protected String getName() {
        Flow f = (Flow)this.getNode().getUserObject();
        String name = f.getName();
        if (name != null) {
            return name;
        }
        return "";
    }

    protected void saveNameChange() {
        Node n = this.getNode();
        Flow f = (Flow)n.getUserObject();
        f.setName(this.m_nameField.getText());
        this.getGraphPane().forceLayout();
    }

    public List<GraphAction> getActions() {
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        actions.add(new AddFlowSequenceAction(this));
        return actions;
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isMinimized()) {
            return this.m_minimizedConfigBox.hitActionArea(x, y);
        }
        if (this.isCollapsed()) {
            if (this.isSelected()) {
                return this.m_collapsedConfigBox.hitActionArea(x, y);
            }
        } else if (this.isSelected()) {
            return this.m_configBox.hitActionArea(x, y);
        }
        return null;
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    protected void updateActions() {
        this.updateBoxActions(this.m_minimizedConfigBox);
        this.updateBoxActions(this.m_collapsedConfigBox);
        this.updateBoxActions(this.m_configBox);
    }

    protected void updateBoxActions(ConfigBox box) {
        if (box != null) {
            Iterator it = box.getActionInfos();
            while (it.hasNext()) {
                ActionInfo info = (ActionInfo)it.next();
                if (!(info.getAction() instanceof GraphAction)) continue;
                GraphAction ga = (GraphAction)info.getAction();
                ga.updateState();
            }
        }
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = ImageCache.getImage("graph/bpel/flow_47x47.png");
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        String s = this.getName();
        int fontHeight = GraphUtils.getFontHeight((Font)UIManager.getFont("TextField.font"));
        int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("TextField.font"), (String)s);
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x, this.m_bounds.y, w, h);
        r.x = this.m_bounds.x + this.m_bounds.width / 2 - r.width / 2;
        r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        r.x += this.m_bounds.width + 20;
        return r;
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = ImageCache.getImage("graph/bpel/flow_47x47.png");
        String s = this.getName();
        int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)TEXT_FONT);
        GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)Color.cyan, (float)0.3f);
        Color lineClr = Color.cyan.darker();
        g.setColor(lineClr);
        g.drawRoundRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height, 10, 10);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)r.x, (int)(r.y + 10), (float)1.5f, (Color)Color.cyan.darker());
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 10), (float)1.5f, (Color)Color.cyan.darker());
        Graphics2D g2 = (Graphics2D)g;
        Color c1 = new Color(223, 242, 249);
        Color c2 = new Color(197, 214, 233);
        GradientPaint gp = new GradientPaint(r.x, r.y, c1, r.x, r.y + r.height, c2);
        g2.setPaint(gp);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        g.setColor(lineClr);
        g.drawRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)this.getTextColor(), (Font)TEXT_FONT);
        }
        this.paintStatusIcons(g);
    }

    protected Color getTextColor() {
        return Color.black;
    }

    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("flow_node");
    }

    protected void paintMinimized(Graphics g, int layer) {
        if (this.isCollapsed()) {
            this.m_minimizedConfigBox.paint(g, Color.white);
            Icon icon = this.getMinimizedIcon();
            int iWidth = icon.getIconWidth();
            icon.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + this.m_bounds.width / 2 - iWidth / 2, this.m_bounds.y + this.m_minimizedBorderWidth);
        } else {
            super.paint(g, layer);
            g.drawImage(m_minimizedDiamond, this.midX() - m_minimizedDiamond.getWidth(null) / 2, this.m_bounds.y + this.m_minimizedBorderWidth, null);
            this.m_minimizedConfigBox.paint(g, Color.white);
            this.paintMinimizedConnections(g);
        }
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_minimizedBorderWidth);
        }
    }

    protected void paintMinimizedConnections(Graphics g) {
        int yPos;
        int diamondHeight = m_minimizedDiamond.getHeight(null);
        int topHorizontal = yPos = this.m_bounds.y + this.m_minimizedBorderWidth + this.m_diamondToTop + diamondHeight + this.m_diamondToTopHorizontal;
        GraphUtils.drawHorzLine((Graphics)g, (int)(this.m_bounds.x + this.m_minimizedBorderWidth), (int)yPos, (int)(this.m_bounds.x + this.m_bounds.width - this.m_minimizedBorderWidth), (float)1.0f, (Color)this.m_lineColor);
        int bottomHorizontal = yPos = this.m_bounds.y + this.m_bounds.height - this.m_minimizedBorderWidth - this.m_bottomHorizontalToBottom;
        GraphUtils.drawHorzLine((Graphics)g, (int)(this.m_bounds.x + this.m_minimizedBorderWidth), (int)yPos, (int)(this.m_bounds.x + this.m_bounds.width - this.m_minimizedBorderWidth), (float)1.0f, (Color)this.m_lineColor);
        int numBranches = this.m_children.size();
        for (int i = 0; i < numBranches; ++i) {
            BaseView v = this.getChild(i);
            int xPos = v.getConnectionX();
            yPos = this.m_bounds.y + this.m_insets.top / 2;
            GraphUtils.drawVertLine((Graphics)g, (int)xPos, (int)topHorizontal, (int)v.topY(), (float)1.0f, (Color)this.m_lineColor);
            GraphUtils.drawVertLine((Graphics)g, (int)xPos, (int)v.bottomY(), (int)bottomHorizontal, (float)1.0f, (Color)this.m_lineColor);
        }
        GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)bottomHorizontal, (float)1.0f, (Color)this.m_lineColor);
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        GraphUtils.paintSelectionBox((Graphics)g, (int)this.m_bounds.x, (int)this.m_bounds.y, (int)this.m_bounds.width, (int)this.m_bounds.height, (Color)c, (float)borderWidth);
    }

    protected void paintSelected(Graphics g) {
    }

    protected Color getSelectedBackgroundColor() {
        return BPELGraphPane.VIEW_SELECTION_BACKGROUND;
    }

    public void paint(Graphics g, int layer) {
        Image img;
        if (this.isSelected()) {
            g.setColor(this.getSelectedBackgroundColor());
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (this.isSelected()) {
                this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
            }
            return;
        }
        if (this.isMinimized()) {
            this.paintMinimized(g, layer);
            return;
        }
        boolean bEditable = this.isEditable();
        Image image = img = bEditable ? m_diamond : m_disabledDiamond;
        if (this.isCollapsed()) {
            int xOffset = Math.max(0, (this.m_bounds.width - img.getWidth(null)) / 2);
            g.drawImage(img, this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth, null);
            String name = this.getName();
            if (name != null) {
                g.setColor(bEditable ? Color.black : Color.lightGray);
                g.setFont(UIManager.getFont("Label.font"));
                g.drawString(name, this.m_nameBounds.x, this.m_nameBounds.y + GraphUtils.getFontAscent((Font)g.getFont()));
            }
            this.m_collapsedConfigBox.paint(g, null);
        } else {
            super.paint(g, layer);
            if (m_diamond != null) {
                g.drawImage(img, this.midX() - img.getWidth(null) / 2, this.m_bounds.y + this.m_borderWidth + this.m_borderToImage, null);
            }
            this.paintLinks(g);
            this.paintConnections(g);
            if (this.isSelected()) {
                this.m_configBox.paint(g, BPELGraphPane.TAB_BACKGROUND_COLOR);
            }
        }
        if (this.isSelected()) {
            this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
        }
        this.paintStatusIcons(g);
    }

    protected void paintLinks(Graphics g) {
        for (FlowLink l : this.m_flowLinks) {
            l.paint(g);
        }
    }

    protected void paintConnections(Graphics g) {
        int yPos;
        int diamondHeight = m_diamond.getHeight(null);
        int numBranches = this.m_children.size();
        int topHorizontal = yPos = this.m_bounds.y + this.m_borderWidth + diamondHeight + this.m_diamondToHorizontal;
        if (numBranches > 1) {
            BaseView first = this.getChild(0);
            BaseView last = this.getChild(numBranches - 1);
            int leftX = first.getConnectionX();
            int rightX = last.getConnectionX();
            GraphUtils.drawHorzLine((Graphics)g, (int)leftX, (int)yPos, (int)rightX, (float)this.m_horizontalHeight, (Color)this.m_lineColor);
        } else {
            GraphUtils.drawHorzLine((Graphics)g, (int)(this.m_bounds.x + this.m_borderWidth), (int)yPos, (int)(this.m_bounds.x + this.m_bounds.width - this.m_borderWidth), (float)this.m_horizontalHeight, (Color)this.m_lineColor);
        }
        int bottomHorizontal = yPos = this.m_bounds.y + this.m_bounds.height - this.m_insets.bottom / 2;
        if (numBranches > 1) {
            BaseView first = this.getChild(0);
            BaseView last = this.getChild(numBranches - 1);
            int leftX = first.getConnectionX();
            int rightX = last.getConnectionX();
            GraphUtils.drawHorzLine((Graphics)g, (int)leftX, (int)yPos, (int)rightX, (float)1.0f, (Color)this.m_lineColor);
        } else {
            GraphUtils.drawHorzLine((Graphics)g, (int)(this.m_bounds.x + this.m_borderWidth), (int)yPos, (int)(this.m_bounds.x + this.m_bounds.width - this.m_borderWidth), (float)this.m_horizontalHeight, (Color)this.m_lineColor);
        }
        for (int i = 0; i < numBranches; ++i) {
            BaseView v = this.getChild(i);
            int xPos = v.getConnectionX();
            GraphUtils.drawVertLine((Graphics)g, (int)xPos, (int)topHorizontal, (int)v.topY(), (float)1.0f, (Color)this.m_lineColor);
            GraphUtils.drawVertLine((Graphics)g, (int)xPos, (int)v.bottomY(), (int)bottomHorizontal, (float)1.0f, (Color)this.m_lineColor);
        }
        GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)bottomHorizontal, (float)1.0f, (Color)this.m_lineColor);
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
        if (this.m_bMagnified) {
            this.m_bMagnified = false;
            ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
        }
    }

    public Cursor getCursor(int x, int y) {
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return Cursor.getPredefinedCursor(12);
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.isSelected() && this.isDraggable()) {
            return Cursor.getPredefinedCursor(13);
        }
        return null;
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_configBox.move(x, y);
        this.m_minimizedConfigBox.move(x, y);
        this.m_collapsedConfigBox.move(x, y);
        this.m_viewStatusBox.move(x, y);
        this.m_nameBounds.x += x;
        this.m_nameBounds.y += y;
    }

    protected Rectangle layoutMinimized(int x, int y, int w, int h, LayoutInfo info) {
        BasicVerticalBranchView branchView;
        int centerX;
        int diff;
        View v;
        Dimension configBoxSize = this.m_minimizedConfigBox.getSize();
        if (this.isCollapsed()) {
            Icon icon = this.getMinimizedIcon();
            int left = this.m_minimizedBorderWidth + configBoxSize.width + this.m_configToImage + icon.getIconWidth() / 2;
            int right = icon.getIconWidth() / 2 + this.m_minimizedBorderWidth;
            int width = 2 * Math.max(left, right);
            int height = 2 * this.m_minimizedBorderWidth + Math.max(icon.getIconHeight(), configBoxSize.height);
            this.setBounds(x, y, width, height);
            this.m_connectionX = this.midX();
            int diamondWidth = m_minimizedDiamond.getWidth(null);
            int diamondHeight = m_minimizedDiamond.getHeight(null);
            this.m_minimizedConfigBox.setBounds(this.m_connectionX - diamondWidth / 2 - configBoxSize.width - this.m_configToImage, this.topY() + this.m_minimizedBorderWidth + diamondHeight / 2 - configBoxSize.height / 2, configBoxSize.width, configBoxSize.height);
            return this.m_bounds;
        }
        this.updateStatusButtons();
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        int diamondHeight = m_minimizedDiamond.getHeight(null);
        this.setInsets(this.m_minimizedBorderWidth + diamondHeight + this.m_diamondToHorizontal + this.m_horizontalHeight + this.m_minimizedHorizontalToBranch, this.m_minimizedBorderWidth + this.m_minimizedSidePadding, this.m_minimizedBorderWidth + 2 * this.m_minimizedBottomHorizontalPadding + this.m_horizontalHeight, this.m_minimizedBorderWidth + this.m_minimizedSidePadding);
        int height = 0;
        int xPos = x + this.m_insets.left;
        int yPos = y + this.m_insets.top;
        int numBranches = this.m_children.size();
        int maxBranchWidth = 2 * this.m_padding;
        int maxBranchHeight = 0;
        for (int i = 0; i < numBranches; ++i) {
            if (i > 0) {
                xPos += this.m_horizontalSpacing;
            }
            View v2 = (View)this.m_children.get(i);
            Rectangle r = v2.layout(xPos, yPos, w, h, info);
            xPos += r.width;
            maxBranchHeight = Math.max(maxBranchHeight, r.height);
            maxBranchWidth = Math.max(maxBranchWidth, r.width);
            height = Math.max(height, r.height);
        }
        int diamondWidth = m_minimizedDiamond.getWidth(null);
        int paddingBorderToConfig = 1;
        Dimension barSize = this.m_minimizedConfigBox.getSize();
        int width = 0;
        width = xPos - x + this.m_insets.right;
        int leftMinWidth = this.m_minimizedBorderWidth + paddingBorderToConfig + barSize.width + this.m_configToImage + diamondWidth / 2;
        int rightMinWidth = diamondWidth / 2 + this.m_viewStatusBox.computeSize().width + this.m_minimizedBorderWidth;
        int minWidth = 2 * Math.max(leftMinWidth, rightMinWidth);
        height += this.m_insets.top + this.m_insets.bottom;
        if (width < minWidth) {
            int diff2 = (minWidth - width) / numBranches;
            for (int i = 0; i < numBranches; ++i) {
                View v3 = (View)this.m_children.get(i);
                v3.move(diff2, 0);
            }
            width = minWidth;
        }
        if (numBranches == 1 && (v = (View)this.m_children.get(0)) instanceof BasicVerticalBranchView && (diff = (centerX = x + width / 2) - (branchView = (BasicVerticalBranchView)v).getConnectionX()) != 0) {
            v.move(diff, 0);
        }
        this.m_bounds.width = width;
        this.m_bounds.height = height;
        this.m_connectionX = this.midX();
        this.m_minimizedConfigBox.setBounds(this.m_connectionX - diamondWidth / 2 - configBoxSize.width - this.m_configToImage, this.topY() + this.m_minimizedBorderWidth + diamondHeight / 2 - configBoxSize.height / 2, configBoxSize.width, configBoxSize.height);
        for (int i = 0; i < numBranches; ++i) {
            VerticalDropBranchView v4 = (VerticalDropBranchView)this.m_children.get(i);
            this.stretchViewToHeight((View)v4, maxBranchHeight);
            v4.stretchLastDropView();
        }
        return this.m_bounds;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        BasicVerticalBranchView branchView;
        int centerX;
        int diff;
        View v;
        this.updateActions();
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        if (this.isMinimized()) {
            return this.layoutMinimized(x, y, w, h, info);
        }
        this.updateStatusButtons();
        int diamondHeight = m_diamond.getHeight(null);
        int diamondWidth = m_diamond.getWidth(null);
        this.setInsets(this.m_borderWidth + this.m_borderToImage + diamondHeight + this.m_diamondToHorizontal + this.m_horizontalHeight + this.m_horizontalToBranch, this.m_borderWidth + this.m_sidePadding, this.m_borderWidth + 2 * this.m_bottomHorizontalPadding + this.m_horizontalHeight, this.m_borderWidth + this.m_sidePadding);
        this.setBounds(x, y, 0, 0);
        int padding = 5;
        int diamondToConfigSpacing = 5;
        if (this.isCollapsed()) {
            int iHeight = m_diamond.getHeight(null);
            int iWidth = m_diamond.getWidth(null);
            Dimension configSize = this.m_collapsedConfigBox.getSize();
            int imageViewWidth = 2 * (iWidth / 2 + this.m_imagePadding + configSize.width + this.m_imagePadding + this.m_borderWidth);
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)this.getName());
            int strViewWidth = this.m_borderWidth + this.m_imagePadding + strWidth + this.m_imagePadding + this.m_borderWidth;
            int viewWidth = Math.max(imageViewWidth, strViewWidth);
            int strHeight = GraphUtils.getFontHeight((Font)UIManager.getFont("Label.font"));
            int viewHeight = this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding + strHeight + this.m_borderWidth;
            this.setBounds(x, y, viewWidth, viewHeight);
            this.m_connectionX = this.midX();
            this.m_collapsedConfigBox.setBounds(this.m_bounds.x + this.m_borderWidth + this.m_imagePadding, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, configSize.width, configSize.height);
            int xOffset = (this.m_bounds.width - strWidth) / 2;
            this.m_nameBounds.setBounds(this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding + iHeight + this.m_imagePadding, strWidth, strHeight);
            this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, this.m_bounds.y + this.m_borderWidth);
            return this.m_bounds;
        }
        int height = 0;
        int xPos = x + this.m_insets.left;
        int yPos = y + this.m_insets.top;
        int numBranches = this.m_children.size();
        int maxBranchWidth = 2 * this.m_padding;
        int maxBranchHeight = 0;
        for (int i = 0; i < numBranches; ++i) {
            if (i > 0) {
                xPos += this.m_horizontalSpacing;
            }
            View v2 = (View)this.m_children.get(i);
            Rectangle r = v2.layout(xPos, yPos, w, h, info);
            xPos += r.width;
            maxBranchHeight = Math.max(maxBranchHeight, r.height);
            maxBranchWidth = Math.max(maxBranchWidth, r.width);
            height = Math.max(height, r.height);
        }
        Dimension tabSize = this.m_configBox.getSize();
        int width = xPos - x + this.m_insets.right;
        height += this.m_insets.top + this.m_insets.bottom;
        if (numBranches == 1 && (v = (View)this.m_children.get(0)) instanceof BasicVerticalBranchView && (diff = (centerX = x + width / 2) - (branchView = (BasicVerticalBranchView)v).getConnectionX()) != 0) {
            v.move(diff, 0);
        }
        this.m_bounds.width = width;
        this.m_bounds.height = height;
        this.m_connectionX = this.midX();
        for (int i = 0; i < numBranches; ++i) {
            branchView = (View)this.m_children.get(i);
            if (!(branchView instanceof VerticalDropBranchView)) continue;
            VerticalDropBranchView v3 = (VerticalDropBranchView)this.m_children.get(i);
            this.stretchViewToHeight((View)v3, maxBranchHeight);
            v3.stretchLastDropView();
        }
        this.m_configBox.setBounds(this.midX() - diamondWidth / 2 - 5 - tabSize.width, this.m_bounds.y + this.m_borderWidth + this.m_imagePadding, tabSize.width, tabSize.height);
        this.m_viewStatusBox.layout(this.m_connectionX + diamondWidth / 2, this.m_bounds.y + this.m_borderWidth);
        return this.m_bounds;
    }

    @Override
    public void addFlowLink(NodeRenderer src, NodeRenderer target) {
        this.m_flowLinks.add(new FlowLink(src, target));
    }

    public Activity getActivity() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        return null;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    public String getVoiceAccessibleText() {
        return "Flow";
    }
}

