/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.tip.tools.ide.common.bpelparser.iface.FlowN;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowNNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicVerticalBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class FlowNView
extends BasicVerticalBranchView
implements StateSaveableView,
Tabable,
VoiceAccessible {
    private static Image m_image = ImageCache.getImage("graph/bpel/flowN_small.png");
    private static Image m_disabledImage = BasicImageCache.createDisabledImage((Image)m_image);

    public FlowNView(GraphPane pane, View parent, FlowNNode n) {
        super(pane, parent, n);
        this.setCollapsable(true);
        Boolean val = (Boolean)n.getData("collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
    }

    @Override
    public Cursor getCursor(int x, int y) {
        Cursor c = super.getCursor(x, y);
        if (c != null) {
            return c;
        }
        if (this.isSelected() && this.isDraggable()) {
            return Cursor.getPredefinedCursor(13);
        }
        return null;
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("flow_n_node");
    }

    @Override
    protected String getText() {
        FlowN n = (FlowN)this.getNode().getUserObject();
        return n.getName();
    }

    @Override
    protected Image getImage() {
        return this.isEditable() ? m_image : m_disabledImage;
    }

    @Override
    protected boolean requiresSequence() {
        return true;
    }

    @Override
    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    @Override
    protected void paintTopConnection(Graphics g) {
        if (!this.isCollapsed()) {
            super.paintTopConnection(g);
        }
    }

    public String getToolTipText() {
        FlowN activity = (FlowN)this.getNode().getUserObject();
        String settingsText = BPELStringTranslator.getString("COLLAXALAF_SETTINGS");
        String text = "<html><body><table><tr><td colspan=2 align=center bgcolor=cyan><b>FlowN " + settingsText + "</b></td></tr>";
        text = text + FlowNView.getRowHTML("Name", activity.getName());
        text = text + FlowNView.getRowHTML("N", activity.getN());
        text = text + FlowNView.getRowHTML("Index Variable", activity.getIndexVariable());
        text = text + "</table></body></html>";
        return text;
    }

    protected static String getRowHTML(String name, String value) {
        if (value == null) {
            value = "";
        }
        return "<tr><td><b>" + name + ":</b></td><td>" + value + "</td></tr>";
    }

    public boolean getAcceptsArrow() {
        return this.isCollapsed();
    }

    @Override
    public List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public String getVoiceAccessibleText() {
        return "FlowN ";
    }
}

