/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkEdgeRenderer;

public class CubicPartnerLinkEdgeRenderer
extends PartnerLinkEdgeRenderer {
    protected CubicCurve2D.Double m_bottomCubic;
    protected CubicCurve2D.Double m_topCubic;
    protected List m_lineSegments = new ArrayList();

    public CubicPartnerLinkEdgeRenderer(BPELGraphPane pane) {
        super(pane);
    }

    protected boolean isDottedLine() {
        return false;
    }

    protected void paintRouted(Graphics g) {
        Stroke oldStroke;
        RenderingHints oldHints;
        Graphics2D g2;
        Graphics2D g2D;
        if (this.m_topCubic == null && this.m_bottomCubic == null) {
            super.paintRouted(g);
            return;
        }
        Color clr = this.getEdgeColor();
        if (this.m_bottomCubic != null) {
            g2D = (Graphics2D)g;
            g2 = (Graphics2D)g;
            oldHints = g2.getRenderingHints();
            g2.setRenderingHints(GraphUtils.SMOOTH_LINE_HINTS);
            oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f, 1, 0));
            g2D.setPaint(clr);
            g2D.draw(this.m_bottomCubic);
            g2.setStroke(oldStroke);
            g2.setRenderingHints(oldHints);
        }
        if (this.m_topCubic != null) {
            g2D = (Graphics2D)g;
            g2 = (Graphics2D)g;
            oldHints = g2.getRenderingHints();
            g2.setRenderingHints(GraphUtils.SMOOTH_LINE_HINTS);
            oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f, 1, 0));
            g2D.setPaint(clr);
            g2D.draw(this.m_topCubic);
            g2.setStroke(oldStroke);
            g2.setRenderingHints(oldHints);
        }
        for (LineSegment segment : this.m_lineSegments) {
            Point2D.Double start = segment.m_start;
            Point2D.Double end = segment.m_end;
            if (this.isDottedLine()) {
                GraphUtils.drawDottedLine((Graphics)g, (int)((int)start.x), (int)((int)start.y), (int)((int)end.x), (int)((int)end.y), (int)3, (Color)clr, (float)10.0f, (float)4.0f);
                continue;
            }
            GraphUtils.drawLine((Graphics)g, (int)((int)start.x), (int)((int)start.y), (int)((int)end.x), (int)((int)end.y), (float)3.0f, (Color)clr);
        }
    }

    protected void createShape() {
        super.createShape();
        this.m_bottomCubic = null;
        this.m_topCubic = null;
        this.m_lineSegments.clear();
        BPELSettings settings = this.m_pane.getSettings();
        if (!settings.m_bRoundedPartnerlinkConnections) {
            return;
        }
        int arc = 15;
        if (this.m_routed[0].x < this.m_routed[3].x && this.m_routed[0].y > this.m_routed[3].y && this.m_routed[0].y - this.m_routed[3].y > 2 * arc) {
            this.m_bottomCubic = new CubicCurve2D.Double();
            Point2D.Double bottomCubicStart = new Point2D.Double();
            Point2D.Double bottomCubicStartControlPoint = new Point2D.Double();
            Point2D.Double bottomCubicEndControlPoint = new Point2D.Double();
            Point2D.Double bottomCubicEnd = new Point2D.Double();
            this.m_bottomCubic.setCurve(bottomCubicStart, bottomCubicStartControlPoint, bottomCubicEndControlPoint, bottomCubicEnd);
            bottomCubicStart.setLocation(this.m_routed[1].x - arc, this.m_routed[1].y);
            bottomCubicEnd.setLocation(this.m_routed[1].x, this.m_routed[1].y - arc);
            bottomCubicStartControlPoint.setLocation(this.m_routed[1].x, this.m_routed[1].y);
            bottomCubicEndControlPoint.setLocation(this.m_routed[1].x, this.m_routed[1].y - arc);
            this.m_bottomCubic.setCurve(bottomCubicStart, bottomCubicStartControlPoint, bottomCubicEndControlPoint, bottomCubicEnd);
            this.m_topCubic = new CubicCurve2D.Double();
            Point2D.Double topCubicStart = new Point2D.Double();
            Point2D.Double topCubicStartControlPoint = new Point2D.Double();
            Point2D.Double topCubicEndControlPoint = new Point2D.Double();
            Point2D.Double topCubicEnd = new Point2D.Double();
            this.m_topCubic.setCurve(bottomCubicStart, topCubicStartControlPoint, topCubicEndControlPoint, bottomCubicEnd);
            topCubicStart.setLocation(this.m_routed[2].x, this.m_routed[2].y + arc);
            topCubicEnd.setLocation(this.m_routed[2].x + arc, this.m_routed[2].y);
            topCubicStartControlPoint.setLocation(this.m_routed[1].x, this.m_routed[2].y);
            topCubicEndControlPoint.setLocation(this.m_routed[2].x + arc, this.m_routed[2].y);
            this.m_topCubic.setCurve(topCubicStart, topCubicStartControlPoint, topCubicEndControlPoint, topCubicEnd);
            LineSegment bottomHorizontal = new LineSegment(new Point2D.Double(this.m_routed[0].x, this.m_routed[0].y), bottomCubicStart);
            LineSegment vertical = new LineSegment(bottomCubicEnd, topCubicStart);
            LineSegment topHorizontal = new LineSegment(topCubicEnd, new Point2D.Double(this.m_routed[3].x, this.m_routed[3].y));
            this.m_lineSegments.add(bottomHorizontal);
            this.m_lineSegments.add(vertical);
            this.m_lineSegments.add(topHorizontal);
        } else if (this.m_routed[0].x < this.m_routed[3].x && this.m_routed[0].y < this.m_routed[3].y && this.m_routed[3].y - this.m_routed[0].y > 2 * arc) {
            this.m_bottomCubic = new CubicCurve2D.Double();
            Point2D.Double bottomCubicStart = new Point2D.Double();
            Point2D.Double bottomCubicStartControlPoint = new Point2D.Double();
            Point2D.Double bottomCubicEndControlPoint = new Point2D.Double();
            Point2D.Double bottomCubicEnd = new Point2D.Double();
            this.m_bottomCubic.setCurve(bottomCubicStart, bottomCubicStartControlPoint, bottomCubicEndControlPoint, bottomCubicEnd);
            bottomCubicStart.setLocation(this.m_routed[2].x, this.m_routed[2].y - arc);
            bottomCubicEnd.setLocation(this.m_routed[2].x + arc, this.m_routed[2].y);
            bottomCubicStartControlPoint.setLocation(bottomCubicStart.getX(), bottomCubicStart.getY());
            bottomCubicEndControlPoint.setLocation(this.m_routed[2].x, this.m_routed[3].y);
            this.m_bottomCubic.setCurve(bottomCubicStart, bottomCubicStartControlPoint, bottomCubicEndControlPoint, bottomCubicEnd);
            this.m_topCubic = new CubicCurve2D.Double();
            Point2D.Double topCubicStart = new Point2D.Double();
            Point2D.Double topCubicStartControlPoint = new Point2D.Double();
            Point2D.Double topCubicEndControlPoint = new Point2D.Double();
            Point2D.Double topCubicEnd = new Point2D.Double();
            this.m_topCubic.setCurve(bottomCubicStart, topCubicStartControlPoint, topCubicEndControlPoint, bottomCubicEnd);
            topCubicStart.setLocation(this.m_routed[1].x - arc, this.m_routed[1].y);
            topCubicEnd.setLocation(this.m_routed[1].x, this.m_routed[1].y + arc);
            topCubicEndControlPoint.setLocation(topCubicEnd.getX(), topCubicEnd.getY());
            topCubicStartControlPoint.setLocation(this.m_routed[1].x, this.m_routed[1].y);
            this.m_topCubic.setCurve(topCubicStart, topCubicStartControlPoint, topCubicEndControlPoint, topCubicEnd);
            LineSegment bottomHorizontal = new LineSegment(bottomCubicEnd, new Point2D.Double(this.m_routed[3].x, this.m_routed[3].y));
            LineSegment vertical = new LineSegment(topCubicEnd, bottomCubicStart);
            LineSegment topHorizontal = new LineSegment(new Point2D.Double(this.m_routed[0].x, this.m_routed[0].y), topCubicStart);
            this.m_lineSegments.add(bottomHorizontal);
            this.m_lineSegments.add(vertical);
            this.m_lineSegments.add(topHorizontal);
        } else {
            this.m_bottomCubic = null;
            this.m_topCubic = null;
        }
    }

    class LineSegment {
        Point2D.Double m_start = new Point2D.Double();
        Point2D.Double m_end = new Point2D.Double();

        public LineSegment(Point2D.Double start, Point2D.Double end) {
            this.m_end = end;
            this.m_start = start;
        }
    }
}

