/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.actions.NoOpAction;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;

public class ConfigBox {
    public static final int VERTICAL_SEPARATOR_HEIGHT = 5;
    public static final String HOVER_ICON_KEY = "HOVER_ICON";
    private int ICON_WIDTH = 20;
    private int ICON_HEIGHT = 20;
    private HashMap<Action, ActionInfo> m_actionMap = new HashMap();
    private Rectangle m_bounds = new Rectangle();
    private List<GraphAction> m_actions;
    private Insets m_insets = new Insets(5, 5, 5, 5);
    private int m_imgSpacing = 0;
    private int m_orientation;
    private boolean m_minimizeMode = false;
    private Color m_borderColor = BPELGraphPane.TAB_BORDER_COLOR;
    private View m_view;
    private boolean m_bDecorated = true;
    private boolean m_bShowTransparentIcons = false;

    public ConfigBox(View v, List<GraphAction> actions, int orientation) {
        this.m_view = v;
        this.m_actions = actions;
        this.m_orientation = orientation;
        switch (this.m_orientation) {
            case 0: {
                this.ICON_WIDTH = 20;
                this.ICON_HEIGHT = 20;
                break;
            }
            case 1: {
                this.ICON_WIDTH = 23;
                this.ICON_HEIGHT = 20;
            }
        }
    }

    public void setTransparentIcons(boolean bTransparentIcons) {
        this.m_bShowTransparentIcons = bTransparentIcons;
    }

    public boolean isDecorated() {
        return this.m_bDecorated;
    }

    public void setDecorated(boolean bDecorate) {
        this.m_bDecorated = bDecorate;
    }

    public void setIconSize(int sz) {
        this.ICON_WIDTH = sz;
        this.ICON_HEIGHT = sz;
    }

    public Color getBorderColor() {
        return this.m_borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.m_borderColor = borderColor;
    }

    public boolean isMinimizeMode() {
        return this.m_minimizeMode;
    }

    public void setMinimizeMode(boolean minimizeMode) {
        this.m_minimizeMode = minimizeMode;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.m_insets.top = top;
        this.m_insets.left = left;
        this.m_insets.bottom = bottom;
        this.m_insets.right = right;
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public void clearHighlights() {
        Collection<ActionInfo> col = this.m_actionMap.values();
        for (ActionInfo info : col) {
            info.setHighlighted(false);
        }
    }

    public ActionInfo hitActionArea(int x, int y) {
        Collection<ActionInfo> col = this.m_actionMap.values();
        for (ActionInfo info : col) {
            Rectangle r;
            if (info.getAction() instanceof NoOpAction || !(r = info.getBounds()).contains(x, y)) continue;
            return info;
        }
        return null;
    }

    public Iterator getActionInfos() {
        Collection<ActionInfo> col = this.m_actionMap.values();
        return col.iterator();
    }

    public void move(int x, int y) {
        this.m_bounds.x += x;
        this.m_bounds.y += y;
        Collection<ActionInfo> col = this.m_actionMap.values();
        for (ActionInfo info : col) {
            Rectangle r = info.getBounds();
            r.x += x;
            r.y += y;
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.m_bounds.setBounds(x, y, w, h);
        this.m_actionMap.clear();
        if (this.m_orientation == 1) {
            int xPos = x + this.m_insets.left;
            int yPos = y + this.m_insets.top;
            int i = 0;
            for (GraphAction action : this.m_actions) {
                ActionInfo info;
                Rectangle r;
                Icon icon;
                if (!action.isVisible() || (icon = (Icon)action.getValue("SmallIcon")) == null) continue;
                if (i > 0) {
                    yPos += this.m_imgSpacing;
                }
                if (this.isMinimizeMode()) {
                    r = new Rectangle(xPos, yPos, icon.getIconWidth(), icon.getIconHeight());
                    info = new ActionInfo((Action)action, r);
                    this.m_actionMap.put((Action)action, info);
                    yPos += r.height;
                } else {
                    r = new Rectangle(xPos, yPos, this.ICON_WIDTH, this.ICON_HEIGHT);
                    info = new ActionInfo((Action)action, r);
                    this.m_actionMap.put((Action)action, info);
                    yPos += r.height;
                }
                ++i;
            }
        } else {
            int xPos = x + this.m_insets.left;
            int yPos = y + this.m_insets.top;
            int i = 0;
            for (GraphAction action : this.m_actions) {
                Icon icon;
                if (!action.isVisible() || (icon = (Icon)action.getValue("SmallIcon")) == null) continue;
                if (i > 0) {
                    xPos += this.m_imgSpacing;
                }
                if (this.isMinimizeMode()) {
                    Rectangle r = new Rectangle(xPos, yPos, icon.getIconWidth(), icon.getIconHeight());
                    ActionInfo info = new ActionInfo((Action)action, r);
                    this.m_actionMap.put((Action)action, info);
                    xPos += icon.getIconWidth();
                } else {
                    int iWidth = this.ICON_WIDTH;
                    Rectangle r = new Rectangle(xPos, yPos, iWidth, h);
                    ActionInfo info = new ActionInfo((Action)action, r);
                    this.m_actionMap.put((Action)action, info);
                    xPos += iWidth;
                }
                ++i;
            }
        }
    }

    public void paint(Graphics g, Color background) {
        Color borderClr;
        if (this.isDecorated() && !this.isMinimizeMode() && background != null) {
            if (this.m_bShowTransparentIcons) {
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)background, (float)0.6f);
            } else {
                g.setColor(background);
                g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
            }
            g.setColor(this.getBorderColor());
            g.drawRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.isDecorated() && (borderClr = this.getBorderColor()) != null) {
            g.setColor(borderClr);
            g.drawRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        int maxImageWidth = 0;
        for (GraphAction action : this.m_actions) {
            Icon hoverIcon;
            Icon img;
            Rectangle bounds;
            if (!action.isVisible()) continue;
            g.setColor(Color.black);
            ActionInfo info = this.m_actionMap.get(action);
            if (info == null || (bounds = info.getBounds()) == null) continue;
            if (this.isDecorated() && !this.isMinimizeMode() && info.isHighlighted()) {
                Color oldClr = g.getColor();
                g.setColor(new Color(255, 255, 225));
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                Color c = this.getBorderColor();
                if (c == null) {
                    c = this.getHighlightBorderColor();
                }
                g.setColor(c);
                g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                g.setColor(oldClr);
            }
            Icon icon = (Icon)action.getValue("SmallIcon");
            if (this.m_bShowTransparentIcons && !info.isHighlighted() && (img = (Icon)action.getValue("TRANSPARENT_ICON")) != null) {
                icon = img;
            }
            if (info.isHighlighted() && (hoverIcon = (Icon)action.getValue(HOVER_ICON_KEY)) != null) {
                icon = hoverIcon;
            }
            if (icon == null) continue;
            int xOffset = Math.max(0, (bounds.width - icon.getIconWidth()) / 2) + 1;
            int yOffset = Math.max(0, (bounds.height - icon.getIconHeight()) / 2) + 1;
            icon.paintIcon(null, g, bounds.x + xOffset, bounds.y + yOffset);
            maxImageWidth = Math.max(maxImageWidth, icon.getIconWidth());
        }
    }

    public Color getHighlightBorderColor() {
        return BPELGraphPane.TAB_BORDER_COLOR;
    }

    public Dimension getSize() {
        Dimension dim = new Dimension();
        if (this.m_orientation == 1) {
            int maxWidth = 30;
            int h = 0;
            int i = 0;
            for (GraphAction action : this.m_actions) {
                if (!action.isVisible()) continue;
                Icon icon = (Icon)action.getValue("SmallIcon");
                if (icon != null) {
                    if (i > 0) {
                        h += this.m_imgSpacing;
                    }
                    if (this.isMinimizeMode()) {
                        h += icon.getIconHeight();
                        maxWidth = Math.max(maxWidth, icon.getIconWidth());
                    } else {
                        h += this.ICON_HEIGHT;
                        maxWidth = this.ICON_WIDTH;
                    }
                }
                ++i;
            }
            dim.height = this.m_insets.top + h + this.m_insets.bottom;
            dim.width = this.m_insets.left + maxWidth + this.m_insets.right;
        } else {
            int w = 0;
            int maxHeight = this.isMinimizeMode() ? 0 : 30;
            int i = 0;
            for (GraphAction action : this.m_actions) {
                if (!action.isVisible()) continue;
                Icon icon = (Icon)action.getValue("SmallIcon");
                if (icon != null) {
                    if (i > 0) {
                        w += this.m_imgSpacing;
                    }
                    if (this.isMinimizeMode()) {
                        w += icon.getIconWidth();
                        maxHeight = Math.max(maxHeight, icon.getIconHeight());
                    } else {
                        w += this.ICON_WIDTH;
                        maxHeight = this.ICON_HEIGHT;
                    }
                }
                ++i;
            }
            dim.height = this.m_insets.top + maxHeight + this.m_insets.bottom;
            dim.width = this.m_insets.left + w + this.m_insets.right;
        }
        return dim;
    }
}

