/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.DropView;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CollaxaDropView
extends DropView {
    public static String DROP_TEXT_LINE1 = BPELStringTranslator.getString("COLLAXALAF_DROP_ACTIVITY", "Drop Activity");
    public static String DROP_TEXT_LINE2 = BPELStringTranslator.getString("COLLAXALAF_HERE", "Here");
    public static Dimension m_textDim;
    public static Font m_font;
    public static Font m_highLightFont;
    public static int m_textHorzPadding;
    public static int m_textVertPadding;
    public static Color m_gutterClr;
    protected boolean m_bTextMode = false;
    protected boolean m_bDropAllowed = true;
    protected String m_dropText;
    protected int m_lineThickness = 1;
    protected boolean m_bPaintLineArrow = true;

    public CollaxaDropView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.setDropText(DROP_TEXT_LINE1);
        this.m_imgDim.width = ImageCache.getImage("graph/bpel/arrowhead.png").getWidth(null);
        this.m_imgDim.height = ImageCache.getImage("graph/bpel/arrowhead.png").getHeight(null);
        this.m_lineThickness = pane.getLineThickness();
    }

    public boolean getPaintLineArrow() {
        return this.m_bPaintLineArrow;
    }

    public void setPaintLineArrow(boolean bPaintLineArrow) {
        this.m_bPaintLineArrow = bPaintLineArrow;
    }

    public Image getDropZoneImage() {
        return this.m_bHighLight ? ImageCache.getImage("graph/bpel/dropzone_bpel_20.png") : ImageCache.getImage("graph/bpel/dropzone_bpel_20.png");
    }

    public void setDropText(String text) {
        this.m_dropText = text;
        int strWidth = GraphUtils.getStringWidth((Font)m_font, (String)this.m_dropText);
        strWidth = Math.max(GraphUtils.getStringWidth((Font)m_font, (String)DROP_TEXT_LINE2), strWidth);
        int strHeight = 2 * GraphUtils.getFontHeight((Font)m_font);
        m_textDim = new Dimension(2 * m_textHorzPadding + strWidth, 2 * m_textVertPadding + strHeight);
    }

    public void setTextMode(boolean bTextMode) {
        this.m_bTextMode = bTextMode;
    }

    public void setDropAllowed(boolean bDropAllowed) {
        this.m_bDropAllowed = bDropAllowed;
    }

    public boolean isDropAllowed() {
        return this.m_bDropAllowed;
    }

    public void setLineThickness(int thickness) {
        this.m_lineThickness = thickness;
    }

    public int getLineThickness() {
        return this.m_lineThickness;
    }

    public void paint(Graphics g, int layer) {
        boolean bPaintDropZones;
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (this.isMinimized()) {
            int lineThickness = this.getLineThickness();
            Color lineColor = this.getGraphPane().getLineColor();
            GraphUtils.drawVertLine((Graphics)g, (int)this.midX(), (int)this.topY(), (int)this.bottomY(), (float)lineThickness, (Color)lineColor);
            return;
        }
        boolean bl = bPaintDropZones = pane.getShowDropZones() && this.isDropAllowed();
        if (this.m_bTextMode) {
            Font f = m_font;
            g.setFont(f);
            Color textColor = this.m_bHighLight || bPaintDropZones ? Color.blue : Color.lightGray;
            g.setColor(textColor);
            int fontHeight = GraphUtils.getFontAscent((Font)m_font);
            int xOffset = Math.max(0, (this.m_bounds.width - GraphUtils.getStringWidth((Font)m_font, (String)this.m_dropText)) / 2);
            g.drawString(this.m_dropText, this.m_bounds.x + xOffset, this.m_bounds.y + this.m_bounds.height / 2);
            xOffset = Math.max(0, (this.m_bounds.width - GraphUtils.getStringWidth((Font)m_font, (String)DROP_TEXT_LINE2)) / 2);
            g.drawString(DROP_TEXT_LINE2, this.m_bounds.x + xOffset, this.m_bounds.y + this.m_bounds.height / 2 + fontHeight);
            GraphUtils.drawVertLine((Graphics)g, (int)this.midX(), (int)this.topY(), (int)(this.topY() + m_textVertPadding / 2), (float)this.getLineThickness(), (Color)this.getGraphPane().getLineColor());
            GraphUtils.drawVertLine((Graphics)g, (int)this.midX(), (int)this.bottomY(), (int)(this.bottomY() - m_textVertPadding / 2), (float)this.getLineThickness(), (Color)this.getGraphPane().getLineColor());
        } else {
            if (bPaintDropZones) {
                int lineThickness = this.getLineThickness();
                Color lineColor = this.getGraphPane().getLineColor();
                Image img = this.getDropZoneImage();
                int iWidth = img.getWidth(null);
                int iHeight = img.getHeight(null);
                int xOffset = Math.max(0, this.m_bounds.width / 2 - iWidth / 2);
                int yOffset = Math.max(0, (this.m_bounds.height - iHeight) / 2) - 2;
                g.drawImage(img, this.m_bounds.x + xOffset, this.m_bounds.y + yOffset, null);
                if (this.m_bPaintLineArrow) {
                    GraphUtils.drawVertLine((Graphics)g, (int)this.midX(), (int)this.topY(), (int)(this.m_bounds.y + yOffset), (float)lineThickness, (Color)lineColor);
                    GraphUtils.drawVertLine((Graphics)g, (int)this.midX(), (int)this.bottomY(), (int)(this.m_bounds.y + yOffset + iHeight), (float)lineThickness, (Color)lineColor);
                }
                if ((img = this.getImage()) != null && this.getShowArrow()) {
                    int yPos = this.m_bounds.y + this.m_bounds.height - this.m_imgDim.height;
                    xOffset = this.m_bounds.width / 2 - img.getWidth(null) / 2;
                    g.drawImage(img, this.m_bounds.x + xOffset, yPos, this.m_imgDim.width, this.m_imgDim.height, null);
                }
                return;
            }
            if (!this.isDropAllowed()) {
                return;
            }
            if (this.m_bPaintLineArrow) {
                this.paintLineArrow(g);
            }
        }
    }

    public void paintLineArrow(Graphics g) {
        int lineThickness = this.getLineThickness();
        Color lineColor = this.getGraphPane().getLineColor();
        if (this.m_bHighLight) {
            this.paintHighLight(g);
        }
        Image img = this.getImage();
        GraphUtils.drawVertLine((Graphics)g, (int)this.midX(), (int)this.topY(), (int)this.bottomY(), (float)lineThickness, (Color)lineColor);
        if (img != null && this.getShowArrow()) {
            int yPos = this.m_bounds.y + this.m_bounds.height - this.m_imgDim.height;
            int xOffset = (this.m_bounds.width - this.m_imgDim.width) / 2 + 1;
            g.drawImage(img, this.m_bounds.x + xOffset, yPos, this.m_imgDim.width, this.m_imgDim.height, null);
        }
    }

    protected void paintHighLight(Graphics g) {
        g.setColor(Color.cyan);
        int width = 6;
        g.fillRect(this.m_bounds.x + this.m_bounds.width / 2 - width / 2, this.m_bounds.y, width, this.m_bounds.height);
        g.setColor(Color.blue);
        g.drawRect(this.m_bounds.x + this.m_bounds.width / 2 - width / 2, this.m_bounds.y, width, this.m_bounds.height);
    }

    protected int getTopPadding() {
        return this.isDropAllowed() ? 15 : 0;
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane.isOptimized()) {
            return true;
        }
        Boolean b = (Boolean)pane.getProperty("MINIMIZE_DROP_ZONES");
        if (b != null) {
            return b;
        }
        return false;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        if (this.isMinimized()) {
            this.m_bounds.setBounds(x, y, this.m_imgDim.width, this.m_imgDim.height);
            this.m_connectionX = this.midX();
            return this.m_bounds;
        }
        if (this.m_bTextMode) {
            this.m_bounds.setBounds(x, y, CollaxaDropView.m_textDim.width + this.m_insets.left + this.m_insets.right, CollaxaDropView.m_textDim.height + this.m_insets.top + this.m_insets.bottom);
            this.m_connectionX = this.midX();
            return this.m_bounds;
        }
        if (this.isDropAllowed()) {
            this.setBounds(x, y, 0, 0);
            Image i = this.getDropZoneImage();
            int imgWidth = i.getWidth(null);
            int imgHeight = i.getHeight(null);
            this.m_bounds.height = this.m_insets.top + this.getTopPadding() + imgHeight;
            this.m_bounds.height += this.m_insets.bottom;
            this.m_bounds.width = this.m_insets.left + this.m_padding + imgWidth + this.m_padding + this.m_insets.right;
            this.m_connectionX = this.midX();
        } else {
            this.setBounds(x, y, 3, 1);
            this.m_connectionX = this.midX();
        }
        return this.m_bounds;
    }

    protected Image getImage() {
        return ImageCache.getImage("graph/bpel/arrowhead.png");
    }

    static {
        m_font = new Font(UIManager.getFont("Label.font").getFontName(), 1, 12);
        m_highLightFont = new Font(UIManager.getFont("Label.font").getFontName(), 1, 14);
        m_textHorzPadding = 15;
        m_textVertPadding = 25;
        m_gutterClr = new Color(240, 240, 240);
    }
}

