/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.graph.view.VoiceAccessible;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BasicVerticalBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CatchView
extends BasicVerticalBranchView
implements StateSaveableView,
VoiceAccessible {
    public CatchView(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
        this.setDraggable(false);
        Boolean val = (Boolean)n.getData((Object)"collapsed");
        if (val != null) {
            this.setCollapsed(val);
        } else {
            this.setCollapsed(true);
        }
    }

    @Override
    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("catch_node");
    }

    @Override
    protected boolean requiresSequence() {
        return true;
    }

    @Override
    protected String getText() {
        Catch c = (Catch)this.getNode().getUserObject();
        QName qname = c.getFaultName();
        if (qname != null) {
            return BPELModelUtil.getPrefixQualifiedName((QName)qname);
        }
        return "";
    }

    @Override
    public boolean canEditName() {
        return false;
    }

    @Override
    protected Image getImage() {
        return ImageCache.getImage("graph/bpel/catch_47x47.png");
    }

    @Override
    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        this.updateStatusButtons();
        return super.layout(x, y, w, h, info);
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    @Override
    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    public String getVoiceAccessibleText() {
        return "Catch Branch";
    }
}

