/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public abstract class BasicVerticalBranchView
extends BPELVerticalDropBranchView
implements ValidatableView,
Magnifiable,
Tabable {
    protected static Font TEXT_FONT = new Font(UIManager.getFont("Label.font").getFontName(), 0, 11);
    protected int m_branchToBorder = 5;
    protected int m_sidePadding = 5;
    protected int m_topToBranch = 2;
    protected int m_imageToBorder = 2;
    protected int m_imageToText = 3;
    protected int m_spaceToBranch = 5;
    protected int m_outsideToInsideBorder = 4;
    protected int m_internalBorderWidth = 1;
    protected int m_minWidth = 120;
    protected int m_minHeight = 120;
    protected int m_borderWidth = 2;
    protected int m_branchSidePadding = 5;
    protected int m_minimizedBorderWidth = 2;
    protected boolean m_bMagnified = false;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;
    protected int m_nameBoxPadding = 3;
    protected Rectangle m_nameBox = new Rectangle();
    protected Rectangle m_imageBounds = new Rectangle();
    protected ConfigBox m_configBox;
    protected ConfigBox m_collapsedConfigBox;
    protected ConfigBox m_minimizedConfigBox;
    protected CollapseExpandViewAction m_collapseAction;
    protected Rectangle m_nameBounds = new Rectangle();
    protected Rectangle m_internalBorderRect = new Rectangle();
    protected JTextField m_nameField = new JTextField();
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected String m_displayText;

    public BasicVerticalBranchView(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
        this.m_configBox = new ConfigBox((View)this, this.createActions(), 0);
        this.m_configBox.setBorderColor(null);
        this.m_configBox.setInsets(0, 0, 0, 0);
        this.m_collapsedConfigBox = new ConfigBox((View)this, this.createCollapsedActions(), 0);
        this.m_collapsedConfigBox.setBorderColor(null);
        this.m_collapsedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox = new ConfigBox((View)this, this.getMinimizedActions(), 0);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setMinimizeMode(true);
        this.m_minimizedConfigBox.setBorderColor(null);
        this.setCanSelect(true);
        this.setCollapsable(true);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane.isOptimized()) {
            return true;
        }
        BPELSettings settings = pane.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SCOPES");
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
        if (this.m_bMagnified) {
            this.m_bMagnified = false;
            ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
        }
    }

    @Override
    public View getView() {
        return this;
    }

    protected boolean requiresSequence() {
        return false;
    }

    protected abstract Image getImage();

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    protected void asyncGenerateValidationReport() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BasicVerticalBranchView.this.generateValidationReport();
            }
        };
        new Thread(r).start();
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    protected String getText() {
        return this.getNode().getName();
    }

    public ToolTipable getToolTipable(int x, int y) {
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        return this;
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        return info == null ? null : Cursor.getPredefinedCursor(12);
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isMinimized()) {
            return this.m_minimizedConfigBox.hitActionArea(x, y);
        }
        if (this.isCollapsed()) {
            return this.m_collapsedConfigBox.hitActionArea(x, y);
        }
        if (this.isSelected()) {
            return this.m_configBox.hitActionArea(x, y);
        }
        return null;
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized()) {
            boolean bHitImage = this.m_imageBounds.contains(evt.getX(), evt.getY());
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered && bHitImage) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_configBox.clearHighlights();
        this.m_collapsedConfigBox.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public boolean hitNameEdit(int x, int y) {
        return this.m_nameBounds.contains(x, y);
    }

    public void setEditingName(boolean bEditing) {
        super.setEditingName(bEditing);
        GraphPane pane = this.getGraphPane();
        if (bEditing) {
            pane.add((Component)this.m_nameField);
            Dimension prefDim = this.m_nameField.getPreferredSize();
            String text = this.getText();
            int strWidth = GraphUtils.getStringWidth((Font)UIManager.getFont("Label.font"), (String)text);
            this.m_nameField.setText(text);
            this.m_nameField.setCaretPosition(0);
            this.m_nameField.requestFocus();
            int xOffset = 0;
            int w = strWidth + this.m_nameField.getInsets().left + this.m_nameField.getInsets().right;
            if (this.m_nameBounds.width < w) {
                xOffset = -(w - this.m_nameBounds.width) / 2;
            }
            this.m_nameField.setBounds(this.m_nameBounds.x + xOffset, this.m_nameBounds.y, w, prefDim.height);
            this.m_nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        BasicVerticalBranchView.this.setEditingName(false);
                        BasicVerticalBranchView.this.saveNameChange();
                    }
                }
            });
            this.m_nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    BasicVerticalBranchView.this.setEditingName(false);
                    BasicVerticalBranchView.this.saveNameChange();
                }
            });
        } else {
            pane.remove((Component)this.m_nameField);
        }
        pane.repaint();
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_nameBox.x += x;
        this.m_nameBox.y += y;
        this.m_configBox.move(x, y);
        this.m_collapsedConfigBox.move(x, y);
        this.m_nameBounds.x += x;
        this.m_nameBounds.y += y;
        this.m_viewStatusBox.move(x, y);
        this.m_imageBounds.x += x;
        this.m_imageBounds.y += y;
        this.m_minimizedConfigBox.move(x, y);
        this.m_internalBorderRect.x += x;
        this.m_internalBorderRect.y += y;
    }

    protected void saveNameChange() {
        Node n = this.getNode();
        n.setName(this.m_nameField.getText());
        this.getGraphPane().forceLayout();
    }

    protected List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    protected List<GraphAction> createCollapsedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public List<GraphAction> getMinimizedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    protected void paintSelected(Graphics g) {
    }

    protected Color getSelectedBackgroundColor() {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        return settings.m_selectedBorderBackgroundColor;
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        GraphUtils.paintSelectionBox((Graphics)g, (int)r.x, (int)r.y, (int)r.width, (int)r.height, (Color)this.getSelectedBackgroundColor(), (float)borderWidth);
    }

    protected Color getTextColor() {
        return this.isEditable() ? Color.black : Color.lightGray;
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = this.getImage();
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        int fontHeight = GraphUtils.getFontHeight((Font)TEXT_FONT);
        int strWidth = 0;
        String s = this.getText();
        if (s != null) {
            strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        }
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x + this.m_bounds.width + 20, this.m_bounds.y, w, h);
        r.y = this.m_imageBounds.y + this.m_imageBounds.height / 2 - r.height / 2;
        if (this.m_bounds.height > r.height) {
            r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        }
        if (r.width < 80) {
            r.width = 80;
        }
        if (r.height < 80) {
            r.height = 80;
        }
        return r;
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = this.getImage();
        String s = this.getText();
        int strWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)TEXT_FONT);
        GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)Color.cyan, (float)0.3f);
        Color lineClr = Color.cyan.darker();
        g.setColor(lineClr);
        GraphUtils.drawRoundRect((Graphics)g, (int)this.m_bounds.x, (int)this.m_bounds.y, (int)this.m_bounds.width, (int)this.m_bounds.height, (float)1.0f, (Color)lineClr, (int)15);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)r.x, (int)(r.y + 10), (float)1.5f, (Color)Color.cyan.darker());
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 10), (float)1.5f, (Color)Color.cyan.darker());
        Graphics2D g2 = (Graphics2D)g;
        Color c1 = new Color(223, 242, 249);
        Color c2 = new Color(197, 214, 233);
        GradientPaint gp = new GradientPaint(r.x, r.y, c1, r.x, r.y + r.height, c2);
        g2.setPaint(gp);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        g.setColor(lineClr);
        g.drawRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)this.getTextColor(), (Font)TEXT_FONT);
        }
        this.paintStatusIcons(g);
    }

    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("window_gear.png");
    }

    protected void paintMinimized(Graphics g, int layer) {
        if (this.isCollapsed()) {
            Icon icon = this.getMinimizedIcon();
            icon.paintIcon((Component)this.getGraphPane(), g, this.m_imageBounds.x, this.m_imageBounds.y);
            if (this.isSelected()) {
                this.paintSelectionBox(g, this.m_bounds, this.m_minimizedBorderWidth);
            }
            this.m_minimizedConfigBox.paint(g, Color.white);
        } else {
            super.paint(g, layer);
            g.setColor(BPELGraphPane.TAB_BORDER_COLOR);
            g.drawRect(this.leftX() + this.m_insets.left, this.topY() + this.m_insets.top, this.m_bounds.width - this.m_insets.left - this.m_insets.right, this.m_bounds.height - this.m_insets.top - this.m_minimizedBorderWidth);
            Icon icon = this.getMinimizedIcon();
            icon.paintIcon((Component)this.getGraphPane(), g, this.m_imageBounds.x, this.m_imageBounds.y);
            if (this.isSelected()) {
                this.paintSelectionBox(g, this.m_bounds, this.m_minimizedBorderWidth);
            }
            this.m_minimizedConfigBox.paint(g, Color.white);
        }
    }

    protected void paintConnections(Graphics g) {
    }

    public void paint(Graphics g, int layer) {
        boolean bSelected = this.isSelected();
        if (bSelected) {
            g.setColor(BPELGraphPane.VIEW_SELECTION_BACKGROUND);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (bSelected) {
                this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
            }
            return;
        }
        if (this.isMinimized()) {
            this.paintMinimized(g, layer);
            return;
        }
        if (this.isCollapsed()) {
            this.paintTopConnection(g);
        } else {
            super.paint(g, layer);
        }
        this.paintBranchImage(g);
        this.paintText(g);
        if (!this.isCollapsed()) {
            g.setColor(BPELGraphPane.TAB_BORDER_COLOR);
            g.drawRect(this.m_internalBorderRect.x, this.m_internalBorderRect.y, this.m_internalBorderRect.width, this.m_internalBorderRect.height);
            this.paintNameToBorderConnection(g);
            this.paintInternalBorderToBottomConnection(g);
            if (bSelected) {
                this.m_configBox.paint(g, null);
                this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
            }
        } else {
            this.m_collapsedConfigBox.paint(g, null);
            if (bSelected) {
                this.paintSelectionBox(g, this.m_bounds, this.m_borderWidth);
            }
        }
        this.paintStatusIcons(g);
    }

    protected void paintNameToBorderConnection(Graphics g) {
        if (!this.isCollapsed()) {
            GraphUtils.drawVertLine((Graphics)g, (int)this.m_connectionX, (int)(this.m_nameBox.y + this.m_nameBox.height), (int)(this.m_bounds.y + this.m_insets.top - this.m_internalBorderWidth), (float)this.getLineThickness(), (Color)this.getGraphPane().getLineColor());
        }
    }

    protected void paintInternalBorderToBottomConnection(Graphics g) {
        GraphUtils.drawVertLine((Graphics)g, (int)this.m_connectionX, (int)(this.m_bounds.y + this.m_bounds.height - this.m_insets.bottom), (int)(this.m_bounds.y + this.m_bounds.height), (float)this.getLineThickness(), (Color)this.getGraphPane().getLineColor());
    }

    protected boolean hasText() {
        return true;
    }

    protected void paintText(Graphics g) {
        String text = this.m_displayText;
        if (text != null && text.trim().length() > 0) {
            Font oldFont = g.getFont();
            g.setFont(TEXT_FONT);
            int ascent = GraphUtils.getFontAscent((Font)TEXT_FONT);
            g.setColor(this.getTextColor());
            g.drawString(text, this.m_nameBounds.x, this.m_nameBounds.y + ascent);
            g.setFont(oldFont);
        } else {
            Image img = this.getImage();
            if (img != null) {
                if (this.isCollapsed()) {
                    GraphUtils.drawVertLine((Graphics)g, (int)this.m_connectionX, (int)(this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder + img.getHeight(null)), (int)this.bottomY(), (float)this.getLineThickness(), (Color)this.getGraphPane().getLineColor());
                } else {
                    GraphUtils.drawVertLine((Graphics)g, (int)this.m_connectionX, (int)(this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder + img.getHeight(null)), (int)this.m_internalBorderRect.y, (float)this.getLineThickness(), (Color)this.getGraphPane().getLineColor());
                }
            }
        }
    }

    protected void paintBranchImage(Graphics g) {
        Image img = this.getImage();
        if (img != null) {
            g.drawImage(img, this.m_connectionX - img.getWidth(null) / 2, this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder, null);
        }
    }

    protected void paintTopConnection(Graphics g) {
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    protected Rectangle layoutMinimized(int x, int y, int w, int h, LayoutInfo info) {
        int nChildren;
        BaseView v;
        Node childNode;
        Node seqNode;
        int numChildren;
        this.updateStatusButtons();
        this.notifyLayoutWillOccur();
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            NodeRenderer renderer = (NodeRenderer)it.next();
            if (!(renderer instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)renderer).setDropAllowed(true);
        }
        if (this.requiresSequence() && (numChildren = (seqNode = this.getNode()).getChildCount()) == 3 && (childNode = seqNode.getChildNode(1)).getNodeType() == 103) {
            v = this.getChildViewForNode(seqNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(seqNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        boolean bTextMode = (nChildren = this.m_children.size()) == 1;
        for (int i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        this.setBounds(x, y, 0, 0);
        Dimension configBoxSize = this.m_minimizedConfigBox.getSize();
        Icon icon = ImageCache.getIcon("window_gear.png");
        int iWidth = icon.getIconWidth();
        int iHeight = icon.getIconHeight();
        int spacing = 2;
        int insideBorderWidth = 1;
        int topWidth = 2 * (this.m_minimizedBorderWidth + spacing + configBoxSize.width + spacing + iWidth / 2);
        this.m_minimizedConfigBox.setBounds(x + this.m_minimizedBorderWidth + spacing, y + this.m_minimizedBorderWidth + spacing, configBoxSize.width, configBoxSize.height);
        if (!this.isCollapsed()) {
            int topInset = this.m_minimizedBorderWidth + spacing + Math.max(configBoxSize.height, iHeight) + spacing + insideBorderWidth + spacing;
            int bottomInset = spacing + insideBorderWidth + this.m_minimizedBorderWidth;
            this.setInsets(topInset, this.m_minimizedBorderWidth + spacing, bottomInset, this.m_minimizedBorderWidth + spacing);
            int maxLeft = 0;
            int maxRight = 0;
            int xPos = x + this.m_insets.left;
            int yPos = y + this.m_insets.top;
            this.m_bounds.height = this.m_insets.top;
            for (int i = 0; i < nChildren; ++i) {
                BaseView v2 = (BaseView)this.m_children.get(i);
                if (i > 0) {
                    yPos += this.m_verticalSpacing;
                    this.m_bounds.height += this.m_verticalSpacing;
                }
                Rectangle r = v2.layout(xPos, yPos, w, h, info);
                maxLeft = Math.max(maxLeft, v2.getLeftWidth());
                maxRight = Math.max(maxRight, v2.getRightWidth());
                yPos += r.height;
                this.m_bounds.height += r.height;
            }
            this.m_bounds.height += this.m_insets.bottom;
            int childrenWidth = 2 * Math.max(maxLeft, maxRight);
            if (childrenWidth < topWidth) {
                maxRight = maxLeft = topWidth / 2;
            }
            for (int i = 0; i < nChildren; ++i) {
                BaseView v3 = (BaseView)this.m_children.get(i);
                int xDiff = Math.max(0, maxLeft - v3.getLeftWidth());
                if (xDiff <= 0) continue;
                v3.move(xDiff, 0);
            }
            this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
            this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        } else {
            int bottomInset = this.m_minimizedBorderWidth;
            int topInset = this.m_minimizedBorderWidth + spacing + Math.max(configBoxSize.height, iHeight);
            this.setInsets(topInset, this.m_minimizedBorderWidth + spacing, bottomInset, this.m_minimizedBorderWidth + spacing);
            this.m_bounds.width = this.m_insets.left + topWidth + this.m_insets.right;
            this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
            this.m_connectionX = this.midX();
        }
        this.m_imageBounds.setBounds(this.midX() - iWidth / 2, this.topY() + this.m_minimizedBorderWidth + spacing, iWidth, iHeight);
        Rectangle r = this.computeMagnifiedBounds();
        this.m_viewStatusBox.layout(r.x + r.width, r.y);
        return this.m_bounds;
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        int topWidth;
        int nChildren;
        BaseView v;
        Node childNode;
        Node seqNode;
        int numChildren;
        this.m_displayText = this.getText();
        this.m_internalBorderRect.setBounds(x, y, 0, 0);
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        if (this.isMinimized()) {
            return this.layoutMinimized(x, y, w, h, info);
        }
        this.updateStatusButtons();
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        int iWidth = 0;
        int iHeight = 0;
        Image img = this.getImage();
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        int textWidth = 0;
        int textHeight = GraphUtils.getFontHeight((Font)TEXT_FONT);
        if (this.hasText()) {
            String text;
            this.m_displayText = text = this.getText();
            if (text != null) {
                textWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)text);
            }
            this.m_nameBox.height = 2 * this.m_nameBoxPadding + textHeight;
            this.m_nameBox.width = 2 * this.m_nameBoxPadding + textWidth;
        } else {
            this.m_nameBox.height = 0;
            this.m_nameBox.width = 0;
        }
        int imgToBox = 5;
        if (this.isCollapsed()) {
            Dimension boxSize = this.m_collapsedConfigBox.getSize();
            this.setBounds(x, y, 0, 0);
            int bottomSpaceToBorder = 2;
            int boxToBorder = 5;
            int w1 = 2 * (iWidth / 2 + imgToBox + boxSize.width + boxToBorder + this.m_borderWidth);
            int w2 = 2 * (this.m_nameBox.width / 2 + this.m_borderWidth);
            if (this.m_nameBox.width > 100) {
                int strWidth = 100 - 2 * this.m_nameBoxPadding;
                this.m_displayText = Helper.stripString((String)this.m_displayText, (Font)TEXT_FONT, (int)strWidth);
                this.m_nameBox.width = 100;
                w2 = 2 * (this.m_nameBox.width / 2 + this.m_borderWidth);
            }
            textWidth = GraphUtils.getStringWidth((Font)TEXT_FONT, (String)this.m_displayText);
            this.m_bounds.width = Math.max(w1, w2);
            this.m_bounds.height = this.m_borderWidth + this.m_imageToBorder + iHeight + this.m_imageToText + this.m_nameBox.height + bottomSpaceToBorder + this.m_borderWidth;
            this.m_connectionX = this.midX();
            this.m_collapsedConfigBox.setBounds(this.m_connectionX - iWidth / 2 - imgToBox - boxSize.width, this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder, boxSize.width, boxSize.height);
            int xOffset = (this.m_bounds.width - this.m_nameBox.width) / 2;
            int textY = this.m_bounds.y + this.m_borderWidth;
            if (iHeight > 0) {
                textY += this.m_imageToText + iHeight;
            }
            this.m_nameBox.setBounds(this.m_bounds.x + xOffset, textY += this.m_imageToText, this.m_nameBox.width, this.m_nameBox.height);
            this.m_nameBounds.setBounds(this.m_nameBox.x + this.m_nameBoxPadding, this.m_nameBox.y + this.m_nameBoxPadding, textWidth, textHeight);
            this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, this.m_bounds.y + this.m_borderWidth);
            return this.m_bounds;
        }
        Dimension configBoxSize = this.m_configBox.getSize();
        int topInset = this.m_borderWidth + this.m_imageToBorder + iHeight + this.m_imageToText + this.m_nameBox.height + this.m_topToBranch + this.m_internalBorderWidth;
        int leftInset = this.m_borderWidth + this.m_outsideToInsideBorder + this.m_internalBorderWidth + this.m_sidePadding;
        int rightInset = this.m_borderWidth + this.m_outsideToInsideBorder + this.m_internalBorderWidth + this.m_sidePadding;
        int bottomInset = this.m_borderWidth + this.m_outsideToInsideBorder + this.m_internalBorderWidth + this.m_branchToBorder;
        this.setInsets(topInset, leftInset, bottomInset, rightInset);
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            NodeRenderer renderer = (NodeRenderer)it.next();
            if (!(renderer instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)renderer).setDropAllowed(true);
        }
        if (this.requiresSequence() && (numChildren = (seqNode = this.getNode()).getChildCount()) == 3 && (childNode = seqNode.getChildNode(1)).getNodeType() == 103) {
            v = this.getChildViewForNode(seqNode.getChildNode(0));
            if (v instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
            if ((v = this.getChildViewForNode(seqNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v).setDropAllowed(false);
            }
        }
        boolean bTextMode = (nChildren = this.m_children.size()) == 1;
        for (int i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (!(v instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v).setTextMode(bTextMode);
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (int i = 0; i < nChildren; ++i) {
            BaseView v2 = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v2.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v2.getLeftWidth());
            maxRight = Math.max(maxRight, v2.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        Dimension statusBarDim = this.m_viewStatusBox.computeSize();
        int widthDueToImages = configBoxSize.width + imgToBox + iWidth + imgToBox + statusBarDim.width;
        int widthDueToChildren = maxLeft + maxRight;
        int widthDueToText = this.m_nameBox.width;
        if (widthDueToChildren < widthDueToText && widthDueToText > 100) {
            this.m_displayText = Helper.stripString((String)this.m_displayText, (Font)TEXT_FONT, (int)(100 - 2 * this.m_nameBoxPadding));
            widthDueToText = this.m_nameBox.width = 100;
        }
        if ((topWidth = Math.max(widthDueToImages, widthDueToText)) > widthDueToChildren) {
            maxLeft = topWidth / 2;
            maxRight = topWidth / 2;
        }
        for (int i = 0; i < nChildren; ++i) {
            BaseView v3 = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v3.getLeftWidth());
            if (xDiff <= 0) continue;
            v3.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.m_configBox.setBounds(this.m_connectionX - iWidth / 2 - imgToBox - configBoxSize.width, this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder, configBoxSize.width, configBoxSize.height);
        int xOffset = (this.m_bounds.width - this.m_nameBox.width) / 2;
        int textY = this.m_bounds.y + this.m_borderWidth + this.m_imageToBorder + iHeight + this.m_imageToText;
        this.m_nameBox.setBounds(this.m_bounds.x + xOffset, textY, this.m_nameBox.width, this.m_nameBox.height);
        this.m_nameBounds.setBounds(this.m_nameBox.x + this.m_nameBoxPadding, this.m_nameBox.y + this.m_nameBoxPadding, textWidth, textHeight);
        this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2 + imgToBox, this.m_bounds.y + this.m_borderWidth);
        this.m_internalBorderRect.setBounds(this.m_bounds.x + this.m_borderWidth + this.m_outsideToInsideBorder, this.m_bounds.y + this.m_insets.top - this.m_internalBorderWidth, this.m_bounds.width - this.m_borderWidth - this.m_borderWidth - this.m_outsideToInsideBorder - this.m_outsideToInsideBorder, this.m_bounds.height - this.m_insets.top - this.m_borderWidth - this.m_outsideToInsideBorder);
        return this.m_bounds;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }
}

