/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;

public class BasicStatusBoxButton
implements StatusBoxButton {
    static int m_borderWidth = 1;
    static Insets m_insets = new Insets(1, 1, 1, 1);
    static Color m_bgColor = BPELGraphPane.TAB_BACKGROUND_COLOR;
    static Color m_borderColor = BPELGraphPane.TAB_BORDER_COLOR;
    protected Dimension m_dim;
    protected Icon m_icon;
    protected boolean m_bHighlight;
    protected Rectangle m_bounds = new Rectangle();
    protected boolean m_bVisible = true;
    protected View m_view;

    public BasicStatusBoxButton(View v, Icon icon) {
        this.m_dim = new Dimension();
        this.m_icon = icon;
        this.m_view = v;
        this.m_dim.width = 23;
        this.m_dim.height = 20;
    }

    @Override
    public void updateStatus() {
    }

    @Override
    public boolean isClickable() {
        return true;
    }

    public String getToolTipText() {
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void setHighLightOn(boolean bOn) {
        if (!this.isClickable()) {
            this.m_bHighlight = false;
            return;
        }
        this.m_bHighlight = bOn;
    }

    @Override
    public Dimension getSize() {
        return this.m_dim;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.m_bounds.setBounds(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.m_bounds;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.m_bHighlight) {
            g.setColor(m_bgColor);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
            g.setColor(m_borderColor);
            g.drawRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        int xOffset = (this.m_bounds.width - this.m_icon.getIconWidth()) / 2;
        int yOffset = (this.m_bounds.height - this.m_icon.getIconHeight()) / 2;
        this.m_icon.paintIcon((Component)this.m_view.getGraphPane(), g, this.m_bounds.x + xOffset + 1, this.m_bounds.y + yOffset + 1);
    }

    @Override
    public void move(int x, int y) {
        this.m_bounds.x += x;
        this.m_bounds.y += y;
    }

    @Override
    public void setVisible(boolean bVisible) {
        this.m_bVisible = bVisible;
    }

    @Override
    public boolean isVisible() {
        return this.m_bVisible;
    }
}

