/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.BaseBPELTaskView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BaseSwitchBranchView
extends BPELVerticalDropBranchView
implements ValidatableView,
Magnifiable {
    protected Font m_font = new Font("SanSerif", 0, 11);
    protected int m_headerHorzPadding = 5;
    protected int m_headerVertPadding = 4;
    protected Color m_headerClr = new Color(240, 240, 240);
    protected int m_minWidth = 80;
    protected int m_minHeight = 80;
    protected int m_borderWidth = 2;
    protected int m_branchSidePadding = 1;
    protected Dimension m_headerDim = new Dimension();
    protected ConfigBox m_configTab;
    protected ConfigBox m_minimizedConfigBox;
    protected CollapseExpandViewAction m_collapseAction;
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bMagnified = false;
    protected int m_minimizedConfigPadding = 1;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;
    protected int m_minimizedBorderWidth = 2;

    public BaseSwitchBranchView(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
        this.setDraggable(false);
        this.m_configTab = new ConfigBox((View)this, this.createActions(), 0);
        this.m_configTab.setBorderColor(null);
        this.m_configTab.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox = new ConfigBox((View)this, this.getMinimizedActions(), 0);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setMinimizeMode(true);
        this.m_minimizedConfigBox.setInsets(0, 0, 0, 0);
        this.m_minimizedConfigBox.setBorderColor(Color.cyan);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.computeHeaderDim();
        this.setInsets(this.m_borderWidth + this.m_headerDim.height, this.m_borderWidth + this.m_branchSidePadding, this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding);
        this.setCollapsable(true);
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane == null) {
            return false;
        }
        if (pane.isOptimized()) {
            return true;
        }
        BPELSettings settings = pane.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SWITCHES");
        if (b != null) {
            return b;
        }
        return false;
    }

    @Override
    public View getView() {
        return this;
    }

    public void setCollapsed(boolean bCollapse) {
        super.setCollapsed(bCollapse);
        this.m_collapseAction.setIconState();
        this.m_bMagnified = false;
        ((BPELGraphPane)this.getGraphPane()).removeMagnifyView((NodeRenderer)this);
    }

    public ConfigBox getConfigBox() {
        return this.m_configTab;
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.add(new ValidationStatusBoxButton(this));
        return this.m_statusButtons.toArray(new StatusBoxButton[0]);
    }

    protected void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    public ToolTipable getToolTipable(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        ActionInfo info = this.hitActionArea(x, y);
        if (info != null) {
            return info.getToolTipable();
        }
        return this;
    }

    public List<GraphAction> getMinimizedActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    protected List<GraphAction> createActions() {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        this.m_collapseAction = new CollapseExpandViewAction((View)this, (Icon)new ImageIcon(GraphImageResource.COLLAPSE_ICON), (Icon)new ImageIcon(GraphImageResource.EXPAND_ICON));
        actions.add((GraphAction)this.m_collapseAction);
        return actions;
    }

    public Cursor getCursor(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null && btn.isClickable()) {
            return Cursor.getPredefinedCursor(12);
        }
        ActionInfo info = this.hitActionArea(x, y);
        return info == null ? null : Cursor.getPredefinedCursor(12);
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    protected String getHeaderText() {
        return "horst";
    }

    protected void computeHeaderDim() {
        Dimension configDim = this.m_configTab.getSize();
        Dimension statusDim = this.m_viewStatusBox.computeSize();
        String text = this.getHeaderText();
        if (text == null) {
            text = "";
        }
        int strHeight = GraphUtils.getFontHeight((Font)this.m_font);
        int strWidth = GraphUtils.getStringWidth((Font)this.m_font, (String)text);
        int headerHeight = 2 * this.m_headerVertPadding + strHeight;
        int headerWidth = 2 * this.m_headerHorzPadding + strWidth + configDim.width + statusDim.width;
        this.m_headerDim.width = headerWidth = Math.max(this.m_minWidth, headerWidth);
        this.m_headerDim.height = headerHeight;
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized() && this.isCollapsed()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
        this.m_configTab.clearHighlights();
        ActionInfo info = this.hitActionArea(evt.getX(), evt.getY());
        if (info != null) {
            info.setHighlighted(bHovered);
        }
    }

    public ActionInfo hitActionArea(int x, int y) {
        if (this.isMinimized()) {
            return this.m_minimizedConfigBox.hitActionArea(x, y);
        }
        return this.m_configTab.hitActionArea(x, y);
    }

    protected Color getSelectedBackgroundColor() {
        return BPELGraphPane.VIEW_SELECTION_BACKGROUND;
    }

    public void paint(Graphics g, int layer) {
        if (this.isEditing()) {
            this.paintEditingMode(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
            return;
        }
        if (this.isMinimized()) {
            this.paintMinimized(g, layer);
            return;
        }
        if (this.isSelected()) {
            g.setColor(this.getSelectedBackgroundColor());
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
        }
        this.paintHeader(g);
        this.m_configTab.paint(g, null);
        g.setColor(BPELGraphPane.TAB_BORDER_COLOR);
        g.drawRect(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_borderWidth, this.m_bounds.width - 2 * this.m_borderWidth, this.m_bounds.height - 2 * this.m_borderWidth);
        this.paintStatusIcons(g);
        if (this.isCollapsed()) {
            this.paintConnections(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
        } else {
            super.paint(g, layer);
        }
    }

    protected Image getImage() {
        return ImageCache.getImage("sequence.default.jpg");
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = this.getImage();
        String s = this.getText();
        Color lineClr = Color.cyan.darker();
        int strWidth = GraphUtils.getStringWidth((Font)this.m_font, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)this.m_font);
        GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)Color.cyan, (float)0.3f);
        g.setColor(lineClr);
        g.drawRoundRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height, 5, 5);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)r.x, (int)(r.y + 10), (float)1.5f, (Color)lineClr);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 10), (float)1.5f, (Color)lineClr);
        Graphics2D g2 = (Graphics2D)g;
        Color c1 = new Color(223, 242, 249);
        Color c2 = new Color(197, 214, 233);
        GradientPaint gp = new GradientPaint(r.x, r.y, c1, r.x, r.y + r.height / 2, c2);
        g2.setPaint(gp);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        g.setColor(lineClr);
        g.drawRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)Color.black, (Font)this.m_font);
        }
        this.paintStatusIcons(g);
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = this.getImage();
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        String s = this.getText();
        int fontHeight = GraphUtils.getFontHeight((Font)this.m_font);
        int strWidth = GraphUtils.getStringWidth((Font)this.m_font, (String)s);
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x + this.m_bounds.width + 20, this.m_bounds.y, w, h);
        r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        if (r.width < 80) {
            r.width = 80;
        }
        if (r.height < 80) {
            r.height = 80;
        }
        return r;
    }

    protected String getText() {
        return "";
    }

    protected void paintMinimized(Graphics g, int layer) {
        if (this.isCollapsed()) {
            this.m_minimizedConfigBox.paint(g, Color.white);
            int iWidth = BaseBPELTaskView.MINIMIZE_ICON.getIconWidth();
            BaseBPELTaskView.MINIMIZE_ICON.paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + this.m_bounds.width / 2 - iWidth / 2, this.m_bounds.y + this.m_minimizedBorderWidth);
        } else {
            super.paint(g, layer);
            g.setColor(this.m_headerClr);
            g.fillRect(this.m_bounds.x + this.m_minimizedBorderWidth, this.m_bounds.y + this.m_minimizedBorderWidth, this.m_bounds.width - 2 * this.m_minimizedBorderWidth, this.m_insets.top);
            this.m_minimizedConfigBox.paint(g, Color.white);
            g.setColor(BPELGraphPane.TAB_BORDER_COLOR);
            g.drawLine(this.leftX() + this.m_minimizedBorderWidth, this.m_bounds.y + this.m_insets.top, this.rightX() - this.m_minimizedBorderWidth, this.m_bounds.y + this.m_insets.top);
            g.drawRect(this.m_bounds.x + this.m_minimizedBorderWidth, this.m_bounds.y + this.m_minimizedBorderWidth, this.m_bounds.width - 2 * this.m_minimizedBorderWidth, this.m_bounds.height - 2 * this.m_minimizedBorderWidth);
        }
        if (this.isSelected()) {
            BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
            BPELSettings settings = pane.getSettings();
            this.paintBorder(g, settings.m_selectedBorderBackgroundColor, this.m_minimizedBorderWidth);
        }
    }

    protected void paintSelectionBox(Graphics g, Rectangle r, int borderWidth) {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = pane.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, borderWidth);
        g.fillRect(r.x, r.y + r.height - borderWidth, r.width, borderWidth);
        g.fillRect(r.x, r.y, borderWidth, r.height);
        g.fillRect(r.x + r.width - borderWidth, r.y, borderWidth, r.height);
        g.setColor(c.darker());
        g.drawRect(r.x, r.y, r.width, r.height);
        g.drawRect(r.x + borderWidth, r.y + borderWidth, r.width - 2 * borderWidth, r.height - 2 * borderWidth);
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_configTab.move(x, y);
        this.m_minimizedConfigBox.move(x, y);
        this.m_viewStatusBox.move(x, y);
    }

    protected void paintConnections(Graphics g) {
        int thickness = this.getGraphPane().getLineThickness();
        Color lineColor = this.getGraphPane().getLineColor();
        GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.topY(), (int)(this.topY() + this.m_borderWidth), (float)thickness, (Color)lineColor);
        GraphUtils.drawVertLine((Graphics)g, (int)this.getConnectionX(), (int)this.bottomY(), (int)(this.bottomY() - this.m_insets.bottom), (float)thickness, (Color)lineColor);
    }

    protected void paintHeader(Graphics g) {
        g.setFont(this.m_font);
        int strHeight = GraphUtils.getFontHeight((Font)this.m_font);
        int strAscent = GraphUtils.getFontAscent((Font)this.m_font);
        int headerHeight = 2 * this.m_headerVertPadding + strHeight;
        g.setColor(this.m_headerClr);
        g.fillRect(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_borderWidth, this.m_bounds.width - 2 * this.m_borderWidth, headerHeight);
        g.setColor(Color.lightGray.darker());
        g.drawString(this.getHeaderText(), this.m_bounds.x + this.m_borderWidth + this.m_headerHorzPadding, this.m_bounds.y + this.m_borderWidth + this.m_headerVertPadding + strAscent);
        if (!this.isCollapsed()) {
            g.setColor(BPELGraphPane.TAB_BORDER_COLOR);
            g.drawLine(this.m_bounds.x + this.m_borderWidth, this.m_bounds.y + this.m_borderWidth + headerHeight - 1, this.m_bounds.x + this.m_bounds.width - this.m_borderWidth, this.m_bounds.y + this.m_borderWidth + headerHeight - 1);
        }
    }

    protected void paintSelected(Graphics g) {
        if (!this.isMinimized()) {
            BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
            BPELSettings settings = pane.getSettings();
            this.paintBorder(g, settings.m_selectedBorderBackgroundColor, this.m_borderWidth);
        }
    }

    private Rectangle layoutMinimized(int x, int y, int w, int h, LayoutInfo info) {
        BaseView v;
        int i;
        int nChildren;
        Node childNode;
        this.notifyLayoutWillOccur();
        Dimension configBoxSize = this.m_minimizedConfigBox.getSize();
        if (this.isCollapsed()) {
            int left = this.m_minimizedBorderWidth + configBoxSize.width + BaseBPELTaskView.MINIMIZE_ICON.getIconWidth() / 2;
            int right = BaseBPELTaskView.MINIMIZE_ICON.getIconWidth() / 2 + this.m_minimizedBorderWidth;
            int width = 2 * Math.max(left, right);
            int height = 2 * this.m_minimizedBorderWidth + Math.max(BaseBPELTaskView.MINIMIZE_ICON.getIconHeight(), configBoxSize.height);
            this.setBounds(x, y, width, height);
            this.m_connectionX = this.midX();
            this.m_minimizedConfigBox.setBounds(x, y, configBoxSize.width, configBoxSize.height);
            return this.m_bounds;
        }
        this.setBounds(x, y, 0, 0);
        int topInset = this.m_minimizedBorderWidth + this.m_minimizedConfigPadding + configBoxSize.height + this.m_minimizedConfigPadding;
        this.setInsets(topInset, this.m_minimizedBorderWidth, this.m_minimizedBorderWidth, this.m_minimizedBorderWidth);
        Node graphNode = this.getNode();
        int numChildren = graphNode.getChildCount();
        if (numChildren == 3 && (childNode = graphNode.getChildNode(1)).getNodeType() == 103) {
            View v2 = this.getChildViewForNode(graphNode.getChildNode(0));
            if (v2 instanceof CollaxaDropView) {
                ((CollaxaDropView)v2).setDropAllowed(false);
            }
            if ((v2 = this.getChildViewForNode(graphNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v2).setDropAllowed(false);
            }
        }
        boolean bTextMode = (nChildren = this.m_children.size()) == 1;
        for (int i2 = 0; i2 < nChildren; ++i2) {
            BaseView v3 = (BaseView)this.m_children.get(i2);
            if (!(v3 instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v3).setTextMode(bTextMode);
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        if (this.m_bounds.width < 30) {
            this.m_bounds.width = 30;
        }
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        this.m_minimizedConfigBox.setBounds(this.rightX() - this.m_minimizedBorderWidth - configBoxSize.width - this.m_minimizedConfigPadding, y + this.m_minimizedBorderWidth, configBoxSize.width, configBoxSize.height);
        return this.m_bounds;
    }

    private void updateActions() {
        ConfigBox box = null;
        box = this.isMinimized() ? this.m_minimizedConfigBox : this.m_configTab;
        Iterator it = box.getActionInfos();
        while (it.hasNext()) {
            ActionInfo info = (ActionInfo)it.next();
            if (!(info.getAction() instanceof GraphAction)) continue;
            GraphAction ga = (GraphAction)info.getAction();
            ga.updateState();
        }
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        BaseView v;
        int i;
        int nChildren;
        Node childNode;
        this.updateActions();
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        if (this.isMinimized()) {
            return this.layoutMinimized(x, y, w, h, info);
        }
        this.updateStatusButtons();
        this.computeHeaderDim();
        this.setInsets(this.m_borderWidth + this.m_headerDim.height, this.m_borderWidth + this.m_branchSidePadding, this.m_borderWidth, this.m_borderWidth + this.m_branchSidePadding);
        this.notifyLayoutWillOccur();
        this.setBounds(x, y, 0, 0);
        Dimension tabSize = this.m_configTab.getSize();
        if (this.isCollapsed()) {
            this.setBounds(x, y, 2 * this.m_borderWidth + this.m_headerDim.width, 2 * this.m_borderWidth + this.m_headerDim.height);
            int yOffset = Math.max(0, (this.m_headerDim.height - tabSize.height) / 2);
            this.m_configTab.setBounds(this.m_bounds.x + this.m_bounds.width - this.m_borderWidth - tabSize.width, y + this.m_borderWidth + yOffset, tabSize.width, tabSize.height);
            this.m_connectionX = this.midX();
            Rectangle configBounds = this.m_configTab.getBounds();
            Dimension statusBoxDim = this.m_viewStatusBox.computeSize();
            this.m_viewStatusBox.layout(configBounds.x - statusBoxDim.width, configBounds.y);
            return this.m_bounds;
        }
        Node graphNode = this.getNode();
        int numChildren = graphNode.getChildCount();
        if (numChildren == 3 && (childNode = graphNode.getChildNode(1)).getNodeType() == 103) {
            View v2 = this.getChildViewForNode(graphNode.getChildNode(0));
            if (v2 instanceof CollaxaDropView) {
                ((CollaxaDropView)v2).setDropAllowed(false);
            }
            if ((v2 = this.getChildViewForNode(graphNode.getChildNode(2))) instanceof CollaxaDropView) {
                ((CollaxaDropView)v2).setDropAllowed(false);
            }
        }
        boolean bTextMode = (nChildren = this.m_children.size()) == 1;
        for (int i2 = 0; i2 < nChildren; ++i2) {
            BaseView v3 = (BaseView)this.m_children.get(i2);
            if (!(v3 instanceof CollaxaDropView)) continue;
            ((CollaxaDropView)v3).setTextMode(bTextMode);
        }
        this.m_bounds.height = this.m_insets.top + this.m_insets.bottom;
        int yPos = y + this.m_insets.top;
        int maxLeft = 0;
        int maxRight = 0;
        int xPos = x + this.m_insets.left;
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            if (i > 0) {
                yPos += this.m_verticalSpacing;
                this.m_bounds.height += this.m_verticalSpacing;
            }
            Rectangle r = v.layout(xPos, yPos, w, h, info);
            maxLeft = Math.max(maxLeft, v.getLeftWidth());
            maxRight = Math.max(maxRight, v.getRightWidth());
            yPos += r.height;
            this.m_bounds.height += r.height;
        }
        if (this.m_bounds.height < this.m_minHeight) {
            this.m_bounds.height = this.m_minHeight;
        }
        if (this.m_headerDim.width / 2 > maxLeft) {
            maxLeft = this.m_headerDim.width / 2;
        }
        if (this.m_headerDim.width / 2 > maxRight) {
            maxRight = this.m_headerDim.width / 2;
        }
        for (i = 0; i < nChildren; ++i) {
            v = (BaseView)this.m_children.get(i);
            int xDiff = Math.max(0, maxLeft - v.getLeftWidth());
            if (xDiff <= 0) continue;
            v.move(xDiff, 0);
        }
        this.m_bounds.width = this.m_insets.left + maxLeft + maxRight + this.m_insets.right;
        this.m_connectionX = this.m_bounds.x + this.m_insets.left + maxLeft;
        int yOffset = Math.max(0, (this.m_headerDim.height - tabSize.height) / 2);
        this.m_configTab.setBounds(this.m_bounds.x + this.m_bounds.width - this.m_borderWidth - tabSize.width, y + this.m_borderWidth + yOffset, tabSize.width, tabSize.height);
        Rectangle configBounds = this.m_configTab.getBounds();
        Dimension statusBoxDim = this.m_viewStatusBox.computeSize();
        this.m_viewStatusBox.layout(configBounds.x - statusBoxDim.width, configBounds.y);
        return this.m_bounds;
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }
}

