/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.PortConnectionView;
import oracle.tip.tools.ide.common.graph.view.TaskView;
import oracle.tip.tools.ide.common.graph.view.ToolTipable;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.imagecache.BasicImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.ActivityNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.AssertStatusButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.PortView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.TimeoutStatusButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidatableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ValidationStatusBoxButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.ViewStatusBox;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BaseBPELTaskView
extends TaskView
implements ValidatableView,
Magnifiable {
    public static final Icon MINIMIZE_ICON = ImageCache.getIcon("window_gear.png");
    protected ViewStatusBox m_viewStatusBox;
    protected List<StatusBoxButton> m_statusButtons = new ArrayList<StatusBoxButton>();
    protected boolean m_bMagnified = false;
    protected int m_magnifiedVertPadding = 5;
    protected int m_magnifiedHorzPadding = 5;
    protected int m_minimizedBorderWidth = 2;
    protected int m_minimizedBorderToImage = 0;
    protected Rectangle m_imageBounds = new Rectangle();

    public BaseBPELTaskView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.m_viewStatusBox = new ViewStatusBox((View)this, 0);
        this.m_viewStatusBox.addStatusBoxButtons(this.getStatusButtons());
        this.setCollapsable(false);
        this.m_borderToImage = 0;
        this.m_sidePadding = 0;
    }

    protected Image getActivityImage() {
        return null;
    }

    protected Image getImage() {
        Activity a = this.getActivity();
        if (a != null && !a.isEditable()) {
            return BasicImageCache.createDisabledImage((Image)this.getActivityImage());
        }
        return this.getActivityImage();
    }

    protected Icon getMinimizedIcon() {
        return ImageCache.getIcon("window_gear.png");
    }

    protected boolean getMinimize(Object typeID) {
        Boolean b;
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        if (pane == null) {
            return false;
        }
        if (pane.isOptimized()) {
            return true;
        }
        BPELSettings settings = pane.getSettings();
        if (settings != null && (b = (Boolean)settings.m_iconizeStateMap.get(typeID)) != null) {
            return b;
        }
        return false;
    }

    public boolean canDelete() {
        Activity a = (Activity)this.getNode().getUserObject();
        return a.canDelete();
    }

    public boolean canEditName() {
        Activity a = (Activity)this.getNode().getUserObject();
        return a.isEditable() && !this.isMinimized();
    }

    public int getEditorType() {
        if (this.isMinimized()) {
            return 1;
        }
        return super.getEditorType();
    }

    public boolean isMinimized() {
        BPELGraphPane pane = (BPELGraphPane)this.getGraphPane();
        return pane != null && pane.isOptimized();
    }

    public NodeEditor getNodeEditor() {
        return NodeEditorFactory.getNodeEditor(this.getNode());
    }

    protected ValidationContext createValidationContext() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        return new ValidationContext(model.getProcess());
    }

    protected StatusBoxButton[] getStatusButtons() {
        this.m_statusButtons.clear();
        ValidationStatusBoxButton validationStatusBtn = new ValidationStatusBoxButton(this);
        validationStatusBtn.setVisible(false);
        this.m_statusButtons.add(validationStatusBtn);
        AssertStatusButton assertBtn = new AssertStatusButton((View)this);
        assertBtn.setVisible(false);
        this.m_statusButtons.add(assertBtn);
        TimeoutStatusButton timeoutBtn = new TimeoutStatusButton((View)this);
        timeoutBtn.setVisible(false);
        this.m_statusButtons.add(timeoutBtn);
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<StatusBoxButton> buttons = plugin.addViewStatusButtons((View)this);
            if (buttons == null) continue;
            this.m_statusButtons.addAll(buttons);
        }
        return this.m_statusButtons.toArray(new StatusBoxButton[this.m_statusButtons.size()]);
    }

    public Cursor getCursor(int x, int y) {
        if (this.m_bounds.contains(x, y)) {
            StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
            if (btn != null && btn.isClickable()) {
                return Cursor.getPredefinedCursor(12);
            }
            if (this.m_nameBounds.contains(x, y) && this.getGraphPane().isEditable()) {
                return Cursor.getPredefinedCursor(2);
            }
            if (this.isSelected() && this.isDraggable() && this.getGraphPane().isEditable()) {
                return Cursor.getPredefinedCursor(13);
            }
        }
        return null;
    }

    public void editingStopped() {
        this.generateValidationReport();
        this.getGraphPane().repaint();
    }

    public ToolTipable getToolTipable(int x, int y) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(x, y);
        if (btn != null) {
            return btn;
        }
        if (this.m_bounds.contains(x, y)) {
            return this;
        }
        return null;
    }

    public Activity getActivity() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        return null;
    }

    protected void asyncGenerateValidationReport() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BaseBPELTaskView.this.generateValidationReport();
            }
        };
        new Thread(r).start();
    }

    protected synchronized void generateValidationReport() {
        Validatable a = this.getValidatableObject();
        if (a != null) {
            a.getValidationReport(this.createValidationContext(), true);
            this.updateStatusButtons();
        }
    }

    protected boolean saveNameChange() {
        ActivityNode a;
        Activity activity;
        Node n = this.getNode();
        String newName = this.m_nameField.getText();
        if (!Helper.isValidName((String)newName, (boolean)true)) {
            this.removeNameFieldFocusListener();
            String msg = BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID");
            String title = BPELStringTranslator.getString("BPEL_ERROR_TITLE");
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this.getGraphPane()), (String)msg, (String)title, (int)0);
            this.addNameFieldFocusListener();
            return false;
        }
        n.setName(this.m_nameField.getText());
        if (n instanceof ActivityNode && (activity = (a = (ActivityNode)n).getActivity()) != null) {
            activity.getValidationReport(this.createValidationContext(), true);
        }
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        model.nodesChanged(n.getParentNode(), new Node[]{n});
        this.getGraphPane().forceLayout();
        return true;
    }

    protected boolean hasWarning() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasWarnings();
        }
        return false;
    }

    protected boolean hasError() {
        ValidationReport r;
        Validatable a = this.getValidatableObject();
        if (a != null && (r = a.getValidationReport(this.createValidationContext(), false)) != null) {
            return r.hasErrors();
        }
        return false;
    }

    public boolean isEditable() {
        Activity a = (Activity)this.getNode().getUserObject();
        return a.isEditable();
    }

    @Override
    public void paintMagnified(Graphics g) {
        int xOffset;
        Rectangle r = this.computeMagnifiedBounds();
        Image img = this.getImage();
        String s = this.getText();
        Color lineClr = Color.cyan.darker();
        int strWidth = GraphUtils.getStringWidth((Font)this.m_font, (String)s);
        int fontAscent = GraphUtils.getFontAscent((Font)this.m_font);
        GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_bounds, (Color)Color.cyan, (float)0.3f);
        g.setColor(lineClr);
        g.drawRoundRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height, 5, 5);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.topY(), (int)r.x, (int)(r.y + 10), (float)1.5f, (Color)lineClr);
        GraphUtils.drawLine((Graphics)g, (int)this.rightX(), (int)this.bottomY(), (int)r.x, (int)(r.y + r.height - 10), (float)1.5f, (Color)lineClr);
        Graphics2D g2 = (Graphics2D)g;
        Color c1 = new Color(207, 242, 247);
        Color c2 = new Color(113, 205, 221);
        GradientPaint gp = new GradientPaint(r.x, r.y, c1, r.x, r.y + r.height / 2, c2);
        g2.setPaint(gp);
        g.fillRoundRect(r.x, r.y, r.width, r.height, 15, 15);
        GraphUtils.drawRoundRect((Graphics)g, (int)r.x, (int)r.y, (int)r.width, (int)r.height, (float)1.0f, (Color)lineClr, (int)15);
        int iHeight = 0;
        if (img != null) {
            iHeight = img.getHeight(null);
            xOffset = (r.width - img.getWidth(null)) / 2;
            g.drawImage(img, r.x + xOffset, r.y + this.m_magnifiedVertPadding, null);
        }
        if (s != null) {
            xOffset = (r.width - strWidth) / 2;
            GraphUtils.paintText((String)s, (Graphics)g, (int)(r.x + xOffset), (int)(r.y + this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontAscent), (Color)this.getTextColor(), (Font)this.m_font);
        }
        this.paintStatusIcons(g);
    }

    protected Rectangle computeMagnifiedBounds() {
        Image img = this.getImage();
        int iWidth = 0;
        int iHeight = 0;
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        String s = this.getText();
        int fontHeight = GraphUtils.getFontHeight((Font)this.m_font);
        int strWidth = GraphUtils.getStringWidth((Font)this.m_font, (String)s);
        int w = Math.max(iWidth, strWidth) + 2 * this.m_magnifiedHorzPadding;
        int h = this.m_magnifiedVertPadding + iHeight + this.m_magnifiedVertPadding + fontHeight + this.m_magnifiedVertPadding;
        Rectangle r = new Rectangle(this.m_bounds.x + this.m_bounds.width + 20, this.m_bounds.y, w, h);
        r.y = this.m_bounds.y + this.m_bounds.height / 2 - r.height / 2;
        if (r.width < 80) {
            r.width = 80;
        }
        if (r.height < 80) {
            r.height = 80;
        }
        return r;
    }

    public void paint(Graphics g, int layer) {
        if (this.isSelected()) {
            GraphUtils.fillSelectionBox((Graphics)g, (int)this.m_bounds.x, (int)this.m_bounds.y, (int)this.m_bounds.width, (int)this.m_bounds.height, (Color)BPELGraphPane.VIEW_SELECTION_BACKGROUND);
        }
        if (this.isEditing()) {
            if (this.m_pane.getZoom() == 1.0 && this.isMinimized()) {
                this.getMinimizedIcon().paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + this.m_minimizedBorderWidth + 1, this.m_bounds.y + this.m_minimizedBorderWidth);
            }
            this.paintEditingMode(g);
            if (this.isSelected()) {
                this.paintSelected(g);
            }
        } else if (this.isMinimized()) {
            if (this.isSelected()) {
                this.paintSelected(g);
            }
            this.getMinimizedIcon().paintIcon((Component)this.getGraphPane(), g, this.m_bounds.x + this.m_minimizedBorderWidth + 1, this.m_bounds.y + this.m_minimizedBorderWidth);
        } else {
            super.paint(g, layer);
            this.paintStatusIcons(g);
        }
    }

    protected Color getTextColor() {
        Activity a = this.getActivity();
        if (a != null && !a.isEditable()) {
            return Color.lightGray;
        }
        return Color.black;
    }

    protected void paintStatusIcons(Graphics g) {
        this.m_viewStatusBox.paint(g);
    }

    public void setPortVisibility() {
        GraphModel model = this.getGraphPane().getModel();
        Iterator iterator = this.m_children.iterator();
        View connectView = null;
        while (iterator.hasNext()) {
            PortNode portNode;
            Edge[] edges;
            View v = (View)iterator.next();
            if (!(v instanceof PortView) || (edges = model.getEdgesForPort(portNode = (PortNode)v.getNode())) == null || edges.length <= 0) continue;
            connectView = v;
            break;
        }
        if (connectView != null) {
            for (View v : this.m_children) {
                if (!(v instanceof PortView)) continue;
                v.setVisible(v == connectView);
            }
        } else {
            for (View v : this.m_children) {
                if (!(v instanceof PortView)) continue;
                v.setVisible(true);
            }
        }
    }

    protected void paintSelected(Graphics g) {
        BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
        BPELSettings settings = graph.getSettings();
        Color c = settings.m_selectedBorderBackgroundColor;
        this.paintBorder(g, c, this.m_borderWidth);
    }

    public void setHovered(boolean bHovered, MouseEvent evt) {
        if (this.isMinimized()) {
            BPELGraphPane graph = (BPELGraphPane)this.getGraphPane();
            if (bHovered) {
                this.m_bMagnified = true;
                graph.addMagnifyView((NodeRenderer)this);
            } else {
                this.m_bMagnified = false;
                graph.removeMagnifyView((NodeRenderer)this);
            }
        }
        this.m_viewStatusBox.clearHighlights();
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null) {
            btn.setHighLightOn(true);
        }
    }

    protected String getWarningMessage() {
        return BPELStringTranslator.getString("COLLAXALAF_WARNING_MESSAGE", "Click Here to View Warning Details");
    }

    protected Color getBorderColor() {
        return BPELGraphPane.TAB_BORDER_COLOR;
    }

    public boolean handleMousePressed(MouseEvent evt) {
        StatusBoxButton btn = this.m_viewStatusBox.hitTest(evt.getX(), evt.getY());
        if (btn != null && btn.isVisible()) {
            btn.mouseClicked(evt);
            return true;
        }
        return false;
    }

    protected int getMinimumWidth() {
        int iWidth = 0;
        Image img = this.getImage();
        if (img != null) {
            iWidth = img.getWidth(null);
        }
        Dimension dim = this.m_viewStatusBox.computeSize();
        int leftMinWidth = this.m_borderWidth + iWidth / 2;
        int rightMinWidth = iWidth / 2 + dim.width + this.m_borderWidth;
        return 2 * Math.max(leftMinWidth, rightMinWidth);
    }

    protected void layoutPorts(int w, int h, LayoutInfo info) {
        int iWidth = 0;
        Image img = this.getImage();
        if (img != null) {
            iWidth = img.getWidth(null);
        }
        int imgLeftX = this.m_bounds.x + Math.max(0, this.m_bounds.width / 2 - iWidth / 2);
        boolean bLeft = true;
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            View v = (View)iterator.next();
            if (!(v instanceof PortConnectionView)) continue;
            PortConnectionView pv = (PortConnectionView)v;
            pv.setOrientation(bLeft ? 2 : 4);
            int iHeight = this.getImage().getHeight(null);
            int prefWidth = v.getPreferredSpan(1);
            int prefHeight = v.getPreferredSpan(0);
            int yOffset = this.m_borderWidth + this.m_insideBorderWidth + this.m_borderToImage + iHeight / 2 - prefHeight / 2;
            if (bLeft) {
                v.layout(imgLeftX - this.m_sidePadding - prefWidth, this.topY() + yOffset, w, h, info);
            } else {
                v.layout(imgLeftX + iWidth + this.m_sidePadding, this.topY() + yOffset, w, h, info);
            }
            bLeft = !bLeft;
        }
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        if (this.isMinimized()) {
            Icon icon = this.getMinimizedIcon();
            this.setBounds(x, y, this.m_minimizedBorderWidth + this.m_minimizedBorderToImage + icon.getIconWidth() + this.m_minimizedBorderToImage + this.m_minimizedBorderWidth, this.m_minimizedBorderWidth + this.m_minimizedBorderToImage + icon.getIconHeight() + this.m_minimizedBorderToImage + this.m_minimizedBorderWidth);
            this.m_connectionX = this.midX();
            this.updateStatusButtons();
            Rectangle r = this.computeMagnifiedBounds();
            this.m_viewStatusBox.layout(r.x + r.width, r.y);
            this.m_imageBounds.setBounds(this.m_bounds);
            return this.m_bounds;
        }
        this.updateStatusButtons();
        this.setPortVisibility();
        int iWidth = 0;
        Image img = this.getImage();
        if (img != null) {
            iWidth = img.getWidth(null);
        }
        Rectangle r = this.doLayout(x, y, w, h, info);
        int nodeType = this.getNode().getNodeType();
        switch (nodeType) {
            case 100: 
            case 101: 
            case 113: {
                this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, r.y);
                break;
            }
            default: {
                this.m_viewStatusBox.layout(this.m_connectionX + iWidth / 2, r.y);
            }
        }
        return r;
    }

    protected int getPortAreaWidth() {
        return 24;
    }

    private Rectangle doLayout(int x, int y, int w, int h, LayoutInfo info) {
        if (this.isEditing()) {
            return this.layoutEditingMode(x, y, w, h, info);
        }
        int iWidth = 0;
        int iHeight = 0;
        Image img = this.getImage();
        if (img != null) {
            iWidth = img.getWidth(null);
            iHeight = img.getHeight(null);
        }
        int textWidth = this.getTextWidth();
        int textHeight = this.getTextHeight();
        int imageHorzSpace = 2 * this.m_sidePadding + iWidth;
        int textHorzSpace = 2 * this.m_sidePadding + textWidth;
        int viewWidth = 2 * this.m_borderWidth + 2 * this.m_insideBorderWidth + Math.max(imageHorzSpace + 2 * this.getPortAreaWidth(), textHorzSpace);
        int minWidth = this.getMinimumWidth();
        if (minWidth > 0 && viewWidth < minWidth) {
            viewWidth = minWidth;
        }
        int viewHeight = this.m_borderWidth + this.m_insideBorderWidth + this.m_borderToImage + iHeight + this.m_imageToText + this.getTextHeight() + this.m_textToBorder + this.m_insideBorderWidth + this.m_borderWidth;
        this.setBounds(x, y, viewWidth, viewHeight);
        this.m_connectionX = this.midX();
        int xOffset = (this.m_bounds.width - textWidth) / 2;
        this.m_nameBounds.setBounds(this.m_bounds.x + xOffset, this.m_bounds.y + this.m_borderWidth + this.m_insideBorderWidth + this.m_borderToImage + iHeight + this.m_imageToText, textWidth, textHeight);
        this.layoutPorts(w, h, info);
        return this.m_bounds;
    }

    public void move(int x, int y) {
        super.move(x, y);
        this.m_viewStatusBox.move(x, y);
        this.m_imageBounds.x += x;
        this.m_imageBounds.y += y;
    }

    @Override
    public void updateStatusButtons() {
        for (StatusBoxButton btn : this.m_statusButtons) {
            btn.updateStatus();
        }
        this.getGraphPane().repaint(this.m_bounds);
    }

    @Override
    public Validatable getValidatableObject() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Validatable) {
            return (Validatable)obj;
        }
        return null;
    }

    @Override
    public BPELGraphPane getBPELGraphPane() {
        return (BPELGraphPane)this.getGraphPane();
    }

    @Override
    public View getView() {
        return this;
    }
}

