/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Rectangle;
import java.util.Iterator;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.LayoutInfo;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.ProcessView;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;

public class BPELView
extends BaseView {
    public BPELView(GraphPane pane, View parent, Node n) {
        super(pane, parent, n);
        this.setInsets(0, 0, 0, 0);
    }

    public boolean getSwimLanesVisible() {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            View v = (View)iterator.next();
            if (!(v instanceof SwimLaneView)) continue;
            SwimLaneView sv = (SwimLaneView)v;
            return sv.getVisible();
        }
        return false;
    }

    public void showSwimLanes(boolean bShow) {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            View v = (View)iterator.next();
            if (!(v instanceof SwimLaneView)) continue;
            SwimLaneView sv = (SwimLaneView)v;
            sv.setVisible(bShow);
        }
    }

    public void createChildNodeRenderers() {
        super.createChildNodeRenderers();
    }

    public Rectangle layout(int x, int y, int w, int h, LayoutInfo info) {
        this.setBounds(x, y, 0, 0);
        int xPos = x + this.m_insets.left;
        int yPos = y + this.m_insets.top;
        int width = 0;
        int height = 0;
        int nChildren = this.m_children.size();
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            Rectangle b = null;
            b = v instanceof ProcessView ? v.layout(xPos, yPos, w, h, info) : v.layout(xPos, yPos, w, h, info);
            xPos += b.width;
            width += b.width;
            height = Math.max(height, v.bottomY());
        }
        this.m_bounds.width = width += this.m_insets.left + this.m_insets.right;
        this.m_bounds.height = height += this.m_insets.top + this.m_insets.bottom;
        if (nChildren == 3) {
            BaseView processView = this.getChild(1);
            BaseView rightSwimLane = this.getChild(2);
            BaseView leftSwimLane = this.getChild(0);
            Rectangle visRect = this.getGraphPane().getVisibleRect();
            if (visRect.width > this.m_bounds.width) {
                int moveX = visRect.width - (rightSwimLane.getBounds().x + rightSwimLane.getBounds().width);
                if (moveX > 0) {
                    rightSwimLane.move(moveX, 0);
                    int midX = visRect.width / 2;
                    int pviewMidX = processView.midX();
                    int diff = midX - pviewMidX;
                    if (diff > 0) {
                        processView.move(diff, 0);
                    }
                }
                this.m_bounds.width = visRect.width;
            }
            SwimLaneView left = this.getLeftSwimLaneView();
            SwimLaneView right = this.getRightSwimLaneView();
            left.layoutPartnerLinks();
            right.layoutPartnerLinks();
            if (leftSwimLane.isVisible()) {
                this.m_bounds.add(left.getBounds());
            }
            if (rightSwimLane.isVisible()) {
                this.m_bounds.add(right.getBounds());
            }
            if (visRect.height > this.m_bounds.height) {
                this.m_bounds.height = visRect.height;
            }
            if (leftSwimLane.getHeight() < this.m_bounds.height) {
                Rectangle r = leftSwimLane.getBounds();
                leftSwimLane.setBounds(r.x, r.y, r.width, this.m_bounds.height);
            }
            if (rightSwimLane.getHeight() < this.m_bounds.height) {
                Rectangle r = rightSwimLane.getBounds();
                rightSwimLane.setBounds(r.x, r.y, r.width, this.m_bounds.height);
            }
        }
        return this.m_bounds;
    }

    SwimLaneView getLeftSwimLaneView() {
        int nChildren = this.m_children.size();
        for (int i = 0; i < nChildren; ++i) {
            View v = (View)this.m_children.get(i);
            if (!(v instanceof SwimLaneView)) continue;
            return (SwimLaneView)v;
        }
        return null;
    }

    SwimLaneView getRightSwimLaneView() {
        int nChildren = this.m_children.size();
        for (int i = nChildren - 1; i >= 0; --i) {
            View v = (View)this.m_children.get(i);
            if (!(v instanceof SwimLaneView)) continue;
            return (SwimLaneView)v;
        }
        return null;
    }

    void adjustForSwimLaneChanges() {
        SwimLaneView left = this.getLeftSwimLaneView();
        SwimLaneView right = this.getRightSwimLaneView();
        this.m_bounds.add(left.getBounds());
        this.m_bounds.add(right.getBounds());
    }
}

