/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.BaseView;
import oracle.tip.tools.ide.common.graph.view.DropView;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.TabTreeNode;
import oracle.tip.tools.ide.common.graph.view.Tabable;
import oracle.tip.tools.ide.common.graph.view.VerticalDropBranchView;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaDropView;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorFactory;

public class BPELVerticalDropBranchView
extends VerticalDropBranchView {
    public BPELVerticalDropBranchView(GraphPane pane, View parent, DroppableBranchNode n) {
        super(pane, parent, n);
    }

    public List<TabTreeNode> getTabTreeNodes() {
        ArrayList<Object> nodes = new ArrayList<TabTreeNode>();
        if (this.isVisible()) {
            if (!this.isCollapsed()) {
                for (NodeRenderer nodeRenderer : this.m_children) {
                    List list = nodeRenderer.getTabTreeNodes();
                    if (list == null) continue;
                    nodes.addAll(list);
                }
            }
            if (this instanceof Tabable) {
                TabTreeNode treeNode = new TabTreeNode((Tabable)this);
                for (TabTreeNode tabTreeNode : nodes) {
                    treeNode.addChild(tabTreeNode);
                }
                nodes = new ArrayList();
                nodes.add(treeNode);
            }
        }
        return nodes;
    }

    public NodeEditor getNodeEditor() {
        return NodeEditorFactory.getNodeEditor(this.getNode());
    }

    protected ValidationContext createValidationContext() {
        BPELGraphModel model = (BPELGraphModel)this.getGraphPane().getModel();
        return new ValidationContext(model.getProcess());
    }

    protected void notifyLayoutWillOccur() {
        int nChildren = this.m_children.size();
        for (int i = 0; i < nChildren; ++i) {
            BaseView v = (BaseView)this.m_children.get(i);
            Node n = v.getNode();
            if (n == null || n.getNodeType() != 0) continue;
            if (v instanceof CollaxaDropView) {
                CollaxaDropView dv = (CollaxaDropView)v;
                dv.setDropAllowed(true);
            }
            boolean bShowArrow = false;
            BaseView nextView = this.getChild(i + 1);
            if (nextView != null) {
                bShowArrow = nextView.getAcceptsArrow();
            }
            ((DropView)v).setShowArrow(bShowArrow);
        }
    }

    public Activity getActivity() {
        Object obj = this.getNode().getUserObject();
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        return null;
    }

    public boolean isEditable() {
        Activity a = this.getActivity();
        return a != null && a.isEditable();
    }

    public boolean canDelete() {
        Activity a = this.getActivity();
        return a != null && a.canDelete();
    }

    public boolean canEditName() {
        Activity a = this.getActivity();
        return a != null && a.isEditable() && this.isCollapsed();
    }
}

