/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CheckBoxCellRenderer;
import oracle.tip.tools.ide.common.ui.DynamicFileFilter;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.common.ui.TableLabelCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.OptimizeData;
import oracle.tip.tools.ide.pm.bpelgraph.editors.OptimizeDataTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneProperties;
import oracle.tip.tools.ide.pm.bpelgraph.views.OptimizeDataCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELPropertiesPanel
extends JPanel
implements ActionListener,
BPELGraphPaneProperties {
    protected JButton m_selectAllBtn;
    protected JButton m_deselectAllBtn;
    protected JButton m_resetBtn;
    protected JButton m_browseAnnotationBtn;
    protected JButton m_deleteAnnotationBtn;
    protected ColorPanel m_swimLaneBackgroundPanel;
    protected ColorPanel m_graphBackgroundColorPanel;
    protected ColorPanel m_swimLaneDividerColorPanel;
    protected ColorPanel m_partnerLinkColorPanel;
    protected ColorPanel m_connectablePartnerLinkColorPanel;
    protected ColorPanel m_unconnectedPartnerLinkColorPanel;
    protected ColorPanel m_selectedPartnerLinkColorPanel;
    protected ColorPanel m_borderColorPanel;
    protected JRadioButton m_leftBtn = new JRadioButton();
    protected JRadioButton m_rightBtn = new JRadioButton();
    protected JRadioButton m_bottomBtn = new JRadioButton();
    protected JRadioButton m_topBtn = new JRadioButton();
    protected JRadioButton m_optimizeBtn;
    protected JRadioButton m_noOptimizeBtn;
    protected JCheckBox m_inlineEditors;
    protected JCheckBox m_autoValidateCB;
    protected JCheckBox m_confirmBeforeDeleteCB;
    protected JCheckBox m_centerZoomCB;
    protected JCheckBox m_fixedWidthSwimLaneCB;
    protected JCheckBox m_roundedPartnerLinksCB;
    protected JTable m_optimizeTable;
    protected JLabel m_typesLbl;
    protected JTextField m_annotationField;
    protected boolean m_bForceLayout;
    protected BPELSettings m_settings;

    public BPELPropertiesPanel(BPELSettings settings) {
        this.createAndLayoutControls();
        this.load(settings);
    }

    public BPELSettings getSettings() {
        return this.m_settings;
    }

    public void load(BPELSettings settings) {
        this.m_settings = settings;
        if (this.m_settings != null) {
            this.loadControls();
        }
    }

    public void loadControls() {
        this.m_annotationField.setText(this.m_settings.m_annotationFileLocation);
        this.m_centerZoomCB.setSelected(this.m_settings.m_bCenterZoom);
        this.m_inlineEditors.setSelected(!this.m_settings.m_bPopupEditor);
        this.m_autoValidateCB.setSelected(this.m_settings.m_bValidateOnLoad);
        this.m_confirmBeforeDeleteCB.setSelected(this.m_settings.m_bConfirmDeletions);
        this.m_fixedWidthSwimLaneCB.setSelected(this.m_settings.m_bFixedWidthLanes);
        this.m_roundedPartnerLinksCB.setSelected(this.m_settings.m_bRoundedPartnerlinkConnections);
        this.loadOptimizations();
        Boolean b = (Boolean)this.m_settings.m_iconizeStateMap.get("OPTIMIZE_GRAPH");
        if (b.booleanValue()) {
            this.m_optimizeBtn.doClick();
        }
        this.m_graphBackgroundColorPanel.setColor(this.m_settings.m_graphBackgroundColor);
        this.m_swimLaneDividerColorPanel.setColor(this.m_settings.m_swimlaneDividerBackgroundColor);
        this.m_swimLaneBackgroundPanel.setColor(this.m_settings.m_swimlaneBackgroundColor);
        this.m_borderColorPanel.setColor(this.m_settings.m_selectedBorderBackgroundColor);
        this.m_unconnectedPartnerLinkColorPanel.setColor(this.m_settings.m_unConnectedPartnerLinkColor);
        this.m_selectedPartnerLinkColorPanel.setColor(this.m_settings.m_selectedPartnerLinkColor);
        this.m_connectablePartnerLinkColorPanel.setColor(this.m_settings.m_connectablePartnerLinkColor);
        this.m_partnerLinkColorPanel.setColor(this.m_settings.m_connectedPartnerLinkColor);
    }

    public boolean getForceLayout() {
        return this.m_bForceLayout;
    }

    public void save() {
        this.m_settings.m_graphBackgroundColor = this.m_graphBackgroundColorPanel.m_color;
        this.m_settings.m_swimlaneDividerBackgroundColor = this.m_swimLaneDividerColorPanel.m_color;
        this.m_settings.m_swimlaneBackgroundColor = this.m_swimLaneBackgroundPanel.m_color;
        this.m_settings.m_selectedBorderBackgroundColor = this.m_borderColorPanel.m_color;
        this.m_settings.m_unConnectedPartnerLinkColor = this.m_unconnectedPartnerLinkColorPanel.m_color;
        this.m_settings.m_selectedPartnerLinkColor = this.m_selectedPartnerLinkColorPanel.m_color;
        this.m_settings.m_connectablePartnerLinkColor = this.m_connectablePartnerLinkColorPanel.m_color;
        this.m_settings.m_connectedPartnerLinkColor = this.m_partnerLinkColorPanel.m_color;
        this.m_settings.m_bPopupEditor = !this.m_inlineEditors.isSelected();
        this.m_settings.m_bValidateOnLoad = this.m_autoValidateCB.isSelected();
        this.m_settings.m_bFixedWidthLanes = this.m_fixedWidthSwimLaneCB.isSelected();
        this.m_settings.m_bRoundedPartnerlinkConnections = this.m_roundedPartnerLinksCB.isSelected();
        this.m_settings.m_bCenterZoom = this.m_centerZoomCB.isSelected();
        this.m_settings.m_bConfirmDeletions = this.m_confirmBeforeDeleteCB.isSelected();
        this.m_settings.m_annotationFileLocation = this.m_annotationField.getText();
        OptimizeDataTableModel model = (OptimizeDataTableModel)((Object)this.m_optimizeTable.getModel());
        for (OptimizeData data : model.getData()) {
            this.m_settings.m_iconizeStateMap.put(data.getType(), new Boolean(data.isOptimize()));
        }
        if (this.m_leftBtn.isSelected()) {
            ApplyCancelPanel.TAB_PLACEMENT = 2;
        } else if (this.m_rightBtn.isSelected()) {
            ApplyCancelPanel.TAB_PLACEMENT = 4;
        } else if (this.m_bottomBtn.isSelected()) {
            ApplyCancelPanel.TAB_PLACEMENT = 3;
        } else if (this.m_topBtn.isSelected()) {
            ApplyCancelPanel.TAB_PLACEMENT = 1;
        }
        if (this.m_optimizeBtn.isSelected()) {
            this.m_settings.m_iconizeStateMap.put("OPTIMIZE_GRAPH", Boolean.TRUE);
        } else {
            this.m_settings.m_iconizeStateMap.put("OPTIMIZE_GRAPH", Boolean.FALSE);
        }
    }

    protected void loadOptimizations() {
        this.setOptimizeValue("MINIMIZE_ASSIGN_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_ASSIGN_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_INVOKE_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_INVOKE_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_RECEIVE_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_RECEIVE_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_REPLY_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_REPLY_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_TRANSFORM_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_TRANSFORM_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_TERMINATE_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_TERMINATE_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_FLOWS", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_FLOWS"));
        this.setOptimizeValue("MINIMIZE_WAIT_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_WAIT_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_COMPENSATE_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_COMPENSATE_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_EMPTY_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_EMPTY_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_JAVA_EMBED_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_JAVA_EMBED_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_THROW_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_THROW_ACTIVITIES"));
        this.setOptimizeValue("MINIMIZE_DROP_ZONES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_DROP_ZONES"));
        this.setOptimizeValue("MINIMIZE_SEQUENCES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_SEQUENCES"));
        this.setOptimizeValue("MINIMIZE_SCOPES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_SCOPES"));
        this.setOptimizeValue("MINIMIZE_SWITCHES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_SWITCHES"));
        this.setOptimizeValue("MINIMIZE_PICKS", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_PICKS"));
        this.setOptimizeValue("MINIMIZE_WHILES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_WHILES"));
        this.setOptimizeValue("MINIMIZE_ONALARMS", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_ONALARMS"));
        this.setOptimizeValue("MINIMIZE_ONMESSAGES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_ONMESSAGES"));
        this.setOptimizeValue("MINIMIZE_CATCHES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_CATCHES"));
        this.setOptimizeValue("MINIMIZE_CATCHALLS", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_CATCHALLS"));
        this.setOptimizeValue("MINIMIZE_COMPENSATION_HANDLERS", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_COMPENSATION_HANDLERS"));
        this.setOptimizeValue("MINIMIZE_VALIDATE_ACTIVITIES", (Boolean)this.m_settings.m_iconizeStateMap.get("MINIMIZE_VALIDATE_ACTIVITIES"));
    }

    protected void createAndLayoutControls() {
        this.m_resetBtn = new JButton();
        BPELStringTranslator.setButton(this.m_resetBtn, BPELStringTranslator.getString("RESET_DEFAULTS"));
        this.m_resetBtn.addActionListener(this);
        this.m_fixedWidthSwimLaneCB = new JCheckBox();
        this.m_fixedWidthSwimLaneCB.addActionListener(this);
        BPELStringTranslator.setButton(this.m_fixedWidthSwimLaneCB, BPELStringTranslator.getString("COLLAXALAF_FIXED_WIDTH_SWIMLANES", "Fixed Width Swim Lanes"));
        this.m_roundedPartnerLinksCB = new JCheckBox();
        this.m_roundedPartnerLinksCB.addActionListener(this);
        BPELStringTranslator.setButton(this.m_roundedPartnerLinksCB, BPELStringTranslator.getString("COLLAXALAF_ROUND_PARTNER_LINKS", "Curved Connections"));
        this.m_autoValidateCB = new JCheckBox();
        BPELStringTranslator.setButton(this.m_autoValidateCB, BPELStringTranslator.getString("COLLAXALAF_VALIDATE_ON_LOAD", "Validate process when loading diagram"));
        this.m_confirmBeforeDeleteCB = new JCheckBox();
        BPELStringTranslator.setButton(this.m_confirmBeforeDeleteCB, BPELStringTranslator.getString("COLLAXALAF_CONFIRM_BEFORE_DELETE", "Confirm Before Delete?"));
        this.m_inlineEditors = new JCheckBox();
        BPELStringTranslator.setButton(this.m_inlineEditors, BPELStringTranslator.getString("COLLAXALAF_USE_INLINE_EDITORS", "Use &inline editors"));
        this.m_annotationField = new JTextField();
        this.m_annotationField.setEditable(false);
        this.m_browseAnnotationBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("BROWSE_FILE_SYSTEM"));
        this.m_browseAnnotationBtn.addActionListener(this);
        this.m_deleteAnnotationBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("garbage_empty16"));
        this.m_deleteAnnotationBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_CLEAR_ANNOTATION"));
        this.m_deleteAnnotationBtn.addActionListener(this);
        JTabbedPane tab = new JTabbedPane(3);
        tab.add(BPELStringTranslator.getString("COLLAXALAF_DIAGRAM_LAYOUT_TITLE"), this.createOptimizePanel());
        tab.add(BPELStringTranslator.getString("COLLAXALAF_COLORS", "Colors"), this.createColorPanel());
        tab.add(BPELStringTranslator.getString("COLLAXALAF_TAB_PLACEMENT", "Tab Placement"), this.createTabPlacementPanel());
        tab.add(BPELStringTranslator.getString("OPTIONS"), this.createOptionPanel());
        tab.add(BPELStringTranslator.getString("ANNOTATION_FILE"), this.createAnnotationPanel());
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)tab, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_resetBtn, (int)0, (int)1, (int)0, (int)1, (int)13, (int)0, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    protected JPanel createOptionPanel() {
        int row = 0;
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_autoValidateCB, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_inlineEditors, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.createZoomPanel(), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_confirmBeforeDeleteCB, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createOptimizePanel() {
        this.m_optimizeBtn = new JRadioButton("Auto Optimize", false);
        this.m_optimizeBtn.addActionListener(this);
        BPELStringTranslator.setButton(this.m_optimizeBtn, BPELStringTranslator.getString("COLLAXALAF_AUTO_OPTIMIZE"));
        this.m_noOptimizeBtn = new JRadioButton("Manual Optimize", true);
        this.m_noOptimizeBtn.addActionListener(this);
        BPELStringTranslator.setButton(this.m_noOptimizeBtn, BPELStringTranslator.getString("COLLAXALAF_MANUAL_OPTIMIZE"));
        ButtonGroup g = new ButtonGroup();
        g.add(this.m_optimizeBtn);
        g.add(this.m_noOptimizeBtn);
        JPanel optimizeBtnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        optimizeBtnPnl.add(this.m_optimizeBtn);
        optimizeBtnPnl.add(this.m_noOptimizeBtn);
        JPanel p = new JPanel(new GridBagLayout());
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        this.m_selectAllBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("table_selectall.png"));
        this.m_selectAllBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_SELECT_ALL"));
        this.m_selectAllBtn.addActionListener(this);
        this.m_deselectAllBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("table_selectnone.png"));
        this.m_deselectAllBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_DESELECT_ALL"));
        this.m_deselectAllBtn.addActionListener(this);
        tb.add((Component)this.m_selectAllBtn);
        tb.add((Component)this.m_deselectAllBtn);
        Vector<OptimizeData> v = new Vector<OptimizeData>();
        v.addElement(new OptimizeData("MINIMIZE_ASSIGN_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_CATCHALLS"));
        v.addElement(new OptimizeData("MINIMIZE_CATCHES"));
        v.addElement(new OptimizeData("MINIMIZE_COMPENSATE_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_COMPENSATION_HANDLERS"));
        v.addElement(new OptimizeData("MINIMIZE_DROP_ZONES"));
        v.addElement(new OptimizeData("MINIMIZE_EMPTY_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_FLOWS"));
        v.addElement(new OptimizeData("MINIMIZE_INVOKE_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_JAVA_EMBED_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_ONALARMS"));
        v.addElement(new OptimizeData("MINIMIZE_ONMESSAGES"));
        v.addElement(new OptimizeData("MINIMIZE_PICKS"));
        v.addElement(new OptimizeData("MINIMIZE_RECEIVE_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_REPLY_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_SCOPES"));
        v.addElement(new OptimizeData("MINIMIZE_SEQUENCES"));
        v.addElement(new OptimizeData("MINIMIZE_SWITCHES"));
        v.addElement(new OptimizeData("MINIMIZE_TERMINATE_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_THROW_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_TRANSFORM_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_WAIT_ACTIVITIES"));
        v.addElement(new OptimizeData("MINIMIZE_WHILES"));
        OptimizeDataTableModel model = new OptimizeDataTableModel();
        model.setData(v);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    BPELPropertiesPanel.this.m_bForceLayout = true;
                }
            }
        });
        this.m_optimizeTable = new JTable((TableModel)((Object)model));
        this.m_optimizeTable.setRowHeight(20);
        this.m_optimizeTable.getTableHeader().setReorderingAllowed(false);
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                BPELPropertiesPanel.this.sortOptimizeTable(col, bAscending);
            }

            public JTable getJTable() {
                return BPELPropertiesPanel.this.m_optimizeTable;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        SortedTableHeaderRenderer header = new SortedTableHeaderRenderer(st);
        TableLabelCellRenderer r = new TableLabelCellRenderer();
        TableColumnModel colModel = this.m_optimizeTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)header);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer(new OptimizeDataCellRenderer());
                continue;
            }
            if (i == 2) {
                col.setCellRenderer((TableCellRenderer)new CheckBoxCellRenderer());
                JCheckBox cb = new JCheckBox();
                cb.setHorizontalAlignment(0);
                col.setCellEditor(new DefaultCellEditor(cb));
                col.setPreferredWidth(120);
                continue;
            }
            col.setCellRenderer((TableCellRenderer)r);
            col.setPreferredWidth(120);
        }
        this.m_typesLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_typesLbl, this.m_optimizeTable, BPELStringTranslator.getString("COLLAXALAF_TYPES") + ":");
        int row = 0;
        JPanel tablePanel = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)tablePanel, (Component)this.m_typesLbl, (int)0, (int)row, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)tablePanel, (Component)tb, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)tablePanel, (Component)GraphUtils.getScrollPane((Component)this.m_optimizeTable), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        row = 0;
        GraphUtils.addComponent((Container)p, (Component)optimizeBtnPnl, (int)0, (int)row++, (int)2, (int)1, (int)10, (int)0, (Insets)new Insets(10, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tablePanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_fixedWidthSwimLaneCB, (int)0, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_roundedPartnerLinksCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    protected void sortOptimizeTable(int col, final boolean bAscending) {
        if (col == 1 || col == 0) {
            OptimizeDataTableModel model = (OptimizeDataTableModel)((Object)this.m_optimizeTable.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    OptimizeData d1 = (OptimizeData)o1;
                    OptimizeData d2 = (OptimizeData)o2;
                    String s1 = d1.getTypeString();
                    String s2 = d2.getTypeString();
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2) {
            OptimizeDataTableModel model = (OptimizeDataTableModel)((Object)this.m_optimizeTable.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    OptimizeData d1 = (OptimizeData)o1;
                    OptimizeData d2 = (OptimizeData)o2;
                    String s1 = Boolean.toString(d1.isOptimize());
                    String s2 = Boolean.toString(d2.isOptimize());
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected void handleOptimizationSelection() {
        this.m_bForceLayout = true;
        boolean bOptimize = this.m_optimizeBtn.isSelected();
        this.m_selectAllBtn.setEnabled(!bOptimize);
        this.m_deselectAllBtn.setEnabled(!bOptimize);
        this.m_optimizeTable.setEnabled(!bOptimize);
        this.m_typesLbl.setEnabled(!bOptimize);
    }

    protected JPanel createTabPlacementPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.m_leftBtn = new JRadioButton();
        BPELStringTranslator.setButton(this.m_leftBtn, BPELStringTranslator.getString("COLLAXALAF_LEFT", "&Left"));
        this.m_rightBtn = new JRadioButton();
        BPELStringTranslator.setButton(this.m_rightBtn, BPELStringTranslator.getString("COLLAXALAF_RIGHT", "&Right"));
        this.m_bottomBtn = new JRadioButton();
        BPELStringTranslator.setButton(this.m_bottomBtn, BPELStringTranslator.getString("COLLAXALAF_BOTTOM", "&Bottom"));
        this.m_topBtn = new JRadioButton();
        BPELStringTranslator.setButton(this.m_topBtn, BPELStringTranslator.getString("COLLAXALAF_TOP", "&Top"));
        JPanel btnPnl = new JPanel(new GridLayout(4, 1, 10, 10));
        btnPnl.add(this.m_topBtn);
        btnPnl.add(this.m_bottomBtn);
        btnPnl.add(this.m_leftBtn);
        btnPnl.add(this.m_rightBtn);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_leftBtn);
        grp.add(this.m_rightBtn);
        grp.add(this.m_bottomBtn);
        grp.add(this.m_topBtn);
        switch (ApplyCancelPanel.TAB_PLACEMENT) {
            case 2: {
                this.m_leftBtn.setSelected(true);
                break;
            }
            case 3: {
                this.m_bottomBtn.setSelected(true);
                break;
            }
            case 4: {
                this.m_rightBtn.setSelected(true);
                break;
            }
            case 1: {
                this.m_topBtn.setSelected(true);
            }
        }
        GraphUtils.addComponent((Container)p, (Component)btnPnl, (int)0, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 10, 5, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JComponent createZoomPanel() {
        this.m_centerZoomCB = new JCheckBox();
        BPELStringTranslator.setButton(this.m_centerZoomCB, BPELStringTranslator.getString("COLLAXALAF_ZOOM_CENTERED", "&Zoom Centered"));
        this.m_centerZoomCB.setSelected(true);
        return this.m_centerZoomCB;
    }

    protected JPanel createAnnotationPanel() {
        JLabel urlLbl = new JLabel();
        BPELStringTranslator.setLabel(urlLbl, this.m_annotationField, BPELStringTranslator.getString("COLLAXALAF_ANNOTATION_FILE_LOCATION", "&Annotation File Location:"));
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_browseAnnotationBtn);
        tb.add((Component)this.m_deleteAnnotationBtn);
        JPanel p = new JPanel(new GridBagLayout());
        UIHelper.addComponent((Container)p, (Component)urlLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)this.m_annotationField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createColorPanel() {
        JPanel clrPnl = new JPanel(new GridBagLayout());
        this.m_swimLaneBackgroundPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_SWIMLANE_BACKGROUND"));
        this.m_swimLaneDividerColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_SWIMLANE_DIVIDER_BACKGROUND"));
        this.m_graphBackgroundColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_PROCESSVIEW_BACKGROUND"));
        this.m_partnerLinkColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_PARTNERLINK_COLOR"));
        this.m_connectablePartnerLinkColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_CONNECTABLE_PARTNERLINK_COLOR"));
        this.m_unconnectedPartnerLinkColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_UNCONNECTED_PARTNERLINK_COLOR"));
        this.m_borderColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_BORDER_COLOR"));
        this.m_selectedPartnerLinkColorPanel = new ColorPanel(BPELStringTranslator.getString("COLLAXA_LAF_CHOOSE_SELECTED_PARTNERLINK_COLOR"));
        int row = 0;
        JLabel label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_SWIMLANE_BKG", "SwimLane Background") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_swimLaneBackgroundPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_CONNECTED_PARTNER_LINK", "Connected Partner Link") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_partnerLinkColorPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_SWIMLANE_DIVIDER", "SwimLane Divider") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)(++row), (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_swimLaneDividerColorPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_CONNECTABLE_PARTNERLINK", "Connectable Partner Link") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_connectablePartnerLinkColorPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_GRAPH_BKG", "Graph Background") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_graphBackgroundColorPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_UNCONNECTED_PARTNERLINK", "Unconnected Partner Link") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_unconnectedPartnerLinkColorPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_SELECTED_BORDER", "Selected Border") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_borderColorPanel, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        label = new JLabel();
        BPELStringTranslator.setLabel(label, this.m_swimLaneBackgroundPanel, BPELStringTranslator.getString("COLLAXALAF_SELECTED_PARTNER_LINK", "Selected Partner Link") + ":");
        GraphUtils.addComponent((Container)clrPnl, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)clrPnl, (Component)this.m_selectedPartnerLinkColorPanel, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel centerPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)centerPnl, (Component)clrPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)centerPnl, (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return centerPnl;
    }

    protected void handleBrowseAnnotation() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter((FileFilter)new DynamicFileFilter(".xml", "XML Files (*.xml)"));
        chooser.setDialogTitle(BPELStringTranslator.getString("COLLAXALAF_CHOOSE_ANNOTATION_FILE"));
        int returnVal = chooser.showOpenDialog(GraphUtils.getFrame((Component)this));
        if (returnVal != 0) {
            return;
        }
        try {
            URL url = chooser.getSelectedFile().toURL();
            this.m_annotationField.setText(url.toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected void handleDeleteAnnotation() {
        this.m_annotationField.setText("");
    }

    protected void setOptimizeValue(String key, Boolean val) {
        if (key == null || val == null) {
            return;
        }
        OptimizeDataTableModel model = (OptimizeDataTableModel)((Object)this.m_optimizeTable.getModel());
        for (OptimizeData data : model.getData()) {
            if (!data.getType().equals(key)) continue;
            data.setOptimize(val);
            return;
        }
    }

    protected void setActivityCheckBoxes(boolean bSelect) {
        OptimizeDataTableModel model = (OptimizeDataTableModel)((Object)this.m_optimizeTable.getModel());
        for (OptimizeData data : model.getData()) {
            data.setOptimize(bSelect);
        }
        model.refresh();
        this.m_bForceLayout = true;
    }

    protected void handleReset() {
        BPELSettings defaultSettings = new BPELSettings();
        this.m_bForceLayout = true;
        this.m_graphBackgroundColorPanel.setColor(defaultSettings.m_graphBackgroundColor);
        this.m_swimLaneBackgroundPanel.setColor(defaultSettings.m_swimlaneBackgroundColor);
        this.m_swimLaneDividerColorPanel.setColor(defaultSettings.m_swimlaneDividerBackgroundColor);
        this.m_partnerLinkColorPanel.setColor(defaultSettings.m_connectedPartnerLinkColor);
        this.m_connectablePartnerLinkColorPanel.setColor(defaultSettings.m_connectablePartnerLinkColor);
        this.m_unconnectedPartnerLinkColorPanel.setColor(defaultSettings.m_unConnectedPartnerLinkColor);
        this.m_borderColorPanel.setColor(defaultSettings.m_selectedBorderBackgroundColor);
        this.m_selectedPartnerLinkColorPanel.setColor(defaultSettings.m_selectedPartnerLinkColor);
        this.m_inlineEditors.setSelected(defaultSettings.m_bPopupEditor);
        this.m_fixedWidthSwimLaneCB.setSelected(defaultSettings.m_bFixedWidthLanes);
        this.m_roundedPartnerLinksCB.setSelected(defaultSettings.m_bRoundedPartnerlinkConnections);
        this.m_autoValidateCB.setSelected(defaultSettings.m_bValidateOnLoad);
        this.m_centerZoomCB.setSelected(defaultSettings.m_bCenterZoom);
        this.m_confirmBeforeDeleteCB.setSelected(defaultSettings.m_bConfirmDeletions);
        Boolean b = (Boolean)defaultSettings.m_iconizeStateMap.get("OPTIMIZE_GRAPH");
        if (b != null) {
            if (b.booleanValue()) {
                this.m_optimizeBtn.doClick();
            } else {
                this.m_noOptimizeBtn.doClick();
            }
        }
        Boolean bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_ASSIGN_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_ASSIGN_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_INVOKE_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_INVOKE_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_RECEIVE_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_RECEIVE_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_REPLY_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_REPLY_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_TRANSFORM_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_TRANSFORM_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_TERMINATE_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_TERMINATE_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_FLOWS");
        this.setOptimizeValue("MINIMIZE_FLOWS", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_WAIT_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_WAIT_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_COMPENSATE_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_COMPENSATE_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_EMPTY_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_EMPTY_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_JAVA_EMBED_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_JAVA_EMBED_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_THROW_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_THROW_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_VALIDATE_ACTIVITIES");
        this.setOptimizeValue("MINIMIZE_VALIDATE_ACTIVITIES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_DROP_ZONES");
        this.setOptimizeValue("MINIMIZE_DROP_ZONES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_SEQUENCES");
        this.setOptimizeValue("MINIMIZE_SEQUENCES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_SCOPES");
        this.setOptimizeValue("MINIMIZE_SCOPES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_SWITCHES");
        this.setOptimizeValue("MINIMIZE_SWITCHES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_PICKS");
        this.setOptimizeValue("MINIMIZE_PICKS", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_WHILES");
        this.setOptimizeValue("MINIMIZE_WHILES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_ONALARMS");
        this.setOptimizeValue("MINIMIZE_ONALARMS", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_ONMESSAGES");
        this.setOptimizeValue("MINIMIZE_ONMESSAGES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_CATCHES");
        this.setOptimizeValue("MINIMIZE_CATCHES", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_CATCHALLS");
        this.setOptimizeValue("MINIMIZE_CATCHALLS", bool);
        bool = (Boolean)defaultSettings.m_iconizeStateMap.get("MINIMIZE_COMPENSATION_HANDLERS");
        this.setOptimizeValue("MINIMIZE_COMPENSATION_HANDLERS", bool);
        OptimizeDataTableModel model = (OptimizeDataTableModel)((Object)this.m_optimizeTable.getModel());
        model.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_resetBtn) {
            this.handleReset();
        } else if (src == this.m_selectAllBtn) {
            this.setActivityCheckBoxes(true);
        } else if (src == this.m_deselectAllBtn) {
            this.setActivityCheckBoxes(false);
        } else if (src == this.m_optimizeBtn || src == this.m_noOptimizeBtn) {
            this.handleOptimizationSelection();
        } else if (src == this.m_browseAnnotationBtn) {
            this.handleBrowseAnnotation();
        } else if (src == this.m_deleteAnnotationBtn) {
            this.handleDeleteAnnotation();
        } else if (src == this.m_fixedWidthSwimLaneCB) {
            this.m_bForceLayout = true;
        }
    }

    class ColorPanel
    extends JButton
    implements ActionListener {
        Color m_color;
        String m_title;

        public ColorPanel(String title) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.m_title = title;
            this.m_color = Color.white;
            this.addActionListener(this);
            this.setBackground(Color.white);
            this.setPreferredSize(new Dimension(16, 16));
            this.setBorder(new LineBorder(Color.lightGray));
        }

        public void setColor(Color c) {
            this.m_color = c;
            this.setBackground(c);
            this.repaint();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = JColorChooser.showDialog(this, this.m_title, this.m_color);
            if (c != null) {
                this.setColor(c);
            }
        }
    }
}

