/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneProperties;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELPropertiesPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BPELPropertiesDialog
extends BPELBaseDialog
implements ActionListener,
BPELGraphPaneProperties {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected BPELPropertiesPanel m_panel;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;

    public BPELPropertiesDialog(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("COLLAXALAF_DIAGRAM_PROPERTIES_TITLE", "Diagram Properties"), true);
        this.m_graph = graph;
        this.createAndLayoutControls();
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    public void handleCancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_panel.save();
            this.m_graph.setSettings(this.m_panel.getSettings());
            this.m_retVal = 0;
            this.dispose();
            if (this.m_panel.getForceLayout()) {
                this.m_graph.forceImmediateLayout();
                this.m_graph.repaint();
            }
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp((Component)((Object)this));
        }
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }

    protected void createAndLayoutControls() {
        this.m_panel = new BPELPropertiesPanel(this.m_graph.getSettings());
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("COLLAXALAF_OK", "&OK"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("COLLAXALAF_CANCEL", "&Cancel"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)c, (Component)this.m_panel, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(530, 560);
        this.setLocationRelativeTo(this.getParent());
    }
}

