/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.outliner.OutlinerUtil;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.NodeUtil;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import org.w3c.dom.Element;

public class BPELNodeRendererDNDHandler
implements DNDDropHandler {
    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphModel model;
        Process process;
        Point pt = null;
        pt = pane.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        NodeRenderer r = pane.getNodeRendererAtPosition(pt.x, pt.y);
        if (!(r instanceof DropZone)) {
            e.rejectDrop();
            return false;
        }
        DropZone dropView = (DropZone)r;
        dropView.setHighLightOn(false);
        View sourceView = (View)data;
        if (GraphUtils.isParentOf((NodeRenderer)sourceView, (NodeRenderer)r)) {
            return false;
        }
        Node sourceNode = sourceView.getNode();
        NodeRenderer targetView = r;
        Node targetNode = targetView.getNode();
        NodeRenderer targetParentView = r.getParent();
        Node targetParentNode = targetParentView.getNode();
        Node nextSibling = NodeUtil.nextSibling((Node)sourceNode);
        if (nextSibling == targetNode) {
            return false;
        }
        Node prevSibling = NodeUtil.prevSibling((Node)sourceNode);
        if (prevSibling == targetNode) {
            return false;
        }
        int index = targetParentNode.indexOf(targetNode);
        if (!this.checkSequenceInsertionNeeded(sourceNode, targetParentNode, pane, index, process = (model = (BPELGraphModel)pane.getModel()).getProcess())) {
            model.moveNode(sourceNode, targetParentNode, index);
        }
        e.dropComplete(true);
        return true;
    }

    private boolean checkSequenceInsertionNeeded(Node childNode, Node parentNode, GraphPane graph, int dropIndex, Process p) {
        boolean bBPAProcess;
        if (BPELDNDDropHandler.requiresAutoSequenceGeneration(parentNode) && ((bBPAProcess = OutlinerUtil.isAnnotatedBPELProcess((Process)p)) || parentNode.getChildCount() >= 3)) {
            BPELGraphModel graphModel = (BPELGraphModel)graph.getModel();
            graphModel.moveNode(childNode, parentNode, dropIndex);
            ContainerActivity targetContainerActivity = (ContainerActivity)parentNode.getUserObject();
            ArrayList childActivities = new ArrayList(targetContainerActivity.getActivityList());
            for (Activity a : childActivities) {
                try {
                    targetContainerActivity.deleteActivity(a);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Sequence sequence = (Sequence)BPELParser.createImplementation(Sequence.class);
            sequence.setName(BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class));
            Element processElem = p.getDOMElement();
            Element seqElem = sequence.createDOMElement(processElem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            sequence.setDOMElement(seqElem);
            try {
                targetContainerActivity.addActivity((Activity)sequence);
                for (Activity a : childActivities) {
                    sequence.addActivity(a);
                }
            }
            catch (Exception e) {
                GraphUtils.displayError((Component)graph, (Throwable)e);
            }
            ((DroppableBranchNode)parentNode).clearChildren();
            ModelBuilder builder = new ModelBuilder();
            SequenceNode seqNode = (SequenceNode)builder.getNodeForActivity((Activity)sequence);
            ((DroppableBranchNode)parentNode).addToEndOfBranch((Node)seqNode);
            graphModel.fireGraphStructureChanged();
            NodeRenderer renderer = graph.getNodeRendererForNode(parentNode);
            if (renderer != null) {
                renderer.rebuildNodeRenderersFromModel();
            }
            graph.forceLayout();
            return true;
        }
        return false;
    }
}

