/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.bpelgraph.actions.NoOpAction;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaNodeRendererFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PopupHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowser;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELGraphPanePopupHandlerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELGraphPanePopupHandler
implements MouseListener,
ActionListener,
PopupHandler {
    protected BPELGraphPane m_graph;
    protected JMenuItem m_addLeftPartnerLinkItem;
    protected JMenuItem m_addRightPartnerLinkItem;
    protected JMenuItem m_deleteItem;
    protected JMenuItem m_printItem;
    protected JMenuItem m_jpegItem;
    protected JMenuItem m_createLinkItem;
    protected JMenuItem m_hideSwimLaneItem;
    protected JMenuItem m_showSwimLaneItem;
    protected JMenuItem m_showPartnerLinkConnectionsItem;
    protected JMenuItem m_hidePartnerLinkConnectionsItem;
    protected JMenuItem m_collapseItem;
    protected JMenuItem m_collapseAllItem;
    protected JMenuItem m_expandItem;
    protected JMenuItem m_expandAllItem;
    protected JMenuItem m_renameItem;
    protected JMenuItem m_editItem;
    protected JMenuItem m_stopEditItem;
    protected JMenuItem m_cancelEditItem;
    protected JMenuItem m_moveToOtherSwimLaneItem;
    protected JMenuItem m_cutItem;
    protected JMenuItem m_copyItem;
    protected JMenuItem m_pasteItem;
    protected JMenuItem m_graphPropsItem;
    protected JMenuItem m_drillInViewItem;
    protected JMenuItem m_drillOutViewItem;
    protected JMenuItem m_variablesItem;
    protected JMenuItem m_messageTypesItem;
    protected JMenuItem m_correlationSetsItem;
    protected JMenuItem m_partnerLinksItem;
    protected JMenuItem m_propertiesItem;
    protected JMenuItem m_propertyAliasesItem;
    protected JMenuItem m_validateProcessItem;
    protected JMenuItem m_validationBrowserItem;
    protected JMenuItem m_bookmarkItem;
    protected JMenuItem m_bookmarksItem;
    protected JMenuItem m_textSearchItem;
    protected JMenuItem m_typeSearchItem;
    protected JCheckBoxMenuItem m_optimizeItem;
    protected JMenu m_insertIntoItem;
    protected JMenu m_insertBeforeItem;
    protected JMenu m_insertAfterItem;
    protected boolean m_bValidate;

    public BPELGraphPanePopupHandler(BPELGraphPane pane) {
        this.m_graph = pane;
        this.m_bValidate = this.m_graph.getValidateOnLoad();
        this.m_graph.addMouseListener(this);
        this.createMenuItems();
        this.registerPopupMenuInvoker();
    }

    @Override
    public void deinstall() {
        this.m_graph.removeMouseListener(this);
    }

    @Override
    public void install() {
        this.m_graph.addMouseListener(this);
    }

    public void registerPopupMenuInvoker() {
        ActionMap actionMap;
        BPELGraphPane component = this.m_graph;
        InputMap inputMap = SwingUtilities.getUIInputMap((JComponent)((Object)component), 0);
        if (inputMap == null) {
            inputMap = new ComponentInputMap((JComponent)((Object)component));
            SwingUtilities.replaceUIInputMap((JComponent)((Object)component), 0, inputMap);
        }
        if ((actionMap = SwingUtilities.getUIActionMap((JComponent)((Object)component))) == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap((JComponent)((Object)component), actionMap);
        }
        inputMap.put(KeyStroke.getKeyStroke(121, 1), "invoke.popupMenu");
        actionMap.put("invoke.popupMenu", new PopupTriggerAction());
    }

    protected Process getProcess() {
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        return model.getProcess();
    }

    protected void createMenuItems() {
        this.m_textSearchItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_TEXT_SEARCH") + "...", ImageCache.getIcon("find_text.png"));
        this.m_textSearchItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_textSearchItem, BPELStringTranslator.getString("COLLAXALAF_TEXT_SEARCH_M"));
        this.m_typeSearchItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_TYPE_SEARCH") + "...", ImageCache.getIcon("branch_find.png"));
        this.m_typeSearchItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_typeSearchItem, BPELStringTranslator.getString("COLLAXALAF_TYPE_SEARCH_M"));
        this.m_optimizeItem = new JCheckBoxMenuItem(BPELStringTranslator.getString("COLLAXALAF_OPTIMIZE_LAYOUT", ""));
        this.m_optimizeItem.setSelected(this.m_graph.isOptimized());
        this.m_optimizeItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_optimizeItem, BPELStringTranslator.getString("COLLAXALAF_OPTIMIZE_LAYOUT"));
        this.m_bookmarkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARK", "Bookmark"), ImageCache.getIcon("bookmarks.png"));
        this.m_bookmarkItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_bookmarkItem, BPELStringTranslator.getString("COLLAXALAF_BOOKMARK"));
        this.m_bookmarksItem = new JMenuItem(BPELStringTranslator.getString("GRAPHPOPUP_MANAGE_BOOKMARKS"), ImageCache.getIcon("bookmarks_preferences.png"));
        this.m_bookmarksItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_bookmarksItem, BPELStringTranslator.getString("GRAPHPOPUP_MANAGE_BOOKMARKS"));
        this.m_propertiesItem = new JMenuItem("", ImageCache.getIcon("property_node"));
        this.m_propertiesItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_propertiesItem, BPELStringTranslator.getString("COLLAXALAF_PROPERTIES_N") + "...");
        this.m_validateProcessItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_VALIDATE_PROCESS", "Validate Process"), ImageCache.getIcon("check16"));
        this.m_validateProcessItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_validateProcessItem, BPELStringTranslator.getString("COLLAXALAF_VALIDATE_PROCESS_N"));
        this.m_validationBrowserItem = new JMenuItem("", ImageCache.getIcon("wrench16"));
        this.m_validationBrowserItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_validationBrowserItem, BPELStringTranslator.getString("COLLAXALAF_VALIDATION_BROWSER_N"));
        this.m_propertyAliasesItem = new JMenuItem("", ImageCache.getIcon("property_alias_node"));
        this.m_propertyAliasesItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_propertyAliasesItem, BPELStringTranslator.getString("COLLAXALAF_PROPERTY_ALIASES_N") + "...");
        this.m_variablesItem = new JMenuItem("", ImageCache.getIcon("variable16"));
        this.m_variablesItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_variablesItem, BPELStringTranslator.getString("COLLAXALAF_VARIABLES_N") + "...");
        this.m_messageTypesItem = new JMenuItem("", ImageCache.getIcon("message_type_node"));
        this.m_messageTypesItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_messageTypesItem, BPELStringTranslator.getString("COLLAXALAF_MESSAGE_TYPES_N") + "...");
        this.m_correlationSetsItem = new JMenuItem("", ImageCache.getIcon("correlation_set_node"));
        this.m_correlationSetsItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_correlationSetsItem, BPELStringTranslator.getString("COLLAXALAF_CORR_SETS_N") + "...");
        this.m_partnerLinksItem = new JMenuItem("", ImageCache.getIcon("partner_link_node"));
        this.m_partnerLinksItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_partnerLinksItem, BPELStringTranslator.getString("PARTNER_LINKS_P") + "...");
        this.m_drillInViewItem = new JMenuItem("", ImageCache.getIcon("drillin16"));
        this.m_drillInViewItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_drillInViewItem, BPELStringTranslator.getString("COLLAXALAF_DRILL_INTO"));
        this.m_drillOutViewItem = new JMenuItem("", ImageCache.getIcon("drillout16"));
        this.m_drillOutViewItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_drillOutViewItem, BPELStringTranslator.getString("COLLAXALAF_DRILL_OUT"));
        this.m_deleteItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_DELETE", "Delete"), ImageCache.getIcon("delete2.png"));
        this.m_deleteItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_deleteItem, BPELStringTranslator.getString("COLLAXALAF_DELETE"));
        this.m_jpegItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_CREATE_JPEG", "Create JPEG Image"), ImageCache.getIcon("camera16"));
        this.m_jpegItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_jpegItem, BPELStringTranslator.getString("COLLAXALAF_CREATE_JPEG_M"));
        this.m_printItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_PRINT", "Print"), ImageCache.getIcon("printer16"));
        this.m_printItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_printItem, BPELStringTranslator.getString("COLLAXALAF_PRINT_M"));
        this.m_createLinkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_CREATE_LINK", "Create Link"));
        this.m_createLinkItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_createLinkItem, BPELStringTranslator.getString("COLLAXALAF_CREATE_LINK"));
        this.m_hideSwimLaneItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_HIDE_SWIMLANES", "Hide Swim Lanes"), ImageCache.getIcon("swimlane16"));
        this.m_hideSwimLaneItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_hideSwimLaneItem, BPELStringTranslator.getString("COLLAXALAF_HIDE_SWIMLANES"));
        this.m_showSwimLaneItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_SHOW_SWIMLANES", "Show Swim Lanes"), ImageCache.getIcon("swimlane16"));
        this.m_showSwimLaneItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_showSwimLaneItem, BPELStringTranslator.getString("COLLAXALAF_SHOW_SWIMLANES"));
        this.m_addLeftPartnerLinkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_CREATE_PARTNERLINK", "Create Partner Link"), ImageCache.getIcon("partner_link_node"));
        this.m_addLeftPartnerLinkItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_addLeftPartnerLinkItem, BPELStringTranslator.getString("COLLAXALAF_CREATE_PARTNERLINK"));
        this.m_addRightPartnerLinkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_CREATE_PARTNERLINK", "Create Partner Link") + "...", ImageCache.getIcon("partner_link_node"));
        this.m_addRightPartnerLinkItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_addRightPartnerLinkItem, BPELStringTranslator.getString("COLLAXALAF_CREATE_PARTNERLINK"));
        this.m_showPartnerLinkConnectionsItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_SHOW_PLINK_CONNS", "Show Partner Link Connections"), ImageCache.getIcon("partnerlink_connections16"));
        this.m_showPartnerLinkConnectionsItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_showPartnerLinkConnectionsItem, BPELStringTranslator.getString("COLLAXALAF_SHOW_PLINK_CONNS"));
        this.m_hidePartnerLinkConnectionsItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_HIDE_PLINK_CONNS", "Hide Partner Link Connections"), ImageCache.getIcon("partnerlink_connections16"));
        this.m_hidePartnerLinkConnectionsItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_hidePartnerLinkConnectionsItem, BPELStringTranslator.getString("COLLAXALAF_HIDE_PLINK_CONNS"));
        this.m_collapseItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_COLLAPSE", "Collapse"));
        this.m_collapseItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_collapseItem, BPELStringTranslator.getString("COLLAXALAF_COLLAPSE"));
        this.m_collapseAllItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_COLLAPSE_ALL", "Collapse All Children"), ImageCache.getIcon("application/bpel/collapse-all.png"));
        this.m_collapseAllItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_collapseAllItem, BPELStringTranslator.getString("COLLAXALAF_COLLAPSE_ALL"));
        this.m_expandItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_EXPAND", "Expand"));
        this.m_expandItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_expandItem, BPELStringTranslator.getString("COLLAXALAF_EXPAND"));
        this.m_expandAllItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_EXPAND_ALL", "Expand All Children"), ImageCache.getIcon("application/bpel/expand-all.png"));
        this.m_expandAllItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_expandAllItem, BPELStringTranslator.getString("COLLAXALAF_EXPAND_ALL"));
        this.m_renameItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_RENAME", "Rename"), ImageCache.getIcon("rename16"));
        this.m_renameItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_renameItem, BPELStringTranslator.getString("COLLAXALAF_RENAME"));
        this.m_editItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_EDIT", "Edit"), ImageCache.getIcon("edit16"));
        this.m_editItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_editItem, BPELStringTranslator.getString("COLLAXALAF_EDIT"));
        this.m_stopEditItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_STOP_EDIT", "Stop Edit"));
        this.m_stopEditItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_stopEditItem, BPELStringTranslator.getString("COLLAXALAF_STOP_EDIT"));
        this.m_cancelEditItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_CANCEL_EDIT", "Cancel Edit"));
        this.m_cancelEditItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_cancelEditItem, BPELStringTranslator.getString("COLLAXALAF_CANCEL_EDIT"));
        this.m_moveToOtherSwimLaneItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_MOVE_OPPOSITE_LANE", "Move To Opposite Swim Lane"), ImageCache.getIcon("move_to_opposite_lane16"));
        this.m_moveToOtherSwimLaneItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_moveToOtherSwimLaneItem, BPELStringTranslator.getString("COLLAXALAF_MOVE_OPPOSITE_LANE"));
        this.m_insertIntoItem = new JMenu(BPELStringTranslator.getString("COLLAXALAF_INSERT_INTO", "Insert Into"));
        this.m_insertIntoItem.add(this.populateInsertIntoMenu());
        this.m_insertIntoItem.add(this.populateStructuredInsertIntoMenu());
        BPELStringTranslator.setButton(this.m_insertIntoItem, BPELStringTranslator.getString("COLLAXALAF_INSERT_INTO"));
        this.m_insertBeforeItem = new JMenu(BPELStringTranslator.getString("COLLAXALAF_INSERT_BEFORE", "Insert Before"));
        this.m_insertBeforeItem.add(this.populateInsertBeforeMenu());
        this.m_insertBeforeItem.add(this.populateStructuredInsertBeforeMenu());
        BPELStringTranslator.setButton(this.m_insertBeforeItem, BPELStringTranslator.getString("COLLAXALAF_INSERT_BEFORE"));
        this.m_insertAfterItem = new JMenu(BPELStringTranslator.getString("COLLAXALAF_INSERT_AFTER", "Insert After"));
        this.m_insertAfterItem.add(this.populateInsertAfterMenu());
        this.m_insertAfterItem.add(this.populateStructuredInsertAfterMenu());
        BPELStringTranslator.setButton(this.m_insertAfterItem, BPELStringTranslator.getString("COLLAXALAF_INSERT_AFTER"));
        this.m_graphPropsItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_DIAGRAM_PROPERTIES", "Diagram Properties..."), ImageCache.getIcon("diagramproperties16"));
        this.m_graphPropsItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_graphPropsItem, BPELStringTranslator.getString("COLLAXALAF_DIAGRAM_PROPERTIES_M"));
        this.m_cutItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_CUT", "Cut"));
        this.m_cutItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_cutItem, BPELStringTranslator.getString("COLLAXALAF_CUT"));
        this.m_copyItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_COPY", "Copy"));
        this.m_copyItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_copyItem, BPELStringTranslator.getString("COLLAXALAF_COPY"));
        this.m_pasteItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_PASTE", "Paste"));
        this.m_pasteItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_pasteItem, BPELStringTranslator.getString("COLLAXALAF_PASTE"));
    }

    protected JMenu populateInsertIntoMenu() {
        JMenu m = new JMenu(BPELStringTranslator.getString("ACTIVITIES"));
        BPELStringTranslator.setButton(m, BPELStringTranslator.getString("ACTIVITIES"));
        m.add(new InsertIntoAssignAction());
        m.add(new InsertIntoCompensateAction());
        m.add(new InsertIntoEmptyAction());
        m.add(new InsertIntoInvokeAction());
        m.add(new InsertIntoReceiveAction());
        m.add(new InsertIntoReplyAction());
        m.add(new InsertIntoTerminateAction());
        m.add(new InsertIntoThrowAction());
        m.add(new InsertIntoTransformAction());
        return m;
    }

    protected JMenu populateStructuredInsertIntoMenu() {
        JMenu m = new JMenu(BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        BPELStringTranslator.setButton(m, BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        m.add(new InsertIntoFlowAction());
        m.add(new InsertIntoFlowNAction());
        m.add(new InsertIntoPickAction());
        m.add(new InsertIntoScopeAction());
        m.add(new InsertIntoSequenceAction());
        m.add(new InsertIntoSwitchAction());
        m.add(new InsertIntoWhileAction());
        return m;
    }

    protected JMenu populateInsertBeforeMenu() {
        JMenu m = new JMenu(BPELStringTranslator.getString("ACTIVITIES"));
        BPELStringTranslator.setButton(m, BPELStringTranslator.getString("ACTIVITIES"));
        m.add(new InsertBeforeAssignAction());
        m.add(new InsertBeforeCompensateAction());
        m.add(new InsertBeforeEmptyAction());
        m.add(new InsertBeforeInvokeAction());
        m.add(new InsertBeforeReceiveAction());
        m.add(new InsertBeforeReplyAction());
        m.add(new InsertBeforeTerminateAction());
        m.add(new InsertBeforeThrowAction());
        m.add(new InsertBeforeTransformationAction());
        m.add(new InsertBeforeWaitAction());
        return m;
    }

    protected JMenu populateStructuredInsertBeforeMenu() {
        JMenu m = new JMenu(BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        BPELStringTranslator.setButton(m, BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        m.add(new InsertBeforeFlowAction());
        m.add(new InsertBeforeFlowNAction());
        m.add(new InsertBeforePickAction());
        m.add(new InsertBeforeScopeAction());
        m.add(new InsertBeforeSequenceAction());
        m.add(new InsertBeforeSwitchAction());
        m.add(new InsertBeforeWhileAction());
        return m;
    }

    protected JMenu populateInsertAfterMenu() {
        JMenu m = new JMenu(BPELStringTranslator.getString("ACTIVITIES"));
        BPELStringTranslator.setButton(m, BPELStringTranslator.getString("ACTIVITIES"));
        m.add(new InsertAfterAssignAction());
        m.add(new InsertAfterCompensateAction());
        m.add(new InsertAfterEmptyAction());
        m.add(new InsertAfterInvokeAction());
        m.add(new InsertAfterReceiveAction());
        m.add(new InsertAfterReplyAction());
        m.add(new InsertAfterTerminateAction());
        m.add(new InsertAfterThrowAction());
        m.add(new InsertAfterTransformationAction());
        m.add(new InsertAfterWaitAction());
        return m;
    }

    protected JMenu populateStructuredInsertAfterMenu() {
        JMenu m = new JMenu(BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        BPELStringTranslator.setButton(m, BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        m.add(new InsertAfterFlowAction());
        m.add(new InsertAfterFlowNAction());
        m.add(new InsertAfterPickAction());
        m.add(new InsertAfterScopeAction());
        m.add(new InsertAfterSequenceAction());
        m.add(new InsertAfterSwitchAction());
        m.add(new InsertAfterWhileAction());
        return m;
    }

    protected void handleBookmark() {
        Activity a = this.m_graph.getSelectedActivity();
        if (a != null) {
            String name = a.getName();
            String xpath = BPELModelUtil.getXPathForActivity((Activity)a);
            if (name == null || name.length() == 0) {
                name = xpath;
            }
            Bookmark bm = new Bookmark(null);
            bm.setBPELType(a.getTypeID());
            bm.setID(a.getID());
            bm.setXPath(xpath);
            bm.setName(name);
            BookmarkDialog dlg = new BookmarkDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)));
            dlg.setTitle("Create Bookmark");
            if (dlg.display(bm) == 0) {
                this.m_graph.getBookmarks().addBookmark(bm);
                JDevBPELEditor editor = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph));
                if (editor != null) {
                    editor.getBPELPerspectiveComponent().saveGraphicsInformation();
                    editor.getBPELPerspectiveComponent().buildBookmarksMenu();
                }
                this.m_graph.getAnalysisPanel().refresh();
            }
            return;
        }
        PartnerLink pl = this.m_graph.getSelectedPartnerLink();
        if (pl != null) {
            BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
            String name = pl.getName();
            String xpath = BPELModelUtil.getXPathForPartnerLink((Process)model.getProcess(), (PartnerLink)pl);
            if (name == null || name.length() == 0) {
                name = xpath;
            }
            Bookmark bm = new Bookmark(null);
            bm.setBPELType(11);
            bm.setID(pl.getID());
            bm.setXPath(xpath);
            bm.setName(name);
            BookmarkDialog dlg = new BookmarkDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)));
            dlg.setTitle("Create Bookmark");
            if (dlg.display(bm) == 0) {
                this.m_graph.getBookmarks().addBookmark(bm);
                JDevBPELEditor editor = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph));
                if (editor != null) {
                    editor.getBPELPerspectiveComponent().saveGraphicsInformation();
                    editor.getBPELPerspectiveComponent().buildBookmarksMenu();
                }
                this.m_graph.getAnalysisPanel().refresh();
            }
        }
    }

    protected void handlePopupMenu(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        this.populateMenu(popup, x, y);
        if (popup.getComponentCount() > 0) {
            popup.show((Component)((Object)this.m_graph), x, y);
        }
    }

    protected JMenuItem setCanCopy() {
        this.m_copyItem.setEnabled(this.m_graph.canCopy());
        return this.m_copyItem;
    }

    protected JMenuItem setCanCut() {
        this.m_cutItem.setEnabled(this.m_graph.canCut());
        return this.m_cutItem;
    }

    protected JMenuItem setCanPaste() {
        this.m_pasteItem.setEnabled(this.m_graph.canPaste());
        return this.m_pasteItem;
    }

    protected void populateMenu(JPopupMenu popup, int x, int y) {
        NodeRenderer r;
        NodeRenderer hitView = this.m_graph.getNodeRendererAtPosition(x, y);
        GraphElement selectedGraphElem = this.m_graph.getSelectedGraphElement();
        Process p = ((BPELGraphModel)this.m_graph.getModel()).getProcess();
        boolean bEditableProcess = p.isEditable() && this.m_graph.isEditable();
        boolean bDrillInto = false;
        if (selectedGraphElem instanceof NodeRenderer) {
            View v;
            r = (NodeRenderer)selectedGraphElem;
            List actions = r.getActions();
            if (actions != null) {
                for (GraphAction action : actions) {
                    if (action instanceof NoOpAction) continue;
                    popup.add((Action)action);
                }
            }
            bDrillInto = CollaxaNodeRendererFactory.isDrillableRenderer(r);
            if (r instanceof View && (v = (View)r).isCollapsable() && !v.isCollapsed()) {
                this.insertSeparatorIfNeeded(popup);
                popup.add(this.m_collapseAllItem);
                popup.add(this.m_expandAllItem);
            }
        }
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            plugin.populateGraphPopupMenu(this.m_graph, x, y, popup, hitView, selectedGraphElem);
        }
        if (hitView instanceof SwimLaneView) {
            this.insertSeparatorIfNeeded(popup);
            this.m_addLeftPartnerLinkItem.setEnabled(bEditableProcess);
            this.m_addRightPartnerLinkItem.setEnabled(bEditableProcess);
            SwimLaneView left = this.m_graph.getLeftSwimLaneView();
            SwimLaneView right = this.m_graph.getRightSwimLaneView();
            if (left == hitView) {
                popup.add(this.m_addLeftPartnerLinkItem);
            } else if (right == hitView) {
                popup.add(this.m_addRightPartnerLinkItem);
            }
        }
        if (bDrillInto) {
            this.insertSeparatorIfNeeded(popup);
            popup.add(this.m_drillInViewItem);
        }
        if (this.m_graph.inDrillDownMode()) {
            if (!bDrillInto) {
                this.insertSeparatorIfNeeded(popup);
            }
            popup.add(this.m_drillOutViewItem);
        }
        if (selectedGraphElem != null) {
            this.insertSeparatorIfNeeded(popup);
            this.m_deleteItem.setEnabled(selectedGraphElem.canDelete());
            popup.add(this.m_deleteItem);
            if (selectedGraphElem instanceof NodeRenderer) {
                r = (NodeRenderer)selectedGraphElem;
                this.m_renameItem.setEnabled(r.canEditName());
                popup.add(this.m_renameItem);
                this.m_editItem.setEnabled(r.isEditable() && !r.isEditing());
                popup.add(this.m_editItem);
                this.m_insertIntoItem.setEnabled(this.canInsertInto());
                popup.add(this.m_insertIntoItem);
                boolean bEnable = this.canInsertBeforeOrAfter();
                this.m_insertBeforeItem.setEnabled(bEnable);
                this.m_insertAfterItem.setEnabled(bEnable);
                popup.add(this.m_insertBeforeItem);
                popup.add(this.m_insertAfterItem);
            }
        }
        this.insertSeparatorIfNeeded(popup);
        JMenu viewMenu = new JMenu(BPELStringTranslator.getString("GRAPHPOPUP_VIEW"));
        BPELStringTranslator.setButton(viewMenu, BPELStringTranslator.getString("GRAPHPOPUP_VIEW"));
        viewMenu.add(this.m_variablesItem);
        viewMenu.add(this.m_partnerLinksItem);
        viewMenu.add(this.m_messageTypesItem);
        viewMenu.add(this.m_correlationSetsItem);
        viewMenu.add(this.m_propertiesItem);
        viewMenu.add(this.m_propertyAliasesItem);
        viewMenu.addSeparator();
        viewMenu.add(this.m_validationBrowserItem);
        popup.add(viewMenu);
        JMenu run = new JMenu(BPELStringTranslator.getString("GRAPHPOPUP_RUN"));
        BPELStringTranslator.setButton(run, BPELStringTranslator.getString("GRAPHPOPUP_RUN"));
        run.add(this.m_validateProcessItem);
        popup.add(run);
        JMenu display = new JMenu(BPELStringTranslator.getString("GRAPHPOPUP_DISPLAY"));
        BPELStringTranslator.setButton(display, BPELStringTranslator.getString("GRAPHPOPUP_DISPLAY"));
        popup.add(display);
        if ((hitView instanceof SwimLaneView || hitView instanceof PartnerLinkView) && hitView instanceof PartnerLinkView) {
            display.add(this.m_moveToOtherSwimLaneItem);
        }
        if (this.m_graph.getSwimLanesVisible()) {
            display.add(this.m_hideSwimLaneItem);
        } else {
            display.add(this.m_showSwimLaneItem);
        }
        display.add(this.m_graph.getShowEndPointConnections() ? this.m_hidePartnerLinkConnectionsItem : this.m_showPartnerLinkConnectionsItem);
        this.m_optimizeItem.setSelected(this.m_graph.isOptimized());
        display.add(this.m_optimizeItem);
        display.addSeparator();
        display.add(this.m_graphPropsItem);
        this.insertSeparatorIfNeeded(popup);
        JMenu searchMenu = new JMenu(BPELStringTranslator.getString("GRAPHPOPUP_SEARCH"));
        BPELStringTranslator.setButton(searchMenu, BPELStringTranslator.getString("GRAPHPOPUP_SEARCH"));
        searchMenu.add(this.m_textSearchItem);
        searchMenu.add(this.m_typeSearchItem);
        popup.add(searchMenu);
        if (selectedGraphElem instanceof NodeRenderer) {
            popup.add(this.m_bookmarkItem);
        }
        popup.add(this.m_bookmarksItem);
        this.insertSeparatorIfNeeded(popup);
        popup.add(this.m_printItem);
        popup.add(this.m_jpegItem);
    }

    protected boolean canInsertInto() {
        GraphElement graphElem = this.m_graph.getSelectedGraphElement();
        if (graphElem == null) {
            return false;
        }
        if (!(graphElem instanceof NodeRenderer)) {
            return false;
        }
        NodeRenderer r = (NodeRenderer)graphElem;
        Node n = r.getNode();
        switch (n.getNodeType()) {
            case 102: 
            case 103: 
            case 106: 
            case 107: 
            case 115: 
            case 116: 
            case 117: 
            case 134: {
                Activity a = (Activity)n.getUserObject();
                if (a instanceof ContainerActivity) {
                    ContainerActivity c = (ContainerActivity)a;
                    return c.isEditable() && c.getActivityList().size() == 0;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean canInsertBeforeOrAfter() {
        GraphElement graphElem = this.m_graph.getSelectedGraphElement();
        if (graphElem == null) {
            return false;
        }
        if (!(graphElem instanceof NodeRenderer)) {
            return false;
        }
        NodeRenderer r = (NodeRenderer)graphElem;
        Node n = r.getNode();
        Node parentNode = n.getParentNode();
        if (parentNode != null) {
            Activity activity;
            Object userObj = parentNode.getUserObject();
            if (userObj instanceof Activity && !(activity = (Activity)parentNode.getUserObject()).isEditable()) {
                return false;
            }
            return parentNode instanceof DroppableBranchNode;
        }
        return false;
    }

    protected void insertActivityBefore(Node newNode) {
        GraphElement graphElem = this.m_graph.getSelectedGraphElement();
        if (graphElem == null) {
            return;
        }
        if (!(graphElem instanceof NodeRenderer)) {
            return;
        }
        NodeRenderer r = (NodeRenderer)graphElem;
        Node selNode = r.getNode();
        Node parentNode = selNode.getParentNode();
        if (!(parentNode instanceof DroppableBranchNode)) {
            return;
        }
        GraphModel model = this.m_graph.getModel();
        DroppableBranchNode droppableParent = (DroppableBranchNode)parentNode;
        int selectedIndex = parentNode.indexOf(selNode);
        if (selectedIndex < 1) {
            return;
        }
        Node dropNode = parentNode.getChildNode(selectedIndex - 1);
        if (dropNode.getNodeType() != 0) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, newNode, this.m_graph, dropNode, p)) {
            return;
        }
        Activity activity = (Activity)newNode.getUserObject();
        ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            BPELGraphPanePopupHandlerPlugin popupPlugin = plugin.getBPELGraphPanePopupHandlerPlugin();
            if (popupPlugin == null || popupPlugin.canInsertActivity(this.m_graph, (Activity)parentActivity, activity)) continue;
            return;
        }
        try {
            parentActivity.insertActivity(selectedIndex / 2, activity);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)((Object)this.m_graph), (Throwable)e);
        }
        model.insertChildNode((Node)droppableParent, newNode, selectedIndex - 1);
    }

    protected void insertActivityAfter(Node newNode) {
        GraphElement graphElem = this.m_graph.getSelectedGraphElement();
        if (graphElem == null) {
            return;
        }
        if (!(graphElem instanceof NodeRenderer)) {
            return;
        }
        NodeRenderer r = (NodeRenderer)graphElem;
        Node selNode = r.getNode();
        Node parentNode = selNode.getParentNode();
        if (!(parentNode instanceof DroppableBranchNode)) {
            return;
        }
        GraphModel model = this.m_graph.getModel();
        DroppableBranchNode droppableParent = (DroppableBranchNode)parentNode;
        int selectedIndex = parentNode.indexOf(selNode);
        if (selectedIndex == -1 || selectedIndex == parentNode.getChildCount() - 1) {
            return;
        }
        Node dropNode = parentNode.getChildNode(selectedIndex + 1);
        if (dropNode.getNodeType() != 0) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, newNode, this.m_graph, dropNode, p)) {
            return;
        }
        Activity activity = (Activity)newNode.getUserObject();
        ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            BPELGraphPanePopupHandlerPlugin popupPlugin = plugin.getBPELGraphPanePopupHandlerPlugin();
            if (popupPlugin == null || popupPlugin.canInsertActivity(this.m_graph, (Activity)parentActivity, activity)) continue;
            return;
        }
        try {
            parentActivity.insertActivity(selectedIndex / 2 + 1, activity);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)((Object)this.m_graph), (Throwable)e);
        }
        model.insertChildNode((Node)droppableParent, newNode, selectedIndex + 1);
    }

    protected void insertActivityInto(Node newNode) {
        GraphElement graphElem = this.m_graph.getSelectedGraphElement();
        if (graphElem == null) {
            return;
        }
        if (!(graphElem instanceof NodeRenderer)) {
            return;
        }
        NodeRenderer r = (NodeRenderer)graphElem;
        Node selNode = r.getNode();
        GraphModel model = this.m_graph.getModel();
        Activity activity = (Activity)newNode.getUserObject();
        ContainerActivity parentActivity = (ContainerActivity)selNode.getUserObject();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            BPELGraphPanePopupHandlerPlugin popupPlugin = plugin.getBPELGraphPanePopupHandlerPlugin();
            if (popupPlugin == null || popupPlugin.canInsertActivity(this.m_graph, (Activity)parentActivity, activity)) continue;
            return;
        }
        try {
            parentActivity.insertActivity(0, activity);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)((Object)this.m_graph), (Throwable)e);
        }
        model.insertChildNode(selNode, newNode, 0);
    }

    protected void insertSeparatorIfNeeded(JPopupMenu popup) {
        Component c;
        int cnt = popup.getComponentCount();
        if (cnt > 0 && !((c = popup.getComponent(cnt - 1)) instanceof JSeparator)) {
            popup.addSeparator();
        }
    }

    protected boolean checkFlowTask(NodeRenderer r) {
        return BPELGraphUtils.findFlowLinker(r) != null;
    }

    protected void addLeftPartnerLink() {
        SwimLaneView left = this.m_graph.getLeftSwimLaneView();
        if (left == null) {
            return;
        }
        this.m_graph.createPartnerLink(left, null);
    }

    protected void addRightPartnerLink() {
        SwimLaneView right = this.m_graph.getRightSwimLaneView();
        if (right == null) {
            return;
        }
        this.m_graph.createPartnerLink(right, null);
    }

    protected void handleDelete() {
        GraphElement graphElem = this.m_graph.getSelectedGraphElement();
        if (graphElem.canDelete()) {
            BPELSettings settings = this.m_graph.getSettings();
            if (settings.m_bConfirmDeletions) {
                int retVal = this.m_graph.showConfirmDialog(graphElem);
                if (retVal == 0) {
                    this.m_graph.deleteGraphElement(graphElem);
                }
            } else {
                this.m_graph.deleteGraphElement(graphElem);
            }
        }
    }

    protected void handleRename() {
        NodeRenderer r = this.getSelectedNodeRenderer();
        if (r == null) {
            return;
        }
        r.setEditingName(true);
    }

    protected void handleEdit() {
        NodeRenderer r = this.getSelectedNodeRenderer();
        if (r == null) {
            return;
        }
        this.m_graph.startEditing(r);
    }

    protected void handleCancelEdit() {
    }

    protected void handleStopEdit() {
    }

    protected void handleCreateLink() {
    }

    NodeRenderer getSelectedNodeRenderer() {
        GraphElement selectedGraphElem = this.m_graph.getSelectedGraphElement();
        if (selectedGraphElem instanceof NodeRenderer) {
            return (NodeRenderer)selectedGraphElem;
        }
        return null;
    }

    void swapSwimLanes() {
        NodeRenderer parentRenderer;
        NodeRenderer r = this.getSelectedNodeRenderer();
        if (r instanceof PartnerLinkView && (parentRenderer = r.getParent()) instanceof SwimLaneView) {
            SwimLaneNode swimLaneNode = (SwimLaneNode)parentRenderer.getNode();
            Node oppositeSwimLaneNode = swimLaneNode.getOrientation() == 2 ? this.m_graph.getRightSwimLaneView().getNode() : this.m_graph.getLeftSwimLaneView().getNode();
            Node node = r.getNode();
            this.m_graph.getModel().moveNode(node, oppositeSwimLaneNode, 0);
            this.m_graph.getLeftSwimLaneView().adjustPortConnectionPositions();
            this.m_graph.getRightSwimLaneView().adjustPortConnectionPositions();
            this.m_graph.forceLayout();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDevBPELEditor editor;
        Object src = e.getSource();
        if (src == this.m_deleteItem) {
            this.handleDelete();
        } else if (src == this.m_graphPropsItem) {
            JDevBPELEditor editor2;
            if (this.m_graph.showPropertiesDialog() == 0 && (editor2 = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph))) != null) {
                editor2.getBPELPerspectiveComponent().updateMinimizeToggleBtn();
                this.m_graph.repaint();
            }
        } else if (src == this.m_validateProcessItem) {
            JDevBPELEditor editor3 = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph));
            if (editor3 != null) {
                editor3.getBPELPerspectiveComponent().validateProcess();
            }
        } else if (src == this.m_validationBrowserItem) {
            ValidationBrowser browser = new ValidationBrowser(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph, null);
            browser.display();
        } else if (src == this.m_jpegItem) {
            try {
                this.m_graph.createJPEG();
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)((Object)this.m_graph), (String)BPELStringTranslator.formatString("ERROR_CREATING_JPG", ex.getMessage()), (int)0);
            }
        } else if (src == this.m_printItem) {
            this.m_graph.printDocument();
        } else if (src == this.m_createLinkItem) {
            this.handleCreateLink();
            GraphElement selView = this.m_graph.getSelectedGraphElement();
            if (selView instanceof NodeRenderer && selView != null) {
                this.m_graph.setLinkNodeRenderer((NodeRenderer)selView);
            }
        } else if (src == this.m_moveToOtherSwimLaneItem) {
            this.swapSwimLanes();
        } else if (src == this.m_hideSwimLaneItem) {
            this.m_graph.showSwimLanes(false);
        } else if (src == this.m_showSwimLaneItem) {
            this.m_graph.showSwimLanes(true);
        } else if (src == this.m_showPartnerLinkConnectionsItem) {
            this.m_graph.showEndPointConnections(true);
        } else if (src == this.m_hidePartnerLinkConnectionsItem) {
            this.m_graph.showEndPointConnections(false);
        } else if (src == this.m_addLeftPartnerLinkItem) {
            this.addLeftPartnerLink();
        } else if (src == this.m_addRightPartnerLinkItem) {
            this.addRightPartnerLink();
        } else if (src == this.m_editItem) {
            this.handleEdit();
        } else if (src == this.m_cancelEditItem) {
            this.handleCancelEdit();
        } else if (src == this.m_stopEditItem) {
            this.handleStopEdit();
        } else if (src == this.m_renameItem) {
            this.handleRename();
        } else if (src == this.m_collapseAllItem) {
            GraphElement selView = this.m_graph.getSelectedGraphElement();
            if (selView instanceof View) {
                View v = (View)selView;
                v.collapseAllChildren();
                this.m_graph.forceLayout();
            }
        } else if (src == this.m_expandAllItem) {
            GraphElement selView = this.m_graph.getSelectedGraphElement();
            if (selView instanceof View) {
                View v = (View)selView;
                v.expandAllChildren();
                this.m_graph.forceLayout();
            }
        } else if (src == this.m_collapseItem) {
            GraphElement selView = this.m_graph.getSelectedGraphElement();
            if (selView instanceof View) {
                View v = (View)selView;
                v.setCollapsed(true);
                this.m_graph.forceLayout();
            }
        } else if (src == this.m_expandItem) {
            GraphElement selView = this.m_graph.getSelectedGraphElement();
            if (selView instanceof View) {
                View v = (View)selView;
                v.setCollapsed(false);
                this.m_graph.forceLayout();
            }
        } else if (src == this.m_copyItem) {
            this.m_graph.doCopy();
        } else if (src == this.m_pasteItem) {
            this.m_graph.doPaste();
        } else if (src == this.m_cutItem) {
            this.m_graph.doCut();
        } else if (src == this.m_drillInViewItem) {
            GraphElement elem = this.m_graph.getSelectedGraphElement();
            if (elem instanceof NodeRenderer) {
                this.m_graph.pushDrillDownRenderer((NodeRenderer)elem);
                this.m_graph.forceLayout();
            }
        } else if (src == this.m_drillOutViewItem) {
            this.m_graph.popDrillDownRenderer();
            this.m_graph.forceLayout();
        } else if (src == this.m_variablesItem) {
            ExplorerTreeDialog dlg = new ExplorerTreeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), BPELStringTranslator.getString("COLLAXALAF_VARIABLES"), this.m_graph, 1);
            dlg.display();
        } else if (src == this.m_messageTypesItem) {
            ExplorerTreeDialog dlg = new ExplorerTreeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), BPELStringTranslator.getString("COLLAXALAF_MESSAGE_TYPES"), this.m_graph, 2);
            dlg.display();
        } else if (src == this.m_correlationSetsItem) {
            ExplorerTreeDialog dlg = new ExplorerTreeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), BPELStringTranslator.getString("COLLAXALAF_CORR_SETS"), this.m_graph, 8);
            dlg.display();
        } else if (src == this.m_propertiesItem) {
            ExplorerTreeDialog dlg = new ExplorerTreeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), BPELStringTranslator.getString("COLLAXALAF_PROPERTIES"), this.m_graph, 64);
            dlg.display();
        } else if (src == this.m_propertyAliasesItem) {
            ExplorerTreeDialog dlg = new ExplorerTreeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), BPELStringTranslator.getString("COLLAXALAF_PROPERTY_ALIASES"), this.m_graph, 128);
            dlg.display();
        } else if (src == this.m_partnerLinksItem) {
            ExplorerTreeDialog dlg = new ExplorerTreeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), BPELStringTranslator.getString("COLLAXALAF_PARTNER_LINKS"), this.m_graph, 4);
            dlg.display();
        } else if (src == this.m_optimizeItem) {
            JDevBPELEditor editor4 = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph));
            if (editor4 != null) {
                editor4.getBPELPerspectiveComponent().toggleMinimize();
            }
        } else if (src == this.m_textSearchItem) {
            JDevBPELEditor editor5 = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph));
            if (editor5 != null) {
                editor5.getBPELPerspectiveComponent().handleSearch();
            }
        } else if (src == this.m_typeSearchItem) {
            JDevBPELEditor editor6 = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph));
            if (editor6 != null) {
                editor6.getBPELPerspectiveComponent().handleTypeSearch();
            }
        } else if (src == this.m_bookmarkItem) {
            this.handleBookmark();
        } else if (src == this.m_bookmarksItem && (editor = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)this.m_graph))) != null) {
            editor.getBPELPerspectiveComponent().editBookmarks();
        }
    }

    class PopupTriggerAction
    extends AbstractAction {
        PopupTriggerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphElement elem = BPELGraphPanePopupHandler.this.m_graph.getSelectedGraphElement();
            if (elem instanceof NodeRenderer) {
                Rectangle r = ((NodeRenderer)elem).getBounds();
                BPELGraphPanePopupHandler.this.handlePopupMenu(r.x, r.y);
            }
        }
    }

    class InsertIntoWhileAction
    extends AbstractAction {
        public InsertIntoWhileAction() {
            super("While", ImageCache.getIcon("while_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(117, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoSequenceAction
    extends AbstractAction {
        public InsertIntoSequenceAction() {
            super("Sequence", ImageCache.getIcon("sequence_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(103, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoScopeAction
    extends AbstractAction {
        public InsertIntoScopeAction() {
            super("Scope", ImageCache.getIcon("scope_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(102, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoPickAction
    extends AbstractAction {
        public InsertIntoPickAction() {
            super("Pick", ImageCache.getIcon("pick_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(114, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoFlowNAction
    extends AbstractAction {
        public InsertIntoFlowNAction() {
            super("FlowN", ImageCache.getIcon("flow_n_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(134, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoFlowAction
    extends AbstractAction {
        public InsertIntoFlowAction() {
            super("Flow", ImageCache.getIcon("flow_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(108, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoSwitchAction
    extends AbstractAction {
        public InsertIntoSwitchAction() {
            super("Switch", ImageCache.getIcon("switch_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(104, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoNotificationAction
    extends AbstractAction {
        public InsertIntoNotificationAction() {
            super("Notification", ImageCache.getIcon("notification_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class InsertIntoUserTaskAction
    extends AbstractAction {
        public InsertIntoUserTaskAction() {
            super("User Task", ImageCache.getIcon("user_task_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class InsertIntoCompensateAction
    extends AbstractAction {
        public InsertIntoCompensateAction() {
            super("Compensate", ImageCache.getIcon("compensate_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(120, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoInvokeAction
    extends AbstractAction {
        public InsertIntoInvokeAction() {
            super("Invoke", ImageCache.getIcon("invoke_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(100, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)n);
        }
    }

    class InsertIntoReplyAction
    extends AbstractAction {
        public InsertIntoReplyAction() {
            super("Reply", ImageCache.getIcon("reply_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(113, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)n);
        }
    }

    class InsertIntoReceiveAction
    extends AbstractAction {
        public InsertIntoReceiveAction() {
            super("Receive", ImageCache.getIcon("receive_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(101, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(0));
            n.addChildNode((Node)new PortNode(0));
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)n);
        }
    }

    class InsertIntoTransformAction
    extends AbstractAction {
        public InsertIntoTransformAction() {
            super("Transform", ImageCache.getIcon("assign_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(133, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoAssignAction
    extends AbstractAction {
        public InsertIntoAssignAction() {
            super("Assign", ImageCache.getIcon("assign_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(109, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoEmptyAction
    extends AbstractAction {
        public InsertIntoEmptyAction() {
            super("Empty", ImageCache.getIcon("empty_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(119, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoWaitAction
    extends AbstractAction {
        public InsertIntoWaitAction() {
            super("Wait", ImageCache.getIcon("wait_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(112, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoTerminateAction
    extends AbstractAction {
        public InsertIntoTerminateAction() {
            super("Terminate", ImageCache.getIcon("terminate_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(118, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertIntoThrowAction
    extends AbstractAction {
        public InsertIntoThrowAction() {
            super("Throw", ImageCache.getIcon("throw_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityInto((Node)ModelBuilder.createGraphNode(121, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterWhileAction
    extends AbstractAction {
        public InsertAfterWhileAction() {
            super("While", ImageCache.getIcon("while_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(117, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterSequenceAction
    extends AbstractAction {
        public InsertAfterSequenceAction() {
            super("Sequence", ImageCache.getIcon("sequence_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(103, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterScopeAction
    extends AbstractAction {
        public InsertAfterScopeAction() {
            super("Scope", ImageCache.getIcon("scope_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(102, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterPickAction
    extends AbstractAction {
        public InsertAfterPickAction() {
            super("Pick", ImageCache.getIcon("pick_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(114, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterFlowNAction
    extends AbstractAction {
        public InsertAfterFlowNAction() {
            super("FlowN", ImageCache.getIcon("flow_n_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(134, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterFlowAction
    extends AbstractAction {
        public InsertAfterFlowAction() {
            super("Flow", ImageCache.getIcon("flow_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(108, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterSwitchAction
    extends AbstractAction {
        public InsertAfterSwitchAction() {
            super("Switch", ImageCache.getIcon("switch_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(104, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterInvokeAction
    extends AbstractAction {
        public InsertAfterInvokeAction() {
            super("Invoke", ImageCache.getIcon("invoke_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(100, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)n);
        }
    }

    class InsertAfterReplyAction
    extends AbstractAction {
        public InsertAfterReplyAction() {
            super("Reply", ImageCache.getIcon("reply_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(113, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)n);
        }
    }

    class InsertAfterReceiveAction
    extends AbstractAction {
        public InsertAfterReceiveAction() {
            super("Receive", ImageCache.getIcon("receive_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(101, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(0));
            n.addChildNode((Node)new PortNode(0));
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)n);
        }
    }

    class InsertAfterAssignAction
    extends AbstractAction {
        public InsertAfterAssignAction() {
            super("Assign", ImageCache.getIcon("assign_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(109, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterNotificationAction
    extends AbstractAction {
        public InsertAfterNotificationAction() {
            super("Notification", ImageCache.getIcon("notification_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class InsertAfterUserTaskAction
    extends AbstractAction {
        public InsertAfterUserTaskAction() {
            super("User Task", ImageCache.getIcon("user_task_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class InsertAfterCompensateAction
    extends AbstractAction {
        public InsertAfterCompensateAction() {
            super("Compensate", ImageCache.getIcon("compensate_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(120, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterEmptyAction
    extends AbstractAction {
        public InsertAfterEmptyAction() {
            super("Empty", ImageCache.getIcon("empty_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(119, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterWaitAction
    extends AbstractAction {
        public InsertAfterWaitAction() {
            super("Wait", ImageCache.getIcon("wait_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(112, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterTerminateAction
    extends AbstractAction {
        public InsertAfterTerminateAction() {
            super("Terminate", ImageCache.getIcon("terminate_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(118, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterTransformationAction
    extends AbstractAction {
        public InsertAfterTransformationAction() {
            super("Transform", ImageCache.getIcon("assign_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(133, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertAfterThrowAction
    extends AbstractAction {
        public InsertAfterThrowAction() {
            super("Throw", ImageCache.getIcon("throw_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityAfter((Node)ModelBuilder.createGraphNode(121, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeWhileAction
    extends AbstractAction {
        public InsertBeforeWhileAction() {
            super("While", ImageCache.getIcon("while_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(117, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeSequenceAction
    extends AbstractAction {
        public InsertBeforeSequenceAction() {
            super("Sequence", ImageCache.getIcon("sequence_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(103, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeScopeAction
    extends AbstractAction {
        public InsertBeforeScopeAction() {
            super("Scope", ImageCache.getIcon("scope_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(102, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforePickAction
    extends AbstractAction {
        public InsertBeforePickAction() {
            super("Pick", ImageCache.getIcon("pick_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(114, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeFlowNAction
    extends AbstractAction {
        public InsertBeforeFlowNAction() {
            super("FlowN", ImageCache.getIcon("flow_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(134, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeFlowAction
    extends AbstractAction {
        public InsertBeforeFlowAction() {
            super("Flow", ImageCache.getIcon("flow_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(108, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeSwitchAction
    extends AbstractAction {
        public InsertBeforeSwitchAction() {
            super("Switch", ImageCache.getIcon("switch_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(104, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeInvokeAction
    extends AbstractAction {
        public InsertBeforeInvokeAction() {
            super("Invoke", ImageCache.getIcon("invoke_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(100, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)n);
        }
    }

    class InsertBeforeReplyAction
    extends AbstractAction {
        public InsertBeforeReplyAction() {
            super("Reply", ImageCache.getIcon("reply_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(113, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)n);
        }
    }

    class InsertBeforeReceiveAction
    extends AbstractAction {
        public InsertBeforeReceiveAction() {
            super("Receive", ImageCache.getIcon("receive_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode n = ModelBuilder.createGraphNode(101, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate);
            n.addChildNode((Node)new PortNode(0));
            n.addChildNode((Node)new PortNode(0));
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)n);
        }
    }

    class InsertBeforeTransformationAction
    extends AbstractAction {
        public InsertBeforeTransformationAction() {
            super("Transform", ImageCache.getIcon("assign_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(133, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeAssignAction
    extends AbstractAction {
        public InsertBeforeAssignAction() {
            super("Assign", ImageCache.getIcon("assign_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(109, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeNotificationAction
    extends AbstractAction {
        public InsertBeforeNotificationAction() {
            super("Notification", ImageCache.getIcon("notification_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class InsertBeforeUserTaskAction
    extends AbstractAction {
        public InsertBeforeUserTaskAction() {
            super("User Task", ImageCache.getIcon("user_task_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class InsertBeforeCompensateAction
    extends AbstractAction {
        public InsertBeforeCompensateAction() {
            super("Compensate", ImageCache.getIcon("compensate_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(120, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeEmptyAction
    extends AbstractAction {
        public InsertBeforeEmptyAction() {
            super("Empty", ImageCache.getIcon("empty_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(119, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeWaitAction
    extends AbstractAction {
        public InsertBeforeWaitAction() {
            super("Wait", ImageCache.getIcon("wait_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(112, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeTerminateAction
    extends AbstractAction {
        public InsertBeforeTerminateAction() {
            super("Terminate", ImageCache.getIcon("terminate_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(118, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }

    class InsertBeforeThrowAction
    extends AbstractAction {
        public InsertBeforeThrowAction() {
            super("Throw", ImageCache.getIcon("throw_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BPELGraphPanePopupHandler.this.insertActivityBefore((Node)ModelBuilder.createGraphNode(121, BPELGraphPanePopupHandler.this.getProcess(), BPELGraphPanePopupHandler.this.m_bValidate));
        }
    }
}

