/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import oracle.tip.tools.ide.common.graph.actions.CollapseExpandViewAction;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;

public class BPELGraphPaneKeyListener
extends KeyAdapter {
    private BPELGraphPane m_graph;

    public BPELGraphPaneKeyListener(BPELGraphPane graph) {
        this.m_graph = graph;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 39) {
            this.handleRightKey();
        } else if (keyCode == 37) {
            this.handleLeftKey();
        } else if (keyCode == 112) {
            this.m_graph.showHelp();
            e.consume();
        }
    }

    protected void handleRightKey() {
        GraphElement ge = this.m_graph.getSelectedGraphElement();
        if (!(ge instanceof View)) {
            return;
        }
        View v = (View)ge;
        if (v.isCollapsed()) {
            CollapseExpandViewAction action = new CollapseExpandViewAction(v);
            action.actionPerformed(new ActionEvent(this.m_graph, 0, "expand"));
        }
    }

    protected void handleLeftKey() {
        GraphElement ge = this.m_graph.getSelectedGraphElement();
        if (!(ge instanceof View)) {
            return;
        }
        View v = (View)ge;
        if (v.isCollapsable() && !v.isCollapsed()) {
            CollapseExpandViewAction action = new CollapseExpandViewAction(v);
            action.actionPerformed(new ActionEvent(this.m_graph, 0, "expand"));
        }
    }
}

