/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import oracle.ide.palette2.PaletteItem;
import oracle.javatools.dnd.DndUtils;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.view.DefaultGraphPaneDropTargetListener;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.DragListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;

public class BPELGraphPaneDropTargetListener
extends DefaultGraphPaneDropTargetListener {
    protected EventListenerList m_dragListenerList = new EventListenerList();

    public BPELGraphPaneDropTargetListener(GraphPane pane) {
        super(pane);
    }

    public void addDragListener(DragListener l) {
        this.m_dragListenerList.add(DragListener.class, l);
    }

    public void removeDragListener(DragListener l) {
        this.m_dragListenerList.remove(DragListener.class, l);
    }

    protected boolean doesDragListenerRejectDrag(NodeRenderer r, Object data) {
        Object[] listeners = this.m_dragListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            DragListener l;
            if (listeners[i] != DragListener.class || !(l = (DragListener)listeners[i + 1]).shouldRejectDrag(r, data)) continue;
            return true;
        }
        return false;
    }

    protected boolean recognizeSwimLaneDrop(SwimLaneView r, Object data) {
        boolean bRightSwimLane;
        if (data == null) {
            return false;
        }
        if (this.isGloballyAcceptableSwimLaneDropData(data)) {
            return true;
        }
        boolean bl = bRightSwimLane = ((SwimLaneNode)r.getNode()).getOrientation() == 4;
        if (bRightSwimLane && this.isAcceptableRightSwimLaneDropData(data)) {
            return true;
        }
        Object[] listeners = this.m_dragListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            DragListener l;
            if (listeners[i] != DragListener.class || !(l = (DragListener)listeners[i + 1]).recognizeSwimLaneDrop(r, data)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGloballyAcceptableSwimLaneDropData(Object data) {
        String dropData = BPELDNDDropHandler.getTaskNameFromDropData(data);
        return dropData != null && (dropData.equalsIgnoreCase("partnerlink") || dropData.equalsIgnoreCase("web_service"));
    }

    protected boolean isAcceptableRightSwimLaneDropData(Object data) {
        String dropData = BPELDNDDropHandler.getTaskNameFromDropData(data);
        return dropData != null && (dropData.equalsIgnoreCase("partnerlink") || dropData.equalsIgnoreCase("web_service") || dropData.equalsIgnoreCase("mediator") || dropData.equalsIgnoreCase("bpel_process"));
    }

    protected boolean canDragListenerHandleDrop(Point pt, NodeRenderer r, Object dropData) {
        Object[] listeners = this.m_dragListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            DragListener l;
            if (listeners[i] != DragListener.class || !(l = (DragListener)listeners[i + 1]).canHandleDropHere(pt, r, dropData)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDragOk(DropTargetDragEvent e) {
        Object dropData;
        NodeRenderer r;
        if (!this.m_pane.isEditable()) {
            return false;
        }
        if (!this.isDragFlavorSupported(e)) {
            return false;
        }
        Point pt = e.getLocation();
        if (!this.isOverDropZone(pt, r = this.m_pane.getNodeRendererAtPosition(pt.x, pt.y), dropData = this.getDropData(e))) {
            return false;
        }
        int da = e.getDropAction();
        return (da & this.m_acceptableActions) != 0;
    }

    protected boolean isProcessEditable() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_pane.getModel();
        Process process = graphModel.getProcess();
        return process.isEditable();
    }

    protected boolean isOverDropZone(Point pt, NodeRenderer r, Object dropData) {
        String taskName;
        boolean bOverSwimLane = r instanceof SwimLaneView;
        if (bOverSwimLane && !this.isProcessEditable()) {
            return false;
        }
        if (this.canDragListenerHandleDrop(pt, r, dropData)) {
            return true;
        }
        boolean bRepaint = false;
        if (this.m_lastDropView != null) {
            this.m_lastDropView.setHighLightOn(false);
            this.m_lastDropView = null;
            bRepaint = true;
        }
        boolean retVal = false;
        boolean bHighlightDropZone = true;
        if (bOverSwimLane) {
            if (this.recognizeSwimLaneDrop((SwimLaneView)r, dropData)) {
                retVal = true;
                bHighlightDropZone = true;
            } else {
                bHighlightDropZone = false;
            }
        }
        if (this.isPartnerLinkTask(taskName = BPELDNDDropHandler.getTaskNameFromDropData(dropData)) && !bOverSwimLane) {
            bHighlightDropZone = false;
            retVal = false;
        }
        if (bHighlightDropZone && r instanceof DropZone) {
            if (this.doesDragListenerRejectDrag(r, dropData)) {
                retVal = false;
            } else {
                retVal = true;
                DropZone dv = (DropZone)r;
                if (!dv.isDropAllowed()) {
                    return false;
                }
                dv.setHighLightOn(true);
                bRepaint = true;
                this.m_lastDropView = dv;
            }
        }
        if (bRepaint) {
            this.m_pane.repaint();
        }
        return retVal;
    }

    protected boolean isPartnerLinkTask(String task) {
        return task != null && (task.equalsIgnoreCase("partnerlink") || task.equalsIgnoreCase("web_service") || task.equalsIgnoreCase("bpel_process") || task.equalsIgnoreCase("mediator"));
    }

    public void dragOver(DropTargetDragEvent e) {
        Transferable t = DndUtils.getTransferable((DropTargetEvent)e);
        if (e.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
            t = e.getTransferable();
            try {
                String id = BPELDNDDropHandler.getTaskNameFromDropData(t.getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR));
                PaletteItem i = (PaletteItem)t.getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                String displayText = i.getName();
                Icon icon = this.getIconForActivity(id);
                Point pt = e.getLocation();
                NodeRenderer r = this.m_pane.getNodeRendererAtPosition(pt.x, pt.y);
                boolean bHighLight = this.isOverDropZone(pt, r, this.getDropData(e));
                ((BPELGraphPane)this.m_pane).setPaintDragImage(displayText, e.getLocation(), icon, bHighLight);
            }
            catch (UnsupportedFlavorException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        super.dragOver(e);
    }

    protected void handleDrop(DropTargetDropEvent e) {
        super.handleDrop(e);
        this.showDropZones(false);
    }

    protected void showDropZones(boolean bShow) {
        ((BPELGraphPane)this.m_pane).showDropZones(bShow);
        if (!bShow) {
            ((BPELGraphPane)this.m_pane).setPaintDragImage(null, null, null, false);
        }
    }

    protected void dropOccurred(DataFlavor flavor, Object data, DropTargetDropEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_pane.requestFocusInWindow();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BPELGraphPaneDropTargetListener.this.m_pane.requestFocusInWindow();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        super.dragEnter(e);
        this.showDropZones(true);
    }

    public void dragExit(DropTargetEvent e) {
        super.dragExit(e);
        this.showDropZones(false);
    }

    private Icon getIconForActivity(String name) {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            Icon icon = plugin.getDragIconForActivity(name);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }
}

