/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Pick;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphModelEvent;
import oracle.tip.tools.ide.common.graph.event.GraphModelListener;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.CompoundNodeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.EdgeRenderer;
import oracle.tip.tools.ide.common.graph.view.EdgeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.InlineEditorFramePanel;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeEditorDialog;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.ViewTransferable;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.DynamicFileFilter;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDataStore;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InvokeGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ReceiveGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ReplyGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.PartnerLinkDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowLinker;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkListener;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PickNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReceiveNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReplyNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import oracle.tip.tools.ide.pm.bpelgraph.views.AnalysisPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneEdgeRendererFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneKeyListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneProperties;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELPropertiesDialog;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchAllView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaNodeRendererFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.CompensationHandlerView;
import oracle.tip.tools.ide.pm.bpelgraph.views.FlowView;
import oracle.tip.tools.ide.pm.bpelgraph.views.Magnifiable;
import oracle.tip.tools.ide.pm.bpelgraph.views.NoteView;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnAlarmView;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnMessageView;
import oracle.tip.tools.ide.pm.bpelgraph.views.OverViewPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PickView;
import oracle.tip.tools.ide.pm.bpelgraph.views.PopupHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.PortView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ProcessView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.bpelgraph.views.SequenceView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.InvokeNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ReceiveViewNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ReplyViewNodeEditor;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.StandardBPELEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class BPELGraphPane
extends GraphPane
implements BPELGraphPaneProperties {
    public static final Color DOTTED_BORDER_COLOR = new Color(220, 220, 220);
    public static final Color TAB_BACKGROUND_COLOR = new Color(240, 240, 240);
    public static final Color TAB_BORDER_COLOR = new Color(218, 218, 218);
    public static final Color TAB_TEXT_COLOR = new Color(152, 152, 152);
    public static final Color FLOW_LINK_COLOR = new Color(211, 211, 211);
    public static final Color VIEW_SELECTION_BACKGROUND = new Color(220, 238, 240);
    public static int PORT_SIZE = 16;
    protected NodeRenderer m_linkingNodeRenderer;
    protected Point m_mousePt = new Point();
    protected PortView m_draggedPortConnection;
    protected boolean m_bShowEndpointConnections = true;
    protected boolean m_bShowDropZones = false;
    private EventListenerList m_endpointConnectionListenerList = new EventListenerList();
    protected InternalGraphModelListener m_internalModelListener;
    protected Color m_portConnectionColor = FLOW_LINK_COLOR;
    protected PartnerLinkDragBox m_partnerLinkDragBox;
    protected int m_imgIndex = 0;
    protected PartnerLinkView m_highLightedPartnerLinkView;
    protected String m_mainMessage = BPELStringTranslator.getString("COLLAXALAF_BUILDING_DIAGRAM");
    protected String m_subMessage = "";
    protected Point m_dragPoint;
    protected Icon m_dragIcon;
    protected String m_dragText;
    protected boolean m_dragHighLight;
    protected List<NodeRenderer> m_magnifiedViews = new ArrayList<NodeRenderer>();
    protected boolean m_bGroupMode;
    protected Rectangle m_groupRect;
    protected Image m_bufImage;
    protected boolean m_bPaintOverView = true;
    protected AnalysisPanel m_analysisPnl;
    protected BookmarkDataStore m_bookmarks = new BookmarkDataStore();
    protected BPELSettings m_settings = new BPELSettings();
    protected PopupHandler m_popupHandler;

    public BPELGraphPane() {
        this.setBackground(Color.green);
        this.setLineColor(new Color(152, 152, 152));
        this.setBackground(this.m_settings.m_graphBackgroundColor);
        this.installNodeRendererFactory((NodeRendererFactory)new CollaxaNodeRendererFactory());
        this.setEdgeRendererFactory((EdgeRendererFactory)new BPELGraphPaneEdgeRendererFactory());
        this.setSelectionBackground(Color.cyan);
        this.addKeyListener(new BPELGraphPaneKeyListener(this));
    }

    protected boolean showValidationWarnings() {
        return true;
    }

    public boolean allowActionEditing() {
        return true;
    }

    protected void installNodeRendererFactory(NodeRendererFactory mainFactory) {
        CompoundNodeRendererFactory factory = new CompoundNodeRendererFactory();
        factory.addNodeRendererFactory(mainFactory);
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            NodeRendererFactory f = plugin.getNodeRendererFactory();
            if (f == null) continue;
            factory.addNodeRendererFactory(f);
        }
        this.setNodeRendererFactory((NodeRendererFactory)factory);
    }

    public String getScreenReaderName() {
        return BPELStringTranslator.getString("BPEL_DIAGRAM");
    }

    public void reloadBPELEditor() {
        final StandardBPELEditor editor = (StandardBPELEditor)SwingUtilities.getAncestorOfClass(StandardBPELEditor.class, (Component)((Object)this));
        if (editor != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    editor.rebuildGraphModel(null);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public PopupHandler getPopupHandler() {
        return this.m_popupHandler;
    }

    public void setPopupHandler(PopupHandler h) {
        if (this.m_popupHandler != null) {
            this.m_popupHandler.deinstall();
        }
        this.m_popupHandler = h;
        if (this.m_popupHandler != null) {
            this.m_popupHandler.install();
        }
    }

    public Color getSelectionColor() {
        BPELSettings settings = this.getSettings();
        return settings.m_selectedBorderBackgroundColor;
    }

    public BPELSettings getSettings() {
        return this.m_settings;
    }

    public void setSettings(BPELSettings settings) {
        this.m_settings = settings;
        if (settings != null) {
            this.putProperty("CENTER_ZOOM", settings.m_bCenterZoom);
            this.putProperty("USE_POPUP_NODE_EDITORS", settings.m_bPopupEditor);
            if (settings.m_graphBackgroundColor != null) {
                this.setBackground(settings.m_graphBackgroundColor);
            }
        }
    }

    public void showHelp() {
        GraphElement graphElem = this.getSelectedGraphElement();
        Point p = this.getMousePosition();
        Component c = null;
        if (p != null) {
            c = this.getComponentAt(p);
        }
        if (graphElem instanceof NodeRenderer) {
            NodeRenderer r = (NodeRenderer)graphElem;
            AbstractActivityNodeEditor editorComp = (AbstractActivityNodeEditor)r.getNodeEditor();
            EditorPage[] pages = editorComp.getEditorPages(r.getGraphPane(), r.getNode());
            if (pages.length >= 1) {
                pages[editorComp.getSelectedIndex()].showHelp();
            }
        } else if (c instanceof InlineEditorFramePanel) {
            InlineEditorFramePanel panel = (InlineEditorFramePanel)c;
            Component editor = panel.getEditorComp();
            if (editor instanceof ApplyCancelPanel) {
                ApplyCancelPanel app = (ApplyCancelPanel)editor;
                app.handleHelp();
            }
        } else {
            HelpSystem.gotoOracleHelpSystem("bpmjdev_default_page");
        }
    }

    public BookmarkDataStore getBookmarks() {
        return this.m_bookmarks;
    }

    public void setBookmarks(BookmarkDataStore bookmarks) {
        this.m_bookmarks = bookmarks;
    }

    public void setAnalysisPanel(AnalysisPanel p) {
        this.m_analysisPnl = p;
    }

    public AnalysisPanel getAnalysisPanel() {
        return this.m_analysisPnl;
    }

    public List<StateSaveableView> getStateSaveableViews() {
        ArrayList<StateSaveableView> l = new ArrayList<StateSaveableView>();
        for (NodeRenderer r : this.getRootNodeRenderers()) {
            l.addAll(this.getStateSaveableViews(r));
        }
        return l;
    }

    public void optimizeDisplay(boolean bOptimize) {
        BPELSettings settings = this.getSettings();
        settings.m_iconizeStateMap.put("OPTIMIZE_GRAPH", bOptimize);
        this.forceLayout();
    }

    public boolean isOptimized() {
        BPELSettings settings = this.getSettings();
        Boolean b = (Boolean)settings.m_iconizeStateMap.get("OPTIMIZE_GRAPH");
        return b != null && b != false;
    }

    private List<StateSaveableView> getStateSaveableViews(NodeRenderer r) {
        List<StateSaveableView> lst;
        Object renderer;
        Iterator it;
        ArrayList<StateSaveableView> l = null;
        if (r instanceof StateSaveableView) {
            l = new ArrayList<StateSaveableView>();
            l.add((StateSaveableView)r);
        }
        if (r instanceof ScopeView) {
            ScopeView sv = (ScopeView)r;
            it = sv.getFaultHandlerViews();
            while (it.hasNext()) {
                renderer = (NodeRenderer)it.next();
                lst = this.getStateSaveableViews((NodeRenderer)renderer);
                if (lst == null) continue;
                if (l == null) {
                    l = new ArrayList();
                }
                l.addAll(lst);
            }
            it = sv.getEventHandlerViews();
            while (it.hasNext()) {
                renderer = (NodeRenderer)it.next();
                lst = this.getStateSaveableViews((NodeRenderer)renderer);
                if (lst == null) continue;
                if (l == null) {
                    l = new ArrayList();
                }
                l.addAll(lst);
            }
            renderer = sv.getCompensationHandlerView();
            if (renderer != null && (lst = this.getStateSaveableViews((NodeRenderer)renderer)) != null) {
                if (l == null) {
                    l = new ArrayList();
                }
                l.addAll(lst);
            }
        }
        if (r instanceof ProcessView) {
            ProcessView pv = (ProcessView)r;
            it = pv.getFaultHandlerViews();
            while (it.hasNext()) {
                renderer = (NodeRenderer)it.next();
                lst = this.getStateSaveableViews((NodeRenderer)renderer);
                if (lst == null) continue;
                if (l == null) {
                    l = new ArrayList();
                }
                l.addAll(lst);
            }
            it = pv.getEventHandlerViews();
            while (it.hasNext()) {
                renderer = (NodeRenderer)it.next();
                lst = this.getStateSaveableViews((NodeRenderer)renderer);
                if (lst == null) continue;
                if (l == null) {
                    l = new ArrayList();
                }
                l.addAll(lst);
            }
            renderer = pv.getCompensationHandlerView();
            if (renderer != null && (lst = this.getStateSaveableViews((NodeRenderer)renderer)) != null) {
                if (l == null) {
                    l = new ArrayList();
                }
                l.addAll(lst);
            }
        }
        Iterator it2 = r.getChildren();
        while (it2.hasNext()) {
            NodeRenderer o = (NodeRenderer)it2.next();
            List<StateSaveableView> l2 = this.getStateSaveableViews(o);
            if (l2 == null) continue;
            if (l == null) {
                l = new ArrayList();
            }
            l.addAll(l2);
        }
        return l;
    }

    public void createJPEG() throws Exception {
        Rectangle bounds = new Rectangle(0, 0, this.m_prefDim.width, this.m_prefDim.height);
        if (bounds.width == 0 || bounds.height == 0) {
            throw new Exception(BPELStringTranslator.getString("CANNOT_CREATE_IMG"));
        }
        URL graphURL = this.getBPELProject().getBPELFileURL();
        if (graphURL != null) {
            String s = Helper.getFileName((URL)graphURL);
            int idx = s.lastIndexOf(46);
            if (idx != -1) {
                s = s.substring(0, idx);
            }
            s = s + ".jpg";
        } else {
            String s = "generatedimage.jpg";
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter((FileFilter)new DynamicFileFilter(".jpg", "JPEG Files (*.jpg)"));
        if (chooser.showSaveDialog(GraphUtils.getFrame((Component)((Object)this))) != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        URL url = f.toURL();
        if (f.exists()) {
            String title = BPELStringTranslator.getString("OVERWRITE_FILE_TITLE");
            String msg = BPELStringTranslator.getString("COLLAXALAF_FILE_EXISTS");
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg, (String)title) == 1) {
                return;
            }
        }
        this.saveImageToFile(url);
    }

    public void saveImageToFile(URL url) throws Exception {
        Rectangle bounds = new Rectangle(0, 0, this.m_prefDim.width, this.m_prefDim.height);
        if (bounds.width == 0 || bounds.height == 0) {
            throw new Exception(BPELStringTranslator.getString("CANNOT_CREATE_IMG"));
        }
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration config = device.getDefaultConfiguration();
        BufferedImage pageImage = config.createCompatibleImage(bounds.width, bounds.height);
        Graphics offGraphics = pageImage.getGraphics();
        offGraphics.setColor(Color.white);
        offGraphics.fillRect(0, 0, bounds.width, bounds.height);
        offGraphics.setClip(0, 0, bounds.width, bounds.height);
        this.paint(offGraphics);
        JPEGTranscoder trans = new JPEGTranscoder();
        trans.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.9));
        BufferedImage jpgImg = trans.createImage(pageImage.getWidth(null), pageImage.getHeight(null));
        Graphics2D g2d = jpgImg.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, jpgImg.getWidth(null), jpgImg.getHeight(null));
        g2d.drawImage(pageImage, null, 0, 0);
        BufferedOutputStream ostream = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url));
        trans.writeImage(jpgImg, new TranscoderOutput((OutputStream)ostream));
        ((OutputStream)ostream).flush();
        ((OutputStream)ostream).close();
    }

    public void saveGraphicsFile() throws Exception {
        BPELProject prj = this.getBPELProject();
        if (prj != null) {
            URL url = prj.getGraphicsFileURL();
            GraphicsFileUtil.saveGraphicsFile(url, this);
        }
    }

    public void selectPartnerLink(PartnerLink link) {
        SwimLaneView right;
        if (!this.getSwimLanesVisible()) {
            this.showSwimLanes(true);
        }
        NodeRenderer linkView = null;
        SwimLaneView left = this.getLeftSwimLaneView();
        if (left != null) {
            Iterator it = left.getChildren();
            while (it.hasNext()) {
                NodeRenderer r = (NodeRenderer)it.next();
                Object obj = r.getNode().getUserObject();
                if (obj != link) continue;
                linkView = r;
                this.setSelectedGraphElement((GraphElement)r, new Point(r.getBounds().x, r.getBounds().y));
                break;
            }
        }
        if ((right = this.getRightSwimLaneView()) != null) {
            Iterator it = right.getChildren();
            while (it.hasNext()) {
                NodeRenderer r = (NodeRenderer)it.next();
                Object obj = r.getNode().getUserObject();
                if (obj != link) continue;
                linkView = r;
                this.setSelectedGraphElement((GraphElement)r, new Point(r.getBounds().x, r.getBounds().y));
                break;
            }
        }
        if (linkView != null) {
            this.scrollNodeRendererToVisible(linkView, true);
        }
    }

    public void setSelectedGraphElement(GraphElement graphElem, Point mouseHit) {
        super.setSelectedGraphElement(graphElem, mouseHit);
        this.m_bPaintOverView = true;
        this.repaint();
        OverViewPanel.getInstance().repaintSelectionBox();
    }

    public void selectActivity(Activity a) {
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        Node node = model.getNodeForActivity(a);
        if (node == null) {
            return;
        }
        NodeRenderer r = this.getNodeRendererForNode(node);
        if (r != null) {
            this.scrollNodeRendererToVisible(r, true);
        }
    }

    public PartnerLink createPartnerLink(Scope s) {
        return this.createPartnerLink(null, s);
    }

    public PartnerLink createPartnerLink(SwimLaneView v, Scope s) {
        return this.createPartnerLink(v, null, s);
    }

    public PartnerLink createPartnerLink(SwimLaneView v, Point dropPoint, Scope s, String wsdlLocation) {
        return this.createPartnerLink(v, dropPoint, s, wsdlLocation, null, null);
    }

    public PartnerLink createPartnerLink(SwimLaneView v, Point dropPoint, Scope s, String wsdlLocation, String iconName, Object obj) {
        JScrollPane sp;
        PartnerLinkDialog dlg;
        PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
        if (iconName != null) {
            Icon icon = ImageCache.getIcon(iconName);
            if (icon != null) {
                partnerLinkNode.setIcon(icon);
            } else {
                URL url = Helper.newURL((URL)BPELAddin.getPartnerLinkIconsDirectory(), (String)iconName);
                if (Helper.exists((URL)url)) {
                    partnerLinkNode.setIcon(new ImageIcon(url));
                }
            }
            partnerLinkNode.setIconName(iconName);
        }
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        Process process = model.getProcess();
        PartnerLinks pls = null;
        pls = s != null ? s.getPartnerLinks() : process.getPartnerLinks();
        List filter = new ArrayList();
        if (pls != null) {
            filter = pls.getPartnerLinks();
        }
        if ((dlg = new PartnerLinkDialog(GraphUtils.getFrame((Component)((Object)this)), this, partnerLinkNode)).create(filter, wsdlLocation, obj) != 0) {
            return null;
        }
        if (dropPoint == null && (sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)this))) != null) {
            JViewport vp = sp.getViewport();
            Rectangle vpRect = vp.getViewRect();
            dropPoint = new Point(5, vpRect.y + vpRect.height / 2 - 20);
        }
        PartnerLink plink = dlg.getPartnerLink();
        plink.getValidationReport(new ValidationContext(process), true);
        if (s != null) {
            s.addPartnerLink(plink);
        } else {
            process.addPartnerLink(plink);
        }
        partnerLinkNode.setDropPoint(dropPoint);
        partnerLinkNode.setUserObject(plink);
        if (v == null) {
            v = this.getLeftSwimLaneView();
        }
        Node n = v.getNode();
        model.addChildNode(n, (Node)partnerLinkNode);
        return plink;
    }

    public PartnerLink createPartnerLink(SwimLaneView v, Point dropPoint, Scope s) {
        return this.createPartnerLink(v, dropPoint, s, null);
    }

    public BPELProject getBPELProject() {
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        if (model != null) {
            return model.getBPELProject();
        }
        return null;
    }

    public BPELXmlModel getBPELXmlModel() {
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        if (model != null) {
            return model.getBPELXmlModel();
        }
        return null;
    }

    public void adjustPortConnectionPositions() {
        SwimLaneView v = this.getLeftSwimLaneView();
        if (v != null) {
            v.adjustPortConnectionPositions();
        }
        if ((v = this.getRightSwimLaneView()) != null) {
            v.adjustPortConnectionPositions();
        }
    }

    public boolean getValidateOnLoad() {
        BPELSettings settings = this.getSettings();
        return settings.m_bValidateOnLoad;
    }

    public void deleteGraphElement(GraphElement graphElem, boolean bAllowMessageDialogs) {
        if (!graphElem.canDelete()) {
            throw new IllegalArgumentException("GraphElement not deletable!");
        }
        if (graphElem instanceof NodeRenderer) {
            NodeRenderer r;
            if (this.m_lastNodeRenderer == graphElem) {
                this.m_lastNodeRenderer = null;
            }
            if ((r = (NodeRenderer)graphElem).isEditing()) {
                String msg = BPELStringTranslator.getString("CANNOT_DELETE_ACTIVITY_EDITED");
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg, (int)0);
                return;
            }
            if (this.hasChildrenBeingEdited(r)) {
                String msg = BPELStringTranslator.getString("CANNOT_DELETE_ACTIVITY_CHILD_EDITED");
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg, (int)0);
                return;
            }
        }
        if (this.inDrillDownMode() && this.getDrillDownRenderer() == graphElem) {
            this.popDrillDownRenderer();
        }
        if (this.m_magnifiedViews.contains(graphElem)) {
            this.m_magnifiedViews.remove(graphElem);
        }
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            if (!plugin.handleDeleteGraphElement(this, graphElem)) continue;
            return;
        }
        if (this.handleGraphElementDelete(graphElem)) {
            return;
        }
        if (graphElem instanceof NoteView) {
            this.deleteNoteView((NoteView)graphElem);
        } else if (graphElem instanceof PartnerLinkView) {
            this.deletePartnerLinkView((PartnerLinkView)graphElem, bAllowMessageDialogs);
        } else if (graphElem instanceof CatchView) {
            this.deleteCatchView((CatchView)graphElem);
        } else if (graphElem instanceof CompensationHandlerView) {
            this.deleteCompensationHandlerView((CompensationHandlerView)graphElem);
        } else if (graphElem instanceof CatchAllView) {
            this.deleteCatchAllView((CatchAllView)graphElem);
        } else if (graphElem instanceof OnAlarmView) {
            this.deleteOnAlarmView((OnAlarmView)graphElem);
        } else if (graphElem instanceof OnMessageView) {
            this.deleteOnMessageView((OnMessageView)graphElem);
        } else if (graphElem instanceof SequenceView) {
            this.deleteSequenceView((SequenceView)graphElem);
        } else if (graphElem instanceof NodeRenderer) {
            this.deleteNodeRenderer((NodeRenderer)graphElem);
        } else if (graphElem instanceof EdgeRenderer) {
            this.deletePartnerLinkConnection(((EdgeRenderer)graphElem).getEdge());
        }
    }

    protected boolean handleGraphElementDelete(GraphElement elem) {
        return false;
    }

    public AnalysisPanel createAnalysisPanel() {
        this.m_analysisPnl = new AnalysisPanel(this);
        return this.m_analysisPnl;
    }

    public void addMagnifyView(NodeRenderer r) {
        if (!this.m_magnifiedViews.contains(r)) {
            this.m_magnifiedViews.add(r);
            this.repaint();
        }
    }

    public void removeMagnifyView(NodeRenderer r) {
        if (this.m_magnifiedViews.contains(r)) {
            this.m_magnifiedViews.remove(r);
            this.repaint();
        }
    }

    protected void setPaintDragImage(String text, Point pt, Icon icon, boolean bHighLight) {
        this.m_dragPoint = pt;
        this.m_dragIcon = icon;
        this.m_dragText = text;
        this.m_dragHighLight = bHighLight;
        this.repaint();
    }

    protected void handleHelp() {
    }

    protected boolean isPortDraggingEnabled() {
        return true;
    }

    protected boolean hasChildrenBeingEdited(NodeRenderer r) {
        if (r.isEditing()) {
            return true;
        }
        Iterator it = r.getChildren();
        while (it.hasNext()) {
            NodeRenderer child = (NodeRenderer)it.next();
            if (child.isEditing()) {
                return true;
            }
            if (!this.hasChildrenBeingEdited(child)) continue;
            return true;
        }
        if (r instanceof ScopeView || r instanceof ProcessView) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (r instanceof ScopeView) {
                ScopeView sv = (ScopeView)r;
                l.addAll(sv.m_faultHandlerViews);
                l.addAll(sv.m_eventHandlerViews);
                if (sv.m_compensationHandlerView != null) {
                    l.add(sv.m_compensationHandlerView);
                }
            } else {
                ProcessView pv = (ProcessView)r;
                l.addAll(pv.m_faultHandlerViews);
                l.addAll(pv.m_eventHandlerViews);
                if (pv.m_compensationHandlerView != null) {
                    l.add(pv.m_compensationHandlerView);
                }
            }
            for (NodeRenderer nodeRenderer : l) {
                if (nodeRenderer.isEditing()) {
                    return true;
                }
                if (!this.hasChildrenBeingEdited(nodeRenderer)) continue;
                return true;
            }
        }
        return false;
    }

    public void deleteNodeRenderer(NodeRenderer graphElem) {
        if (this.getSelectedGraphElement() == graphElem) {
            this.deselectGraphElement(new Point(0, 0));
        }
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        this.deleteChildEdges(graphElem, true);
        NodeRenderer parent = graphElem.getParent();
        Node childNode = graphElem.getNode();
        if (parent != null) {
            Object parentUserObj = parent.getNode().getUserObject();
            Object childUserObj = childNode.getUserObject();
            if (parentUserObj instanceof ContainerActivity && childUserObj instanceof Activity) {
                ContainerActivity container = (ContainerActivity)parentUserObj;
                try {
                    container.deleteActivity((Activity)childUserObj);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)((Object)this), (Throwable)e);
                    return;
                }
            }
            model.deleteNode(parent.getNode(), childNode);
        } else {
            model.deleteNode(null, childNode);
        }
    }

    protected void deleteSequenceView(SequenceView graphElem) {
        FlowView fv;
        NodeRenderer parent = graphElem.getParent();
        if (parent instanceof FlowView && (fv = (FlowView)parent).getChildCount() <= 1) {
            String msg = BPELStringTranslator.getString("COLLAXALAF_SEQUENCE_DELETE_MESSAGE", "Cannot delete the Sequence because the Flow will become invalid!");
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg, (int)0);
            return;
        }
        this.deleteNodeRenderer((NodeRenderer)graphElem);
    }

    protected void deleteCatchView(CatchView graphElem) {
        this.deleteChildEdges((NodeRenderer)graphElem, true);
        NodeRenderer parent = graphElem.getParent();
        if (parent instanceof ScopeView) {
            ((ScopeView)parent).deleteCatchView(graphElem);
        } else if (parent instanceof ProcessView) {
            ((ProcessView)parent).deleteCatchView(graphElem);
        }
    }

    protected void deleteCompensationHandlerView(CompensationHandlerView graphElem) {
        this.deleteChildEdges((NodeRenderer)graphElem, true);
        NodeRenderer parent = graphElem.getParent();
        if (parent instanceof ScopeView) {
            ((ScopeView)parent).deleteCompensationHandlerView(graphElem);
        } else if (parent instanceof ProcessView) {
            ((ProcessView)parent).deleteCompensationHandlerView(graphElem);
        }
    }

    protected void deleteCatchAllView(CatchAllView graphElem) {
        this.deleteChildEdges((NodeRenderer)graphElem, true);
        NodeRenderer parent = graphElem.getParent();
        if (parent instanceof ScopeView) {
            ((ScopeView)parent).deleteCatchAllView(graphElem);
        } else if (parent instanceof ProcessView) {
            ((ProcessView)parent).deleteCatchAllView(graphElem);
        }
    }

    protected void deleteOnAlarmView(OnAlarmView graphElem) {
        this.deleteChildEdges((NodeRenderer)graphElem, true);
        NodeRenderer parent = graphElem.getParent();
        if (parent instanceof ScopeView) {
            ScopeView scopeView = (ScopeView)parent;
            scopeView.deleteOnAlarmView(graphElem);
        } else if (parent instanceof ProcessView) {
            ProcessView processView = (ProcessView)parent;
            processView.deleteOnAlarmView(graphElem);
        } else {
            if (parent instanceof PickView) {
                OnAlarm alarm = (OnAlarm)graphElem.getNode().getUserObject();
                Pick pick = (Pick)parent.getNode().getUserObject();
                try {
                    pick.deleteOnAlarm(alarm);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)((Object)this), (Throwable)e);
                }
            }
            this.executeBasicDelete((GraphElement)graphElem);
        }
    }

    protected void deleteOnMessageView(OnMessageView graphElem) {
        NodeRenderer parent = graphElem.getParent();
        if (parent instanceof ScopeView) {
            this.deleteChildEdges((NodeRenderer)graphElem, true);
            ScopeView scopeView = (ScopeView)parent;
            scopeView.deleteOnMessageView(graphElem);
        } else if (parent instanceof ProcessView) {
            this.deleteChildEdges((NodeRenderer)graphElem, true);
            ProcessView processView = (ProcessView)parent;
            processView.deleteOnMessageView(graphElem);
        } else {
            if (parent instanceof PickView) {
                PickView pv = (PickView)parent;
                PickNode pickNode = (PickNode)pv.getNode();
                List messages = pickNode.getOnMessageNodes();
                if (messages.size() <= 1) {
                    String msg = BPELStringTranslator.getString("COLLAXALAF_CANNOT_DELETE_ONMESSAGE", "Cannot delete the OnMessage because the Pick will become invalid!");
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg, (int)0);
                    return;
                }
                this.deleteChildEdges((NodeRenderer)graphElem, true);
                OnMessage msg = (OnMessage)graphElem.getNode().getUserObject();
                Pick pick = (Pick)parent.getNode().getUserObject();
                try {
                    pick.deleteOnMessage(msg);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)((Object)this), (Throwable)e);
                }
            }
            this.executeBasicDelete((GraphElement)graphElem);
        }
    }

    protected void deleteChildEdges(NodeRenderer r, boolean bRecurse) {
        Object pv;
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        Iterator it = r.getChildren();
        while (it.hasNext()) {
            NodeRenderer childRenderer = (NodeRenderer)it.next();
            if (childRenderer instanceof PortView) {
                pv = (PortView)childRenderer;
                PortNode portNode = (PortNode)pv.getNode();
                Edge[] edges = model.getEdgesForPort(portNode);
                if (edges == null) continue;
                for (Edge e : edges) {
                    PortNode partnerLinkPortNode;
                    PortNode src = e.getSource();
                    PortNode target = e.getTarget();
                    PortNode portNode2 = partnerLinkPortNode = src != portNode ? src : target;
                    if (partnerLinkPortNode == null) continue;
                    model.deleteNode(partnerLinkPortNode.getParentNode(), (Node)partnerLinkPortNode);
                }
                continue;
            }
            if (!bRecurse) continue;
            this.deleteChildEdges(childRenderer, true);
        }
        if (r instanceof ScopeView || r instanceof ProcessView) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (r instanceof ScopeView) {
                ScopeView sv = (ScopeView)r;
                l.addAll(sv.m_faultHandlerViews);
                l.addAll(sv.m_eventHandlerViews);
                if (sv.m_compensationHandlerView != null) {
                    l.add(sv.m_compensationHandlerView);
                }
            } else {
                pv = (ProcessView)r;
                l.addAll(((ProcessView)pv).m_faultHandlerViews);
                l.addAll(((ProcessView)pv).m_eventHandlerViews);
                if (((ProcessView)pv).m_compensationHandlerView != null) {
                    l.add(((ProcessView)pv).m_compensationHandlerView);
                }
            }
            for (NodeRenderer nodeRenderer : l) {
                if (nodeRenderer instanceof PortView) {
                    this.deletePortsAndEdge((PortView)nodeRenderer);
                    continue;
                }
                if (!bRecurse) continue;
                this.deleteChildEdges(nodeRenderer, true);
            }
        }
    }

    protected void deletePortsAndEdge(PortView pv) {
        PortNode pn;
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        Edge[] edges = model.getEdgesForPort(pn = (PortNode)pv.getNode());
        if (edges == null) {
            return;
        }
        for (Edge e : edges) {
            PortNode partnerLinkPortNode;
            PortNode src = e.getSource();
            PortNode target = e.getTarget();
            PortNode portNode = partnerLinkPortNode = src != pn ? src : target;
            if (partnerLinkPortNode == null) continue;
            model.deleteNode(partnerLinkPortNode.getParentNode(), (Node)partnerLinkPortNode);
        }
    }

    protected int showConfirmDialog(GraphElement graphElem) {
        if (!this.getSettings().m_bConfirmDeletions) {
            return 0;
        }
        if (graphElem instanceof PartnerLinkView) {
            return GraphUtils.showConfirmDialogNoAsDefault((Component)GraphUtils.getFrame((Component)((Object)this)), (String)MessageBundleUtil.getCommonString((String)"GRAPHPANE_DEL_PARTNERLINK"), (String)MessageBundleUtil.getCommonString((String)"GRAPHPANE_DEL_TASK"));
        }
        return super.showConfirmDialog(graphElem);
    }

    protected void deletePartnerLinkView(PartnerLinkView r, boolean bConfirmDelete) {
        PartnerLinkNode n;
        PartnerLink link;
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        BPELXmlModel mainModel = model.getBPELXmlModel();
        WSDLModel wsdlModel = mainModel.getWSDLModel();
        if (wsdlModel.canPartnerLinkWSDLBeDeleted(link = (PartnerLink)(n = (PartnerLinkNode)r.getNode()).getUserObject())) {
            boolean bDeleteWSDL = true;
            if (bConfirmDelete) {
                String msg = BPELStringTranslator.getString("COLLAXALAF_DELETE_WSDL_MSG");
                String title = BPELStringTranslator.getString("COLLAXALAF_CONFIRM_DELETE");
                boolean bl = bDeleteWSDL = GraphUtils.showConfirmDialog((Component)IDEResolver.getIDE().getFrame(), (String)msg, (String)title) == 0;
            }
            if (bDeleteWSDL) {
                wsdlModel.deletePartnerLinkWSDL(link);
            }
        }
        Node childNode = r.getNode();
        NodeRenderer parent = r.getParent();
        if (parent != null) {
            Process p;
            Scope s;
            Object childUserObj = childNode.getUserObject();
            if (childUserObj instanceof PartnerLink && (s = BPELModelUtil.getScopeForPartnerLink((Process)(p = model.getProcess()), (PartnerLink)((PartnerLink)childUserObj))) != null) {
                s.deletePartnerLink((PartnerLink)childUserObj);
                List activities = BPELModelUtil.updatePartnerLinkReference((Scope)p, (String)((PartnerLink)childUserObj).getName(), null);
                BPELModelUtil.validateActivities((Process)p, (List)activities);
            }
            model.deleteNode(parent.getNode(), childNode);
        }
    }

    protected void deleteNoteView(NoteView v) {
        Scope s = (Scope)v.getNode().getUserObject();
        s.setUserComment("");
        this.forceImmediateLayout(false);
    }

    protected void deletePartnerLinkConnection(Edge edge) {
        Node activityNode = this.getActivityNode(edge.getSource(), edge.getTarget());
        PortNode partnerLinkPortNode = this.getPartnerLinkPortNode(edge);
        if (activityNode instanceof InvokeNode) {
            Invoke invoke = (Invoke)activityNode.getUserObject();
            invoke.setPartnerLink(null);
            invoke.setPortType(null);
            invoke.setOperation(null);
        } else if (activityNode instanceof ReplyNode) {
            Reply reply = (Reply)activityNode.getUserObject();
            reply.setPartnerLink(null);
            reply.setPortType(null);
            reply.setOperation(null);
        } else if (activityNode instanceof ReceiveNode) {
            Receive receive = (Receive)activityNode.getUserObject();
            receive.setPartnerLink(null);
            receive.setPortType(null);
            receive.setOperation(null);
        }
        this.getModel().deleteEdges(new Edge[]{edge});
        if (partnerLinkPortNode != null) {
            BPELGraphModel model = (BPELGraphModel)this.getModel();
            model.deleteNode(partnerLinkPortNode.getParentNode(), (Node)partnerLinkPortNode);
        }
    }

    protected PortNode getPartnerLinkPortNode(Edge e) {
        PortNode src = e.getSource();
        if (src.getParentNode() instanceof PartnerLinkNode) {
            return src;
        }
        PortNode target = e.getTarget();
        if (target.getParentNode() instanceof PartnerLinkNode) {
            return target;
        }
        return null;
    }

    protected Node getActivityNode(PortNode src, PortNode target) {
        Node parent = src.getParentNode();
        if (parent instanceof InvokeNode || parent instanceof ReplyNode || parent instanceof ReceiveNode) {
            return parent;
        }
        parent = target.getParentNode();
        if (parent instanceof InvokeNode || parent instanceof ReplyNode || parent instanceof ReceiveNode) {
            return parent;
        }
        return null;
    }

    public String getSelectedXPath() {
        BPELGraphModel model;
        Process process;
        Object obj;
        PartnerLinkView v;
        Node n;
        Activity a = this.getSelectedActivity();
        if (a != null) {
            return BPELModelUtil.getXPathForActivity((Activity)a);
        }
        GraphElement elem = this.getSelectedGraphElement();
        if (elem instanceof PartnerLinkView && (n = (v = (PartnerLinkView)elem).getNode()) != null && (obj = v.getNode().getUserObject()) instanceof PartnerLink && (process = (model = (BPELGraphModel)this.getModel()).getProcess()) != null) {
            return BPELModelUtil.getXPathForPartnerLink((Process)process, (PartnerLink)((PartnerLink)obj));
        }
        return null;
    }

    public PartnerLink getSelectedPartnerLink() {
        GraphElement elem = this.getSelectedGraphElement();
        if (elem instanceof PartnerLinkView) {
            PartnerLinkView v = (PartnerLinkView)elem;
            return (PartnerLink)v.getNode().getUserObject();
        }
        return null;
    }

    public Activity getSelectedActivity() {
        GraphElement elem = this.getSelectedGraphElement();
        if (!(elem instanceof NodeRenderer)) {
            return null;
        }
        NodeRenderer r = (NodeRenderer)elem;
        Node n = r.getNode();
        if (n == null) {
            return null;
        }
        Object obj = n.getUserObject();
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        return null;
    }

    public boolean canCopy() {
        GraphElement elem = this.getSelectedGraphElement();
        if (!(elem instanceof NodeRenderer)) {
            return false;
        }
        NodeRenderer r = (NodeRenderer)elem;
        Node n = r.getNode();
        switch (n.getNodeType()) {
            case 106: 
            case 107: 
            case 115: 
            case 116: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(GraphModel model) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.m_model != null && this.m_internalModelListener != null) {
                this.m_model.removeGraphModelListener((GraphModelListener)this.m_internalModelListener);
            }
            super.setModel(model);
            if (model != null) {
                this.m_internalModelListener = new InternalGraphModelListener();
                model.addGraphModelListener((GraphModelListener)this.m_internalModelListener);
            }
        }
    }

    public int showPropertiesDialog() {
        BPELPropertiesDialog dlg = new BPELPropertiesDialog(GraphUtils.getFrame((Component)((Object)this)), this);
        return dlg.display();
    }

    public void showDropZones(boolean bShow) {
        this.m_bShowDropZones = bShow;
        this.repaint();
    }

    public boolean getShowDropZones() {
        return this.m_bShowDropZones;
    }

    public void addEndpointConnectionListener(PartnerLinkListener l) {
        this.m_endpointConnectionListenerList.add(PartnerLinkListener.class, l);
    }

    public void removeEndpointConnectionListener(PartnerLinkListener l) {
        this.m_endpointConnectionListenerList.remove(PartnerLinkListener.class, l);
    }

    public void showEndPointConnections(boolean bShow) {
        this.m_bShowEndpointConnections = bShow;
        for (EdgeRenderer r : this.m_edgeRenderers) {
            r.setVisible(bShow);
        }
        this.repaint();
    }

    public boolean getShowEndPointConnections() {
        return this.m_bShowEndpointConnections;
    }

    public void setLinkNodeRenderer(NodeRenderer v) {
        this.m_linkingNodeRenderer = v;
    }

    public NodeRenderer getLinkView() {
        return this.m_linkingNodeRenderer;
    }

    public synchronized void showLoading(boolean bShow, String mainMsg, String subMsg) {
        this.m_bShowLoading = bShow;
        if (bShow) {
            this.m_mainMessage = mainMsg;
            this.m_subMessage = subMsg;
            new Painter();
        }
        Rectangle visRect = this.getVisibleRect();
        this.paintImmediately(visRect.x, visRect.y, visRect.width, visRect.height);
    }

    public void displayDiagram() {
        super.showLoading(false);
    }

    public void showLoading(boolean bShow) {
    }

    protected void paintGraph(Graphics g, double zoomFactor, boolean bCenterZoom) {
        this.paintDiagram(g, this.getZoom(), this.getZoomCentered());
        if (OverViewPanel.getInstance().getPaintDiagramStructure()) {
            this.paintOverviewImage();
            OverViewPanel.getInstance().updateDisplay();
        }
    }

    protected void paintOverviewImage() {
        if (!this.m_bPaintOverView) {
            return;
        }
        Rectangle bounds = new Rectangle(0, 0, this.m_prefDim.width, this.m_prefDim.height);
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        Dimension scaledDim = OverViewPanel.getInstance().computeScaledDimension();
        if (scaledDim == null) {
            return;
        }
        if (this.m_bufImage == null || scaledDim.width != this.m_bufImage.getWidth(null) || scaledDim.height != this.m_bufImage.getHeight(null)) {
            if (scaledDim.width <= 0 || scaledDim.height <= 0) {
                return;
            }
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration config = device.getDefaultConfiguration();
            this.m_bufImage = config.createCompatibleImage(scaledDim.width, scaledDim.height);
        }
        if (this.m_bufImage != null) {
            Graphics offGraphics = this.m_bufImage.getGraphics();
            offGraphics.setColor(Color.white);
            offGraphics.fillRect(0, 0, bounds.width, bounds.height);
            offGraphics.setClip(0, 0, bounds.width, bounds.height);
            double scaledZoom = scaledDim.width > scaledDim.height ? (double)scaledDim.width / (double)bounds.width : (double)scaledDim.height / (double)bounds.height;
            this.paintDiagram(offGraphics, scaledZoom, false);
            this.m_bPaintOverView = false;
        }
    }

    public void paintDiagram(Graphics g, double zoomFactor, boolean bCenterZoom) {
        super.paintGraph(g, zoomFactor, bCenterZoom);
        if (this.m_linkingNodeRenderer != null) {
            Rectangle r = this.m_linkingNodeRenderer.getBounds();
            GraphUtils.drawLine((Graphics)g, (int)(r.x + r.width / 2), (int)(r.y + r.height / 2), (int)this.m_mousePt.x, (int)this.m_mousePt.y, (float)4.0f, (Color)FLOW_LINK_COLOR);
        }
        if (this.m_draggedPortConnection != null) {
            Image img;
            Point draggedPortPt = new Point(this.m_draggedPortConnection.getBounds().x, this.m_draggedPortConnection.getBounds().y);
            draggedPortPt.x = (int)((double)(draggedPortPt.x + this.m_xTranslation) * zoomFactor);
            draggedPortPt.y = (int)((double)(draggedPortPt.y + this.m_yTranslation) * zoomFactor);
            Point portConnectionPt = this.m_draggedPortConnection.getConnectionPoint();
            portConnectionPt.x = (int)((double)(portConnectionPt.x + this.m_xTranslation) * zoomFactor);
            portConnectionPt.y = (int)((double)(portConnectionPt.y + this.m_yTranslation) * zoomFactor);
            boolean bDraggingToRight = this.m_mousePt.x > draggedPortPt.x;
            int nonZoomMouseX = (int)((double)this.m_mousePt.x / zoomFactor) - this.m_xTranslation;
            int nonZoomMouseY = (int)((double)this.m_mousePt.y / zoomFactor);
            if (bDraggingToRight) {
                GraphUtils.drawLine((Graphics)g, (int)portConnectionPt.x, (int)portConnectionPt.y, (int)this.m_mousePt.x, (int)(this.m_mousePt.y - PORT_SIZE / 2), (float)3.0f, (Color)this.m_portConnectionColor);
                img = this.m_draggedPortConnection.getDragImage(nonZoomMouseX, nonZoomMouseY);
                if (img != null) {
                    g.drawImage(img, this.m_mousePt.x, this.m_mousePt.y - PORT_SIZE, null);
                }
            } else {
                GraphUtils.drawLine((Graphics)g, (int)portConnectionPt.x, (int)portConnectionPt.y, (int)this.m_mousePt.x, (int)(this.m_mousePt.y - PORT_SIZE / 2), (float)3.0f, (Color)this.m_portConnectionColor);
                img = this.m_draggedPortConnection.getDragImage(nonZoomMouseX, nonZoomMouseY);
                if (img != null) {
                    g.drawImage(img, this.m_mousePt.x - PORT_SIZE, this.m_mousePt.y - PORT_SIZE, null);
                }
            }
        }
        if (this.m_partnerLinkDragBox != null) {
            this.paintPartnerLinkDragBox(g, this.m_partnerLinkDragBox);
        }
        if (this.m_dragPoint != null && this.m_dragIcon != null) {
            Font f = UIManager.getFont("Label.font");
            int fontHeight = GraphUtils.getFontHeight((Font)f);
            int ascent = GraphUtils.getFontAscent((Font)f);
            int strWidth = GraphUtils.getStringWidth((Font)f, (String)this.m_dragText);
            int spacing = 5;
            Point p = this.m_dragPoint;
            int padding = 10;
            int xOffset = 15;
            int yOffset = 5;
            Rectangle r = new Rectangle(p.x + xOffset, p.y + yOffset, Math.max(strWidth, this.m_dragIcon.getIconWidth()) + 2 * padding, padding + this.m_dragIcon.getIconHeight() + spacing + fontHeight + padding);
            if (r.width < 100) {
                r.width = 100;
            }
            GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)r, (Color)(this.m_dragHighLight ? Color.yellow : Color.white), (float)0.8f);
            int thickness = this.m_dragHighLight ? 2 : 1;
            Color clr = this.m_dragHighLight ? Color.black : Color.cyan;
            GraphUtils.drawRect((Graphics)g, (int)r.x, (int)r.y, (int)r.width, (int)r.height, (int)thickness, (Color)clr);
            xOffset = (r.width - this.m_dragIcon.getIconWidth()) / 2;
            this.m_dragIcon.paintIcon((Component)((Object)this), g, r.x + xOffset, r.y + padding);
            g.setFont(f);
            g.setColor(Color.black);
            xOffset = (r.width - strWidth) / 2;
            g.drawString(this.m_dragText, r.x + xOffset, r.y + padding + this.m_dragIcon.getIconHeight() + spacing + ascent);
        }
        for (NodeRenderer nodeRenderer : this.m_magnifiedViews) {
            if (!(nodeRenderer instanceof Magnifiable)) continue;
            Magnifiable v = (Magnifiable)nodeRenderer;
            v.paintMagnified(g);
        }
        if (this.m_groupRect != null) {
            GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)this.m_groupRect, (Color)Color.cyan, (float)0.2f);
            g.setColor(Color.blue);
            g.drawRect(this.m_groupRect.x, this.m_groupRect.y, this.m_groupRect.width, this.m_groupRect.height);
        }
    }

    public Image getPaneImage() {
        return this.m_bufImage;
    }

    public void doPaste() {
        try {
            Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipBoard.getContents(this);
            Object data = transferable.getTransferData(ViewTransferable.DATA_FLAVOR);
            if (!(data instanceof Node)) {
                System.err.println("Can paste data of type:" + data + " to this graph!");
                return;
            }
            this.handlePaste(((Node)data).createCopy());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handlePaste(Node newNode) {
        GraphElement elem = this.getSelectedGraphElement();
        if (elem == null) {
            return;
        }
        if (!(elem instanceof NodeRenderer)) {
            return;
        }
        NodeRenderer r = (NodeRenderer)elem;
        boolean bCollapsed = r.isCollapsed();
        Node selNode = r.getNode();
        Node parentNode = selNode.getParentNode();
        GraphModel model = this.getModel();
        if (bCollapsed) {
            if (parentNode instanceof DroppableBranchNode) {
                DroppableBranchNode droppableParent = (DroppableBranchNode)parentNode;
                int selectedIndex = parentNode.indexOf(selNode);
                if (selectedIndex < 1) {
                    return;
                }
                Node prevNode = parentNode.getChildNode(selectedIndex - 1);
                if (prevNode.getNodeType() != 0) {
                    return;
                }
                model.insertChildNode((Node)droppableParent, newNode, selectedIndex + 1);
            }
        } else if (selNode instanceof DroppableBranchNode) {
            model.insertChildNode(selNode, newNode, 0);
        } else if (parentNode instanceof DroppableBranchNode) {
            DroppableBranchNode droppableParent = (DroppableBranchNode)parentNode;
            int selectedIndex = parentNode.indexOf(selNode);
            if (selectedIndex < 1) {
                return;
            }
            Node prevNode = parentNode.getChildNode(selectedIndex - 1);
            if (prevNode.getNodeType() != 0) {
                return;
            }
            model.insertChildNode((Node)droppableParent, newNode, selectedIndex + 1);
        }
    }

    protected void paintPartnerLinkDragBox(Graphics g, PartnerLinkDragBox dragBox) {
        g.setColor(Color.white);
        Rectangle bounds = new Rectangle(dragBox.m_bounds.x, dragBox.m_bounds.y, dragBox.m_bounds.width, dragBox.m_bounds.height);
        g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, 10, 10);
        g.setColor(Color.black);
        g.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, 10, 10);
    }

    protected Dimension layoutGraph(boolean bBuildTabTree) {
        JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, (Component)((Object)this));
        Dimension sz = vp.getSize();
        Rectangle visibleRect = new Rectangle(0, 0, sz.width, sz.height);
        if (this.m_lastLayoutDimensions.width >= 0 && this.m_lastLayoutDimensions.height >= 0 && this.m_lastLayoutDimensions.width == visibleRect.width && this.m_lastLayoutDimensions.height == visibleRect.height) {
            this.computeTranslation(this.getDocumentBounds());
            return this.m_prefDim;
        }
        Dimension dim = super.layoutGraph(bBuildTabTree);
        this.adjustPortConnectionPositions();
        this.layoutEdges();
        this.autoRoutePartnerLinks();
        this.m_bPaintOverView = true;
        if (this.m_analysisPnl != null) {
            this.m_analysisPnl.refresh();
        }
        return dim;
    }

    protected void autoRoutePartnerLinks() {
        SwimLaneView right;
        SwimLaneView left = this.getLeftSwimLaneView();
        if (left != null) {
            left.autoRouteEdges();
        }
        if ((right = this.getRightSwimLaneView()) != null) {
            right.autoRouteEdges();
        }
    }

    protected void paintEdges(Graphics g) {
        if (this.getSwimLanesVisible() && this.getShowEndPointConnections()) {
            super.paintEdges(g);
        }
    }

    protected void unloadGraphElements() {
        this.m_partnerLinkDragBox = null;
        if (this.m_magnifiedViews != null) {
            this.m_magnifiedViews.clear();
        }
        super.unloadGraphElements();
    }

    protected void clearHighLightedPartnerLink() {
        if (this.m_highLightedPartnerLinkView != null) {
            this.m_highLightedPartnerLinkView.setHighLighted(false);
            this.m_highLightedPartnerLinkView = null;
        }
    }

    protected void handlePortDrag(MouseEvent evt) {
        int y;
        int x;
        boolean bDraggingToRight;
        BPELSettings settings = this.getSettings();
        this.clearHighLightedPartnerLink();
        this.m_mousePt.setLocation(new Point(evt.getX(), evt.getY()));
        this.m_portConnectionColor = settings.m_unConnectedPartnerLinkColor;
        if (this.m_draggedPortConnection == null) {
            return;
        }
        double zoomFactor = this.getZoom();
        int draggedPortX = (int)((double)(this.m_draggedPortConnection.getBounds().x + this.m_xTranslation) * zoomFactor);
        Rectangle hotSpot = new Rectangle();
        boolean bl = bDraggingToRight = this.m_mousePt.x > draggedPortX;
        if (bDraggingToRight) {
            hotSpot.setBounds(this.m_mousePt.x, this.m_mousePt.y - PORT_SIZE, PORT_SIZE, PORT_SIZE);
            x = hotSpot.x + hotSpot.width / 2;
            y = hotSpot.y + hotSpot.height / 2;
        } else {
            hotSpot.setBounds(this.m_mousePt.x - PORT_SIZE, this.m_mousePt.y - PORT_SIZE, PORT_SIZE, PORT_SIZE);
            x = hotSpot.x + hotSpot.width / 2;
            y = hotSpot.y + hotSpot.height / 2;
        }
        Point zoomPoint = this.convertToNonScaledTranslatedCoordinates(new Point(x, y));
        NodeRenderer v = this.getNodeRendererAtPosition(zoomPoint.x, zoomPoint.y);
        if (v != null && v.getNode().getNodeType() == 111) {
            this.m_highLightedPartnerLinkView = (PartnerLinkView)v;
            this.m_highLightedPartnerLinkView.setHighLighted(true);
            this.m_portConnectionColor = settings.m_connectablePartnerLinkColor;
        }
        this.repaint();
    }

    protected void handlePartnerLinkDrag(MouseEvent e) {
        boolean bDragInitiatied;
        this.clearHighLightedPartnerLink();
        int tolerance = 5;
        int startDragY = this.m_partnerLinkDragBox.m_dragStartPoint.y;
        boolean bl = bDragInitiatied = this.m_mousePt.y < startDragY - tolerance || this.m_mousePt.y > startDragY + tolerance;
        if (!this.m_partnerLinkDragBox.m_bDragStarted && bDragInitiatied) {
            this.m_partnerLinkDragBox.m_bDragStarted = true;
        }
        if (!this.m_partnerLinkDragBox.m_bDragStarted) {
            return;
        }
        int y = this.m_mousePt.y - this.m_partnerLinkDragBox.m_yGrabOffset;
        double zoomFactor = this.getZoom();
        Rectangle bounds = this.m_partnerLinkDragBox.m_view.getBounds();
        int scaledYTranslation = (int)((double)this.m_yTranslation * zoomFactor);
        int nonZoomYPos = y - scaledYTranslation;
        int graphYPos = (int)((double)nonZoomYPos / zoomFactor);
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle docBounds = this.getDocumentBounds();
        int boundaryPadding = 20;
        if (graphYPos < boundaryPadding) {
            graphYPos = boundaryPadding;
        } else if (graphYPos + bounds.height > visibleRect.y + visibleRect.height) {
            Rectangle r2 = new Rectangle(visibleRect);
            r2.y += y + bounds.height - (visibleRect.y + visibleRect.height);
            this.scrollRectToVisible(r2);
        }
        if (graphYPos + bounds.height > docBounds.y + docBounds.height - boundaryPadding) {
            graphYPos = docBounds.y + docBounds.height - bounds.height - boundaryPadding;
        }
        this.setCursor(Cursor.getPredefinedCursor(13));
        int scaledYPos = (int)((double)(graphYPos + this.m_yTranslation) * zoomFactor);
        int scaledXPos = (int)((double)(bounds.x + this.m_xTranslation) * zoomFactor);
        int scaledWidth = (int)((double)bounds.width * zoomFactor);
        int scaledHeight = (int)((double)bounds.height * zoomFactor);
        this.m_partnerLinkDragBox.m_bounds.setBounds(scaledXPos, scaledYPos, scaledWidth, scaledHeight);
        this.repaint();
    }

    protected void handlePartnerLinkRelease(MouseEvent evt) {
        this.clearHighLightedPartnerLink();
        if (this.m_partnerLinkDragBox == null || !this.m_partnerLinkDragBox.m_bDragStarted) {
            return;
        }
        int y = this.m_mousePt.y - this.m_partnerLinkDragBox.m_yGrabOffset;
        int graphYPos = evt.getY() - this.m_partnerLinkDragBox.m_yGrabOffset;
        int boundaryPadding = 20;
        Rectangle bounds = this.m_partnerLinkDragBox.m_view.getBounds();
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle docBounds = this.getDocumentBounds();
        if (graphYPos < boundaryPadding) {
            graphYPos = boundaryPadding;
        } else if (graphYPos + bounds.height > visibleRect.y + visibleRect.height) {
            Rectangle r2 = new Rectangle(visibleRect);
            r2.y += y + bounds.height - (visibleRect.y + visibleRect.height);
            this.scrollRectToVisible(r2);
        }
        if (graphYPos + bounds.height > docBounds.y + docBounds.height - boundaryPadding) {
            graphYPos = docBounds.y + docBounds.height - bounds.height - boundaryPadding;
        }
        Rectangle b = this.m_partnerLinkDragBox.m_view.getBounds();
        this.m_partnerLinkDragBox.m_view.setAbsolutePositioned(false);
        this.m_partnerLinkDragBox.m_view.move(0, graphYPos - b.y);
        this.m_partnerLinkDragBox.m_view.setAbsolutePositioned(true);
        this.m_partnerLinkDragBox = null;
        this.forceLayout();
        this.repaint();
    }

    protected void handlePortRelease(MouseEvent evt) {
        NodeRenderer parent;
        int y;
        int x;
        boolean bDraggingToRight;
        if (this.m_draggedPortConnection == null) {
            return;
        }
        double zoomFactor = this.getZoom();
        Point zoomDraggedPortConnection = new Point(this.m_draggedPortConnection.getBounds().x, this.m_draggedPortConnection.getBounds().y);
        zoomDraggedPortConnection.x = (int)((double)zoomDraggedPortConnection.x * zoomFactor);
        zoomDraggedPortConnection.y = (int)((double)zoomDraggedPortConnection.y * zoomFactor);
        Rectangle hotSpot = new Rectangle();
        boolean bl = bDraggingToRight = this.m_mousePt.x > zoomDraggedPortConnection.x;
        if (bDraggingToRight) {
            hotSpot.setBounds(this.m_mousePt.x, this.m_mousePt.y - PORT_SIZE, PORT_SIZE, PORT_SIZE);
            x = hotSpot.x + hotSpot.width / 2;
            y = hotSpot.y + hotSpot.height / 2;
        } else {
            hotSpot.setBounds(this.m_mousePt.x - PORT_SIZE, this.m_mousePt.y - PORT_SIZE, PORT_SIZE, PORT_SIZE);
            x = hotSpot.x + hotSpot.width / 2;
            y = hotSpot.y + hotSpot.height / 2;
        }
        Point zoomPoint = this.convertToNonScaledTranslatedCoordinates(new Point(x, y));
        NodeRenderer v = this.getNodeRendererAtPosition(zoomPoint.x, zoomPoint.y);
        if (v != null && v.getNode().getNodeType() == 111 && (parent = this.m_draggedPortConnection.getParent()) != null) {
            this.m_draggedPortConnection = null;
            this.repaint();
            this.editTaskPartnerLinkConnection(parent, v);
        }
        this.m_draggedPortConnection = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
    }

    protected void editTaskPartnerLinkConnection(NodeRenderer taskRenderer, NodeRenderer partnerLinkRenderer) {
        if (!taskRenderer.isEditable()) {
            return;
        }
        NodeEditor editor = taskRenderer.getNodeEditor();
        if (editor == null) {
            return;
        }
        Component editorComp = editor.getNodeEditorComponent((GraphPane)this, taskRenderer.getNode());
        if (editorComp == null) {
            return;
        }
        editor.setNodeRenderer(taskRenderer);
        taskRenderer.setEditing(true);
        if (editor instanceof InvokeNodeEditor) {
            InvokeNodeEditor invokeEditor = (InvokeNodeEditor)editor;
            InvokeGenEditPage genPage = invokeEditor.getGeneralPage();
            PartnerLink plink = (PartnerLink)partnerLinkRenderer.getNode().getUserObject();
            Activity a = (Activity)taskRenderer.getNode().getUserObject();
            if (this.canActivityUsePartnerLink(a, plink)) {
                genPage.setPartnerLinkConnectionMode(plink.getName());
            }
        } else if (editor instanceof ReceiveViewNodeEditor) {
            ReceiveViewNodeEditor recvEditor = (ReceiveViewNodeEditor)editor;
            ReceiveGenEditPage genPage = recvEditor.getGeneralPage();
            PartnerLink plink = (PartnerLink)partnerLinkRenderer.getNode().getUserObject();
            Activity a = (Activity)taskRenderer.getNode().getUserObject();
            if (this.canActivityUsePartnerLink(a, plink)) {
                genPage.setPartnerLinkConnectionMode(plink.getName());
            }
        } else if (editor instanceof ReplyViewNodeEditor) {
            ReplyViewNodeEditor replyEditor = (ReplyViewNodeEditor)editor;
            ReplyGenEditPage genPage = replyEditor.getGeneralPage();
            PartnerLink plink = (PartnerLink)partnerLinkRenderer.getNode().getUserObject();
            Activity a = (Activity)taskRenderer.getNode().getUserObject();
            if (this.canActivityUsePartnerLink(a, plink)) {
                genPage.setPartnerLinkConnectionMode(plink.getName());
            }
        }
        new NodeEditorDialog(GraphUtils.getFrame((Component)((Object)this)), (GraphPane)this, editor, taskRenderer, editorComp).setVisible(true);
        editor.cancelNodeEditing();
    }

    protected boolean canActivityUsePartnerLink(Activity a, PartnerLink link) {
        if (!BPELModelUtil.canActivityUsePartnerLink((Activity)a, (PartnerLink)link)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("CANNOT_CONNECT_LINK"), (int)0);
            return false;
        }
        return true;
    }

    public void mouseReleased(MouseEvent evt) {
        this.clearHighLightedPartnerLink();
        super.mouseReleased(evt);
        if (this.m_draggedPortConnection != null) {
            this.handlePortRelease(evt);
        } else if (this.m_partnerLinkDragBox != null) {
            this.handlePartnerLinkRelease(evt);
        }
        if (this.m_groupRect != null) {
            int w = evt.getX() - this.m_groupRect.x;
            int h = evt.getY() - this.m_groupRect.y;
            this.m_groupRect.setBounds(this.m_groupRect.x, this.m_groupRect.y, w, h);
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int mods = e.getModifiers();
        if ((mods & 2) > 0 && this.m_groupRect != null) {
            int w = e.getX() - this.m_groupRect.x;
            int h = e.getY() - this.m_groupRect.y;
            this.m_groupRect.setBounds(this.m_groupRect.x, this.m_groupRect.y, w, h);
            this.repaint();
            return;
        }
        super.mouseDragged(e);
        this.m_mousePt.setLocation(new Point(e.getX(), e.getY()));
        if (this.m_draggedPortConnection != null) {
            this.handlePortDrag(e);
        } else if (this.m_partnerLinkDragBox != null) {
            this.handlePartnerLinkDrag(e);
        }
    }

    public void mousePressed(MouseEvent evt) {
        this.m_groupRect = null;
        int mods = evt.getModifiers();
        if ((mods & 2) > 0) {
            this.m_groupRect = new Rectangle(evt.getX(), evt.getY(), 0, 0);
            this.repaint();
            return;
        }
        super.mousePressed(evt);
        if (!this.isPortDraggingEnabled()) {
            return;
        }
        Point pt = this.convertToNonScaledTranslatedCoordinates(evt.getPoint());
        NodeRenderer target = this.getNodeRendererAtPosition(pt.x, pt.y);
        if (target instanceof PortView) {
            PortView pv = (PortView)target;
            if (!(pv.getParent() instanceof PartnerLinkView)) {
                this.m_draggedPortConnection = (PortView)target;
            }
        } else if (target instanceof PartnerLinkView) {
            this.m_partnerLinkDragBox = new PartnerLinkDragBox();
            this.m_partnerLinkDragBox.m_dragStartPoint.setLocation(pt.x, pt.y);
            this.m_partnerLinkDragBox.m_view = (PartnerLinkView)target;
            this.m_partnerLinkDragBox.m_yGrabOffset = Math.max(0, pt.y - target.getBounds().y);
        }
        if (this.m_linkingNodeRenderer != null) {
            FlowLinker linker;
            if (target != null && (linker = BPELGraphUtils.findFlowLinker(target)) != null) {
                linker.addFlowLink(this.m_linkingNodeRenderer, target);
            }
            this.setLinkNodeRenderer(null);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.m_mousePt.setLocation(e.getX(), e.getY());
        if (this.m_linkingNodeRenderer != null) {
            this.repaint();
        }
    }

    public SwimLaneView getLeftSwimLaneView() {
        for (NodeRenderer v : this.getRootNodeRenderers()) {
            if (!(v instanceof BPELView)) continue;
            BPELView bv = (BPELView)v;
            return bv.getLeftSwimLaneView();
        }
        return null;
    }

    public SwimLaneView getRightSwimLaneView() {
        for (NodeRenderer v : this.getRootNodeRenderers()) {
            if (!(v instanceof BPELView)) continue;
            BPELView bv = (BPELView)v;
            return bv.getRightSwimLaneView();
        }
        return null;
    }

    public boolean getSwimLanesVisible() {
        for (NodeRenderer v : this.getRootNodeRenderers()) {
            if (!(v instanceof BPELView)) continue;
            BPELView bv = (BPELView)v;
            return bv.getSwimLanesVisible();
        }
        return false;
    }

    public void showSwimLanes(boolean bShow) {
        boolean bDoLayout = false;
        for (NodeRenderer v : this.getRootNodeRenderers()) {
            if (!(v instanceof BPELView)) continue;
            BPELView bv = (BPELView)v;
            bv.showSwimLanes(bShow);
            bDoLayout = true;
        }
        if (bDoLayout) {
            this.forceLayout();
        }
    }

    BPELView getBPELView() {
        for (NodeRenderer v : this.getRootNodeRenderers()) {
            if (!(v instanceof BPELView)) continue;
            return (BPELView)v;
        }
        return null;
    }

    Object fireAddEndPoint() {
        Object[] listeners = this.m_endpointConnectionListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object userObj;
            if (listeners[i] != PartnerLinkListener.class || (userObj = ((PartnerLinkListener)listeners[i + 1]).addEndPoint(this)) == null) continue;
            return userObj;
        }
        return null;
    }

    public PartnerLink createPartnerLinkNode(SwimLaneView v, Point dropPoint, Scope s, PartnerLink plink) {
        JScrollPane sp;
        PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
        BPELGraphModel model = (BPELGraphModel)this.getModel();
        Process process = model.getProcess();
        if (dropPoint == null && (sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)this))) != null) {
            JViewport vp = sp.getViewport();
            Rectangle vpRect = vp.getViewRect();
            dropPoint = new Point(5, vpRect.y + vpRect.height / 2 - 20);
        }
        plink.getValidationReport(new ValidationContext(process), true);
        if (s != null) {
            s.addPartnerLink(plink);
        } else {
            process.addPartnerLink(plink);
        }
        partnerLinkNode.setDropPoint(dropPoint);
        partnerLinkNode.setUserObject(plink);
        if (v == null) {
            v = this.getLeftSwimLaneView();
        }
        Node n = v.getNode();
        model.addChildNode(n, (Node)partnerLinkNode);
        return plink;
    }

    class Painter
    implements ActionListener {
        Timer m_timer = new Timer(90, this);

        public Painter() {
            this.m_timer.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Painter painter = this;
            synchronized (painter) {
                BPELGraphPane.this.repaint();
                if (!BPELGraphPane.this.m_bShowLoading) {
                    this.m_timer.stop();
                }
                BPELGraphPane.this.m_imgIndex = BPELGraphPane.this.m_imgIndex == 5 ? 0 : ++BPELGraphPane.this.m_imgIndex;
            }
        }
    }

    class PartnerLinkDragBox {
        Point m_dragStartPoint = new Point();
        PartnerLinkView m_view;
        Rectangle m_bounds = new Rectangle();
        int m_yGrabOffset = 0;
        boolean m_bDragStarted = false;

        PartnerLinkDragBox() {
        }
    }

    class InternalGraphModelListener
    implements GraphModelListener {
        InternalGraphModelListener() {
        }

        public void graphNodesChanged(GraphModelEvent e) {
        }

        public void graphNodesInserted(GraphModelEvent e) {
        }

        public void graphNodesRemoved(GraphModelEvent e) {
        }

        public void graphStructureChanged(GraphModelEvent e) {
        }

        public void edgesInserted(GraphModelEvent e) {
            BPELGraphPane.this.forceLayout();
        }

        public void edgesRemoved(GraphModelEvent e) {
            BPELGraphPane.this.forceLayout();
        }
    }
}

