/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.ide.palette2.PaletteItem;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.implementations.xmlef.XMLEFImplementationsUtil;
import oracle.tip.tools.ide.common.bpelparser.outliner.OutlinerUtil;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.w3c.dom.Element;

public class BPELDNDDropHandler
implements DNDDropHandler {
    public static String getTaskNameFromDropData(Object data) {
        if (data instanceof DerivedXmlKey) {
            return ((DerivedXmlKey)data).getLocalName();
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof PaletteItemImpl) {
            return ((PaletteItemImpl)data).getShortLabel();
        }
        if (data instanceof PaletteItem) {
            PaletteItem item = (PaletteItem)data;
            String id = item.getItemId();
            int idx = id.lastIndexOf(58);
            if (idx != -1) {
                id = id.substring(idx + 1);
            }
            return id;
        }
        return null;
    }

    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        if (!graph.isEditable()) {
            return false;
        }
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        boolean bValidate = graph.getValidateOnLoad();
        String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
        Point pt = graph.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        if (r instanceof SwimLaneView && (taskName.equalsIgnoreCase("web_service") || taskName.equalsIgnoreCase("partnerlink"))) {
            graph.createPartnerLink((SwimLaneView)r, new Point(x, y), (Scope)process);
            return true;
        }
        if (!(r instanceof DropZone)) {
            return false;
        }
        DropZone dropView = (DropZone)r;
        if (!dropView.isDropAllowed()) {
            return false;
        }
        Node parentNode = r.getParent().getNode();
        ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
        if (parentActivity == null) {
            return false;
        }
        if (!parentActivity.isEditable()) {
            String name = parentActivity.getName();
            String type = BPELParser.getActivityTypeName((Activity)parentActivity);
            String msg = null;
            if (Helper.hasValue((String)name)) {
                Object[] args = new String[]{type, name};
                msg = BPELStringTranslator.formatString("PARENT_ACTVITIY_NOT_EDITABLE1", args);
            } else {
                Object[] args = new String[]{type};
                msg = BPELStringTranslator.formatString("PARENT_ACTVITIY_NOT_EDITABLE2", args);
            }
            GraphUtils.displayMessage((Component)pane, (String)msg, (int)0);
            return true;
        }
        dropView.setHighLightOn(false);
        Node dropNode = r.getNode();
        GraphNode newNode = null;
        boolean bRebuildPartnerLinks = false;
        if (taskName.equalsIgnoreCase("invoke")) {
            newNode = ModelBuilder.createGraphNode(100, process, bValidate);
            newNode.addChildNode((Node)new PortNode(1));
            newNode.addChildNode((Node)new PortNode(1));
        } else if (taskName.equalsIgnoreCase("assign")) {
            newNode = ModelBuilder.createGraphNode(109, process, bValidate);
        } else if (taskName.equalsIgnoreCase("transform")) {
            newNode = ModelBuilder.createGraphNode(133, process, bValidate);
        } else if (taskName.equalsIgnoreCase("scope")) {
            newNode = ModelBuilder.createGraphNode(102, process, bValidate);
        } else if (taskName.equalsIgnoreCase("pick")) {
            newNode = ModelBuilder.createGraphNode(114, process, bValidate);
        } else if (taskName.equalsIgnoreCase("switch")) {
            newNode = ModelBuilder.createGraphNode(104, process, bValidate);
        } else if (taskName.equalsIgnoreCase("terminate")) {
            newNode = ModelBuilder.createGraphNode(118, process, bValidate);
        } else if (taskName.equalsIgnoreCase("compensate")) {
            newNode = ModelBuilder.createGraphNode(120, process, bValidate);
        } else if (taskName.equalsIgnoreCase("empty")) {
            newNode = ModelBuilder.createGraphNode(119, process, bValidate);
        } else if (taskName.equalsIgnoreCase("throw")) {
            newNode = ModelBuilder.createGraphNode(121, process, bValidate);
        } else if (taskName.equalsIgnoreCase("sequence")) {
            newNode = ModelBuilder.createGraphNode(103, process, bValidate);
        } else if (taskName.equalsIgnoreCase("while")) {
            newNode = ModelBuilder.createGraphNode(117, process, bValidate);
        } else if (taskName.equalsIgnoreCase("flowN")) {
            newNode = ModelBuilder.createGraphNode(134, process, bValidate);
        } else if (taskName.equalsIgnoreCase("flow")) {
            newNode = ModelBuilder.createGraphNode(108, process, bValidate);
        } else if (taskName.equalsIgnoreCase("receive")) {
            newNode = ModelBuilder.createGraphNode(101, process, bValidate);
            newNode.addChildNode((Node)new PortNode(0));
            newNode.addChildNode((Node)new PortNode(0));
        } else if (taskName.equalsIgnoreCase("reply")) {
            newNode = ModelBuilder.createGraphNode(113, process, bValidate);
            newNode.addChildNode((Node)new PortNode(1));
            newNode.addChildNode((Node)new PortNode(1));
        } else if (taskName.equalsIgnoreCase("wait")) {
            newNode = ModelBuilder.createGraphNode(112, process, bValidate);
        } else if (taskName.equalsIgnoreCase("partnerLink") || taskName.equalsIgnoreCase("web_service")) {
            GraphUtils.displayMessage(null, (String)BPELStringTranslator.getString("COLLAXALAF_CANNOT_DROP_PARTNERLINK", "Cannot drop a PartnerLink here! PartnerLinks can only be dropped on the left or right swimlanes."), (int)0);
            return false;
        }
        if (newNode != null) {
            Activity activity = (Activity)newNode.getUserObject();
            if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, (Node)newNode, graph, dropNode, process)) {
                return true;
            }
            int index = parentNode.indexOf(dropNode);
            if (activity != null) {
                try {
                    parentActivity.insertActivity(index / 2, activity);
                }
                catch (Exception e1) {
                    GraphUtils.displayError((Component)pane, (Throwable)e1);
                    return false;
                }
            }
            model.insertChildNode(parentNode, (Node)newNode, index);
            if (bRebuildPartnerLinks) {
                model.buildPartnerLinkConnections();
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean checkForSequenceInsertion(Node parentNode, Node newNode, GraphPane graph, Node dropNode, Process p) {
        boolean bBPAProcess;
        if (BPELDNDDropHandler.requiresAutoSequenceGeneration(parentNode) && ((bBPAProcess = OutlinerUtil.isAnnotatedBPELProcess((Process)p)) || parentNode.getChildCount() >= 3)) {
            NodeRenderer r;
            Object userObj;
            int index = parentNode.indexOf(dropNode);
            parentNode.insertChildNode(index, newNode);
            Iterator iterator = parentNode.getChildren().iterator();
            ArrayList<Node> childNodes = new ArrayList<Node>();
            while (iterator.hasNext()) {
                Node n = (Node)iterator.next();
                if (n.getNodeType() == 0) continue;
                childNodes.add(n);
            }
            try {
                ContainerActivity containerActivity = (ContainerActivity)parentNode.getUserObject();
                Sequence sequence = (Sequence)BPELParser.createImplementation(Sequence.class);
                sequence.setName(BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class));
                Element processElem = p.getDOMElement();
                Element seqElem = sequence.createDOMElement(processElem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                sequence.setDOMElement(seqElem);
                containerActivity.addActivity((Activity)sequence);
                List containerActivities = containerActivity.getActivityList();
                for (Node n : childNodes) {
                    Activity act = (Activity)n.getUserObject();
                    if (containerActivities.contains(act)) {
                        XMLEFImplementationsUtil.forceActivityDelete((ContainerActivity)containerActivity, (Activity)act);
                    }
                    sequence.addActivity(act);
                }
                ((DroppableBranchNode)parentNode).clearChildren();
                SequenceNode sequenceNode = new SequenceNode();
                sequenceNode.setUserObject(sequence);
                for (Node n : childNodes) {
                    sequenceNode.addToEndOfBranch(n);
                }
                ((DroppableBranchNode)parentNode).addToEndOfBranch((Node)sequenceNode);
            }
            catch (Exception e) {
                GraphUtils.displayError((Component)graph, (Throwable)e);
                return false;
            }
            Activity selectedActivity = null;
            GraphElement selection = graph.getSelectedGraphElement();
            if (selection instanceof NodeRenderer && (userObj = (r = (NodeRenderer)selection).getNode().getUserObject()) instanceof Activity) {
                selectedActivity = (Activity)userObj;
            }
            BPELGraphModel graphModel = (BPELGraphModel)graph.getModel();
            graphModel.fireGraphStructureChanged();
            NodeRenderer renderer = graph.getNodeRendererForNode(parentNode);
            if (renderer != null) {
                renderer.rebuildNodeRenderersFromModel();
            }
            graph.forceImmediateLayout(true);
            if (selectedActivity != null && graph instanceof BPELGraphPane) {
                BPELGraphPane bpelGraph = (BPELGraphPane)graph;
                bpelGraph.selectActivity(selectedActivity);
            }
            return true;
        }
        return false;
    }

    public static boolean requiresAutoSequenceGeneration(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        switch (parentNode.getNodeType()) {
            case 102: 
            case 106: 
            case 107: 
            case 115: 
            case 116: 
            case 117: 
            case 122: 
            case 123: 
            case 126: 
            case 134: {
                return true;
            }
        }
        return parentNode instanceof ScopeNode || parentNode.getUserObject() instanceof Scope;
    }
}

