/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDataStore;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class AnalysisPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final Icon EYE_ICON = ImageCache.getIcon("application/bpel/eye.png");
    public static final int UNKNOWN = 0;
    public static final int WORKING = 1;
    public static final int DONE = 2;
    public static final int HAS_ERRORS = 3;
    public static final int HAS_WARNINGS = 4;
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int BOOKMARK = 2;
    protected static final Color COLOR = new Color(255, 255, 225);
    protected static Dimension m_prefDim = new Dimension(15, 20);
    protected JToolTip m_toolTip;
    protected Rectangle m_statusRect = new Rectangle();
    protected BPELGraphPane m_graph;
    protected JPanelPopup tipWindow;
    protected List m_rects = new ArrayList();
    protected int m_state = 0;
    protected int m_errorCnt = 0;
    protected int m_warningCnt = 0;

    public AnalysisPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.m_toolTip = new JToolTip();
        this.m_toolTip.setBackground(COLOR);
        this.m_toolTip.setBorder(new LineBorder(Color.black));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void refresh() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AnalysisPanel.this.computeRects();
            }
        };
        new Thread(r).start();
    }

    @Override
    public Dimension getPreferredSize() {
        return m_prefDim;
    }

    @Override
    public Dimension getMinimumSize() {
        return m_prefDim;
    }

    protected void paintStatusRect(Graphics g) {
        if (this.m_statusRect.width > 0 && this.m_statusRect.height > 0) {
            Icon icon = null;
            Color c = this.getBackground();
            Color c1 = Color.gray;
            Color c2 = Color.gray.darker();
            switch (this.m_state) {
                case 1: {
                    icon = EYE_ICON;
                    c = COLOR;
                    break;
                }
                case 2: {
                    c = Color.white;
                    c1 = Color.white;
                    c2 = Color.lightGray;
                    break;
                }
                case 3: {
                    c = Color.red;
                    c1 = Color.red.brighter();
                    c2 = Color.red.darker();
                    break;
                }
                case 4: {
                    c = Color.yellow;
                    c1 = Color.yellow.brighter();
                    c2 = Color.yellow.darker();
                    break;
                }
            }
            Graphics2D g2 = (Graphics2D)g;
            c1 = c.brighter();
            c2 = c.darker();
            GradientPaint gp = new GradientPaint(this.m_statusRect.x, this.m_statusRect.y, c1, this.m_statusRect.x + this.m_statusRect.width, this.m_statusRect.y + this.m_statusRect.height, c2);
            g2.setPaint(gp);
            g.fillRect(this.m_statusRect.x, this.m_statusRect.y, this.m_statusRect.width, this.m_statusRect.height);
            g.setColor(this.getBackground());
            g.draw3DRect(this.m_statusRect.x, this.m_statusRect.y, this.m_statusRect.width, this.m_statusRect.height, false);
            if (icon != null) {
                icon.paintIcon(this, g, this.m_statusRect.x, this.m_statusRect.y);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintStatusRect(g);
        for (AnalysisRect analysisRect : this.m_rects) {
            Color c = analysisRect.getColor();
            g.setColor(c);
            Rectangle r = analysisRect.getRect();
            g.fillRect(r.x, r.y, r.width, r.height);
            GraphUtils.drawHorzLine((Graphics)g, (int)(r.x + 1), (int)(r.y + r.height - 1), (int)(r.x + r.width - 1), (float)1.0f, (Color)analysisRect.getShadowColor());
            GraphUtils.drawVertLine((Graphics)g, (int)(r.x + r.width - 1), (int)r.y, (int)(r.y + r.height - 1), (float)1.0f, (Color)analysisRect.getShadowColor());
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.refresh();
    }

    protected void setState(int state) {
        this.m_state = state;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRects() {
        Object object = this.m_graph.getTreeLock();
        synchronized (object) {
            this.setState(1);
            this.repaint();
            List l = new ArrayList();
            Dimension dim = this.getSize();
            this.m_statusRect.setBounds(2, 0, dim.width - 5, dim.width - 5);
            BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
            if (model == null) {
                this.setState(0);
                return;
            }
            Process p = model.getProcess();
            if (p == null) {
                this.setState(0);
                return;
            }
            int padding = 4;
            int yStart = this.m_statusRect.height + padding;
            int yEnd = dim.height - this.m_statusRect.height - padding;
            for (NodeRenderer renderer : this.m_graph.getRootNodeRenderers()) {
                l = this.checkNodeRenderer(renderer, yStart, yEnd);
            }
            ArrayList data = l;
            int type = 2;
            for (AnalysisRect r : data) {
                if (r.m_type == 0) {
                    type = 3;
                    break;
                }
                if (r.m_type != 1) continue;
                type = 4;
            }
            this.m_errorCnt = 0;
            this.m_warningCnt = 0;
            for (AnalysisRect r : data) {
                switch (r.m_type) {
                    case 0: {
                        ++this.m_errorCnt;
                        break;
                    }
                    case 1: {
                        ++this.m_warningCnt;
                        break;
                    }
                }
            }
            this.setRectsInUIThread(data, type);
        }
    }

    protected void setRectsInUIThread(final List data, final int state) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AnalysisPanel.this.setRects(data, state);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected synchronized void setRects(List l, int state) {
        this.m_rects = l;
        this.setState(state);
    }

    protected List checkNodeRenderer(NodeRenderer renderer, int yStart, int yEnd) {
        Validatable v;
        ValidationReport report;
        AnalysisRect r;
        String msg;
        ArrayList<AnalysisRect> lst = new ArrayList<AnalysisRect>();
        if (renderer == null) {
            return lst;
        }
        Node n = renderer.getNode();
        if (n == null) {
            return lst;
        }
        Object userObj = n.getUserObject();
        if (userObj instanceof Activity) {
            Activity a = (Activity)userObj;
            BookmarkDataStore marks = this.m_graph.getBookmarks();
            for (Bookmark bookmark : marks.getBookmarks()) {
                if (bookmark.getID() != a.getID()) continue;
                msg = BPELStringTranslator.formatString("COLLAXALAF_ANALYSIS_BOOKMARK", bookmark.getName());
                r = new AnalysisRect(new Color(123, 166, 229), new Color(0, 0, 178), this.computeAnalysisRect(renderer, yStart, yEnd), msg, 2);
                r.m_renderer = renderer;
                lst.add(r);
            }
        }
        if (userObj instanceof Validatable && (report = (v = (Validatable)userObj).getValidationReport(null, false)) != null) {
            Object[] args;
            String type = "";
            if (v instanceof Activity) {
                Activity a = (Activity)v;
                type = BPELParser.getActivityTypeName((Activity)a);
            } else if (v instanceof PartnerLink) {
                type = "Partner Link";
            }
            if (report.hasErrors()) {
                args = new Object[]{type, "" + report.getNumErrors()};
                msg = BPELStringTranslator.formatString("COLLAXALAF_ANALYSIS_ERROR", args);
                r = new AnalysisRect(Color.red, new Color(181, 0, 0), this.computeAnalysisRect(renderer, yStart, yEnd), msg, 0);
                r.m_renderer = renderer;
                lst.add(r);
            } else if (report.hasWarnings()) {
                args = new Object[]{type, "" + report.getNumWarnings()};
                msg = BPELStringTranslator.formatString("COLLAXALAF_ANALYSIS_WARNING", args);
                r = new AnalysisRect(Color.yellow, new Color(181, 178, 0), this.computeAnalysisRect(renderer, yStart, yEnd), msg, 1);
                r.m_renderer = renderer;
                lst.add(r);
            }
        }
        if (!renderer.isCollapsed()) {
            Iterator it = renderer.getChildren();
            while (it.hasNext()) {
                NodeRenderer child = (NodeRenderer)it.next();
                List l = this.checkNodeRenderer(child, yStart, yEnd);
                lst.addAll(l);
            }
        }
        return lst;
    }

    protected Rectangle computeAnalysisRect(NodeRenderer renderer, int yStart, int yEnd) {
        Dimension dim = this.getSize();
        Rectangle viewBounds = renderer.getBounds();
        Rectangle docBounds = this.m_graph.getDocumentBounds();
        double pctY = (double)viewBounds.y / (double)docBounds.height;
        int yPos = (int)((double)(yEnd - yStart) * pctY);
        return new Rectangle(2, yStart + yPos, dim.width - 4, 3);
    }

    protected AnalysisRect hitRect(int x, int y) {
        Rectangle r;
        this.hideTip();
        if (this.m_statusRect.contains(x, y)) {
            return null;
        }
        ArrayList<AnalysisRect> bookmarks = new ArrayList<AnalysisRect>();
        for (AnalysisRect rect : this.m_rects) {
            if (rect.m_type == 2) {
                bookmarks.add(rect);
                continue;
            }
            r = rect.getRect();
            if (!r.contains(x, y)) continue;
            this.showJToolTip(rect.m_text, r.y + r.height + 3);
            return rect;
        }
        for (AnalysisRect rect : bookmarks) {
            r = rect.getRect();
            if (!r.contains(x, y)) continue;
            this.showJToolTip(rect.m_text, r.y + r.height + 3);
            return rect;
        }
        return null;
    }

    protected synchronized void showJToolTip(String text, int y) {
        this.m_toolTip.setTipText(text);
        Dimension tipSize = this.m_toolTip.getPreferredSize();
        if (this.tipWindow == null) {
            this.tipWindow = new JPanelPopup(this.m_toolTip, tipSize);
        }
        this.tipWindow.setSize(tipSize);
        this.tipWindow.show(this, 0 - tipSize.width, y);
    }

    void hideTip() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.m_statusRect.contains(e.getX(), e.getY())) {
            switch (this.m_state) {
                case 1: {
                    this.showJToolTip(BPELStringTranslator.getString("COLLAXALAF_ANALYSIS_PERFORMING"), this.m_statusRect.y);
                    break;
                }
                case 3: {
                    String msg = BPELStringTranslator.formatString("COLLAXALAF_ANALYSIS_ERRORS", "" + this.m_errorCnt);
                    this.showJToolTip(msg, this.m_statusRect.y);
                    break;
                }
                case 4: {
                    String msg = BPELStringTranslator.formatString("COLLAXALAF_ANALYSIS_WARNINGS", "" + this.m_warningCnt);
                    this.showJToolTip(msg, this.m_statusRect.y);
                    break;
                }
                case 2: {
                    this.showJToolTip(BPELStringTranslator.getString("COLLAXALAF_ANALYSIS_DONE"), this.m_statusRect.y);
                    break;
                }
                case 0: {
                    this.showJToolTip(BPELStringTranslator.getString("COLLAXALAF_ANALYSIS_NO_INFO"), this.m_statusRect.y);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (this.hitRect(e.getX(), e.getY()) != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.hideTip();
        AnalysisRect r = this.hitRect(e.getX(), e.getY());
        if (r != null && r.m_renderer != null) {
            this.m_graph.scrollNodeRendererToVisible(r.m_renderer, true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hideTip();
    }

    class JPanelPopup
    extends JPanel {
        public JPanelPopup(JComponent t, Dimension s) {
            this.setLayout(new BorderLayout());
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.add((Component)t, "Center");
            this.setSize(s);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public Rectangle getBounds() {
            return super.getBounds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void show(JComponent invoker, int x, int y) {
            AnalysisPanel analysisPanel = AnalysisPanel.this;
            synchronized (analysisPanel) {
                Point p = new Point(x, y);
                SwingUtilities.convertPointToScreen(p, AnalysisPanel.this);
                SwingUtilities.convertPointFromScreen(p, invoker.getRootPane().getLayeredPane());
                this.setBounds(p.x, p.y, this.getSize().width, this.getSize().height);
                invoker.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hide() {
            AnalysisPanel analysisPanel = AnalysisPanel.this;
            synchronized (analysisPanel) {
                Container parent = this.getParent();
                Rectangle r = this.getBounds();
                if (parent != null) {
                    parent.remove(this);
                    parent.repaint(r.x, r.y, r.width, r.height);
                }
            }
        }
    }

    class AnalysisRect {
        public Color m_bgColor;
        public Color m_color;
        public Rectangle m_rect;
        public String m_text;
        public NodeRenderer m_renderer;
        public int m_type;

        public AnalysisRect(Color color, Color bgColor, Rectangle rect, String text, int type) {
            this.m_color = color;
            this.m_bgColor = bgColor;
            this.m_rect = rect;
            this.m_text = text;
            this.m_type = type;
        }

        public Color getShadowColor() {
            return this.m_bgColor;
        }

        public void setShadowColor(Color bgColor) {
            this.m_bgColor = bgColor;
        }

        public Color getColor() {
            return this.m_color;
        }

        public void setColor(Color color) {
            this.m_color = color;
        }

        public Rectangle getRect() {
            return this.m_rect;
        }

        public void setRect(Rectangle rect) {
            this.m_rect = rect;
        }
    }
}

