/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.settings;

import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JViewport;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.util.ResolvedXPathObject;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDataStore;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFilePlugin;
import oracle.tip.tools.ide.pm.bpelgraph.settings.PartnerLinkLocation;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ProcessView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.bpelgraph.views.StateSaveableView;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GraphicsFileUtil {
    public static final String PARTNER_LINK_LOCATIONS_TAG = "partnerlink_locations";
    public static final String PARTNER_LINK_TAG = "partnerlink";
    public static final String GRAPH_LAYOUT_TAG = "graph_layout";
    public static final String LAYOUT_ITEM_TAG = "layout_item";
    public static final String BOOKMARKS_TAG = "bookmarks";
    public static final String DIAGRAM_TAG = "diagram";
    public static final String GRAPHICS_TAG = "graphics";
    public static final String ICONIZE_TAG = "iconize";
    public static final String ANNOTATION_FILE_TAG = "annotationfile";
    public static final String SHOW_HANDLERS_ATT = "showhandlers";
    public static final String COLLAPSED_ATT = "collapsed";
    public static final String SWIMLANE_VISIBLE_ATT = "show_swimlanes";
    public static final String FILE_ATT = "file";

    public static BPELSettings readSettings(Document doc) {
        if (doc == null) {
            return null;
        }
        BPELSettings settings = new BPELSettings();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            GraphicsFilePlugin graphicsPlugin = plugin.getGraphicsFilePlugin();
            if (graphicsPlugin == null) continue;
            graphicsPlugin.read(doc, settings);
        }
        Iterator it = XMLHelper.getChildElementIterator((Element)doc.getDocumentElement());
        while (it.hasNext()) {
            Color c;
            Element e = (Element)it.next();
            String tagName = e.getTagName();
            if (tagName.equalsIgnoreCase(PARTNER_LINK_LOCATIONS_TAG)) {
                Iterator linkIterator = XMLHelper.getChildElementIterator((Element)e);
                while (linkIterator.hasNext()) {
                    Element linkElem = (Element)linkIterator.next();
                    PartnerLinkLocation loc = new PartnerLinkLocation();
                    loc.readElement(linkElem);
                    settings.m_partnerLinkLocations.add(loc);
                }
                continue;
            }
            if (tagName.equalsIgnoreCase(ANNOTATION_FILE_TAG)) {
                settings.m_annotationFileLocation = XMLHelper.getAttribute((Element)e, (String)FILE_ATT);
                continue;
            }
            if (tagName.equalsIgnoreCase(BOOKMARKS_TAG)) continue;
            if (tagName.equalsIgnoreCase(ICONIZE_TAG)) {
                GraphicsFileUtil.loadIconizeInfo(settings, e);
                continue;
            }
            if (tagName.equalsIgnoreCase(GRAPH_LAYOUT_TAG)) {
                settings.m_graphLayoutElement = e;
                continue;
            }
            if (!tagName.equalsIgnoreCase(DIAGRAM_TAG)) continue;
            String s = XMLHelper.getAttribute((Element)e, (String)"popupEditor");
            if (s != null) {
                if (s.equalsIgnoreCase("true")) {
                    settings.m_bPopupEditor = true;
                } else if (s.equalsIgnoreCase("false")) {
                    settings.m_bPopupEditor = false;
                }
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"fixedWidthSwimlanes")) != null) {
                if (s.equalsIgnoreCase("true")) {
                    settings.m_bFixedWidthLanes = true;
                } else if (s.equalsIgnoreCase("false")) {
                    settings.m_bFixedWidthLanes = false;
                }
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"roundedPartnerlinks")) != null) {
                if (s.equalsIgnoreCase("true")) {
                    settings.m_bRoundedPartnerlinkConnections = true;
                } else if (s.equalsIgnoreCase("false")) {
                    settings.m_bRoundedPartnerlinkConnections = false;
                }
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"centerZoom")) != null) {
                if (s.equalsIgnoreCase("true")) {
                    settings.m_bCenterZoom = true;
                } else if (s.equalsIgnoreCase("false")) {
                    settings.m_bCenterZoom = false;
                }
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"confirmBeforeDelete")) != null) {
                if (s.equalsIgnoreCase("true")) {
                    settings.m_bConfirmDeletions = true;
                } else if (s.equalsIgnoreCase("false")) {
                    settings.m_bConfirmDeletions = false;
                }
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"validateOnLoad")) != null) {
                if (s.equalsIgnoreCase("true")) {
                    settings.m_bValidateOnLoad = true;
                } else if (s.equalsIgnoreCase("false")) {
                    settings.m_bValidateOnLoad = false;
                }
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"selectedPartnerLinkColor")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_selectedPartnerLinkColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"swimlaneBackground")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_swimlaneBackgroundColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"swimlaneDividerBackground")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_swimlaneDividerBackgroundColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"graphBackground")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_graphBackgroundColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"selectedBorderBackground")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_selectedBorderBackgroundColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"connectedPartnerLinkColor")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_connectedPartnerLinkColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"connectablePartnerLinkColor")) != null && (c = GraphicsFileUtil.parseColor(s)) != null) {
                settings.m_connectablePartnerLinkColor = c;
            }
            if ((s = XMLHelper.getAttribute((Element)e, (String)"unconnectedPartnerLinkColor")) == null || (c = GraphicsFileUtil.parseColor(s)) == null) continue;
            settings.m_unConnectedPartnerLinkColor = c;
        }
        return settings;
    }

    public static void readBookmarks(Document doc, BPELGraphPane pane, BPELGraphModel model) {
        Element elem = XMLHelper.getFirstChildElementByName((Element)doc.getDocumentElement(), (String)BOOKMARKS_TAG);
        if (elem != null) {
            BookmarkDataStore ds = new BookmarkDataStore();
            ds.read(elem, model.getProcess());
            pane.setBookmarks(ds);
        }
    }

    private static void saveBookmarks(Document doc, BPELGraphPane pane) {
        BPELGraphModel model;
        Element e;
        XMLHelper.removeAllChildrenWithTagName((Element)doc.getDocumentElement(), (String)BOOKMARKS_TAG);
        BookmarkDataStore ds = pane.getBookmarks();
        if (ds != null && (e = ds.createElement(doc, (model = (BPELGraphModel)pane.getModel()).getProcess())) != null) {
            doc.getDocumentElement().appendChild(e);
        }
    }

    private static void loadIconizeInfo(BPELSettings settings, Element iconizeElem) {
        settings.m_iconizeStateMap.put("MINIMIZE_ASSIGN_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"assign", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_ASSIGN_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"assign", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_INVOKE_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"invoke", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_RECEIVE_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"receive", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_REPLY_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"reply", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_TRANSFORM_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"transform", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_TERMINATE_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"terminate", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_WAIT_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"wait", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_COMPENSATE_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"compensate", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_EMPTY_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"empty", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_JAVA_EMBED_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"javaembedding", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_THROW_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"throw", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_VALIDATE_ACTIVITIES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"validate", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_DROP_ZONES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"dropzone", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_SEQUENCES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"sequence", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_SCOPES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"scope", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_PICKS", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"pick", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_WHILES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"while", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_FLOWS", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"flow", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_SWITCHES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"switch", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_ONALARMS", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"onalarm", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_ONMESSAGES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"onmessage", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_CATCHES", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"catch", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_CATCHALLS", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"catchall", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("MINIMIZE_COMPENSATION_HANDLERS", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"compensationhandler", (Boolean)Boolean.TRUE));
        settings.m_iconizeStateMap.put("OPTIMIZE_GRAPH", XMLHelper.getBooleanAttribute((Element)iconizeElem, (String)"optimize", (Boolean)Boolean.TRUE));
    }

    public static void loadGraphLayout(Element layoutElem, BPELGraphModel model) {
        boolean bShowSwimLanes = XMLHelper.getBooleanAttribute((Element)layoutElem, (String)SWIMLANE_VISIBLE_ATT, (Boolean)Boolean.TRUE);
        for (SwimLaneNode swimLaneNode : model.getNodesOfType(110)) {
            swimLaneNode.storeData(SWIMLANE_VISIBLE_ATT, new Boolean(bShowSwimLanes));
        }
        for (Element elem : XMLHelper.getChildElements((Node)layoutElem)) {
            String xpath = XMLHelper.getAttribute((Element)elem, (String)"xpath");
            if (xpath == null) continue;
            try {
                oracle.tip.tools.ide.common.graph.model.Node node;
                ResolvedXPathObject r = BPELModelUtil.getObjectFromXPath((Process)model.getProcess(), (String)xpath);
                if (r.getEvalObjectType() != 2 || (node = model.getNodeForActivity((Activity)r.getEvalObject())) == null) continue;
                node.storeData((Object)COLLAPSED_ATT, (Object)XMLHelper.getBooleanAttribute((Element)elem, (String)COLLAPSED_ATT, (Boolean)Boolean.TRUE));
                node.storeData((Object)SHOW_HANDLERS_ATT, (Object)XMLHelper.getBooleanAttribute((Element)elem, (String)SHOW_HANDLERS_ATT, (Boolean)Boolean.TRUE));
            }
            catch (Exception e) {}
        }
    }

    private static Color parseColor(String s) {
        if (s == null) {
            return null;
        }
        int cnt = 0;
        int red = -1;
        int green = -1;
        int blue = -1;
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            try {
                int iVal = Integer.parseInt(tok);
                if (cnt == 0) {
                    red = iVal;
                } else if (cnt == 1) {
                    green = iVal;
                } else {
                    blue = iVal;
                    break;
                }
                ++cnt;
            }
            catch (NumberFormatException e) {}
        }
        if (red > -1 && green > -1 && blue > -1) {
            return new Color(red, green, blue);
        }
        return null;
    }

    public static Document loadGraphicsFile(URL graphicsURL) throws Exception {
        if (Helper.exists((URL)graphicsURL)) {
            return GraphicsFileUtil.parseDoc(graphicsURL);
        }
        return null;
    }

    private static Document parseDoc(URL url) throws Exception {
        DOMParser parser = new DOMParser();
        parser.parse(url);
        return parser.getDocument();
    }

    public static void save(BPELSettings settings, URL u) throws Exception {
        Document doc = GraphicsFileUtil.createInitialGraphicsDoc();
        if (settings != null) {
            GraphicsFileUtil.saveDiagramProperties(doc, settings);
        }
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            GraphicsFilePlugin graphicsPlugin = plugin.getGraphicsFilePlugin();
            if (graphicsPlugin == null) continue;
            graphicsPlugin.save(doc, settings);
        }
        GraphicsFileUtil.save(doc, u);
    }

    public static void saveGraphicsFile(URL graphicsFileURL, BPELGraphPane pane) throws Exception {
        if (graphicsFileURL == null) {
            throw new Exception("Graphics file URL is null!");
        }
        JDevHelper.checkOutFile((URL)graphicsFileURL);
        Document doc = GraphicsFileUtil.createInitialGraphicsDoc();
        GraphicsFileUtil.saveDiagramProperties(doc, pane.getSettings());
        GraphicsFileUtil.savePartnerLinks(doc, pane);
        GraphicsFileUtil.saveGraphLayout(doc, pane);
        GraphicsFileUtil.saveBookmarks(doc, pane);
        GraphicsFileUtil.save(doc, graphicsFileURL);
    }

    private static void saveIconizeInfo(Document doc, BPELSettings settings) {
        Element elem = doc.createElement(ICONIZE_TAG);
        doc.getDocumentElement().appendChild(elem);
        XMLHelper.setBooleanAttribute((Element)elem, (String)"assign", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_ASSIGN_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"invoke", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_INVOKE_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"receive", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_RECEIVE_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"reply", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_REPLY_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"transform", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_TRANSFORM_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"terminate", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_TERMINATE_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"wait", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_WAIT_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"compensate", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_COMPENSATE_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"empty", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_EMPTY_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"javaembedding", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_JAVA_EMBED_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"throw", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_THROW_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"validate", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_VALIDATE_ACTIVITIES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"dropzone", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_DROP_ZONES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"sequence", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SEQUENCES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"scope", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SCOPES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"pick", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_PICKS")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"while", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_WHILES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"flow", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_FLOWS")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"switch", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_SWITCHES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"onalarm", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_ONALARMS")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"onmessage", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_ONMESSAGES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"catch", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_CATCHES")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"catchall", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_CATCHALLS")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"compensationhandler", (Boolean)((Boolean)settings.m_iconizeStateMap.get("MINIMIZE_COMPENSATION_HANDLERS")));
        XMLHelper.setBooleanAttribute((Element)elem, (String)"optimize", (Boolean)((Boolean)settings.m_iconizeStateMap.get("OPTIMIZE_GRAPH")));
    }

    private static void saveGraphLayout(Document doc, BPELGraphPane pane) {
        Element elem = doc.createElement(GRAPH_LAYOUT_TAG);
        doc.getDocumentElement().appendChild(elem);
        Container c = pane.getParent();
        if (c instanceof JViewport) {
            JViewport vp = (JViewport)c;
            Rectangle r = vp.getViewRect();
            String string = r.x + "," + r.y + "," + r.width + "," + r.height;
            XMLHelper.setAttribute((Element)elem, (String)"viewport", (Object)string);
        }
        XMLHelper.setBooleanAttribute2((Element)elem, (String)SWIMLANE_VISIBLE_ATT, (Boolean)pane.getSwimLanesVisible());
        List<StateSaveableView> l = pane.getStateSaveableViews();
        for (NodeRenderer nodeRenderer : l) {
            Activity a = (Activity)nodeRenderer.getNode().getUserObject();
            String xpath = BPELModelUtil.getXPathForActivity((Activity)a);
            if (xpath == null) continue;
            Element e = doc.createElement(LAYOUT_ITEM_TAG);
            e.setAttribute(COLLAPSED_ATT, nodeRenderer.isCollapsed() ? "true" : "false");
            e.setAttribute("xpath", xpath);
            e.setAttribute("type", BPELParser.getActivityTypeName((Activity)a));
            if (nodeRenderer instanceof ScopeView) {
                e.setAttribute(SHOW_HANDLERS_ATT, ((ScopeView)nodeRenderer).getShowHandlers() ? "true" : "false");
            } else if (nodeRenderer instanceof ProcessView) {
                e.setAttribute(SHOW_HANDLERS_ATT, ((ProcessView)nodeRenderer).getShowHandlers() ? "true" : "false");
            }
            elem.appendChild(e);
        }
    }

    private static void saveDiagramProperties(Document doc, BPELSettings settings) {
        Element docElem = doc.getDocumentElement();
        Element diagramElem = doc.createElement(DIAGRAM_TAG);
        docElem.appendChild(diagramElem);
        XMLHelper.setAttribute((Element)diagramElem, (String)"popupEditor", (Object)settings.m_bPopupEditor);
        XMLHelper.setAttribute((Element)diagramElem, (String)"fixedWidthSwimlanes", (Object)settings.m_bFixedWidthLanes);
        XMLHelper.setAttribute((Element)diagramElem, (String)"roundedPartnerlinks", (Object)settings.m_bRoundedPartnerlinkConnections);
        XMLHelper.setAttribute((Element)diagramElem, (String)"centerZoom", (Object)settings.m_bCenterZoom);
        XMLHelper.setAttribute((Element)diagramElem, (String)"validateOnLoad", (Object)settings.m_bValidateOnLoad);
        XMLHelper.setAttribute((Element)diagramElem, (String)"confirmBeforeDelete", (Object)settings.m_bConfirmDeletions);
        XMLHelper.setAttribute((Element)diagramElem, (String)"selectedPartnerLinkColor", (Object)GraphicsFileUtil.getRGB(settings.m_selectedPartnerLinkColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"swimlaneBackground", (Object)GraphicsFileUtil.getRGB(settings.m_swimlaneBackgroundColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"swimlaneDividerBackground", (Object)GraphicsFileUtil.getRGB(settings.m_swimlaneDividerBackgroundColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"graphBackground", (Object)GraphicsFileUtil.getRGB(settings.m_graphBackgroundColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"selectedBorderBackground", (Object)GraphicsFileUtil.getRGB(settings.m_selectedBorderBackgroundColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"connectedPartnerLinkColor", (Object)GraphicsFileUtil.getRGB(settings.m_connectedPartnerLinkColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"connectablePartnerLinkColor", (Object)GraphicsFileUtil.getRGB(settings.m_connectablePartnerLinkColor));
        XMLHelper.setAttribute((Element)diagramElem, (String)"unconnectedPartnerLinkColor", (Object)GraphicsFileUtil.getRGB(settings.m_unConnectedPartnerLinkColor));
        Element annotationElem = doc.createElement(ANNOTATION_FILE_TAG);
        docElem.appendChild(annotationElem);
        XMLHelper.setAttribute((Element)annotationElem, (String)FILE_ATT, (Object)settings.m_annotationFileLocation);
        GraphicsFileUtil.saveIconizeInfo(doc, settings);
    }

    private static String getRGB(Color c) {
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
    }

    private static void savePartnerLinks(Document doc, BPELGraphPane pane) {
        String icon;
        Element elem;
        PartnerLink l;
        PartnerLinkNode node;
        View v;
        Element docElem = doc.getDocumentElement();
        SwimLaneView view = pane.getLeftSwimLaneView();
        Element locationsElem = doc.createElement(PARTNER_LINK_LOCATIONS_TAG);
        docElem.appendChild(locationsElem);
        Iterator it = view.getChildren();
        while (it.hasNext()) {
            v = (View)it.next();
            if (!(v instanceof PartnerLinkView)) continue;
            node = (PartnerLinkNode)v.getNode();
            l = (PartnerLink)node.getUserObject();
            elem = doc.createElement(PARTNER_LINK_TAG);
            elem.setAttribute("name", "" + l.getName());
            elem.setAttribute("x", "" + v.getBounds().x);
            elem.setAttribute("y", "" + v.getBounds().y);
            elem.setAttribute("side", "left");
            icon = node.getIconName();
            if (icon != null) {
                elem.setAttribute("image", icon);
            }
            locationsElem.appendChild(elem);
        }
        view = pane.getRightSwimLaneView();
        it = view.getChildren();
        while (it.hasNext()) {
            v = (View)it.next();
            if (!(v instanceof PartnerLinkView)) continue;
            node = (PartnerLinkNode)v.getNode();
            l = (PartnerLink)node.getUserObject();
            elem = doc.createElement(PARTNER_LINK_TAG);
            elem.setAttribute("name", "" + l.getName());
            elem.setAttribute("x", "" + v.getBounds().x);
            elem.setAttribute("y", "" + v.getBounds().y);
            elem.setAttribute("side", "right");
            icon = node.getIconName();
            if (icon != null) {
                elem.setAttribute("image", icon);
            }
            locationsElem.appendChild(elem);
        }
    }

    public static void save(Document doc, URL url) throws Exception {
        OutputStream outStream = null;
        try {
            outStream = URLFileSystem.openOutputStream((URL)url);
            XMLPrintDriver driver = new XMLPrintDriver(outStream);
            driver.setFormatPrettyPrint(true);
            driver.setEOLChars(System.getProperty("line.separator"));
            driver.setEncoding("UTF-8");
            driver.printDocument((XMLDocument)doc);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static Document createInitialGraphicsDoc() {
        XMLDocument doc = new XMLDocument();
        try {
            doc.setVersion("1.0");
            doc.setEncoding("UTF-8");
            Element sensors = doc.createElement(GRAPHICS_TAG);
            doc.appendChild((Node)sensors);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }
}

