/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.model;

import java.util.List;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.pm.bpelgraph.model.ActivityNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchCaseNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchDefaultNode;

public class SwitchNode
extends ActivityNode {
    public SwitchNode() {
        super(104);
    }

    public SwitchCaseNode addCaseNode() {
        SwitchCaseNode node = new SwitchCaseNode();
        int nChildCount = this.getChildCount();
        if (nChildCount > 0) {
            this.insertChildNode(nChildCount - 1, (Node)node);
        } else {
            this.addChildNode((Node)node);
        }
        return node;
    }

    public SwitchDefaultNode addDefaultNode() {
        SwitchDefaultNode node = new SwitchDefaultNode();
        int nChildCount = this.getChildCount();
        if (nChildCount == 0) {
            this.addChildNode((Node)node);
        } else {
            if (this.hasDefaultNode()) {
                throw new RuntimeException("Cannot add mmore than 1 Default branch to a SwitchNode!");
            }
            this.addChildNode((Node)node);
        }
        return node;
    }

    private boolean hasDefaultNode() {
        List l = this.getChildren();
        for (Node n : l) {
            if (n.getNodeType() != 107) continue;
            return true;
        }
        return false;
    }

    public String getDisplayTypeName() {
        return "Switch";
    }

    public Node createCopy() {
        SwitchNode copy = new SwitchNode();
        for (Node n : this.getChildren()) {
            Node childCopy = n.createCopy();
            if (childCopy == null) continue;
            copy.addChildNode(childCopy);
        }
        return copy;
    }
}

