/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.Compensate;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Empty;
import oracle.tip.tools.ide.common.bpelparser.iface.EventHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.Flow;
import oracle.tip.tools.ide.common.bpelparser.iface.FlowN;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Pick;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.Switch;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchOtherwise;
import oracle.tip.tools.ide.common.bpelparser.iface.Terminate;
import oracle.tip.tools.ide.common.bpelparser.iface.Throw;
import oracle.tip.tools.ide.common.bpelparser.iface.Transformation;
import oracle.tip.tools.ide.common.bpelparser.iface.Wait;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ActivityNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.AssignNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.CatchAllNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CatchNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CompensateNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.CompensationHandlerNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.EmptyNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.EventHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.FaultHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowNNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.FlowNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnAlarmNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.OnMessageNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkConnection;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PickNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ProcessNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReceiveNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReplyNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchCaseNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchDefaultNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwitchNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.TerminateNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ThrowNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.TransformNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.WaitNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.WhileNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModelBuilder {
    private static List<ModelBuilderPlugin> m_plugins = new ArrayList<ModelBuilderPlugin>();
    protected SwimLaneNode m_leftSwimLaneNode;
    protected SwimLaneNode m_rightSwimLaneNode;
    protected BPELGraphModel m_graphModel;
    protected boolean m_bBuildPartnerLinks;

    public ModelBuilder() {
        this(true);
    }

    public ModelBuilder(boolean bBuildPartnerLinks) {
        this.m_bBuildPartnerLinks = bBuildPartnerLinks;
        for (ModelBuilderPlugin plugin : m_plugins) {
            plugin.setModelBuilder(this);
        }
    }

    public static void addModelBuilderPlugin(ModelBuilderPlugin plugin) {
        m_plugins.add(plugin);
    }

    public void setGraphModel(BPELGraphModel graphModel) {
        this.m_graphModel = graphModel;
        this.setRightSwimLaneNode(graphModel.getRightSwimLaneNode());
        this.setLeftSwimLaneNode(graphModel.getLeftSwimLaneNode());
    }

    public void setLeftSwimLaneNode(SwimLaneNode leftSwimLaneNode) {
        this.m_leftSwimLaneNode = leftSwimLaneNode;
    }

    public void setRightSwimLaneNode(SwimLaneNode rightSwimLaneNode) {
        this.m_rightSwimLaneNode = rightSwimLaneNode;
    }

    public SwimLaneNode getLeftSwimLaneNode() {
        return this.m_leftSwimLaneNode;
    }

    public SwimLaneNode getRightSwimLaneNode() {
        return this.m_rightSwimLaneNode;
    }

    public static int getNodeIDForActivity(Activity a) {
        for (ModelBuilderPlugin plugin : m_plugins) {
            int id = plugin.getNodeIDForActivity(a);
            if (id == -1) continue;
            return id;
        }
        if (a instanceof Sequence) {
            return 103;
        }
        if (a instanceof Process) {
            return 105;
        }
        if (a instanceof Invoke) {
            return 100;
        }
        if (a instanceof Scope) {
            return 102;
        }
        if (a instanceof Reply) {
            return 113;
        }
        if (a instanceof Terminate) {
            return 118;
        }
        if (a instanceof Wait) {
            return 112;
        }
        if (a instanceof Receive) {
            return 101;
        }
        if (a instanceof Assign) {
            return 109;
        }
        if (a instanceof Pick) {
            return 114;
        }
        if (a instanceof OnAlarm) {
            return 116;
        }
        if (a instanceof OnMessage) {
            return 115;
        }
        if (a instanceof Flow) {
            return 108;
        }
        if (a instanceof Switch) {
            return 104;
        }
        if (a instanceof SwitchCase) {
            return 106;
        }
        if (a instanceof While) {
            return 117;
        }
        if (a instanceof FlowN) {
            return 134;
        }
        if (a instanceof SwitchOtherwise) {
            return 107;
        }
        if (a instanceof Throw) {
            return 121;
        }
        if (a instanceof Empty) {
            return 119;
        }
        if (a instanceof Compensate) {
            return 120;
        }
        if (a instanceof Catch) {
            return 122;
        }
        if (a instanceof CatchAll) {
            return 123;
        }
        return -1;
    }

    public static GraphNode createGraphNode(int type, Process p, boolean bValidate) {
        for (ModelBuilderPlugin plugin : m_plugins) {
            GraphNode graphNode = plugin.createGraphNode(type, p, bValidate);
            if (graphNode == null) continue;
            return graphNode;
        }
        Object newNode = null;
        Element processElem = p.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        ValidationContext ct = new ValidationContext(p);
        if (type == 105) {
            newNode = new ProcessNode();
            Activity activity = (Activity)BPELParser.createImplementation(Process.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            newNode.setUserObject(activity);
        } else if (type == 134) {
            newNode = new FlowNNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"FlowN", FlowN.class);
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(FlowN.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 102) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Scope", Scope.class);
            newNode = new ScopeNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Scope.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 121) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Throw", Throw.class);
            newNode = new ThrowNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Throw.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 103) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class);
            newNode = new SequenceNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Sequence.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 118) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Terminate", Terminate.class);
            newNode = new TerminateNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Terminate.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 112) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Wait", Wait.class);
            newNode = new WaitNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Wait.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 120) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Compensate", Compensate.class);
            newNode = new CompensateNode();
            newNode.setName(name);
            Compensate activity = (Compensate)BPELParser.createImplementation(Compensate.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 119) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Empty", Empty.class);
            newNode = new EmptyNode();
            newNode.setName(name);
            Empty activity = (Empty)BPELParser.createImplementation(Empty.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 109) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Assign", Assign.class);
            newNode = new AssignNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Assign.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 101) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Receive", Receive.class);
            newNode = new ReceiveNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Receive.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 113) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Reply", Reply.class);
            newNode = new ReplyNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Reply.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 100) {
            newNode = new InvokeNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Invoke", Invoke.class);
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Invoke.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 104) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Switch", Switch.class);
            SwitchNode switchNode = new SwitchNode();
            switchNode.setName(name);
            SwitchCaseNode caseNode = switchNode.addCaseNode();
            SwitchDefaultNode defaultNode = switchNode.addDefaultNode();
            Activity activity = (Activity)BPELParser.createImplementation(Switch.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            switchNode.setUserObject(activity);
            activity.setName(name);
            SwitchCase caseActivity = (SwitchCase)BPELParser.createImplementation(SwitchCase.class);
            caseActivity.setDOMElement(caseActivity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            SwitchOtherwise otherwiseActivity = (SwitchOtherwise)BPELParser.createImplementation(SwitchOtherwise.class);
            otherwiseActivity.setDOMElement(otherwiseActivity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            try {
                ((Switch)activity).addSwitchCase(caseActivity);
                ((Switch)activity).setSwitchOtherwise(otherwiseActivity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            caseNode.setUserObject(caseActivity);
            defaultNode.setUserObject(otherwiseActivity);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode = switchNode;
        } else if (type == 122) {
            CatchNode node = new CatchNode();
            Catch impl = (Catch)BPELParser.createImplementation(Catch.class);
            impl.setDOMElement(impl.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            if (bValidate) {
                impl.getValidationReport(new ValidationContext(p), true);
            }
            node.setUserObject(impl);
            newNode = node;
        } else if (type == 123) {
            CatchAllNode node = new CatchAllNode();
            CatchAll impl = (CatchAll)BPELParser.createImplementation(CatchAll.class);
            impl.setDOMElement(impl.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            if (bValidate) {
                impl.getValidationReport(new ValidationContext(p), true);
            }
            node.setUserObject(impl);
            newNode = node;
        } else if (type == 106) {
            newNode = new SwitchCaseNode();
        } else if (type == 107) {
            newNode = new SwitchDefaultNode();
        } else if (type == 108) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Flow", Flow.class);
            Flow flow = (Flow)BPELParser.createImplementation(Flow.class);
            flow.setDOMElement(flow.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            flow.setName(name);
            Sequence sequence1 = (Sequence)BPELParser.createImplementation(Sequence.class);
            String sequence1_name = BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class);
            sequence1.setDOMElement(sequence1.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            sequence1.setName(sequence1_name);
            Sequence sequence2 = (Sequence)BPELParser.createImplementation(Sequence.class);
            String sequence2_name = sequence1_name;
            if (sequence1_name.startsWith("Sequence_")) {
                String sub = sequence1_name.substring(name.length());
                try {
                    int iVal = Integer.parseInt(sub);
                    sequence2_name = sub + (iVal + 1);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            sequence2.setDOMElement(sequence2.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            sequence2.setName(sequence2_name);
            try {
                flow.addSequence(sequence1);
                flow.addSequence(sequence2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SequenceNode seqNode1 = new SequenceNode();
            seqNode1.setUserObject(sequence1);
            seqNode1.setName(sequence1_name);
            SequenceNode seqNode2 = new SequenceNode();
            seqNode2.setUserObject(sequence2);
            seqNode2.setName(sequence2_name);
            FlowNode flowNode = new FlowNode();
            flowNode.setUserObject(flow);
            flowNode.addSequence(seqNode1);
            flowNode.addSequence(seqNode2);
            if (bValidate) {
                flow.getValidationReport(ct, true);
            }
            newNode = flowNode;
        } else if (type == 114) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Pick", Pick.class);
            newNode = new PickNode();
            newNode.setName(name);
            OnMessageNode onMsgNode = new OnMessageNode();
            OnAlarmNode onAlarmNode = new OnAlarmNode();
            newNode.addChildNode((Node)onMsgNode);
            newNode.addChildNode((Node)onAlarmNode);
            Activity activity = (Activity)BPELParser.createImplementation(Pick.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            newNode.setUserObject(activity);
            Pick pick = (Pick)activity;
            pick.setName(name);
            OnAlarm alarm = (OnAlarm)BPELParser.createImplementation(OnAlarm.class);
            alarm.setDOMElement(alarm.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            try {
                pick.addOnAlarm(alarm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            onAlarmNode.setUserObject(alarm);
            OnMessage msg = (OnMessage)BPELParser.createImplementation(OnMessage.class);
            msg.setDOMElement(msg.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            try {
                pick.addOnMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            onMsgNode.setUserObject(msg);
            if (bValidate) {
                msg.getValidationReport(ct, true);
                alarm.getValidationReport(ct, true);
                activity.getValidationReport(ct, true);
            }
        } else if (type == 116) {
            newNode = new OnAlarmNode();
            OnAlarm impl = (OnAlarm)BPELParser.createImplementation(OnAlarm.class);
            impl.setDOMElement(impl.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            if (bValidate) {
                impl.getValidationReport(new ValidationContext(p), true);
            }
            newNode.setUserObject(impl);
        } else if (type == 115) {
            newNode = new OnMessageNode();
            OnMessage impl = (OnMessage)BPELParser.createImplementation(OnMessage.class);
            impl.setDOMElement(impl.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            if (bValidate) {
                impl.getValidationReport(new ValidationContext(p), true);
            }
            newNode.setUserObject(impl);
        } else if (type == 102) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Scope", Scope.class);
            newNode = new ScopeNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Scope.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 103) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class);
            newNode = new SequenceNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Sequence.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 117) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"While", While.class);
            newNode = new WhileNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(While.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 133) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Transform", Assign.class);
            newNode = new TransformNode();
            newNode.setName(name);
            Activity activity = (Activity)BPELParser.createImplementation(Transformation.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(ct, true);
            }
            newNode.setUserObject(activity);
        } else if (type == 124) {
            newNode = new FaultHandlersNode();
        } else if (type == 125) {
            newNode = new EventHandlersNode();
        } else if (type == 126) {
            newNode = new CompensationHandlerNode();
        }
        if (newNode != null) {
            ModelBuilder.notifyNodeCreated(newNode);
        }
        return newNode;
    }

    public GraphModel build(Process p) {
        return this.build(p, this.m_bBuildPartnerLinks);
    }

    public GraphModel build(Process p, boolean bBuildPartnerLinks) {
        this.m_bBuildPartnerLinks = bBuildPartnerLinks;
        this.m_graphModel = this.createBPELGraphModel();
        this.m_leftSwimLaneNode = new SwimLaneNode(2);
        this.m_rightSwimLaneNode = new SwimLaneNode(4);
        List scopes = BPELModelUtil.getAllScopeActivities((Process)p);
        this.addPartnerLinks(scopes, this.m_leftSwimLaneNode, this.m_rightSwimLaneNode);
        ProcessNode processNode = this.handleProcess(p);
        GraphNode rootNode = new GraphNode(3);
        if (this.m_bBuildPartnerLinks) {
            rootNode.addChildNode((Node)this.m_leftSwimLaneNode);
        }
        rootNode.addChildNode((Node)processNode);
        if (this.m_bBuildPartnerLinks) {
            rootNode.addChildNode((Node)this.m_rightSwimLaneNode);
        }
        this.m_graphModel.addRootNode((Node)rootNode);
        return this.m_graphModel;
    }

    protected BPELGraphModel createBPELGraphModel() {
        return new BPELGraphModel();
    }

    protected ProcessNode handleProcess(Process p) {
        CompensationHandler compHandler;
        EventHandlers eventHandlers;
        ProcessNode processNode = new ProcessNode();
        processNode.setUserObject(p);
        processNode.setName(p.getName());
        processNode.addChildNode((Node)new GraphNode(8));
        Iterator iterator = p.getActivities();
        while (iterator.hasNext()) {
            Activity a = (Activity)iterator.next();
            Node n = this.getNodeForActivity(a);
            if (n == null) continue;
            processNode.addChildNode(n);
        }
        processNode.addChildNode((Node)new GraphNode(9));
        FaultHandlers handlers = p.getFaultHandlers();
        if (handlers != null) {
            FaultHandlersNode fNode = new FaultHandlersNode();
            fNode.setUserObject(handlers);
            processNode.setFaultHandlersNode(fNode);
            for (Catch c : handlers.getCatches()) {
                CatchNode catchNode = new CatchNode();
                catchNode.setUserObject(c);
                this.addChildNodes((Node)catchNode, (ContainerActivity)c);
                fNode.addChildNode((Node)catchNode);
            }
            CatchAll ca = handlers.getCatchAll();
            if (ca != null) {
                CatchAllNode catchAllNode = new CatchAllNode();
                catchAllNode.setUserObject(ca);
                this.addChildNodes((Node)catchAllNode, (ContainerActivity)ca);
                fNode.addChildNode((Node)catchAllNode);
            }
        }
        if ((eventHandlers = p.getEventHandlers()) != null) {
            EventHandlersNode evtNode = new EventHandlersNode();
            evtNode.setUserObject(eventHandlers);
            processNode.setEventHandlersNode(evtNode);
            for (OnMessage msg : eventHandlers.getOnMessages()) {
                OnMessageNode msgNode = new OnMessageNode();
                msgNode.setUserObject(msg);
                this.addChildNodes((Node)msgNode, (ContainerActivity)msg);
                evtNode.addChildNode((Node)msgNode);
            }
            for (OnAlarm alarm : eventHandlers.getOnAlarms()) {
                OnAlarmNode alarmNode = new OnAlarmNode();
                alarmNode.setUserObject(alarm);
                this.addChildNodes((Node)alarmNode, (ContainerActivity)alarm);
                evtNode.addChildNode((Node)alarmNode);
            }
        }
        if ((compHandler = p.getCompensationHandler()) != null) {
            CompensationHandlerNode compNode = new CompensationHandlerNode();
            compNode.setUserObject(compHandler);
            this.addChildNodes((Node)compNode, (ContainerActivity)compHandler);
            processNode.setCompensationHandlerNode(compNode);
        }
        return processNode;
    }

    public Node getNodeForActivity(Activity a) {
        for (ModelBuilderPlugin plugin : m_plugins) {
            GraphNode graphNode = plugin.getNodeForActivity(a);
            if (graphNode == null) continue;
            return graphNode;
        }
        if (a instanceof Sequence) {
            return this.handleSequence((Sequence)a);
        }
        if (a instanceof Invoke) {
            return this.handleInvoke((Invoke)a);
        }
        if (a instanceof Scope) {
            return this.handleScope((Scope)a);
        }
        if (a instanceof Reply) {
            return this.handleReply((Reply)a);
        }
        if (a instanceof Terminate) {
            return this.handleTerminate((Terminate)a);
        }
        if (a instanceof Wait) {
            return this.handleWait((Wait)a);
        }
        if (a instanceof Receive) {
            return this.handleReceive((Receive)a);
        }
        if (a instanceof Assign) {
            return this.handleAssign((Assign)a);
        }
        if (a instanceof Pick) {
            return this.handlePick((Pick)a);
        }
        if (a instanceof OnAlarm) {
            return this.handleOnAlarm((OnAlarm)a);
        }
        if (a instanceof OnMessage) {
            return this.handleOnMessage((OnMessage)a);
        }
        if (a instanceof Flow) {
            return this.handleFlow((Flow)a);
        }
        if (a instanceof Switch) {
            return this.handleSwitch((Switch)a);
        }
        if (a instanceof SwitchCase) {
            return this.handleSwitchCase((SwitchCase)a);
        }
        if (a instanceof While) {
            return this.handleWhile((While)a);
        }
        if (a instanceof FlowN) {
            return this.handleFlowN((FlowN)a);
        }
        if (a instanceof SwitchOtherwise) {
            return this.handleSwitchOtherwise((SwitchOtherwise)a);
        }
        if (a instanceof Throw) {
            return this.handleThrow((Throw)a);
        }
        if (a instanceof Empty) {
            return this.handleEmpty((Empty)a);
        }
        if (a instanceof Compensate) {
            return this.handleCompensate((Compensate)a);
        }
        return null;
    }

    public void addPartnerLinks(List<Scope> scopeLst, SwimLaneNode leftSwimlaneNode, SwimLaneNode rightSwimlaneNode) {
        if (scopeLst == null) {
            return;
        }
        for (Scope s : scopeLst) {
            PartnerLinks links = s.getPartnerLinks();
            if (links == null) continue;
            this.addPartnerLinks(links, leftSwimlaneNode, rightSwimlaneNode);
        }
    }

    public void addPartnerLinks(PartnerLinks plinks, SwimLaneNode leftSwimlaneNode, SwimLaneNode rightSwimlaneNode) {
        if (plinks == null) {
            return;
        }
        boolean bLeft = true;
        List links = plinks.getPartnerLinks();
        for (PartnerLink l : links) {
            PartnerLinkNode linkNode = new PartnerLinkNode();
            linkNode.setUserObject(l);
            ModelBuilder.notifyNodeCreated((Node)linkNode);
            if (linkNode.getSwimlanePreference() == 1) {
                leftSwimlaneNode.addChildNode((Node)linkNode);
                continue;
            }
            if (linkNode.getSwimlanePreference() == 2) {
                rightSwimlaneNode.addChildNode((Node)linkNode);
                continue;
            }
            if (bLeft) {
                leftSwimlaneNode.addChildNode((Node)linkNode);
            } else {
                rightSwimlaneNode.addChildNode((Node)linkNode);
            }
            bLeft = !bLeft;
        }
    }

    private static void notifyNodeCreated(Node n) {
        if (n != null) {
            for (ModelBuilderPlugin plugin : m_plugins) {
                plugin.nodeCreated(n);
            }
        }
    }

    private Node handlePick(Pick p) {
        PickNode n = new PickNode();
        n.setUserObject(p);
        n.setName(p.getName());
        this.addChildNodes((Node)n, (ContainerActivity)p);
        return n;
    }

    private Node handleOnAlarm(OnAlarm p) {
        OnAlarmNode n = new OnAlarmNode();
        n.setUserObject(p);
        n.setName(p.getName());
        this.addChildNodes((Node)n, (ContainerActivity)p);
        return n;
    }

    private Node handleOnMessage(OnMessage p) {
        OnMessageNode n = new OnMessageNode();
        n.setUserObject(p);
        this.addChildNodes((Node)n, (ContainerActivity)p);
        return n;
    }

    protected Node handleThrow(Throw t) {
        ThrowNode n = new ThrowNode();
        n.setUserObject(t);
        return n;
    }

    protected Node handleCompensate(Compensate c) {
        CompensateNode n = new CompensateNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected Node handleEmpty(Empty e) {
        EmptyNode n = new EmptyNode();
        n.setUserObject(e);
        return n;
    }

    protected Node handleFlowN(FlowN f) {
        FlowNNode n = new FlowNNode();
        n.setUserObject(f);
        this.addChildNodes((Node)n, (ContainerActivity)f);
        return n;
    }

    protected Node handleWhile(While w) {
        WhileNode n = new WhileNode();
        n.setUserObject(w);
        this.addChildNodes((Node)n, (ContainerActivity)w);
        return n;
    }

    public Node handleSwitch(Switch s) {
        SwitchNode n = new SwitchNode();
        n.setUserObject(s);
        n.setName(s.getName());
        this.addChildNodes((Node)n, (ContainerActivity)s);
        return n;
    }

    protected Node handleSwitchCase(SwitchCase s) {
        SwitchCaseNode n = new SwitchCaseNode();
        n.setUserObject(s);
        n.setName(s.getName());
        this.addChildNodes((Node)n, (ContainerActivity)s);
        return n;
    }

    protected Node handleSwitchOtherwise(SwitchOtherwise s) {
        SwitchDefaultNode n = new SwitchDefaultNode();
        n.setUserObject(s);
        n.setName(s.getName());
        this.addChildNodes((Node)n, (ContainerActivity)s);
        return n;
    }

    protected Node handleFlow(Flow f) {
        FlowNode n = new FlowNode();
        n.setUserObject(f);
        n.setName(f.getName());
        this.addChildNodes((Node)n, (ContainerActivity)f);
        return n;
    }

    protected Node handleAssign(Assign r) {
        ActivityNode n = r instanceof Transformation ? new TransformNode() : new AssignNode();
        n.setUserObject(r);
        n.setName(r.getName());
        return n;
    }

    protected Node handleTerminate(Terminate r) {
        TerminateNode n = new TerminateNode();
        n.setUserObject(r);
        n.setName(r.getName());
        return n;
    }

    protected Node handleReceive(Receive r) {
        PartnerLinkNode partnerLinkNode;
        String link;
        ReceiveNode receiveNode = new ReceiveNode();
        receiveNode.setUserObject(r);
        receiveNode.setName(r.getName());
        PortNode receivePortNode = new PortNode(0);
        receiveNode.addChildNode((Node)receivePortNode);
        receiveNode.addChildNode((Node)new PortNode(0));
        if (this.m_bBuildPartnerLinks && (link = r.getPartnerLink()) != null && (partnerLinkNode = this.findPartnerLinkNode(link)) != null) {
            PortNode partnerLinkPort = new PortNode(1);
            partnerLinkNode.addChildNode((Node)partnerLinkPort);
            PartnerLinkConnection edge = new PartnerLinkConnection(partnerLinkPort, receivePortNode);
            this.m_graphModel.insertEdge((Edge)edge);
        }
        return receiveNode;
    }

    protected Node handleReply(Reply r) {
        PartnerLinkNode partnerLinkNode;
        String link;
        ReplyNode n = new ReplyNode();
        n.setUserObject(r);
        n.setName(r.getName());
        PortNode replyPortNode = new PortNode(1);
        n.addChildNode((Node)replyPortNode);
        n.addChildNode((Node)new PortNode(1));
        if (this.m_bBuildPartnerLinks && (link = r.getPartnerLink()) != null && (partnerLinkNode = this.findPartnerLinkNode(link)) != null) {
            PortNode partnerLinkPort = new PortNode(0);
            partnerLinkNode.addChildNode((Node)partnerLinkPort);
            PartnerLinkConnection edge = new PartnerLinkConnection(replyPortNode, partnerLinkPort);
            this.m_graphModel.insertEdge((Edge)edge);
        }
        return n;
    }

    protected Node handleWait(Wait w) {
        WaitNode n = new WaitNode();
        n.setUserObject(w);
        n.setName(w.getName());
        return n;
    }

    protected Node handleInvoke(Invoke invoke) {
        PartnerLinkNode n;
        String link;
        InvokeNode invokeNode = new InvokeNode();
        invokeNode.setUserObject(invoke);
        invokeNode.setName(invoke.getName());
        PortNode invokePortNode = new PortNode(1);
        invokeNode.addChildNode((Node)invokePortNode);
        invokeNode.addChildNode((Node)new PortNode(1));
        FaultHandlers handlers = invoke.getFaultHandlers();
        if (handlers != null) {
            FaultHandlersNode fNode = new FaultHandlersNode();
            invokeNode.setFaultHandlersNode(fNode);
            for (Catch c : handlers.getCatches()) {
                CatchNode catchNode = new CatchNode();
                catchNode.setUserObject(c);
                fNode.addChildNode((Node)catchNode);
            }
            CatchAll ca = handlers.getCatchAll();
            if (ca != null) {
                CatchAllNode catchAllNode = new CatchAllNode();
                catchAllNode.setUserObject(ca);
                fNode.addChildNode((Node)catchAllNode);
            }
        }
        if (this.m_bBuildPartnerLinks && (link = invoke.getPartnerLink()) != null && (n = this.findPartnerLinkNode(link)) != null) {
            PortNode partnerLinkPort = new PortNode(0);
            n.addChildNode((Node)partnerLinkPort);
            PartnerLinkConnection edge = new PartnerLinkConnection(invokePortNode, partnerLinkPort);
            this.m_graphModel.insertEdge((Edge)edge);
        }
        return invokeNode;
    }

    private PartnerLinkNode findPartnerLinkNode(String linkName) {
        PartnerLinkNode partnerLinkNode;
        PartnerLink modelLink;
        if (this.m_leftSwimLaneNode != null) {
            for (Node n : this.m_leftSwimLaneNode.getChildren()) {
                if (!(n instanceof PartnerLinkNode) || !(modelLink = (PartnerLink)(partnerLinkNode = (PartnerLinkNode)n).getUserObject()).getName().equals(linkName)) continue;
                return partnerLinkNode;
            }
        }
        if (this.m_rightSwimLaneNode != null) {
            for (Node n : this.m_rightSwimLaneNode.getChildren()) {
                if (!(n instanceof PartnerLinkNode) || !(modelLink = (PartnerLink)(partnerLinkNode = (PartnerLinkNode)n).getUserObject()).getName().equals(linkName)) continue;
                return partnerLinkNode;
            }
        }
        return null;
    }

    public Node handleScope(Scope s) {
        ScopeNode scopeNode = new ScopeNode();
        this.buildScopeNode(scopeNode, s);
        return scopeNode;
    }

    public Node buildScopeNode(ScopeNode scopeNode, Scope s) {
        CompensationHandler compHandler;
        EventHandlers eventHandlers;
        scopeNode.setUserObject(s);
        this.addChildNodes(scopeNode, (ContainerActivity)s);
        scopeNode.setName(s.getName());
        FaultHandlers handlers = s.getFaultHandlers();
        if (handlers != null) {
            FaultHandlersNode fNode = new FaultHandlersNode();
            fNode.setUserObject(handlers);
            scopeNode.setFaultHandlersNode(fNode);
            for (Catch c : handlers.getCatches()) {
                CatchNode catchNode = new CatchNode();
                catchNode.setUserObject(c);
                this.addChildNodes((Node)catchNode, (ContainerActivity)c);
                fNode.addChildNode((Node)catchNode);
            }
            CatchAll ca = handlers.getCatchAll();
            if (ca != null) {
                CatchAllNode catchAllNode = new CatchAllNode();
                catchAllNode.setUserObject(ca);
                this.addChildNodes((Node)catchAllNode, (ContainerActivity)ca);
                fNode.addChildNode((Node)catchAllNode);
            }
        }
        if ((eventHandlers = s.getEventHandlers()) != null) {
            EventHandlersNode evtNode = new EventHandlersNode();
            evtNode.setUserObject(eventHandlers);
            scopeNode.setEventHandlersNode(evtNode);
            for (OnMessage msg : eventHandlers.getOnMessages()) {
                OnMessageNode msgNode = new OnMessageNode();
                msgNode.setUserObject(msg);
                this.addChildNodes((Node)msgNode, (ContainerActivity)msg);
                evtNode.addChildNode((Node)msgNode);
            }
            for (OnAlarm alarm : eventHandlers.getOnAlarms()) {
                OnAlarmNode alarmNode = new OnAlarmNode();
                alarmNode.setUserObject(alarm);
                this.addChildNodes((Node)alarmNode, (ContainerActivity)alarm);
                evtNode.addChildNode((Node)alarmNode);
            }
        }
        if ((compHandler = s.getCompensationHandler()) != null) {
            CompensationHandlerNode compNode = new CompensationHandlerNode();
            compNode.setUserObject(compHandler);
            this.addChildNodes((Node)compNode, (ContainerActivity)compHandler);
            scopeNode.setCompensationHandlerNode(compNode);
        }
        return scopeNode;
    }

    protected Node handleSequence(Sequence s) {
        SequenceNode seqNode = new SequenceNode();
        seqNode.setUserObject(s);
        this.addChildNodes((Node)seqNode, (ContainerActivity)s);
        return seqNode;
    }

    public void addChildNodes(Node parentNode, ContainerActivity c) {
        Iterator iterator = c.getActivities();
        while (iterator.hasNext()) {
            Activity a = (Activity)iterator.next();
            Node childNode = this.getNodeForActivity(a);
            if (childNode == null) continue;
            if (parentNode instanceof DroppableBranchNode) {
                ((DroppableBranchNode)parentNode).addToEndOfBranch(childNode);
                continue;
            }
            parentNode.addChildNode(childNode);
        }
    }
}

