/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.graph.model.DefaultGraphModel;
import oracle.tip.tools.ide.common.graph.model.Edge;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.NodeInfo;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.CompensationHandlerNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.EventHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.FaultHandlersNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkConnection;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ProcessNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeGraphNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import oracle.tip.tools.ide.pm.bpelgraph.settings.PartnerLinkLocation;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;

public class BPELGraphModel
extends DefaultGraphModel {
    protected Process m_process;
    protected List<PartnerLinkLocation> m_partnerLinkLocations = new ArrayList<PartnerLinkLocation>();
    protected BPELXmlModel m_bpelModel;
    protected HashMap<String, Object> m_dataMap = new HashMap();

    public void putData(String key, Object value) {
        this.m_dataMap.put(key, value);
    }

    public Object getData(String key) {
        return this.m_dataMap.get(key);
    }

    public BPELProject getBPELProject() {
        return this.m_bpelModel.getBPELProject();
    }

    public void setBPELXmlModel(BPELXmlModel model) {
        this.m_bpelModel = model;
    }

    public BPELXmlModel getBPELXmlModel() {
        return this.m_bpelModel;
    }

    public void setProcess(Process p) {
        this.m_process = p;
    }

    public Process getProcess() {
        if (this.m_bpelModel != null) {
            return this.m_bpelModel.getProcess();
        }
        return this.m_process;
    }

    public synchronized void loadGraphicsInformation(Document doc, BPELGraphPane pane) {
        URL imgDir = BPELAddin.getPartnerLinkIconsDirectory();
        BPELSettings settings = GraphicsFileUtil.readSettings(doc);
        if (settings != null) {
            this.m_partnerLinkLocations.clear();
            this.m_partnerLinkLocations.addAll(settings.m_partnerLinkLocations);
            pane.setSettings(settings);
            if (settings.m_graphLayoutElement != null) {
                GraphicsFileUtil.loadGraphLayout(settings.m_graphLayoutElement, this);
            }
        }
        GraphicsFileUtil.readBookmarks(doc, pane, this);
        Process process = this.getProcess();
        if (process != null) {
            SwimLaneNode leftSwimLaneNode = this.getLeftSwimLaneNode();
            SwimLaneNode rightSwimLaneNode = this.getRightSwimLaneNode();
            if (leftSwimLaneNode == null || rightSwimLaneNode == null) {
                return;
            }
            for (PartnerLinkLocation loc : this.m_partnerLinkLocations) {
                PartnerLinkNode linkNode;
                String linkName = loc.getLinkName();
                String imageFile = loc.getImage();
                Icon icon = this.loadIcon(imgDir, imageFile);
                if (icon == null && Helper.hasValue((String)imageFile)) {
                    icon = ImageCache.getIcon(imageFile);
                }
                if (icon != null) {
                    linkNode = this.findPartnerLinkNode(rightSwimLaneNode, linkName);
                    if (linkNode == null) {
                        linkNode = this.findPartnerLinkNode(leftSwimLaneNode, linkName);
                    }
                    if (linkNode != null) {
                        linkNode.setIconName(loc.getImage());
                        linkNode.setIcon(icon);
                    }
                }
                if (loc.isLeft()) {
                    linkNode = this.findPartnerLinkNode(rightSwimLaneNode, linkName);
                    if (linkNode == null) continue;
                    this.moveNode((Node)linkNode, (Node)leftSwimLaneNode, leftSwimLaneNode.getChildCount());
                    continue;
                }
                linkNode = this.findPartnerLinkNode(leftSwimLaneNode, linkName);
                if (linkNode == null) continue;
                this.moveNode((Node)linkNode, (Node)rightSwimLaneNode, rightSwimLaneNode.getChildCount());
            }
        }
    }

    protected Icon loadIcon(URL imgDir, String imgFile) {
        if (imgDir == null || imgFile == null) {
            return null;
        }
        URL url = URLFactory.newURL((URL)imgDir, (String)imgFile);
        if (URLFileSystem.exists((URL)url)) {
            return new ImageIcon(url);
        }
        return null;
    }

    private PartnerLinkNode findPartnerLinkNode(SwimLaneNode parent, String linkName) {
        for (Node n : parent.getChildren()) {
            PartnerLinkNode pnode;
            PartnerLink l;
            if (!(n instanceof PartnerLinkNode) || !(l = (PartnerLink)(pnode = (PartnerLinkNode)n).getUserObject()).getName().equalsIgnoreCase(linkName)) continue;
            return pnode;
        }
        return null;
    }

    public void buildPartnerLinkConnections() {
        List<PartnerLinkNode> partnerLinkNodes = this.getPartnerLinkNodes();
        int[] types = new int[]{100, 101, 113};
        List<Node> activityLst = this.searchForNodesOfType(types);
        for (Node activityNode : activityLst) {
            Receive recv;
            for (Node pn : activityNode.getChildren()) {
                PortNode portNode = (PortNode)pn;
                Edge[] edges = this.getEdgesForPort(portNode);
                if (edges == null) continue;
                for (Edge e : edges) {
                    PortNode src = e.getSource();
                    PortNode target = e.getTarget();
                    if (src != null && src != portNode) {
                        this.deleteNode(src.getParentNode(), (Node)src);
                        continue;
                    }
                    if (target == null || target == portNode) continue;
                    this.deleteNode(target.getParentNode(), (Node)target);
                }
            }
            String partnerLinkName = null;
            if (activityNode.getNodeType() == 100) {
                Invoke invoke = (Invoke)activityNode.getUserObject();
                partnerLinkName = invoke.getPartnerLink();
            } else if (activityNode.getNodeType() == 101) {
                recv = (Receive)activityNode.getUserObject();
                partnerLinkName = recv.getPartnerLink();
            } else if (activityNode.getNodeType() == 113) {
                recv = (Reply)activityNode.getUserObject();
                partnerLinkName = recv.getPartnerLink();
            }
            if (partnerLinkName == null || activityNode.getChildCount() == 0) continue;
            PortNode taskPortNode = (PortNode)activityNode.getChildNode(0);
            PartnerLinkNode partnerLinkNode = this.getPartnerLinkNode(partnerLinkName, partnerLinkNodes);
            if (partnerLinkNode == null) continue;
            PortNode partnerLinkPort = new PortNode(0);
            this.addChildNode((Node)partnerLinkNode, (Node)partnerLinkPort);
            this.insertEdge((Edge)new PartnerLinkConnection(taskPortNode, partnerLinkPort));
        }
    }

    public PartnerLinkNode getPartnerLinkNode(String partnerLinkName, List<PartnerLinkNode> links) {
        if (partnerLinkName == null) {
            return null;
        }
        for (PartnerLinkNode link : links) {
            PartnerLink plink = (PartnerLink)link.getUserObject();
            String s = plink.getName();
            if (s == null || !s.equals(partnerLinkName)) continue;
            return link;
        }
        return null;
    }

    public Node getNodeForActivity(Activity a) {
        for (Node n : this.m_rootNodes) {
            Node result = this.findNodeForActivity(n, a);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Node findNodeForActivity(Node n, Activity a) {
        Node result;
        EventHandlersNode en;
        Node result2;
        CompensationHandlerNode cn;
        Node result3;
        FaultHandlersNode fn;
        Object userObj = n.getUserObject();
        if (userObj == a) {
            return n;
        }
        if (n instanceof ScopeGraphNode) {
            ScopeGraphNode sn = (ScopeGraphNode)n;
            fn = sn.getFaultHandlersNode();
            if (fn != null && (result3 = this.findNodeForActivity((Node)fn, a)) != null) {
                return result3;
            }
            cn = sn.getCompensationHandlerNode();
            if (cn != null && (result2 = this.findNodeForActivity((Node)cn, a)) != null) {
                return result2;
            }
            en = sn.getEventHandlersNode();
            if (en != null && (result = this.findNodeForActivity((Node)en, a)) != null) {
                return result;
            }
        } else if (n instanceof ProcessNode) {
            ProcessNode pn = (ProcessNode)n;
            fn = pn.getFaultHandlersNode();
            if (fn != null && (result3 = this.findNodeForActivity((Node)fn, a)) != null) {
                return result3;
            }
            cn = pn.getCompensationHandlerNode();
            if (cn != null && (result2 = this.findNodeForActivity((Node)cn, a)) != null) {
                return result2;
            }
            en = pn.getEventHandlersNode();
            if (en != null && (result = this.findNodeForActivity((Node)en, a)) != null) {
                return result;
            }
        }
        for (Node childNode : n.getChildren()) {
            result3 = this.findNodeForActivity(childNode, a);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    public SwimLaneNode getLeftSwimLaneNode() {
        List roots = this.getRootNodes();
        if (roots.size() > 0) {
            Node rootNode = (Node)roots.get(0);
            for (Node childNode : rootNode.getChildren()) {
                SwimLaneNode lane;
                if (!(childNode instanceof SwimLaneNode) || (lane = (SwimLaneNode)childNode).getOrientation() != 2) continue;
                return lane;
            }
        }
        return null;
    }

    public SwimLaneNode getRightSwimLaneNode() {
        List roots = this.getRootNodes();
        if (roots.size() > 0) {
            Node rootNode = (Node)roots.get(0);
            for (Node childNode : rootNode.getChildren()) {
                SwimLaneNode lane;
                if (!(childNode instanceof SwimLaneNode) || (lane = (SwimLaneNode)childNode).getOrientation() != 4) continue;
                return lane;
            }
        }
        return null;
    }

    public List<PartnerLinkNode> getPartnerLinkNodes() {
        ArrayList<PartnerLinkNode> result = new ArrayList<PartnerLinkNode>();
        List roots = this.getRootNodes();
        if (roots.size() > 0) {
            Node rootNode = (Node)roots.get(0);
            for (Node childNode : rootNode.getChildren()) {
                if (!(childNode instanceof SwimLaneNode)) continue;
                SwimLaneNode lane = (SwimLaneNode)childNode;
                for (Node linkNode : lane.getChildren()) {
                    if (!(linkNode instanceof PartnerLinkNode)) continue;
                    result.add((PartnerLinkNode)linkNode);
                }
            }
        }
        return result;
    }

    private List<Node> searchForNodesOfType(int[] types) {
        ArrayList<Node> result = new ArrayList<Node>();
        List roots = this.getRootNodes();
        if (roots != null) {
            for (Node n : roots) {
                this.findNodeOfType(n, types, result);
            }
        }
        return result;
    }

    public void findNodeOfType(Node n, int[] types, List<Node> lst) {
        List childLst;
        if (this.isOfType(n, types)) {
            lst.add(n);
        }
        if (n instanceof ScopeGraphNode) {
            CompensationHandlerNode compHandlerNode;
            EventHandlersNode eventHandlersNode;
            ScopeGraphNode scopeNode = (ScopeGraphNode)n;
            FaultHandlersNode faultHandlers = scopeNode.getFaultHandlersNode();
            if (faultHandlers != null) {
                this.findNodeOfType((Node)faultHandlers, types, lst);
            }
            if ((eventHandlersNode = scopeNode.getEventHandlersNode()) != null) {
                this.findNodeOfType((Node)eventHandlersNode, types, lst);
            }
            if ((compHandlerNode = scopeNode.getCompensationHandlerNode()) != null) {
                this.findNodeOfType((Node)compHandlerNode, types, lst);
            }
        }
        if ((childLst = n.getChildren()) != null) {
            for (Node childNode : childLst) {
                this.findNodeOfType(childNode, types, lst);
            }
        }
    }

    private boolean isOfType(Node n, int[] types) {
        for (int type : types) {
            if (n.getNodeType() != type) continue;
            return true;
        }
        return false;
    }

    public void moveNode(Node childNode, Node newParentNode, int index) {
        Object userObj = childNode.getUserObject();
        if (userObj instanceof Activity) {
            Activity childActivity = (Activity)childNode.getUserObject();
            Activity oldParentActivity = childActivity.getParentActivity();
            Activity newParentActivity = (Activity)newParentNode.getUserObject();
            try {
                if (oldParentActivity == newParentActivity && oldParentActivity instanceof ContainerActivity) {
                    int insertIndex = index / 2;
                    ContainerActivity newContainer = (ContainerActivity)newParentActivity;
                    List l = newContainer.getActivityList();
                    int numActivities = l.size();
                    if (insertIndex >= numActivities) {
                        newContainer.deleteActivity(childActivity);
                        newContainer.addActivity(childActivity);
                    } else {
                        Activity a = (Activity)newContainer.getActivityList().get(insertIndex);
                        newContainer.deleteActivity(childActivity);
                        int targetIdx = newContainer.getActivityList().indexOf(a);
                        newContainer.insertActivity(targetIdx, childActivity);
                    }
                } else {
                    if (oldParentActivity instanceof ContainerActivity) {
                        ContainerActivity oldContainer = (ContainerActivity)oldParentActivity;
                        oldContainer.deleteActivity(childActivity);
                    }
                    if (newParentActivity instanceof ContainerActivity) {
                        ContainerActivity container = (ContainerActivity)newParentActivity;
                        container.insertActivity(index / 2, childActivity);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while modifying the BPEL model!", e);
            }
        }
        Node targetNode = null;
        Node oldParent = childNode.getParentNode();
        if (oldParent != null) {
            if (oldParent == newParentNode && index >= 0 && index < oldParent.getChildCount()) {
                targetNode = oldParent.getChildNode(index);
            }
            NodeInfo[] childInfo = this.executeDeleteNodes(oldParent, new Node[]{childNode});
            this.fireGraphNodesRemoved(oldParent, childInfo);
        }
        if (targetNode != null) {
            index = oldParent.indexOf(targetNode);
        }
        this.insertChildNode(newParentNode, childNode, index);
    }
}

