/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.timeout;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.border.TitledBorder;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.XPathScrollPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.timeout.TimeoutPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class UntilPanel
extends JPanel
implements ActionListener {
    protected static int MAX_YEARS_ALLOWED = 100;
    protected static int MAX_MONTHS_ALLOWED = 1200;
    protected static int MAX_DAYS_ALLOWED = 36500;
    protected JSpinner m_untilDateSpinner;
    protected JScrollPane m_untilScrollPane;
    protected XPathEditorPane m_untilExpBuilder;
    protected JButton m_untilExpressionBuilderBtn;
    protected JLabel m_untilExprLbl;
    protected JLabel m_untilTimeLbl;
    protected JRadioButton m_timeRB;
    protected JRadioButton m_expressionRB;
    protected TimeoutPage m_page;

    public UntilPanel(TimeoutPage page) {
        this.m_page = page;
        this.setBorder(new TitledBorder(BPELStringTranslator.getString("UNTIL")));
        this.init();
    }

    protected void enableUntilTime(boolean bEnable) {
        this.m_untilDateSpinner.setEnabled(bEnable);
        this.m_untilTimeLbl.setEnabled(bEnable);
    }

    protected void enableUntilExpression(boolean bEnable) {
        this.m_untilExpBuilder.setEnabled(bEnable);
        this.m_untilExprLbl.setEnabled(bEnable);
        this.m_untilExpressionBuilderBtn.setEnabled(bEnable);
    }

    protected void init() {
        FieldFocusListener listener = new FieldFocusListener();
        this.m_untilExpBuilder = new XPathEditorPane();
        this.m_untilScrollPane = new XPathScrollPane((Component)this.m_untilExpBuilder, 21, 31);
        this.m_untilExpBuilder.setEditable(true);
        this.m_untilExpBuilder.addFocusListener((FocusListener)listener);
        this.m_untilExpressionBuilderBtn = new JButton(ImageCache.getIcon("expressionbuilder"));
        this.m_untilExpressionBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_untilExpressionBuilderBtn.addActionListener(this);
        this.m_untilDateSpinner = this.createDateTimeSpinner(listener);
        this.m_timeRB = new JRadioButton();
        this.m_timeRB.addActionListener(this);
        this.m_expressionRB = new JRadioButton();
        this.m_expressionRB.addActionListener(this);
        JPanel panel = new JPanel(new GridBagLayout());
        this.m_untilTimeLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_untilTimeLbl, this.getTextField(this.m_untilDateSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_UNTIL_TIME") + ":");
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_untilExpressionBuilderBtn);
        GraphUtils.addComponent((Container)panel, (Component)this.m_untilTimeLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_untilDateSpinner, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel expanel = new JPanel(new GridBagLayout());
        this.m_untilExprLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_untilExprLbl, (Component)this.m_untilExpBuilder, BPELStringTranslator.getString("EDITOR_WAIT_ALARM_UNTIL_EXP") + ":");
        GraphUtils.addComponent((Container)expanel, (Component)this.m_untilExprLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)expanel, (Component)this.m_untilScrollPane, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.5, (double)0.0);
        GraphUtils.addComponent((Container)expanel, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_timeRB, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)panel, (int)1, (int)0, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_expressionRB, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)expanel, (int)1, (int)1, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    private JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    private JSpinner createDateTimeSpinner(FocusListener listener) {
        Calendar calTime = Calendar.getInstance();
        calTime.add(13, 2);
        Date initDate = calTime.getTime();
        calTime.add(1, MAX_YEARS_ALLOWED);
        Date endDate = calTime.getTime();
        SpinnerDateModel timeModel = new SpinnerDateModel(initDate, null, endDate, 13);
        JSpinner spinner = new JSpinner(timeModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, BPELStringTranslator.getString("EDITOR_DATE_SPINNER_FORMAT"));
        spinner.setEditor(dateEditor);
        JFormattedTextField ftf = dateEditor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        ftf.addFocusListener(listener);
        return spinner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_untilExpressionBuilderBtn) {
            this.m_page.showExpressionBuilder(this.m_untilExpBuilder);
            if (this.m_untilExpBuilder.getText() != null) {
                this.m_expressionRB.setSelected(true);
            }
        }
    }

    class FieldFocusListener
    implements FocusListener {
        FieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object src = e.getSource();
            if (src == UntilPanel.this.m_untilExpBuilder) {
                UntilPanel.this.m_expressionRB.setSelected(true);
            } else if (src == UntilPanel.this.getTextField(UntilPanel.this.m_untilDateSpinner)) {
                UntilPanel.this.m_timeRB.setSelected(true);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

