/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.timeout;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.xml.namespace.QName;
import oracle.ide.controls.JWrappedLabel;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Duration;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.DatetimeExpressionUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.DurationExpressionUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ICanTimeout;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.DurationSpinnerModel;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.timeout.ForPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.timeout.UntilPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class TimeoutPage
extends BaseEditingPage
implements ActionListener {
    public static final String TIMEOUT_PANEL = "TIMEOUT_PANEL";
    public static final String RECEIVE_MESSAGE_PANEL = "RECEIVE_MESSAGE_PANEL";
    public static final String ONE_WAY_INVOKE_MESSAGE_PANEL = "ONE_WAY_INVOKE_MESSAGE_PANEL";
    public static final String NO_LINK_SET_MESSAGE_PANEL = "NO_LINK_SET_MESSAGE_PANEL";
    protected ForPanel m_forPnl;
    protected UntilPanel m_untilPnl;
    protected ICanTimeout m_timeoutActivity;
    protected CardPanel m_cardPnl;
    protected boolean m_bCanSetTimeout = true;

    public TimeoutPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    protected void checkActivityType() {
        this.m_cardPnl.show(TIMEOUT_PANEL);
        this.m_bCanSetTimeout = true;
        if (this.m_timeoutActivity instanceof Receive) {
            Receive rec = (Receive)this.m_timeoutActivity;
            if (rec.getCreateInstance().booleanValue()) {
                this.m_bCanSetTimeout = false;
                this.m_cardPnl.show(RECEIVE_MESSAGE_PANEL);
            }
        } else if (this.m_timeoutActivity instanceof Invoke) {
            Invoke invoke = (Invoke)this.m_timeoutActivity;
            if (!this.isLinkSet(invoke)) {
                this.m_bCanSetTimeout = false;
                this.m_cardPnl.show(NO_LINK_SET_MESSAGE_PANEL);
            } else if (this.isOnewayInvoke(invoke)) {
                this.m_bCanSetTimeout = false;
                this.m_cardPnl.show(ONE_WAY_INVOKE_MESSAGE_PANEL);
            }
        }
    }

    @Override
    public void onSelection() {
        this.checkActivityType();
    }

    protected boolean isLinkSet(Invoke invoke) {
        String link = invoke.getPartnerLink();
        return Helper.hasValue((String)link);
    }

    protected boolean isOnewayInvoke(Invoke invoke) {
        String link = invoke.getPartnerLink();
        if (link != null) {
            String wsdlLoc;
            QName portType = invoke.getPortType();
            String operation = invoke.getOperation();
            Process process = this.m_graphPane.getBPELXmlModel().getProcess();
            PartnerLink plink = BPELModelUtil.getPartnerLinkByName((String)link, (Process)process);
            if (plink != null && (wsdlLoc = plink.getWSDLLocation()) != null) {
                QName qname = WSDLUtil.getOperationOutput((String)wsdlLoc, (QName)portType, (String)operation);
                return qname == null;
            }
        }
        return false;
    }

    @Override
    public void saveChanges() {
        if (!this.m_bCanSetTimeout) {
            return;
        }
        if (this.m_forPnl.m_timeRB.isSelected()) {
            Duration duration = new Duration();
            DurationSpinnerModel m = (DurationSpinnerModel)this.m_forPnl.m_forSpinner.getModel();
            duration.setYear(Integer.valueOf(m.getYears()));
            duration.setMonth(Integer.valueOf(m.getMonths()));
            duration.setDay(Integer.valueOf(m.getDays()));
            duration.setHourOfDay(Integer.valueOf(m.getHours()));
            duration.setMinute(Integer.valueOf(m.getMinutes()));
            duration.setSecond(Integer.valueOf(m.getSeconds()));
            if (this.isTimeSet(m)) {
                this.m_timeoutActivity.setFor("'" + DurationExpressionUtil.getDurationExpression((Duration)duration) + "'");
            } else {
                this.m_timeoutActivity.setFor(null);
            }
            this.m_timeoutActivity.setUntil(null);
        } else if (this.m_forPnl.m_expressionRB.isSelected()) {
            this.m_timeoutActivity.setFor(this.m_forPnl.m_forExpBuilder.getText());
            this.m_timeoutActivity.setUntil(null);
            this.m_forPnl.m_forExpBuilder.saveCachedNS();
        } else if (this.m_untilPnl.m_timeRB.isSelected()) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime((Date)this.m_untilPnl.m_untilDateSpinner.getValue());
            this.m_timeoutActivity.setUntil("'" + DatetimeExpressionUtil.getDateTimeString((Calendar)cal) + "'");
            this.m_timeoutActivity.setFor(null);
        } else {
            this.m_timeoutActivity.setUntil(this.m_untilPnl.m_untilExpBuilder.getText());
            this.m_timeoutActivity.setFor(null);
            this.m_untilPnl.m_untilExpBuilder.saveCachedNS();
        }
    }

    protected boolean isTimeSet(DurationSpinnerModel m) {
        return m.getDays() > 0 || m.getYears() > 0 || m.getMinutes() > 0 || m.getMonths() > 0 || m.getSeconds() > 0;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("TIMEOUT");
    }

    @Override
    public void setUserObject(Object obj) {
        super.setUserObject(obj);
        this.m_timeoutActivity = (ICanTimeout)obj;
        String forInitStr = "";
        String untilInitStr = "";
        if (this.m_timeoutActivity.getFor() != null) {
            String forStr = this.m_timeoutActivity.getFor();
            if (forStr.startsWith("'") && forStr.endsWith("'")) {
                forStr = forStr.substring(1, forStr.length() - 1);
            }
            Duration dur = null;
            try {
                dur = DurationExpressionUtil.parseDurationExpression((String)forStr);
            }
            catch (IllegalArgumentException ile) {
                // empty catch block
            }
            if (dur != null) {
                DurationSpinnerModel model = (DurationSpinnerModel)this.m_forPnl.m_forSpinner.getModel();
                model.setDuration(dur);
                this.setIntModelValue(this.m_forPnl.m_forYearSpinner, dur.getYear());
                this.setIntModelValue(this.m_forPnl.m_forMonthSpinner, dur.getMonth());
                this.setIntModelValue(this.m_forPnl.m_forDaySpinner, dur.getDay());
                this.setTimeModelValue(this.m_forPnl.m_forTimeSpinner, dur);
                this.m_forPnl.m_timeRB.setSelected(true);
            } else {
                forInitStr = this.m_timeoutActivity.getFor();
                this.m_forPnl.m_expressionRB.setSelected(true);
            }
        } else if (this.m_timeoutActivity.getUntil() != null) {
            String untilStr = this.m_timeoutActivity.getUntil();
            if (untilStr.startsWith("'") && untilStr.endsWith("'")) {
                untilStr = untilStr.substring(1, untilStr.length() - 1);
            }
            Calendar cal = null;
            try {
                cal = DatetimeExpressionUtil.parseDateTimeExpression((String)untilStr);
            }
            catch (IllegalArgumentException ile) {
                // empty catch block
            }
            if (cal != null) {
                this.m_untilPnl.m_untilDateSpinner.getModel().setValue(cal.getTime());
                this.m_untilPnl.m_timeRB.setSelected(true);
            } else {
                untilInitStr = this.m_timeoutActivity.getUntil();
                this.m_untilPnl.m_expressionRB.setSelected(true);
            }
        } else {
            this.m_forPnl.m_timeRB.setSelected(true);
        }
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)((Activity)this.m_timeoutActivity), (Process)this.m_processModel);
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl forDataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_timeoutActivity, this.m_nsResolver);
        this.m_forPnl.m_forExpBuilder.initializeEditorPane((VariableDataCallBack)forDataCallBack, forInitStr, this.m_nsResolver, false, false);
        this.m_untilPnl.m_untilExpBuilder.initializeEditorPane((VariableDataCallBack)forDataCallBack, untilInitStr, this.m_nsResolver, false, false);
        this.attachRadioButtonListeners();
        this.enablePanels();
        this.checkActivityType();
    }

    private void setTimeModelValue(JSpinner spinner, Duration d) {
        Calendar cal = Calendar.getInstance();
        if (d.getHour() != null) {
            cal.set(11, d.getHour());
        } else {
            cal.set(11, 0);
        }
        if (d.getMinute() != null) {
            cal.set(12, d.getMinute());
        } else {
            cal.set(12, 0);
        }
        if (d.getSecond() != null) {
            cal.set(13, d.getSecond());
        } else {
            cal.set(13, 0);
        }
        spinner.getModel().setValue(cal.getTime());
    }

    private void setIntModelValue(JSpinner spinner, Integer i) {
        if (i == null) {
            return;
        }
        spinner.getModel().setValue(i);
    }

    protected void showExpressionBuilder(XPathEditorPane editor) {
        this.invokeGraphicalXPathBuilder(editor, (Activity)this.m_timeoutActivity);
    }

    protected void createControls() {
        this.m_forPnl = new ForPanel(this);
        this.m_untilPnl = new UntilPanel(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_untilPnl.m_timeRB);
        group.add(this.m_untilPnl.m_expressionRB);
        group.add(this.m_forPnl.m_timeRB);
        group.add(this.m_forPnl.m_expressionRB);
        this.m_untilPnl.m_timeRB.doClick();
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(TIMEOUT_PANEL, (Component)this.createTimeoutPanel());
        this.m_cardPnl.add(RECEIVE_MESSAGE_PANEL, (Component)this.createReceiveMessagePanel());
        this.m_cardPnl.add(ONE_WAY_INVOKE_MESSAGE_PANEL, (Component)this.createOneWayInvokeMessagePanel());
        this.m_cardPnl.add(NO_LINK_SET_MESSAGE_PANEL, (Component)this.createNoLinkSetMessagePanel());
    }

    protected JPanel createNoLinkSetMessagePanel() {
        JWrappedLabel l = new JWrappedLabel();
        String msg = BPELStringTranslator.getString("NO_LINK_SET_MESSAGE");
        l.setText(msg);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createOneWayInvokeMessagePanel() {
        JWrappedLabel l = new JWrappedLabel();
        String msg = BPELStringTranslator.getString("ONE_WAY_INVOKE_TIMEOUT_MESSAGE");
        l.setText(msg);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createReceiveMessagePanel() {
        JWrappedLabel l = new JWrappedLabel();
        String msg = BPELStringTranslator.getString("RECEIVE_TIMEOUT_MESSAGE");
        l.setText(msg);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createTimeoutPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_forPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_untilPnl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)2, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void attachRadioButtonListeners() {
        this.m_forPnl.m_expressionRB.addActionListener(this);
        this.m_forPnl.m_timeRB.addActionListener(this);
        this.m_untilPnl.m_timeRB.addActionListener(this);
        this.m_untilPnl.m_expressionRB.addActionListener(this);
    }

    protected void enablePanels() {
        if (this.m_forPnl.m_expressionRB.isSelected()) {
            this.m_forPnl.enableForUntil(false);
            this.m_forPnl.enableForExpression(true);
            this.m_untilPnl.enableUntilTime(false);
            this.m_untilPnl.enableUntilExpression(false);
        } else if (this.m_forPnl.m_timeRB.isSelected()) {
            this.m_forPnl.enableForUntil(true);
            this.m_forPnl.enableForExpression(false);
            this.m_untilPnl.enableUntilTime(false);
            this.m_untilPnl.enableUntilExpression(false);
        } else if (this.m_untilPnl.m_expressionRB.isSelected()) {
            this.m_forPnl.enableForUntil(false);
            this.m_forPnl.enableForExpression(false);
            this.m_untilPnl.enableUntilTime(false);
            this.m_untilPnl.enableUntilExpression(true);
        } else if (this.m_untilPnl.m_timeRB.isSelected()) {
            this.m_forPnl.enableForUntil(false);
            this.m_forPnl.enableForExpression(false);
            this.m_untilPnl.enableUntilTime(true);
            this.m_untilPnl.enableUntilExpression(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_forPnl.m_expressionRB || src == this.m_forPnl.m_timeRB || src == this.m_untilPnl.m_expressionRB || src == this.m_untilPnl.m_timeRB) {
            this.enablePanels();
        }
    }
}

