/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.timeout;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.DurationSpinner;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.XPathScrollPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.timeout.TimeoutPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ForPanel
extends JPanel
implements ActionListener {
    protected static int MAX_YEARS_ALLOWED = 100;
    protected static int MAX_MONTHS_ALLOWED = 1200;
    protected static int MAX_DAYS_ALLOWED = 36500;
    protected JScrollPane m_forScrollPane;
    protected XPathEditorPane m_forExpBuilder;
    protected JButton m_forExpressionBuilderBtn;
    protected JRadioButton m_timeRB;
    protected JRadioButton m_expressionRB;
    protected JSpinner m_forYearSpinner;
    protected JSpinner m_forMonthSpinner;
    protected JSpinner m_forDaySpinner;
    protected JSpinner m_forTimeSpinner;
    protected JLabel m_forTimeLbl;
    protected JLabel m_forExprLbl;
    protected DurationSpinner m_forSpinner;
    protected TimeoutPage m_page;

    public ForPanel(TimeoutPage page) {
        this.m_page = page;
        this.setBorder(new TitledBorder(BPELStringTranslator.getString("FOR")));
        this.init();
    }

    protected void enableForUntil(boolean bEnable) {
        this.m_forSpinner.setEnabled(bEnable);
        this.m_forTimeLbl.setEnabled(bEnable);
    }

    protected void enableForExpression(boolean bEnable) {
        this.m_forExpressionBuilderBtn.setEnabled(bEnable);
        this.m_forExpBuilder.setEnabled(bEnable);
        this.m_forExprLbl.setEnabled(bEnable);
    }

    private JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    protected void init() {
        FieldFocusListener listener = new FieldFocusListener();
        this.m_forExpBuilder = new XPathEditorPane();
        this.m_forScrollPane = new XPathScrollPane((Component)this.m_forExpBuilder, 21, 31);
        this.m_forExpBuilder.setEditable(true);
        this.m_forExpBuilder.addFocusListener((FocusListener)listener);
        this.m_forExpressionBuilderBtn = new JButton(ImageCache.getIcon("expressionbuilder"));
        this.m_forExpressionBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_forExpressionBuilderBtn.addActionListener(this);
        this.m_forYearSpinner = this.createNumberSpinner(MAX_YEARS_ALLOWED, listener);
        this.m_forMonthSpinner = this.createNumberSpinner(MAX_MONTHS_ALLOWED, listener);
        this.m_forDaySpinner = this.createNumberSpinner(MAX_DAYS_ALLOWED, listener);
        this.m_forTimeSpinner = this.createTimeSpinner(listener);
        this.m_timeRB = new JRadioButton();
        this.m_timeRB.addActionListener(this);
        this.m_expressionRB = new JRadioButton();
        this.m_expressionRB.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_timeRB);
        group.add(this.m_expressionRB);
        JLabel lblYear = new JLabel();
        BPELStringTranslator.setLabel(lblYear, this.getTextField(this.m_forYearSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_YEAR"));
        JLabel lblMonth = new JLabel();
        BPELStringTranslator.setLabel(lblMonth, this.getTextField(this.m_forMonthSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_MON"));
        JLabel lblDay = new JLabel();
        BPELStringTranslator.setLabel(lblDay, this.getTextField(this.m_forDaySpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_DAY"));
        JLabel lblTime = new JLabel();
        BPELStringTranslator.setLabel(lblTime, this.getTextField(this.m_forTimeSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_FOR_TIME"));
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_forExpressionBuilderBtn);
        this.m_forTimeLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_forTimeLbl, (Component)this.m_forSpinner, BPELStringTranslator.getString("EDITOR_TIME_I"));
        JPanel timePnl = new JPanel(new GridBagLayout());
        this.m_forSpinner = new DurationSpinner();
        GraphUtils.addComponent((Container)timePnl, (Component)this.m_forTimeLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)timePnl, (Component)this.m_forSpinner, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.m_forExprLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_forExprLbl, (Component)this.m_forExpBuilder, BPELStringTranslator.getString("EDITOR_WAIT_ALARM_FOR_EXP") + ":");
        JPanel expressionPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)expressionPnl, (Component)this.m_forExprLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)expressionPnl, (Component)this.m_forScrollPane, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)expressionPnl, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_timeRB, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)timePnl, (int)1, (int)0, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_expressionRB, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)expressionPnl, (int)1, (int)1, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    private JSpinner createNumberSpinner(int max, FocusListener listener) {
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, max, 1);
        JSpinner spinner = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "#");
        spinner.setEditor(editor);
        JFormattedTextField ftf = editor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ftf.addFocusListener(listener);
        return spinner;
    }

    private JSpinner createTimeSpinner(FocusListener listener) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 1);
        SpinnerDateModel timeModel = new SpinnerDateModel(cal.getTime(), null, null, 13);
        JSpinner spinner = new JSpinner(timeModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, BPELStringTranslator.getString("EDITOR_TIME_SPINNER_FORMAT"));
        spinner.setEditor(dateEditor);
        JFormattedTextField ftf = dateEditor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        ftf.addFocusListener(listener);
        return spinner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_forExpressionBuilderBtn) {
            this.m_page.showExpressionBuilder(this.m_forExpBuilder);
            if (this.m_forExpBuilder.getText() != null) {
                this.m_expressionRB.setSelected(true);
            }
        }
    }

    class FieldFocusListener
    implements FocusListener {
        FieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object src = e.getSource();
            if (src == ForPanel.this.m_forExpBuilder) {
                ForPanel.this.m_expressionRB.setSelected(true);
            } else {
                ForPanel.this.m_timeRB.setSelected(true);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

