/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.addin.folders.custom.ServiceInfo;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.ServiceTypePanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.AdapterWsdlInfo;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.ServiceConfigurator;

public class ServiceTypeDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected int m_retVal = 1;
    protected BPELGraphPane m_graph;
    protected AdapterWsdlInfo m_wsdlInfo = null;
    protected ServiceTypePanel m_panel;
    protected String m_updateWSDL;
    protected List m_urls;
    protected static Map<String, ServiceConfigurator> TYPE_MAP = new LinkedHashMap<String, ServiceConfigurator>();

    public ServiceTypeDialog(JFrame f, BPELGraphPane graph, String update_wsdl_path) {
        super(f, BPELStringTranslator.getString("EDITOR_SELECT_SERVICE_TYPE"), true);
        this.m_updateWSDL = update_wsdl_path;
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    public AdapterWsdlInfo getWsdlInfo() {
        return this.m_wsdlInfo;
    }

    public List getURLs() {
        return this.m_urls;
    }

    protected void createControls() {
        this.m_panel = new ServiceTypePanel();
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_panel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 280);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
    }

    protected void updateButtons() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (this.m_panel.m_type != null) {
                String type = this.m_panel.m_type.getServiceType();
                try {
                    ServiceConfigurator wizard = TYPE_MAP.get(type);
                    wizard.display(GraphUtils.getFrame((Component)((Object)this)), this.m_updateWSDL, this.m_graph.getBPELProject());
                    ServiceInfo svcInfo = wizard.getServiceInfo();
                    if (svcInfo == null) {
                        return;
                    }
                    this.m_wsdlInfo = (AdapterWsdlInfo)((Object)svcInfo.getParameter());
                    this.m_urls = wizard.getURLs();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.formatString("EDITOR_PLE_WSDL_EXCEPTION", new Object[]{ex.getMessage()}), (int)0);
                    return;
                }
                this.m_retVal = 0;
                this.dispose();
                return;
            }
            GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("EDITOR_NO_SERVICE_TYPE"), (int)0);
            return;
        }
        if (src == this.m_cancelBtn) {
            this.handleCancel();
            return;
        } else {
            if (src != this.m_helpBtn) return;
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_panel);
    }

    static {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<ServiceConfigurator> configurators = plugin.getServiceConfigurators();
            if (configurators == null) continue;
            for (ServiceConfigurator item : configurators) {
                TYPE_MAP.put(item.getServiceType(), item);
            }
        }
    }
}

