/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.PropertyInputDialog;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.Pair;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class PartnerLinkPropertyEditPage
extends BaseEditingPage
implements ActionListener {
    protected JButton m_createPropBtn;
    protected JButton m_deletePropBtn;
    protected JList m_propList;
    protected JTextArea m_propValueArea;
    protected PartnerLink m_partnerLink;

    public PartnerLinkPropertyEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_partnerLink = (PartnerLink)model;
        this.loadControls();
    }

    protected void createControls() {
        this.m_createPropBtn = UIHelper.createToolBarButton((int)0);
        this.m_createPropBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_CRT_PTY"));
        this.m_createPropBtn.addActionListener(this);
        this.m_deletePropBtn = UIHelper.createToolBarButton((int)2);
        this.m_deletePropBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_DEL_PTY"));
        this.m_deletePropBtn.addActionListener(this);
        this.m_deletePropBtn.setEnabled(false);
        this.m_propList = new JList(new DefaultListModel());
        this.m_propList.setSelectionMode(0);
        this.m_propList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PartnerLinkPropertyEditPage.this.updateControls();
            }
        });
        this.m_propValueArea = new JTextArea();
        this.m_propValueArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PartnerLinkPropertyEditPage.this.handlePropValueChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PartnerLinkPropertyEditPage.this.handlePropValueChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    protected void updateControls() {
        int[] indices = this.m_propList.getSelectedIndices();
        this.m_deletePropBtn.setEnabled(indices != null && indices.length > 0);
        this.setValueData();
    }

    protected void setValueData() {
        Object obj = this.m_propList.getSelectedValue();
        if (!(obj instanceof Pair)) {
            this.m_propValueArea.setText("");
            return;
        }
        Pair p = (Pair)obj;
        this.m_propValueArea.setText(p.getValue());
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_createPropBtn);
        tb.add((Component)this.m_deletePropBtn);
        JLabel propLbl = new JLabel();
        BPELStringTranslator.setLabel(propLbl, this.m_propList, BPELStringTranslator.getString("EDITOR_PS_PROP_NAMES", "Property Names:"));
        JLabel valueLbl = new JLabel();
        BPELStringTranslator.setLabel(valueLbl, this.m_propValueArea, BPELStringTranslator.getString("EDITOR_PS_PROP_VALS", "Property Value:"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)propLbl, (int)0, (int)row, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(5, 10, 2, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.m_propList), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)valueLbl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.m_propValueArea), (int)0, (int)row, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void loadControls() {
        List propList;
        if (this.m_partnerLink.getName() == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.m_propList.getModel();
        BPELProject prj = this.m_graphModel.getBPELProject();
        DeploymentFile depFile = prj.getDeploymentFile();
        if (depFile != null && (propList = depFile.getPLProperties(this.m_partnerLink.getName())) != null) {
            for (PLProperties p : propList) {
                model.addElement(new Pair(p.m_name, p.m_value, p.m_type));
            }
        }
    }

    protected void handleCreateProperty() {
        PropertyInputDialog dlg = new PropertyInputDialog(GraphUtils.getFrame((Component)this), BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_CRT_PTY", "Create Property"), BPELStringTranslator.getString("EDITOR_PS_NAME", "Name:"), 0);
        dlg.setHelpId("bpmjdev_create_property");
        String s = dlg.display();
        if (s != null && !s.trim().equals("")) {
            DefaultListModel model = (DefaultListModel)this.m_propList.getModel();
            Pair pr = new Pair(s, s, null);
            model.addElement(pr);
            this.updateControls();
            this.m_propList.setSelectedValue(pr, true);
        }
    }

    protected void handleDeleteProperty() {
        DefaultListModel model = (DefaultListModel)this.m_propList.getModel();
        int[] indices = this.m_propList.getSelectedIndices();
        if (indices == null) {
            return;
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            model.removeElementAt(index);
        }
        this.updateControls();
    }

    @Override
    public void saveChanges() {
        if (this.m_partnerLink == null || this.m_partnerLink.getName() == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.m_propList.getModel();
        ArrayList<PLProperties> list = new ArrayList<PLProperties>();
        for (int i = 0; i < model.size(); ++i) {
            Pair p = (Pair)model.get(i);
            list.add(new PLProperties(p.getName(), p.getValue(), p.getType()));
        }
        try {
            DeploymentFile depFile = this.m_graphModel.getBPELProject().getDeploymentFile();
            depFile.setPLProperties(this.m_partnerLink.getName(), list);
        }
        catch (RuntimeException ex) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_PLE_PL_NOT_WELL_DEFINED_PLP"), (int)0);
            throw ex;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_createPropBtn) {
            this.handleCreateProperty();
        } else if (src == this.m_deletePropBtn) {
            this.handleDeleteProperty();
        }
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EDITOR_COR_SET_PTY_DLG");
    }

    protected void handlePropValueChange() {
        Object o = this.m_propList.getSelectedValue();
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            p.setValue(this.m_propValueArea.getText());
        }
    }

    public String getPartnerLinkName() {
        return this.m_partnerLink.getName();
    }
}

