/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.DynamicFileFilter;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinkImagePage
extends BaseEditingPage
implements ActionListener,
ListSelectionListener {
    protected PartnerLinkNode m_node;
    protected JTextField m_imgLocField;
    protected JLabel m_imageLbl;
    protected JButton m_addBtn;
    protected JButton m_deleteBtn;
    protected JList m_imageLst;
    protected List<String> m_deleteList = new ArrayList<String>();
    protected List<URL> m_addList = new ArrayList<URL>();

    public PartnerLinkImagePage(BPELGraphPane pane, PartnerLinkNode node) {
        super(pane);
        this.m_node = node;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    @Override
    public void loadData() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PartnerLinkImagePage.this.loadDirImages();
                }
                finally {
                    PartnerLinkImagePage.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void saveSelectedIcon() {
        ListItem item = (ListItem)this.m_imageLst.getSelectedValue();
        if (item != null) {
            Icon icon = item.m_icon;
            this.m_node.setIcon(icon);
            this.m_node.setIconName(item.m_entryName);
        }
    }

    @Override
    public void saveChanges() {
        this.saveSelectedIcon();
        if (this.m_deleteList.size() > 0) {
            URL imgDir = BPELAddin.getPartnerLinkIconsDirectory();
            String s = BPELStringTranslator.getString("DEL_IMG_MSG") + "\n";
            String files = "";
            Iterator<String> it = this.m_deleteList.iterator();
            int cnt = 0;
            while (it.hasNext()) {
                String s1 = it.next();
                if (cnt > 0) {
                    files = files + ", ";
                }
                files = files + s1;
                ++cnt;
            }
            if (GraphUtils.showConfirmDialog((Component)this, (String)(s = s + files), (String)BPELStringTranslator.getString("DEL_IMG")) == 0) {
                for (String s1 : this.m_deleteList) {
                    URL u = URLFactory.newURL((URL)imgDir, (String)s1);
                    if (!URLFileSystem.exists((URL)u)) continue;
                    URLFileSystem.delete((URL)u);
                }
            }
        }
        if (this.m_addList.size() > 0) {
            BPELProject prj = this.m_graphPane.getBPELProject();
            for (URL src : this.m_addList) {
                URL dest = URLFactory.newURL((URL)BPELAddin.getPartnerLinkIconsDirectory(), (String)URLFileSystem.getFileName((URL)src));
                try {
                    URLFileSystem.copy((URL)src, (URL)dest);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("ERROR_COPY_IMG_TO_MODEL_DIR"), (int)0);
                }
            }
        }
        this.m_addList.clear();
        this.m_deleteList.clear();
    }

    protected void updateButtons() {
        this.m_deleteBtn.setEnabled(this.m_imageLst.getSelectedIndex() != -1);
    }

    protected void createControls() {
        this.m_imageLst = new JList(new DefaultListModel());
        this.m_imageLst.setSelectionMode(0);
        this.m_imageLst.setCellRenderer(new ListRenderer());
        this.m_imageLst.addListSelectionListener(this);
        this.m_addBtn = UIHelper.createToolBarButton((int)3);
        this.m_addBtn.addActionListener(this);
        this.m_deleteBtn = UIHelper.createToolBarButton((int)2);
        this.m_deleteBtn.addActionListener(this);
        this.m_imgLocField = new JTextField();
        this.m_imgLocField.setEditable(false);
        Icon icon = new ImageIcon(ImageCache.getImage("graph/bpel/partnerlink_20x20.png"));
        if (this.m_node.getIcon() != null) {
            icon = this.m_node.getIcon();
        }
        this.m_imageLbl = new JLabel(icon);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JPanel imgPnl = new JPanel(new GridBagLayout());
        imgPnl.setBackground(Color.white);
        GraphUtils.addComponent((Container)imgPnl, (Component)this.m_imageLbl, (int)0, (int)0, (int)1, (int)1, (int)10, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(imgPnl), (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.4);
        GraphUtils.addComponent((Container)this, (Component)this.createBrowserPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected JComponent createBrowserPanel() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_addBtn);
        tb.add((Component)this.m_deleteBtn);
        JPanel imgPnl = new JPanel();
        imgPnl.setBackground(Color.white);
        JPanel p = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_imageLst, BPELStringTranslator.getString("EDIT_IMAGES", "&Images") + ":");
        GraphUtils.addComponent((Container)p, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(10, 0, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JScrollPane(this.m_imageLst), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EDIT_IMAGE", "Image");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleAddImage();
        } else if (src == this.m_deleteBtn) {
            this.handleDeleteImage();
        }
    }

    protected void handleDeleteImage() {
        DefaultListModel model = (DefaultListModel)this.m_imageLst.getModel();
        int[] indices = this.m_imageLst.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            ListItem item = (ListItem)model.elementAt(indices[i]);
            if (item.m_entryName != null) {
                this.m_deleteList.add(item.m_entryName);
            }
            model.removeElementAt(indices[i]);
        }
        this.updateButtons();
    }

    protected void handleAddImage() {
        File[] files;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".gif", "GIF Files (*.gif)"));
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".jpg", "JPEG Files (*.jpg)"));
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".png", "PNG Files (*.png)"));
        chooser.setDialogTitle(BPELStringTranslator.getString("ADD_IMAGE", "Add Image"));
        int returnVal = chooser.showOpenDialog(GraphUtils.getFrame((Component)this));
        if (returnVal != 0) {
            return;
        }
        for (File file : files = chooser.getSelectedFiles()) {
            URL u = null;
            try {
                u = Helper.getURL((File)file);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            ImageIcon icon = new ImageIcon(u);
            ListItem item = new ListItem(icon, URLFileSystem.getFileName((URL)u), u);
            DefaultListModel model = (DefaultListModel)this.m_imageLst.getModel();
            model.insertElementAt(item, 0);
            this.m_imageLst.setSelectedValue(item, true);
            URL imgDir = BPELAddin.getPartnerLinkIconsDirectory();
            if (!URLFileSystem.exists((URL)imgDir)) {
                URLFileSystem.mkdir((URL)imgDir);
            }
            this.m_addList.add(u);
        }
        this.updateButtons();
    }

    protected void loadDirImages() {
        DefaultListModel model = (DefaultListModel)this.m_imageLst.getModel();
        URL imgDir = BPELAddin.getPartnerLinkIconsDirectory();
        File dir = Helper.getFile((URL)imgDir);
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (String file : files) {
            String urlStr;
            URL u;
            if (!file.endsWith(".gif") && !file.endsWith(".png") && !file.endsWith(".jpg") || (u = this.makeURL(urlStr = "file:/" + dir.getPath() + "/" + file)) == null) continue;
            ImageIcon icon = new ImageIcon(u);
            ListItem item = new ListItem(icon, URLFileSystem.getFileName((URL)u), null);
            model.addElement(item);
        }
    }

    protected URL makeURL(String s) {
        return URLFactory.newURL((String)s);
    }

    protected void handleImageSelection() {
        ListItem item = (ListItem)this.m_imageLst.getSelectedValue();
        if (item != null) {
            this.m_imageLbl.setIcon(item.m_icon);
        }
        this.updateButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.m_imageLst) {
            this.handleImageSelection();
        }
    }

    class ListItem {
        protected Icon m_icon;
        protected URL m_url;
        protected String m_entryName;

        public ListItem(Icon icon, String text, URL url) {
            this.m_icon = icon;
            this.m_entryName = text;
            this.m_url = url;
        }

        public String toString() {
            return this.m_entryName;
        }
    }

    class ListRenderer
    extends DefaultListCellRenderer {
        public ListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        protected Icon getIcon(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return null;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText("");
            if (value instanceof ListItem) {
                ListItem item = (ListItem)value;
                this.setIcon(item.m_icon);
                this.setToolTipText(item.m_entryName);
            }
            return this;
        }
    }
}

