/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.resourcepicker.ResourcePickerDialog;
import oracle.tip.tools.ide.common.resourcepicker.appserver.explorer.ResourcePaletteAppServerAdapater;
import oracle.tip.tools.ide.common.resourcepicker.uddi.ResourcePaletteUDDIAdapter;
import oracle.tip.tools.ide.common.resourcepicker.uddi.UDDIService;
import oracle.tip.tools.ide.common.resourcepicker.uddi.UDDIServiceOptionPicker;
import oracle.tip.tools.ide.common.resourcepicker.wsil.explorer.ResourcePaletteWSILAdapater;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.URLUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.utils.deploy.ActivitationAgent;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.model.SCABaseObject;
import oracle.tip.tools.ide.fabric.model.SCAReference;
import oracle.tip.tools.ide.fabric.model.SCAService;
import oracle.tip.tools.ide.fabric.scabrowser.PartnerLinkServiceChooserDialog;
import oracle.tip.tools.ide.fabric.scabrowser.PartnerLinkServicesViewerContext;
import oracle.tip.tools.ide.pm.addin.folders.custom.ServiceInfo;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.ServiceTypeDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.XMLUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.AdapterWsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.SCAPartnerlinkInfo;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.ServiceConfigurator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinkEditPage
extends BaseEditingPage
implements FocusListener,
ActionListener,
ItemListener,
MouseListener {
    public static final String B2B_MY_ROLE_RECEIVE = "B2BReceive_";
    public static final String B2B_MY_ROLE_SEND = "B2BSend_";
    public static final QName INBOUND_BINDING = new QName("http://xmlns.oracle.com/pcbpel/", "inbound_binding");
    public static final QName OUTBOUND_BINDING = new QName("http://xmlns.oracle.com/pcbpel/wsdl/jca/", "binding");
    public static final String RETRY_INTERVAL_PROP = "retryInterval";
    public static final String DEFAULT_RETRY_INTERVAL = "60";
    protected JTextField m_nameField;
    protected JTextField m_wsdlField;
    protected JComboBox m_partnerLinkTypeCB;
    protected JComboBox m_myRoleCB;
    protected JComboBox m_partnerRoleCB;
    protected JButton m_importWSDLBtn;
    protected JButton m_importSCAServiceBtn;
    protected JButton m_refreshWSDLBtn;
    protected JButton m_invokeServiceWizardBtn;
    protected JTextField m_imgLocField;
    protected JTextField m_scopeField;
    protected JButton m_browseImagesBtn;
    protected JLabel m_imageLbl;
    protected JLabel m_errorLbl;
    protected JLabel m_scopeLbl;
    protected JPanel m_wsdlPnl;
    protected boolean m_bInboundWSDL;
    protected boolean m_bOutboundWSDL;
    protected boolean m_bAdapterWSDL;
    protected boolean m_bOutOfProject = false;
    protected boolean m_bLoadControl;
    protected boolean m_bCreatePartnerLink;
    protected boolean m_bFocusListenerEnabled = true;
    protected String m_origWSDLLoc;
    protected String m_initWSDLLoc;
    protected String m_portType;
    protected String m_wsdlLocation;
    protected String m_errorMsg;
    protected String m_scaName = null;
    protected AdapterWsdlInfo m_adapterWSDLInfo;
    protected List m_adapterFileList;
    protected DocumentListener m_docListener;
    protected Definition m_definition;
    protected Hashtable m_techLogicNames;
    protected Object m_parameterObj;
    protected PartnerLinkNode m_node;
    protected PartnerLink m_partnerLink;
    protected int m_scaMask = -1;
    protected Object m_scaObject = null;
    protected UDDIService m_uddiService = null;

    public PartnerLinkEditPage(BPELGraphPane pane, PartnerLinkNode node) {
        super(pane);
        this.m_node = node;
        this.createControls();
        this.layoutControls();
        this.initControls();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public boolean validateEditorChanges() {
        String r2;
        String r1;
        PartnerLinks plinks;
        String name = this.m_nameField.getText();
        if (!Helper.hasValue((String)name)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_PLE_NO_NAME_SPEC"), (int)0);
            return false;
        }
        String origName = this.m_partnerLink.getName();
        if (origName != null && !origName.equals(name) && (plinks = this.m_processModel.getPartnerLinks()) != null && !BPELModelUtil.isUniquePartnerLinkName((List)plinks.getPartnerLinks(), (String)name)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_PLE_NAME_EXISTS"), (int)0);
            return false;
        }
        if (!XMLUtil.isValidName(name)) {
            String msg = BPELStringTranslator.formatString("NOT_VALID_PARTNERLINK_NAME_ERROR", name);
            GraphUtils.displayMessage((Component)this, (String)msg, (int)0);
            return false;
        }
        Object selItem1 = this.m_myRoleCB.getSelectedItem();
        Object selItem2 = this.m_partnerRoleCB.getSelectedItem();
        if (this.m_myRoleCB.getModel().getSize() >= 2 && selItem1 instanceof RoleDataItem && selItem2 instanceof RoleDataItem && (r1 = ((RoleDataItem)selItem1).getRole().getName()).equals(r2 = ((RoleDataItem)selItem2).getRole().getName())) {
            String msg = BPELStringTranslator.getString("PARTNER_LINK_SAME_ROLES", "The same role is selected for both my role and partner role.");
            GraphUtils.displayMessage((Component)this, (String)msg, (int)0);
            return false;
        }
        Object obj = this.m_partnerLinkTypeCB.getSelectedItem();
        if (obj instanceof PartnerLinkTypeDataItem && !(selItem1 instanceof RoleDataItem) && !(selItem2 instanceof RoleDataItem)) {
            String msg = BPELStringTranslator.getString("PARTNER_LINK_NO_ROLES", "Please set my role and/or partner role.");
            GraphUtils.displayMessage((Component)this, (String)msg, (int)0);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        try {
            this.saveToModel();
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)this, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getURLString(String loc) {
        if (!Helper.hasValue((String)loc)) {
            return loc;
        }
        URL url = null;
        try {
            url = new URL(loc);
        }
        catch (Exception ex) {
            URL bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
            url = URLFactory.newURL((URL)bpelDirURL, (String)loc);
        }
        return URLUtil.toString((URL)url);
    }

    private String getRelLoc(URL url) {
        if (URLFileSystem.isLocal((URL)url)) {
            return URLFileSystem.toRelativeSpec((URL)url, (URL)this.m_graphPane.getBPELProject().getBPELDirectoryURL());
        }
        return URLUtil.toString((URL)url);
    }

    private String getRelLoc(String urlString) {
        URL url = URLFactory.newURL((String)urlString);
        if (url == null) {
            return null;
        }
        if (URLFileSystem.isLocal((URL)url)) {
            return URLFileSystem.toRelativeSpec((URL)url, (URL)this.m_graphPane.getBPELProject().getBPELDirectoryURL());
        }
        return URLUtil.toString((URL)url);
    }

    private void saveToModel() throws Exception {
        ActivitationAgent ag;
        Role r;
        String fileProcessName;
        String wsdl = this.getURLString(this.m_wsdlField.getText());
        if (this.m_partnerLink == null || !Helper.hasValue((String)wsdl)) {
            return;
        }
        URL wsdlURL = URLFactory.newURL((String)wsdl);
        if (URLFileSystem.isDirectory((URL)wsdlURL)) {
            return;
        }
        BPELProject prj = this.m_graphPane.getBPELProject();
        DeploymentFile deploymentFile = prj.getDeploymentFile();
        if (deploymentFile == null) {
            GraphUtils.displayMessage((Component)this, (String)"Unable to find deployment file!", (int)0);
            return;
        }
        Process process = this.m_graphModel.getProcess();
        String prjProcessName = prj.getProcessName();
        if (!prjProcessName.equals(fileProcessName = process.getName())) {
            String msg = BPELStringTranslator.formatString("PROCESS_NAME_AND_FILE_NAME_NOT_SAME", new Object[]{prjProcessName, fileProcessName});
            GraphUtils.displayMessage((Component)this, (String)msg, (int)0);
            return;
        }
        String origName = this.m_partnerLink.getName();
        this.m_partnerLink.setProcessURL(prj.getBPELFileURL());
        this.m_partnerLink.setWSDLLocation(wsdl);
        this.m_partnerLink.setInbound(this.m_bInboundWSDL);
        this.m_partnerLink.setPortType(this.m_portType);
        this.m_partnerLink.setName(this.m_nameField.getText());
        String newName = this.m_nameField.getText().trim();
        BPELModelUtil.updatePartnerLinkReference((Scope)process, (String)origName, (String)newName);
        Object obj = this.m_partnerLinkTypeCB.getSelectedItem();
        if (obj instanceof PartnerLinkTypeDataItem) {
            PartnerLinkTypeDataItem dataItem = (PartnerLinkTypeDataItem)obj;
            PartnerLinkType wsdlPartnerLinkType = dataItem.getPartnerLinkType();
            QName qname = wsdlPartnerLinkType.getQName();
            String namespaceURI = qname.getNamespaceURI();
            String localPart = qname.getLocalPart();
            String processPrefix = null;
            if (namespaceURI != null) {
                processPrefix = process.addNamespace(namespaceURI);
            }
            this.m_partnerLink.setPartnerLinkType(new QName(namespaceURI, localPart, processPrefix));
        } else {
            this.m_partnerLink.setPartnerLinkType(null);
        }
        Object selItem = this.m_myRoleCB.getSelectedItem();
        if (selItem instanceof RoleDataItem) {
            r = ((RoleDataItem)selItem).getRole();
            if (r != null) {
                String myRoleName = r.getName();
                this.m_partnerLink.setMyRole(myRoleName);
                if (myRoleName.startsWith(B2B_MY_ROLE_RECEIVE)) {
                    this.m_bInboundWSDL = true;
                    this.m_portType = r.getPortType().getQName().getLocalPart();
                } else if (myRoleName.startsWith(B2B_MY_ROLE_SEND)) {
                    this.m_bInboundWSDL = false;
                    this.m_portType = null;
                } else {
                    this.checkInboundFromMyRole(r);
                }
            } else {
                this.m_partnerLink.setMyRole(null);
            }
        } else {
            this.m_partnerLink.setMyRole(null);
        }
        selItem = this.m_partnerRoleCB.getSelectedItem();
        if (selItem instanceof RoleDataItem) {
            r = ((RoleDataItem)selItem).getRole();
            if (r != null) {
                this.m_partnerLink.setPartnerRole(r.getName());
            } else {
                this.m_partnerLink.setPartnerRole(null);
            }
        } else {
            this.m_partnerLink.setPartnerRole(null);
        }
        if (this.m_bInboundWSDL || this.m_bAdapterWSDL && this.m_portType != null) {
            ag = deploymentFile.getActivitationAgent(this.m_partnerLink.getName());
            if (ag == null) {
                ag = new ActivitationAgent("oracle.tip.adapter.fw.agent.jca.JCAActivationAgent");
                ag.addProperty("portType", this.m_portType, null);
                deploymentFile.addActivitationAgent(this.m_partnerLink.getName(), ag);
            }
        } else {
            deploymentFile.removeActivitationAgent(this.m_partnerLink.getName());
        }
        if (this.m_bCreatePartnerLink) {
            this.firePartnerLinkCreated();
        } else {
            this.firePartnerLinkUpdated(origName);
        }
        if (this.m_techLogicNames != null) {
            ag = deploymentFile.getActivitationAgent(this.m_partnerLink.getName());
            if (this.m_bInboundWSDL && ag == null) {
                ag = new ActivitationAgent("oracle.tip.adapter.fw.agent.jca.JCAActivationAgent");
                deploymentFile.addActivitationAgent(this.m_partnerLink.getName(), ag);
            }
            Enumeration enum_var = this.m_techLogicNames.keys();
            while (enum_var.hasMoreElements()) {
                String name = (String)enum_var.nextElement();
                if (this.m_bInboundWSDL) {
                    ag.addProperty((String)this.m_techLogicNames.get(name), "", name);
                    continue;
                }
                deploymentFile.addPLProperties(this.m_partnerLink.getName(), (String)this.m_techLogicNames.get(name), "", name);
            }
        }
        if (this.m_bOutboundWSDL) {
            deploymentFile.addPLProperties(this.m_partnerLink.getName(), RETRY_INTERVAL_PROP, DEFAULT_RETRY_INTERVAL, null);
        }
    }

    @Override
    public void loadData() {
        if (!this.m_bLoadControl) {
            this.loadControls();
        }
        this.setModified(true);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_partnerLink = (PartnerLink)model;
    }

    public void setPartnerLink(PartnerLink p) {
        this.m_partnerLink = p;
        this.loadControls();
    }

    public PartnerLink getPartnerLink() {
        return this.m_partnerLink;
    }

    public String getWSDLLocation() {
        return this.m_wsdlLocation;
    }

    public void setWSDLLocation(String wsdlLocation) {
        this.m_wsdlLocation = wsdlLocation;
    }

    public void setParameter(Object obj) {
        this.m_parameterObj = obj;
    }

    public String getNameFromTextField() {
        return this.m_nameField.getText().trim();
    }

    protected void initControls() {
        this.m_nameField.setText(BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"PartnerLink", PartnerLink.class));
    }

    protected void loadControls() {
        this.m_bLoadControl = true;
        this.m_nameField.setText(this.m_partnerLink.getName());
        Scope scope = BPELModelUtil.getScopeForPartnerLink((Process)this.m_processModel, (PartnerLink)this.m_partnerLink);
        if (scope != null) {
            this.m_scopeField.setText(scope.getName());
        }
        if (scope == null || scope instanceof Process) {
            BPELStringTranslator.setLabel(this.m_scopeLbl, this.m_scopeField, BPELStringTranslator.getString("GENERAL_PROCESS_NAME") + ":");
        } else {
            BPELStringTranslator.setLabel(this.m_scopeLbl, this.m_scopeField, BPELStringTranslator.getString("GENERAL_SCOPE_NAME") + ":");
        }
        String wsdl = this.m_partnerLink.getWSDLLocation();
        String prjDir = this.m_graphPane.getBPELProject().getProjectURL().toExternalForm();
        String myRole = this.m_partnerLink.getMyRole();
        String partnerRole = this.m_partnerLink.getPartnerRole();
        this.m_bCreatePartnerLink = wsdl == null || wsdl.trim().length() == 0 || wsdl.equals(prjDir) || (myRole == null || myRole.trim().length() == 0) && (partnerRole == null || partnerRole.trim().length() == 0);
        BPELProject prj = this.m_graphPane.getBPELProject();
        this.m_partnerLink.setProcessURL(prj.getBPELFileURL());
        try {
            if (this.m_wsdlLocation != null) {
                URL url = new URL(this.m_wsdlLocation);
                if (url != null) {
                    url = this.copyToBPELDirectoryIfNeeded(url);
                    this.m_wsdlField.setText(this.getRelLoc(url));
                    this.m_wsdlField.setCaretPosition(0);
                    prj.addProjectNode(url);
                    prj.refresh();
                }
            } else {
                this.m_initWSDLLoc = wsdl;
                this.m_wsdlField.setText(this.getRelLoc(wsdl));
                this.m_wsdlField.setCaretPosition(0);
            }
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_PLE_FAILED_TO_ADD_PRJ"), (int)0);
        }
        this.m_bInboundWSDL = this.m_partnerLink.isInbound();
        this.m_portType = this.m_partnerLink.getPortType();
        this.clearModels();
        if (this.m_parameterObj != null && this.m_parameterObj instanceof AdapterWsdlInfo) {
            this.handleAdapterWSDLInfo((AdapterWsdlInfo)((Object)this.m_parameterObj), null);
        } else {
            this.asyncParseWSDL(true);
        }
    }

    protected void setValuesFromModelData() {
        QName qname = this.m_partnerLink.getPartnerLinkType();
        boolean sameType = false;
        if (qname != null && (sameType = this.selectPartnerLinkType(qname.toString()))) {
            String myRole = this.m_partnerLink.getMyRole();
            this.selectRole(myRole, this.m_myRoleCB);
            String partnerRole = this.m_partnerLink.getPartnerRole();
            this.selectRole(partnerRole, this.m_partnerRoleCB);
        }
        if (!sameType) {
            this.selectFirstPartnerLinkType();
        }
    }

    protected void asyncParseWSDL(final boolean bSelectValuesInModel) {
        this.showErrorMessage(null, false);
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PartnerLinkEditPage.this.parseWSDL();
                    if (bSelectValuesInModel) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                PartnerLinkEditPage.this.setValuesFromModelData();
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                finally {
                    PartnerLinkEditPage.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void showErrorMessage(final String html, final boolean bShow) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PartnerLinkEditPage.this.m_errorMsg = html;
                if (bShow) {
                    PartnerLinkEditPage.this.m_errorLbl.setText(BPELStringTranslator.getString("COLLAXALAF_CLICK_PL_ERROR"));
                    PartnerLinkEditPage.this.m_errorLbl.setIcon(GlobalImageCache.getIcon((String)"error.png"));
                } else {
                    PartnerLinkEditPage.this.m_errorLbl.setIcon(null);
                    PartnerLinkEditPage.this.m_errorLbl.setText("");
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void handleImportWSDL() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new ResourcePaletteWSILAdapater());
        list.add(new ResourcePaletteAppServerAdapater());
        list.add(new ResourcePaletteUDDIAdapter());
        ResourcePickerDialog resourcePickerDialog = new ResourcePickerDialog(GraphUtils.getFrame((Component)this), 1, null, list);
        if (resourcePickerDialog.display() != 1) {
            return;
        }
        Object resource = resourcePickerDialog.getSelectedResource();
        if (resource != null) {
            URL wsdlURL = null;
            if (resource instanceof UDDIService) {
                this.m_uddiService = (UDDIService)resource;
                UDDIServiceOptionPicker uddiOptionPicker = new UDDIServiceOptionPicker(GraphUtils.getFrame((Component)this));
                uddiOptionPicker.run();
                this.m_uddiService.setResolveWSDL(uddiOptionPicker.isResolveWSDL());
                this.m_uddiService.setResolveEndpoint(uddiOptionPicker.isResolveEndpoint());
                wsdlURL = this.m_uddiService.getWSDL();
            } else {
                wsdlURL = resourcePickerDialog.getSelectedURL();
                this.m_uddiService = null;
            }
            this.m_scaObject = null;
            this.setWSDL(wsdlURL, this.m_graphPane.getBPELProject());
        } else {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_PLE_NO_WSDL"), (int)0);
        }
    }

    protected void handleImportSCAService() {
        BPELProject prj = this.m_graphPane.getBPELProject();
        Context currentContext = JDevHelper.getContext((Project)((Project)prj.getProjectContext()));
        PartnerLinkServicesViewerContext svcViewContext = new PartnerLinkServicesViewerContext(currentContext);
        svcViewContext.setCurrentBPELComponentName(prj.getProcessName());
        PartnerLinkServiceChooserDialog dlg = new PartnerLinkServiceChooserDialog(GraphUtils.getFrame((Component)this), currentContext, svcViewContext);
        dlg.getScaBrowser().setBorder(null);
        dlg.getScaBrowser().setLabelVisible(false);
        dlg.getScaBrowser().getCheckBox().setVisible(false);
        dlg.setTitle(MessageBundleUtil.getCommonString((String)"SERVICE_EXPLORER", (String)"Service Explorer"));
        dlg.runDialog();
        if (dlg.isCancelled()) {
            return;
        }
        SCABaseObject returnVal = dlg.getSelectedObject();
        if (returnVal == null || !(returnVal instanceof SCAService) && !(returnVal instanceof SCAReference)) {
            return;
        }
        SCAPartnerlinkInfo ret = SCAPartnerlinkInfo.handleSCAObject(returnVal, prj);
        if (ret.m_bIsNotImport) {
            this.m_scaName = ret.m_scaName;
            this.m_scaMask = ret.m_scaMask;
            this.m_wsdlField.setText(this.getRelLoc(ret.m_wsdlURL));
            this.parseWSDL();
            String plName = this.m_scaName;
            if (this.m_scaName.indexOf("/") > 0) {
                plName = plName.replace("/", ".");
            }
            this.m_nameField.setText(plName);
            this.selectPartnerLinkType(ret.m_sPartnerlinkTypeName);
            this.selectRole(ret.m_myRoleName, this.m_myRoleCB);
            if (ret.m_partnerRolenName != null) {
                this.selectRole(ret.m_partnerRolenName, this.m_partnerRoleCB);
            }
            this.m_scaObject = ret.m_scaObject;
            this.m_uddiService = null;
        } else {
            this.m_scaObject = null;
            this.m_uddiService = null;
            this.setWSDL(ret.m_wsdlURL, prj);
        }
    }

    private void setWSDL(URL url, BPELProject prj) {
        if (url != null) {
            url = this.copyToBPELDirectoryIfNeeded(url);
            this.m_wsdlField.setText(this.getRelLoc(url));
            try {
                prj.addProjectNode(url);
                prj.refresh();
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_PLE_FAILED_TO_ADD_PRJ"), (int)0);
            }
            this.asyncParseWSDL(true);
        }
    }

    protected URL copyToBPELDirectoryIfNeeded(URL fileURL) {
        if (fileURL == null || !fileURL.getProtocol().startsWith("file")) {
            return fileURL;
        }
        BPELProject prj = this.m_graphPane.getBPELProject();
        URL wsdlDirURL = prj.getWSDLRoot();
        if (Helper.isBaseURLFor((URL)wsdlDirURL, (URL)fileURL)) {
            return fileURL;
        }
        fileURL = CommonScaUtils.putFileinProjectDir((Component)GraphUtils.getFrame((Component)this), (Project)((Project)this.m_graphModel.getBPELProject().getProjectContext()), (URL)wsdlDirURL, (URL)wsdlDirURL, (URL)fileURL, BPELWSDLNode.class);
        return fileURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServiceWizard() {
        this.m_scaMask &= 0xFFFFFFFD;
        this.m_scaMask &= 0xFFFFFF7F;
        String wsdlurl = null;
        String tempstr = this.getURLString(this.m_wsdlField.getText());
        AdapterWsdlInfo awc = null;
        List urls = null;
        try {
            boolean isAdapterService = false;
            ServiceConfigurator configurator = null;
            if (Helper.hasValue((String)tempstr) && (configurator = this.getServiceConfigurator(new URL(tempstr))) != null) {
                isAdapterService = true;
            }
            if (isAdapterService) {
                wsdlurl = tempstr;
                configurator.display(GraphUtils.getFrame((Component)this), wsdlurl, this.m_graphPane.getBPELProject());
                ServiceInfo svcInfo = configurator.getServiceInfo();
                if (svcInfo == null) {
                    return;
                }
                awc = (AdapterWsdlInfo)((Object)svcInfo.getParameter());
                urls = configurator.getURLs();
            } else {
                ServiceTypeDialog dlg = new ServiceTypeDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, wsdlurl);
                dlg.display();
                awc = dlg.getWsdlInfo();
                urls = dlg.getURLs();
            }
            if (awc != null) {
                this.handleAdapterWSDLInfo(awc, urls);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_PLE_WSDL_EXCEPTION", new Object[]{ex.getMessage()}), (int)0);
        }
        finally {
            this.m_bFocusListenerEnabled = true;
        }
    }

    private ServiceConfigurator getServiceConfigurator(URL wsdlURL) {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<ServiceConfigurator> configurators = plugin.getServiceConfigurators();
            if (configurators == null) continue;
            for (ServiceConfigurator item : configurators) {
                if (!item.typeMatchs(this.getBPELProject().getProjectContext(), wsdlURL, this.getBPELProject().getProcessName(), this.m_partnerLink.getName())) continue;
                return item;
            }
        }
        return null;
    }

    protected void handleAdapterWSDLInfo(AdapterWsdlInfo awc, List fileList) {
        this.m_parameterObj = awc;
        this.m_scaMask &= 0xFFFFFFFD;
        this.m_scaMask &= 0xFFFFFF7F;
        URL newwsdl = awc._wsdlFileURL;
        this.m_wsdlField.setText(this.getRelLoc(newwsdl));
        this.m_bInboundWSDL = awc._isInboundService;
        this.m_bOutboundWSDL = !this.m_bInboundWSDL;
        this.m_bAdapterWSDL = true;
        this.m_adapterWSDLInfo = awc;
        this.m_scaName = this.m_adapterWSDLInfo.getServiceName();
        this.m_adapterFileList = fileList;
        Definition def = awc._definition;
        if (def == null) {
            try {
                def = WSDLUtil.parseWSDL((URL)newwsdl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (def != null) {
            this.m_portType = null;
            this.m_bFocusListenerEnabled = false;
            this.parseWSDL();
            this.m_bInboundWSDL = awc._isInboundService;
            this.m_bOutboundWSDL = !this.m_bInboundWSDL;
            this.m_partnerLinkTypeCB.grabFocus();
            if (this.m_partnerLinkTypeCB.getModel().getSize() > 0) {
                this.m_partnerLinkTypeCB.setSelectedIndex(0);
                this.m_bFocusListenerEnabled = true;
                this.populateRoles();
                if (awc._my_role_name != null) {
                    this.m_myRoleCB.setEnabled(true);
                    this.selectRole(awc._my_role_name, this.m_myRoleCB);
                    this.m_portType = awc._my_portType_name;
                } else {
                    this.m_myRoleCB.setEnabled(false);
                }
                if (awc._partner_role_name != null) {
                    this.m_partnerRoleCB.setEnabled(true);
                    this.selectRole(awc._partner_role_name, this.m_partnerRoleCB);
                } else {
                    this.m_partnerRoleCB.setEnabled(false);
                }
            }
            this.m_techLogicNames = awc._logicalNames;
            this.m_node.setIcon(awc._adapter_type_icon);
            BPELGraphModel model = this.m_graphModel;
            Process process = model.getProcess();
            process.fireModelChanged((Object)process, 17, (Object)URLUtil.toExternalForm((URL)newwsdl));
            this.m_nameField.setEditable(false);
            this.m_wsdlField.setEnabled(false);
            this.m_partnerLinkTypeCB.setEnabled(false);
            this.m_myRoleCB.setEnabled(false);
            this.m_partnerRoleCB.setEnabled(false);
            this.m_importWSDLBtn.setEnabled(false);
            this.m_importSCAServiceBtn.setEnabled(false);
            this.m_refreshWSDLBtn.setEnabled(false);
            this.m_invokeServiceWizardBtn.setEnabled(false);
        }
    }

    protected void selectFirstPartnerLinkType() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_partnerLinkTypeCB.getModel();
        int sz = model.getSize();
        if (sz > 0) {
            this.m_partnerLinkTypeCB.setSelectedIndex(0);
        }
    }

    protected boolean selectPartnerLinkType(String type) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_partnerLinkTypeCB.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            PartnerLinkTypeDataItem item = (PartnerLinkTypeDataItem)model.getElementAt(i);
            PartnerLinkType plinkType = item.getPartnerLinkType();
            String s1 = plinkType.getQName().toString();
            if (!s1.equalsIgnoreCase(type)) continue;
            this.m_partnerLinkTypeCB.setSelectedItem(item);
            return true;
        }
        return false;
    }

    protected void selectRole(String roleName, JComboBox cb) {
        if (roleName == null) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            RoleDataItem item;
            Role r;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof RoleDataItem) || !(r = (item = (RoleDataItem)obj).getRole()).getName().equalsIgnoreCase(roleName)) continue;
            cb.setSelectedItem(item);
            return;
        }
        cb.setSelectedIndex(0);
    }

    protected void createControls() {
        this.m_errorLbl = new JLabel("", null, 2);
        this.m_errorLbl.setVisible(true);
        this.m_errorLbl.setCursor(Cursor.getPredefinedCursor(12));
        this.m_errorLbl.addMouseListener(this);
        this.m_refreshWSDLBtn = new JButton(ImageCache.getIcon("refresh16"));
        this.m_refreshWSDLBtn.addActionListener(this);
        this.m_refreshWSDLBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_PLE_PARSE_WSDL"));
        this.m_importWSDLBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_importWSDLBtn.setToolTipText(BPELStringTranslator.getString("SCA_RESOURCE_LOOKUP_TIP"));
        this.m_importWSDLBtn.addActionListener(this);
        this.m_importSCAServiceBtn = new JButton(ImageCache.getIcon("application/bpel/service_explorer16.png"));
        this.m_importSCAServiceBtn.setToolTipText(BPELStringTranslator.getString("SCA_SERVICE_EXPLORER_TIP"));
        this.m_importSCAServiceBtn.addActionListener(this);
        this.m_invokeServiceWizardBtn = new JButton(ImageCache.getIcon("adapter16"));
        this.m_invokeServiceWizardBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_PLE_DEF_ADP_SVR") + "...");
        this.m_invokeServiceWizardBtn.addActionListener(this);
        this.m_nameField = new JTextField();
        this.m_scopeField = new JTextField();
        this.m_scopeField.setEditable(false);
        this.m_wsdlField = new JTextField();
        this.m_wsdlField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PartnerLinkEditPage.this.m_origWSDLLoc = null;
                    PartnerLinkEditPage.this.asyncParseWSDL(false);
                }
            }
        });
        this.m_wsdlField.addFocusListener(this);
        this.m_docListener = new WSDLFieldListener();
        this.m_partnerLinkTypeCB = new JComboBox();
        this.m_partnerLinkTypeCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("port_type_node")));
        this.m_partnerLinkTypeCB.addActionListener(this);
        this.m_partnerLinkTypeCB.addItemListener(this);
        this.m_myRoleCB = new JComboBox();
        this.m_myRoleCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_role_node")));
        this.m_partnerRoleCB = new JComboBox();
        this.m_partnerRoleCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_role_node")));
    }

    protected void layoutControls() {
        JToolBar tb = new JToolBar();
        tb.setBorderPainted(false);
        tb.add(this.m_importWSDLBtn);
        tb.add(this.m_importSCAServiceBtn);
        tb.add(this.m_invokeServiceWizardBtn);
        tb.addSeparator();
        tb.add(this.m_refreshWSDLBtn);
        this.m_wsdlPnl = new JPanel(new GridBagLayout());
        this.m_wsdlPnl.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_PLE_WSDL_SETTINGS")));
        JLabel wsdlFileLbl = new JLabel();
        BPELStringTranslator.setLabel(wsdlFileLbl, this.m_wsdlField, BPELStringTranslator.getString("EDITOR_PLE_WSDL_FILE"));
        JLabel plinkTypeLbl = new JLabel();
        BPELStringTranslator.setLabel(plinkTypeLbl, this.m_partnerLinkTypeCB, BPELStringTranslator.getString("EDITOR_PLE_PL_TYPE"));
        JLabel myRoleLbl = new JLabel();
        BPELStringTranslator.setLabel(myRoleLbl, this.m_myRoleCB, BPELStringTranslator.getString("EDITOR_PLE_MY_ROLE"));
        JLabel partnerRoleLbl = new JLabel();
        BPELStringTranslator.setLabel(partnerRoleLbl, this.m_partnerRoleCB, BPELStringTranslator.getString("EDITOR_PLE_PT_ROLE"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)tb, (int)0, (int)row++, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)wsdlFileLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)this.m_wsdlField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)plinkTypeLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)this.m_partnerLinkTypeCB, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)partnerRoleLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)this.m_partnerRoleCB, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)myRoleLbl, (int)0, (int)row, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)this.m_wsdlPnl, (Component)this.m_myRoleCB, (int)1, (int)row, (int)2, (int)1, (int)18, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        this.m_scopeLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_scopeLbl, this.m_scopeField, BPELStringTranslator.getString("GENERAL_PROCESS_NAME") + ":");
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_scopeLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_scopeField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_wsdlPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_errorLbl, (int)0, (int)row, (int)2, (int)1, (int)18, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void clearModels() {
        this.m_partnerLinkTypeCB.removeAllItems();
        this.m_myRoleCB.removeAllItems();
        this.m_partnerRoleCB.removeAllItems();
    }

    protected void parseWSDL() {
        PartnerLinkTypeDataItem modelData;
        Map roles;
        Definition def;
        URI uri;
        URL newURL;
        String wsdlLoc = this.getURLString(this.m_wsdlField.getText());
        if (wsdlLoc == null) {
            return;
        }
        if ((wsdlLoc = wsdlLoc.trim()).length() == 0) {
            return;
        }
        BPELProject prj = this.m_graphPane.getBPELProject();
        URL projDir = prj.getProjectURL();
        if (wsdlLoc.equals(projDir.toExternalForm())) {
            return;
        }
        String lower = wsdlLoc.toLowerCase();
        if (SCAProject.isFilePathRelative((String)lower) && Helper.exists((URL)(newURL = Helper.newURL((URL)projDir, (String)wsdlLoc)))) {
            wsdlLoc = newURL.toString();
            if (wsdlLoc.endsWith("/")) {
                wsdlLoc = wsdlLoc.substring(0, wsdlLoc.length() - 1);
            }
            this.m_wsdlField.setText(this.getRelLoc(wsdlLoc));
        }
        try {
            QName p;
            URL url = URLFactory.newURL((String)wsdlLoc);
            wsdlLoc = URIUtil.escapeURIString((String)wsdlLoc);
            uri = new URI(wsdlLoc);
            def = WSDLUtil.parseWSDLDocument((URI)uri);
            String absWSDL = PartnerLinkWSDLUtil.getAbstractWsdlLocation((Definition)def, (URI)uri);
            if (absWSDL != null) {
                def = WSDLUtil.parseWSDLDocument((String)absWSDL);
            }
            if (def == null) {
                String html = BPELStringTranslator.getString("EDITOR_PLE_UNABLE_PARSE_WSDL");
                this.showErrorMessage(html, true);
                return;
            }
            if ((this.m_initWSDLLoc == null || !this.m_initWSDLLoc.equals(wsdlLoc) && !URIUtil.escapeURIString((String)this.m_initWSDLLoc).equals(wsdlLoc)) && (p = def.getQName()) != null) {
                String localPart = p.getLocalPart();
                if (this.m_parameterObj != null && this.m_parameterObj instanceof AdapterWsdlInfo) {
                    this.m_nameField.setText(((AdapterWsdlInfo)((Object)this.m_parameterObj))._service_name);
                } else if (localPart.trim().length() > 0 && !this.doesNameExist(localPart)) {
                    this.m_nameField.setText(p.getLocalPart());
                }
            }
        }
        catch (URISyntaxException ex) {
            this.clearModels();
            ex.printStackTrace();
            String html = BPELStringTranslator.getString("EDITOR_PLE_UNABLE_PARSE_WSDL");
            this.showErrorMessage(html, true);
            return;
        }
        catch (Exception e) {
            this.clearModels();
            e.printStackTrace();
            String html = Helper.hasValue((String)e.getMessage()) ? "ERROR:" + e.getMessage() : BPELStringTranslator.getString("EDITOR_PLE_UNABLE_PARSE_WSDL");
            this.showErrorMessage(html, true);
            return;
        }
        DefaultComboBoxModel model = this.populatePartnerLinkType(def);
        if (model.getSize() == 1 && (roles = (modelData = (PartnerLinkTypeDataItem)model.getElementAt(0)).getPartnerLinkType().getRoles()) != null && roles.size() == 1) {
            this.checkForInboundWSDL(uri);
        }
        this.m_definition = def;
    }

    protected DefaultComboBoxModel populatePartnerLinkType(Definition def) {
        Map map;
        DefaultComboBoxModel<PartnerLinkTypeDataItem> model = new DefaultComboBoxModel<PartnerLinkTypeDataItem>();
        if (def != null && (map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)def)) != null && map.size() > 0) {
            for (QName qName : map.keySet()) {
                PartnerLinkType type = (PartnerLinkType)map.get(qName);
                PartnerLinkTypeDataItem modelData = new PartnerLinkTypeDataItem(qName, type);
                model.addElement(modelData);
            }
        }
        this.setComboBoxModel(model, this.m_partnerLinkTypeCB, true);
        return model;
    }

    protected void checkForInboundWSDL(URI uri) {
        this.m_bAdapterWSDL = false;
        try {
            AdapterWsdlInfo info = WizardWSDLUtil.parseAdapterWsdl(uri.toURL());
            if (info == null) {
                this.m_bInboundWSDL = false;
            } else {
                this.m_bAdapterWSDL = true;
                this.m_bInboundWSDL = info._isInboundService;
                this.m_bOutboundWSDL = !info._isInboundService;
                this.m_portType = info._my_portType_name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void checkInboundFromMyRole(Role role) {
        if (this.m_bInboundWSDL || this.m_bAdapterWSDL || this.m_definition == null) {
            return;
        }
        QName rQName = role.getPortType().getQName();
        if (rQName == null) {
            return;
        }
        Map bindings = this.m_definition.getBindings();
        Iterator it = bindings.values().iterator();
        int count = 0;
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            QName bQName = b.getPortType().getQName();
            if (bQName == null || !bQName.equals(rQName)) continue;
            ++count;
            List extElements = b.getExtensibilityElements();
            if (extElements.size() <= 0) continue;
            ExtensibilityElement extElem = (ExtensibilityElement)extElements.get(0);
            QName qname = extElem.getElementType();
            if (INBOUND_BINDING.equals(qname)) {
                this.m_portType = bQName.getLocalPart();
                this.m_bInboundWSDL = true;
                continue;
            }
            if (!OUTBOUND_BINDING.equals(qname)) continue;
            this.m_bOutboundWSDL = true;
        }
        if (count > 1) {
            this.m_portType = null;
            this.m_bInboundWSDL = false;
            this.m_bOutboundWSDL = false;
        }
    }

    protected void setComboBoxModel(final DefaultComboBoxModel model, final JComboBox cb, final boolean bSelectedFirstItem) {
        if (SwingUtilities.isEventDispatchThread()) {
            cb.setModel(model);
            if (bSelectedFirstItem && model.getSize() > 0) {
                this.m_partnerLinkTypeCB.setSelectedIndex(0);
            } else if (cb == this.m_partnerLinkTypeCB) {
                this.checkCreateNewWSDL();
            }
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    cb.setModel(model);
                    if (bSelectedFirstItem && model.getSize() > 0) {
                        PartnerLinkEditPage.this.m_partnerLinkTypeCB.setSelectedIndex(0);
                    } else if (cb == PartnerLinkEditPage.this.m_partnerLinkTypeCB) {
                        PartnerLinkEditPage.this.checkCreateNewWSDL();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void checkCreateNewWSDL() {
        String title;
        if (this.m_origWSDLLoc != null && this.m_origWSDLLoc.equals(this.getURLString(this.m_wsdlField.getText()))) {
            return;
        }
        this.m_origWSDLLoc = this.getURLString(this.m_wsdlField.getText());
        String msg = BPELStringTranslator.getString("EDITOR_PLE_CREATE_DEF_PL");
        if (GraphUtils.showConfirmDialog((Component)this, (String)msg, (String)(title = BPELStringTranslator.getString("EDITOR_PLE_PLT"))) == 0) {
            this.createNewWSDLFromPLWSDL();
        }
    }

    protected void createNewWSDLFromPLWSDL() {
        this.enableUserInput(false);
        final String wsdlURI = URIUtil.escapeURIString((String)this.getURLString(this.m_wsdlField.getText()));
        final String plName = this.m_nameField.getText();
        final BPELProject prj = this.m_graphPane.getBPELProject();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final String strNewWSDL = PartnerLinkWSDLUtil.createWSDLAddPLTypes((BPELProject)prj, (String)plName, (String)wsdlURI, null, (boolean)false);
                    Definition def = WSDLUtil.parseWSDLDocument((String)URIUtil.escapeURIString((String)strNewWSDL));
                    PartnerLinkEditPage.this.populatePartnerLinkType(def);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            PartnerLinkEditPage.this.m_wsdlField.setText(PartnerLinkEditPage.this.getRelLoc(strNewWSDL));
                            PartnerLinkEditPage.this.setValuesFromModelData();
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    prj.refresh();
                    PartnerLinkEditPage.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void populateRoles() {
        if (!this.m_bFocusListenerEnabled) {
            return;
        }
        QName modelPartnerLinkType = this.m_partnerLink.getPartnerLinkType();
        String modelMyRole = this.m_partnerLink.getMyRole();
        String modelPartnerRole = this.m_partnerLink.getPartnerRole();
        this.m_myRoleCB.removeAllItems();
        this.m_partnerRoleCB.removeAllItems();
        Object obj = this.m_partnerLinkTypeCB.getSelectedItem();
        if (!(obj instanceof PartnerLinkTypeDataItem)) {
            return;
        }
        PartnerLinkTypeDataItem partnerLinkData = (PartnerLinkTypeDataItem)obj;
        if (partnerLinkData == null) {
            return;
        }
        PartnerLinkType type = partnerLinkData.getPartnerLinkType();
        boolean bModelPartnerLinkTypeSelected = modelPartnerLinkType != null && modelPartnerLinkType.toString().equals(type.getQName().toString());
        boolean bMyRoleFound = false;
        boolean bPartnerRoleFound = false;
        DefaultComboBoxModel<Object> myRoleModel = new DefaultComboBoxModel<Object>();
        myRoleModel.addElement(BPELStringTranslator.getString("NO_SELECTION_ITEM"));
        Collection roles = type.getRoles().values();
        for (Role r : roles) {
            if (modelMyRole != null && modelMyRole.equalsIgnoreCase(r.getName())) {
                bMyRoleFound = true;
            }
            if (modelPartnerRole != null && modelPartnerRole.equalsIgnoreCase(r.getName())) {
                bPartnerRoleFound = true;
            }
            myRoleModel.addElement(new RoleDataItem(r));
        }
        if (bModelPartnerLinkTypeSelected) {
            if (modelMyRole == null || !bMyRoleFound) {
                // empty if block
            }
            if (modelPartnerRole == null || !bPartnerRoleFound) {
                // empty if block
            }
        }
        this.setComboBoxModel(myRoleModel, this.m_myRoleCB, false);
        bMyRoleFound = false;
        bPartnerRoleFound = false;
        DefaultComboBoxModel<Object> partnerRoleModel = new DefaultComboBoxModel<Object>();
        partnerRoleModel.addElement(NO_SELECTION_ITEM);
        roles = type.getRoles().values();
        for (Role r : roles) {
            if (modelMyRole != null && modelMyRole.equalsIgnoreCase(r.getName())) {
                bMyRoleFound = true;
            }
            if (modelPartnerRole != null && modelPartnerRole.equalsIgnoreCase(r.getName())) {
                bPartnerRoleFound = true;
            }
            partnerRoleModel.addElement(new RoleDataItem(r));
        }
        if (bModelPartnerLinkTypeSelected) {
            if (modelMyRole == null || !bMyRoleFound) {
                // empty if block
            }
            if (modelPartnerRole == null || !bPartnerRoleFound) {
                // empty if block
            }
        }
        this.setComboBoxModel(partnerRoleModel, this.m_partnerRoleCB, false);
    }

    protected boolean doesNameExist(String name) {
        PartnerLinks pls = null;
        List partnerlinkLst = null;
        Scope s = BPELModelUtil.getScopeForPartnerLink((Process)this.m_processModel, (PartnerLink)this.m_partnerLink);
        pls = s != null ? s.getPartnerLinks() : this.m_processModel.getPartnerLinks();
        if (pls != null) {
            partnerlinkLst = pls.getPartnerLinks();
        }
        if (partnerlinkLst != null) {
            for (PartnerLink obj : partnerlinkLst) {
                if (obj.getName() == null || !obj.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected void firePartnerLinkCreated() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdapterPartnerLink", this.m_bAdapterWSDL);
        if (this.m_partnerLink.getMyRole() == null && this.m_partnerLink.getPartnerRole() != null) {
            this.m_bInboundWSDL = false;
            this.m_bOutboundWSDL = true;
        } else if (this.m_partnerLink.getMyRole() != null && this.m_partnerLink.getPartnerRole() == null) {
            this.m_bInboundWSDL = true;
            this.m_bOutboundWSDL = false;
        }
        map.put("InboundPartnerLink", this.m_bInboundWSDL);
        map.put("OutboundPartnerLink", this.m_bOutboundWSDL);
        map.put("AddExtRef", Boolean.TRUE);
        map.put("AddExtRef", Boolean.TRUE);
        map.put("Reference_Name", this.m_scaName);
        map.put("PartnerLinkSCAMask", this.m_scaMask);
        if (this.m_scaObject != null) {
            map.put("scaObject", this.m_scaObject);
        }
        if (this.m_uddiService != null) {
            map.put("uddiService", this.m_uddiService);
        }
        this.m_processModel.fireModelChanged((Object)this.m_processModel, 5, (Object)this.m_partnerLink, map);
    }

    protected void firePartnerLinkUpdated(String oldName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PL_OldName", oldName);
        map.put("PartnerLinkSCAMask", this.m_scaMask);
        if (this.m_scaObject != null) {
            map.put("scaObject", this.m_scaObject);
        }
        if (this.m_uddiService != null) {
            map.put("uddiService", this.m_uddiService);
        }
        this.m_processModel.fireModelChanged((Object)this.m_processModel, 25, (Object)this.m_partnerLink, map);
    }

    protected Icon getIcon(String type) {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<ServiceConfigurator> configurators = plugin.getServiceConfigurators();
            if (configurators == null) continue;
            for (ServiceConfigurator item : configurators) {
                if (!item.typeMatchs(type)) continue;
                return item.getIcon();
            }
        }
        return null;
    }

    protected static String getIconName(String s) {
        if (s.equalsIgnoreCase("File")) {
            return "palette/adapterservice/file_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Ftp")) {
            return "palette/adapterservice/ftp_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("DB")) {
            return "palette/adapterservice/db_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("AQ")) {
            return "palette/adapterservice/aq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Apps")) {
            return "palette/adapterservice/oracle_applications_palette.png";
        }
        if (s.equalsIgnoreCase("Jms")) {
            return "palette/adapterservice/jms_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("MQ")) {
            return "palette/adapterservice/mq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("SOCKET")) {
            return "palette/adapterservice/socket_adapter_palette.png";
        }
        return null;
    }

    protected static String getIconNameOnly(String s) {
        if (s.equalsIgnoreCase("File")) {
            return "file_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Ftp")) {
            return "ftp_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("DB")) {
            return "db_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("AQ")) {
            return "aq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("Apps")) {
            return "oracle_applications_palette.png";
        }
        if (s.equalsIgnoreCase("Jms")) {
            return "jms_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("MQ")) {
            return "mq_adapter_palette.png";
        }
        if (s.equalsIgnoreCase("SOCKET")) {
            return "socket_adapter_palette.png";
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_errorLbl.getText() != null && this.m_errorLbl.getText().length() > 0) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)this.m_errorMsg, (int)0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_partnerLinkTypeCB) {
            this.populateRoles();
        } else if (src == this.m_refreshWSDLBtn) {
            this.m_origWSDLLoc = null;
            this.asyncParseWSDL(true);
        } else if (src == this.m_importSCAServiceBtn) {
            this.handleImportSCAService();
        } else if (src == this.m_importWSDLBtn) {
            this.handleImportWSDL();
        } else if (src == this.m_invokeServiceWizardBtn) {
            this.handleServiceWizard();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.m_wsdlField && this.m_wsdlField.getDocument() != null && Helper.hasValue((String)this.m_wsdlField.getText())) {
            this.m_wsdlField.getDocument().addDocumentListener(this.m_docListener);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.m_wsdlField && this.m_wsdlField.getDocument() != null) {
            this.m_wsdlField.getDocument().removeDocumentListener(this.m_docListener);
        }
        if (this.m_bFocusListenerEnabled && src == this.m_wsdlField) {
            this.parseWSDL();
        }
    }

    public class WSDLFieldListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void update() {
            PartnerLinkEditPage.this.m_partnerLinkTypeCB.removeAllItems();
            PartnerLinkEditPage.this.m_myRoleCB.removeAllItems();
            PartnerLinkEditPage.this.m_partnerRoleCB.removeAllItems();
            PartnerLinkEditPage.this.m_bInboundWSDL = false;
        }
    }

    class PartnerLinkTypeDataItem {
        QName m_qname;
        PartnerLinkType m_type;

        public PartnerLinkTypeDataItem(QName name, PartnerLinkType type) {
            this.m_qname = name;
            this.m_type = type;
        }

        public PartnerLinkType getPartnerLinkType() {
            return this.m_type;
        }

        public String toString() {
            return this.m_qname.getLocalPart();
        }
    }

    class RoleDataItem {
        Role m_role;

        public RoleDataItem(Role r) {
            this.m_role = r;
        }

        public Role getRole() {
            return this.m_role;
        }

        public String toString() {
            return this.m_role.getName();
        }
    }
}

