/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.PartnerLinkEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.PartnerLinkImagePage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.PartnerLinkPropertyEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.metadata.XMLUtil;

public class PartnerLinkDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JTabbedPane m_tab;
    protected JButton m_helpBtn;
    protected JButton m_applyBtn;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected PartnerLinkEditPage m_page;
    protected PartnerLinkImagePage m_imagePage;
    protected PartnerLinkPropertyEditPage m_propPage;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected PartnerLink m_partnerLink;
    protected PartnerLinkNode m_node;
    protected boolean m_bCreating = true;
    protected Process m_process;
    protected List m_partnerLinksFilter;

    public PartnerLinkDialog(JFrame f, BPELGraphPane graph, PartnerLinkNode node) {
        super(f, BPELStringTranslator.getString("EDITOR_PLD_CREATE_TITLE"), true);
        this.m_node = node;
        this.m_graph = graph;
        if (graph != null) {
            BPELGraphModel model = (BPELGraphModel)graph.getModel();
            this.m_process = model.getProcess();
        }
        this.createControls();
        this.layoutControls();
    }

    public PartnerLink getPartnerLink() {
        return this.m_partnerLink;
    }

    public int edit(PartnerLink link, List partnerlinksFilter) {
        this.m_bCreating = false;
        this.m_partnerLinksFilter = partnerlinksFilter;
        this.m_partnerLink = link;
        this.setTitle(BPELStringTranslator.formatString("EDITOR_PLD_EDIT_TITLE", new Object[]{this.m_partnerLink.getName()}));
        this.m_page.setPartnerLink(link);
        this.loadControls();
        this.setVisible(true);
        return this.m_retVal;
    }

    public int create(List partnerLinksFilter) {
        return this.create(partnerLinksFilter, null, null);
    }

    public int create(List partnerLinksFilter, String wsdlLocation, Object obj) {
        this.m_bCreating = true;
        this.m_partnerLinksFilter = partnerLinksFilter;
        String plname = BPELModelUtil.generateUniqueName((Process)this.m_process, (String)"PartnerLink", PartnerLink.class);
        List nameLst = this.getNames(this.m_partnerLinksFilter);
        if (this.doesNameExist(this.m_partnerLinksFilter, plname)) {
            this.m_partnerLink.setName(BPELModelUtil.createUniqueName((String)"PartnerLink", (String)plname, (List)nameLst));
        } else {
            this.m_partnerLink.setName(plname);
        }
        if (wsdlLocation != null) {
            this.m_page.setWSDLLocation(wsdlLocation);
        }
        if (obj != null) {
            this.m_page.setParameter(obj);
        }
        this.loadControls();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected boolean doesNameExist(List partnerlinkLst, String name) {
        if (partnerlinkLst != null) {
            for (PartnerLink obj : partnerlinkLst) {
                if (obj.getName() == null || !obj.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected List getNames(List partnerlinkLst) {
        ArrayList<String> nameLst = new ArrayList<String>();
        if (partnerlinkLst != null) {
            for (PartnerLink obj : partnerlinkLst) {
                nameLst.add(obj.getName());
            }
        }
        return nameLst;
    }

    protected void loadControls() {
        this.m_page.loadData();
        this.m_imagePage.loadData();
    }

    protected void createControls() {
        this.m_tab = new JTabbedPane(ApplyCancelPanel.TAB_PLACEMENT);
        this.m_page = new PartnerLinkEditPage(this.m_graph, this.m_node);
        this.m_tab.add(BPELStringTranslator.getString("GENERAL_EDITOR_TITLE"), this.m_page);
        this.m_imagePage = new PartnerLinkImagePage(this.m_graph, this.m_node);
        this.m_tab.add(this.m_imagePage.getTitle(), this.m_imagePage);
        this.m_propPage = new PartnerLinkPropertyEditPage(this.m_graph);
        this.m_tab.add(this.m_propPage.getTitle(), this.m_propPage);
        this.m_partnerLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        this.m_page.setUserObject(this.m_partnerLink);
        this.m_propPage.setUserObject(this.m_partnerLink);
        this.m_applyBtn = new JButton();
        BPELStringTranslator.setButton(this.m_applyBtn, BPELStringTranslator.getString("APPLY_BUTTON_TEXT_RES_A"));
        this.m_applyBtn.addActionListener(this);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_applyBtn);
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        GraphUtils.addComponent((Container)c, (Component)this.m_tab, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(418, 360);
        this.setLocationRelativeTo(this.getParent());
    }

    protected boolean isValidData() {
        if (!this.m_page.validateEditorChanges()) {
            return false;
        }
        String name = this.m_page.getNameFromTextField();
        if (name == null || name.trim().length() == 0) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_INVALID_NAME"));
            return false;
        }
        if (this.m_bCreating) {
            if (!BPELModelUtil.isUniquePartnerLinkName((List)this.m_partnerLinksFilter, (String)name.trim())) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_PL_CRE_DLG_PL_EXIST"));
                return false;
            }
        } else {
            String origName = this.m_page.getPartnerLink().getName();
            String newName = this.m_page.getNameFromTextField();
            if (newName == null || newName.length() == 0) {
                return false;
            }
            if (newName.equalsIgnoreCase(origName)) {
                return true;
            }
            if (!BPELModelUtil.isUniquePartnerLinkName((List)this.m_partnerLinksFilter, (String)newName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_PL_CRE_DLG_PL_EXIST"));
                return false;
            }
        }
        if (!XMLUtil.isValidName(name)) {
            String msg = BPELStringTranslator.formatString("NOT_VALID_PARTNERLINK_NAME_ERROR", name);
            GraphUtils.displayMessage((Component)((Object)this), (String)msg, (int)0);
            return false;
        }
        return true;
    }

    protected void save() {
        this.m_page.saveChanges();
        this.m_imagePage.saveChanges();
        this.m_propPage.saveChanges();
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (!this.isValidData()) {
                return;
            }
            this.save();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_applyBtn) {
            if (this.isValidData()) {
                this.m_bCreating = false;
            }
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp(this.m_tab.getSelectedComponent());
        }
    }
}

